/*******************************************************************************
 * Copyright (c) 2004 Composent, Inc. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Composent, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.ecf.filetransfer;

/**
 * Adapter for setting rate control on IFileTransferInfo instances that expose
 * this adapter interface via
 * IFileTransferInfo.getAdapter(IFileTransferRateControlInfo.class)
 * 
 */
public interface IFileTransferRateControlInfo {
	/**
	 * Set maximum download speed in bytes/second. Specifying a maximum download
	 * speed of 0 indicates that any exiting rate cap should be removed, and the
	 * transfer should proceed as fast as possible a
	 * 
	 * @param maxDownloadSpeed
	 *            in bytes/second
	 */
	public void setMaxDownloadSpeed(long maxDownloadSpeed);

	/**
	 * Set maximum upload speed in bytes/second. Specifying a maximum upload
	 * speed of 0 indicates that any exiting rate cap should be removed, and the
	 * transfer should proceed as fast as possible
	 * 
	 * @param maxUploadSpeed
	 *            in bytes/second
	 */
	public void setMaxUploadSpeed(long maxUploadSpeed);
}
