/*******************************************************************************
 * Copyright (c) 2004 Composent, Inc. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Composent, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.ecf.filetransfer;

/**
 * Adapter interface for pausing and resuming IFileTransfer instances that
 * expose this adapter interface via
 * IFileTransfer.getAdapter(IFileTransferPausable.class)
 * 
 */
public interface IFileTransferPausable {

	/**
	 * Pause file transfer. If the associated IFileTransfer is already paused,
	 * or has already completed then calling this method has no effect.
	 * 
	 */
	public void pause();

	/**
	 * Resume file transfer after having been paused. If the associated
	 * IFileShare is not already paused, or has already completed then this
	 * method has no effect.
	 * 
	 */
	public void resume();
}
