/*
 * Created on May 18, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.qnx.tools.ide.qde.managedbuilder.internal.ui.pages;

import java.io.File;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.qnx.tools.utils.ui.controls.ControlFactory;
import com.qnx.tools.utils.ui.controls.RadioButtonsArea;

/**
 * @author AChapiro
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SelectExtraLibDialog extends SelectPathInputDialog {
	public static final int LINK_MODE_STATIC = 1;
	public static final int LINK_MODE_DYNAMIC = 2;

	private String libDir;
	private int linkMode;
	
	private Text txtlibDirectoryInput;
	
	private RadioButtonsArea linkType;
	/**
	 * @param parentShell
	 * @param dialogTitle
	 * @param dialogMessage
	 * @param initialValue
	 * @param initialType
	 */
	public SelectExtraLibDialog(Shell parentShell, String initialName, String initialDir, int initialType) {
		super(parentShell, 
				"Link library", 
				"Libray name",
				initialName);
		libDir = initialDir;
		linkMode = initialType;
	}
	/* (non-Javadoc)
	 * @see com.qnx.tools.ide.qde.managedbuilder.internal.ui.pages.SelectPathInputDialog#extraButtonsForButtonBar()
	 */
	protected void extraButtonsForButtonBar(final Composite buttonBar) {
		Button browse = createButton(buttonBar, 3, "Browse...", false);
		browse.addSelectionListener(new SelectionAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				FileDialog dlg = new FileDialog(getShell());
				String path = dlg.open();
				if(null != path) {
					IPath libPath = new Path(path);
					File file = libPath.toFile();
					if(file.isFile()) {
						String name = libPath.lastSegment();
						int nStart = 0, nEnd = name.length();
						boolean isStatic = true;
						if(name.startsWith("lib"))
							nStart = 3;
						if(name.endsWith(".so")) {
							nEnd -=3;
							isStatic = false;
						} else
							if(name.endsWith(".a"))
								nEnd -=2;
						name = name.substring(nStart, nEnd);
						inputField.setText(name);
						libPath = libPath.removeLastSegments(1);
						linkType.setSelectedButton(isStatic ? 0 : 1);
					}
					txtlibDirectoryInput.setText(libPath.toString());
				}
			}
		});

		super.extraButtonsForButtonBar(buttonBar);
		
	}
	/* (non-Javadoc)
	 * @see com.qnx.tools.ide.qde.managedbuilder.internal.ui.pages.SelectPathInputDialog#extraControls(org.eclipse.swt.widgets.Composite)
	 */
	protected void extraControls(Composite dialogArea) {
		super.extraControls(dialogArea);
		
		Label dirLabel = ControlFactory.createBoldLabel(dialogArea, "Library search path");
		dirLabel.setFont(dialogArea.getFont());
		
		txtlibDirectoryInput = ControlFactory.createTextField(dialogArea);
		txtlibDirectoryInput.setFont(dialogArea.getFont());
		((GridData)(txtlibDirectoryInput.getLayoutData())).widthHint = 
			convertHorizontalDLUsToPixels(IDialogConstants.MINIMUM_MESSAGE_AREA_WIDTH);
		
		txtlibDirectoryInput.setText(libDir);
		
		linkType = new RadioButtonsArea(dialogArea, "Link type", 2, 
				new String[][] {{"Static", "static"}, 
								{"Dynamic", "dinamic"}});
		linkType.setSelectedButton(linkMode == LINK_MODE_STATIC ? 0 : 1);
	}
	/**
	 * @return Returns the linkMode.
	 */
	boolean isStatic() {
		return (linkMode == LINK_MODE_STATIC);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {
		linkMode = ((linkType.getSeletedIndex() == 0) ? LINK_MODE_STATIC :
			LINK_MODE_DYNAMIC);
		libDir = txtlibDirectoryInput.getText();
		super.okPressed();
	}
	/**
	 * @return Returns the libDir.
	 */
	String getLibDir() {
		return libDir;
	}
}
