/*
 * Created on May 14, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.qnx.tools.ide.qde.managedbuilder.internal.ui.pages;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.ui.properties.CustomBuildSettingsPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.qnx.tools.utils.ui.controls.ControlFactory;
import com.qnx.tools.utils.ui.controls.TableMouseAdapter;

/**
 * @author AChapiro
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class MMBExtraLibsPage extends CustomBuildSettingsPage {
	private final static String COL1_PROPERTY = "lib"; //$NON-NLS-1$
	private final static String COL2_PROPERTY = "link_type"; //$NON-NLS-1$

	
	private final static String LIB_OPTION_ID = "com.qnx.tools.gnu.cpp.link.option.libs";
	private final static String LNK_STATIC = "static";
	private final static String LNK_DYNAMIC = "dynamic";
	
	protected TableViewer lstLibs;
	private Composite buttons;	
	private Button btnAdd, btnDelete, btnEdit, btnUp, btnDown;
	
	/* (non-Javadoc)
	 * @see org.eclipse.cdt.managedbuilder.ui.properties.IBuildSettingsPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		Composite composite = ControlFactory.createComposite(parent, 6);
		setControl(composite);
		((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;		
		
			
			createTable();
			
			createButtons();
			
			ControlFactory.setTableResizeHandler(composite, lstLibs.getTable(), 
					buttons, new int[] {100});
	    
	}

	protected void createTable() {
		String[] columnHeaders = new String[] {
				"Library",
				"Link type"
			};
			
		lstLibs = ControlFactory.createTableViewer((Composite)getControl(), 
	    		SWT.DEFAULT, SWT.DEFAULT, SWT.NONE, 
	    		columnHeaders, new int[] {80, 20});
	    		
	    lstLibs.getTable().getColumn(0).setResizable(true);
	    
	    ((GridData)(lstLibs.getTable().getLayoutData())).horizontalSpan = 5;
		
		CellEditor[] editors = new CellEditor[] {
				new TextCellEditor(lstLibs.getTable()) {
					public boolean isValueValid() {
						Table table = lstLibs.getTable();
						String newLib = (String)getValue();
						int nSelectedRow = table.getSelectionIndex();
						for(int i = 0, j = table.getItemCount(); i < j; ++i) {
							if(i != nSelectedRow) {
							}
						}
						return true;
					}
				},

				new ComboBoxCellEditor(lstLibs.getTable(), new String[] {"Static", "Dynamic"}) {
					public boolean isValueValid() {
						int newValueIndex = ((Integer)getValue()).intValue();
						return (newValueIndex >= 0);
					}
				}
			};
				
			lstLibs.setCellEditors(editors);
			lstLibs.setCellModifier(new CellModifier());
			lstLibs.setColumnProperties(new String[] {COL1_PROPERTY, COL2_PROPERTY});


			lstLibs.addSelectionChangedListener(new ISelectionChangedListener() {
				public void selectionChanged(SelectionChangedEvent event) {
				    IStructuredSelection selection= (IStructuredSelection) event.getSelection();
				    Object selectedElement= selection.getFirstElement();
				    changeButtonsEnableStatus();				    	
				}
			});
					
			lstLibs.setSorter(null);
			lstLibs.setLabelProvider(new TableLabelProvider());
			lstLibs.setContentProvider(new IStructuredContentProvider()  {
				public Object[] getElements(Object inputElement) {
					return (Object[])inputElement;
				}
				public void dispose() {
				}
				public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
				}
			 
			});
			

			lstLibs.getTable().addMouseListener(new TableMouseAdapter(lstLibs));
			
		
	}

	protected void createButtons() {

		buttons = ControlFactory.createComposite((Composite)getControl(), 1);
		GridData gd = ((GridData)buttons.getLayoutData());
		gd.verticalAlignment = GridData.BEGINNING;
		gd.grabExcessHorizontalSpace = false;


		btnAdd = ControlFactory.createPushButton(buttons, "Add..."); 
		btnAdd.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				ControlFactory.deactivateCellEditor(lstLibs);
				SelectExtraLibDialog dlg = new SelectExtraLibDialog(getShell(),	"", "", 0);
				if(Window.OK == dlg.open()) {
					String libName = dlg.getInputValue();
					String libDir = dlg.getLibDir();
					boolean isStatic = dlg.isStatic();
					LibItem lib = new LibItem(libName, isStatic, new Path(libDir));
					lstLibs.add(lib);
				}
			}
		});

		
		btnDelete = ControlFactory.createPushButton(buttons, "Remove"); 
		btnDelete.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = 
				    (IStructuredSelection)lstLibs.getSelection();
				Object selElement = selection.getFirstElement();
				if(selElement != null) {
					// Modify storage
					/*
					List list = (List)listHandler.getValue();
					int selIndex = list.indexOf(selElement);
					list.remove(selElement);
					listHandler.setValue(list, true);
					// Modify table
					lstDirs.cancelEditing();
					lstDirs.remove(selElement);
                    // Modify selection
					int count = list.size();
					if(count > 0)
						lstDirs.getTable().select(Math.min(selIndex, count - 1));
					// Modify Delete button's state						
			    	btnDelete.setEnabled(count > 0);
					notifyOnChange(lstDirs.getTable());
					*/
				}
			}
		});

		btnEdit = ControlFactory.createPushButton(buttons, "Edit..."); 
		btnEdit.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				ControlFactory.deactivateCellEditor(lstLibs);
			}
		});
		
		
		btnDelete.setEnabled(lstLibs.getTable().getItemCount() > 0);

		ControlFactory.insertSpace(buttons, 1, 20);
		
		btnUp = ControlFactory.createPushButton(buttons, "Up"); 
		btnUp.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(swapNeighbours(true) == 0)
					btnUp.setEnabled(false);			
				changeButtonsEnableStatus();
			}
		});

		btnDown = ControlFactory.createPushButton(buttons, "Down"); 
		btnDown.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(swapNeighbours(false) == 0)
					btnDown.setEnabled(false);			
				changeButtonsEnableStatus();
			}
		});
		
	}
	
	private int swapNeighbours(boolean bUp) {	
		int up, down, index;
		index = lstLibs.getTable().getSelectionIndex();
		if(index >= 0) {
			if(bUp) {
				up = index;
				index = down = index - 1;
			} else {
				down = index;
				index = up = index + 1;
			}
			/*
			List list = (List)listHandler.getValue();
			Table table = lstDirs.getTable();
			Object elementUp = list.get(up);
			Object elementDown = list.get(down);
			list.set(up, elementDown);
			list.set(down, elementUp);
			lstDirs.setInput(list.toArray());
			table.select(index);
			notifyOnChange(lstDirs.getTable());
			*/
		}
		return index;
	}
	
	private void changeButtonsEnableStatus() {
		Table table = lstLibs.getTable();
		int index = table.getSelectionIndex();
		btnDelete.setEnabled(index >= 0);
		if(null != btnUp){
			btnUp.setEnabled(index > 0);
		}
		if(null != btnDown){
			btnDown.setEnabled((index >= 0) && 
							 (index < (table.getItemCount() - 1)));
		}
			    
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.cdt.managedbuilder.ui.properties.IBuildOptionSettingsPage#updateFields()
	 */
	public void updateFields() {
		IOption option = getOption(LIB_OPTION_ID);
		assert (option.getValueType() == IOption.LIBRARIES);
		try {
			String[] allLibs = option.getLibraries();
			for (int i = 0; i < allLibs.length; i++) {
				String string = allLibs[i];
				String linkType, libName;
				int nSpacePos = string.indexOf(' ');
				if(0 == nSpacePos) {
					linkType = "-B" + LNK_DYNAMIC;
					libName = string;
				} else {
					linkType = string.substring(0, nSpacePos);
					libName  = string.substring(nSpacePos + 1);
				}
				if(linkType.startsWith("-B"))
					linkType = linkType.substring(2);
				if(libName.startsWith("-l"))
					libName = libName.substring(2);
				assert(LNK_DYNAMIC.equals(linkType) || LNK_STATIC.equals(linkType));
				
				lstLibs.add(new LibItem(libName, 
						LNK_STATIC.equals(linkType) ? true : false, null));
				
			}
		} catch (BuildException e) {
			e.printStackTrace();
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.cdt.managedbuilder.ui.properties.IBuildOptionSettingsPage#storeSettings()
	 */
	public boolean performOk() {
		TableItem[] items = lstLibs.getTable().getItems();
		IOption option = getOption(LIB_OPTION_ID);
		assert (option.getValueType() == IOption.LIBRARIES);
		String[] libs = new String[items.length];
		for(int i = 0; i < items.length; ++i) {
			libs[i] = "-B" + items[i].getText(1) + " -l" + items[i].getText(0);
		}
		setValue(LIB_OPTION_ID, libs);
		
		return super.performOk();
	}
	
	private class LibItem {
		private IPath libDir;
		private String libName;
		private boolean bStatic;
		
		LibItem(String libName, boolean bStatic, IPath libDir) {
			this.libName = libName;
			this.bStatic = bStatic;
			this.libDir = libDir;
		}
		
		IPath getLibDir() {	return libDir;	}
		void setLibDir(IPath libDir) { this.libDir = libDir;	}
		String getLibName() { return libName; }
		void setLibName(String libName) { this.libName = libName; }
		boolean isStatic() {	return bStatic; }
		void setStatic(boolean bStatic) { this.bStatic = bStatic; }
	}
	
	private class CellModifier implements ICellModifier {
		private int nRow;
		public boolean canModify(Object element, String property) {
			nRow = lstLibs.getTable().getSelectionIndex();
			return true;
		}
		public Object getValue(Object element, String property) {
			
			LibItem lib = (LibItem)element;
			if(property.equals(COL1_PROPERTY))
				return lib.getLibName();
			else 
				return new Integer(lib.isStatic() ? 1 : 0);
		}
		
		public void modify(Object element, String property, Object value) {
			
			final LibItem lib = (LibItem)(((TableItem)element).getData());
			if(property.equals(COL1_PROPERTY))
				lib.setLibName((String)value);
			else 
				lib.setStatic(((Integer)value).intValue() == 0);
			
			Display.getCurrent().asyncExec(new Runnable() {
				public void run() {
					lstLibs.update((Object)lib, null);
				}
			});
		}
	}


    protected static class TableLabelProvider extends LabelProvider implements ITableLabelProvider {		
		/**
		 * @see ITableLabelProvider#getColumnText(Object, int)
		 */
		public String getColumnText(Object object, int column) {
			LibItem linkLib = (LibItem)object;
			switch(column) {
				case 0:
					return linkLib.getLibName();
				case 1:
					return (linkLib.isStatic() ? "static" : "dynamic");
			}
			return ""; //$NON-NLS-1$
		}

		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}
	}
	
	
}
