REM @echo off

REM Répertoire d'installation de l'application
SET APP_HOME=.

REM Chemin complet de l'exécutable Java
SET JAVA_EXEC=%JAVA_HOME%\bin\java

REM Fichier de propriétés de l'application
SET APP_PROPERTIES=%APP_HOME%\app.properties

REM Fichier de configuration des logs
SET LOG_CONFIGURATION=%APP_HOME%\logback.xml

REM Paramètres de la jvm (essentiellement la gestion de la mémoire
SET JAVA_OPTIONS=-Xms64m -Xmx512m -XX:MaxPermSize=128m

REM Paramètre JMX (activation et port)
SET JMX_ENABLED=true
SET JMX_PORT=7777

REM Activation des aspects
SET ASPECTS_ENABLED=true

REM Préparation des paramètres pour Java
SET JAVA_OPTIONS=-cp "%APP_HOME%\libs\ProtoApp-v0.0.1-SNAPSHOT.jar;%APP_HOME%\libs\*" %JAVA_OPTIONS%

REM Ajout des paramètres pour les aspects si nécessaire
SET ASPECTJ_AGENT=-javaagent:%APP_HOME%\libs\aspectjweaver-1.7.3.jar
REM SET ASPECTJ_TRACE=-Daj.weaving.verbose=true -Dorg.aspectj.weaver.showWeaveInfo=true -Dorg.aspectj.weaver.loadtime.configuration=file:./aop.xml -Daj.class.path=%APP_HOME%\libs -Daj.aspect.path=%APP_HOME%\libs\org.iiter.continuum.protos.aspects-0.0.1-SNAPSHOT.jar
SET ASPECTJ_TRACE=-Daj.weaving.verbose=true -Dorg.aspectj.weaver.showWeaveInfo=true
REM SET ASPECTJ_TRACE=-Daj.weaving.verbose=true -Dorg.aspectj.weaver.showWeaveInfo=true -Dorg.aspectj.weaver.loadtime.configuration=jar:file:%APP_HOME%/libs/org.iiter.continuum.protos.aspects-0.0.1-SNAPSHOT.jar!/META-INF/aop.xml

IF %ASPECTS_ENABLED% == true (
	REM SET JAVA_OPTIONS=%ASPECTJ_AGENT% %JAVA_OPTIONS% %ASPECTJ_TRACE%
	SET JAVA_OPTIONS=-javaagent:%APP_HOME%\org.iiter.continuum.protos.agent-0.0.1-SNAPSHOT.jar %ASPECTJ_AGENT% %JAVA_OPTIONS% %ASPECTJ_TRACE%
	REM SET JAVA_OPTIONS=-javaagent:%APP_HOME%\org.iiter.continuum.protos.agent-0.0.1-SNAPSHOT.jar %JAVA_OPTIONS%
	REM SET JAVA_OPTIONS=-javaagent:%APP_HOME%\libs\aspectjweaver-1.7.3.jar %JAVA_OPTIONS%
)

REM Ajout des paramètres pour JMX si nécessaire
IF %JMX_ENABLED% == true (
	SET JAVA_OPTIONS=%JAVA_OPTIONS% -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.port=%JMX_PORT% -Dcom.sun.management.jmxremote.authenticate=false -Dcom.sun.management.jmxremote.ssl=false
)

REM Lancement de l'application
"%JAVA_EXEC%" %JAVA_OPTIONS% -Dlogback.configurationFile=file:%LOG_CONFIGURATION% org.iiter.continuum.protos.simple.App
