package org.iiter.continuum.protos.agent;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/**
 * Noeud d'une hiérarchie
 * @param <T> Type de noeud de la hiérarchie
 */
public class HierarchyNode<T> {
	private final HierarchyNode<T> parent;
	private final List<HierarchyNode<T>> children;
	private final T value;
	
	/**
	 * Constructeur du noeud
	 * @param value Valeur du noeud
	 */
	public HierarchyNode(T value, HierarchyNode<T> parent) {
		super();
		this.parent = parent;
		this.value = value;
		this.children = new ArrayList<HierarchyNode<T>>();
	}

	public HierarchyNode<T> addChild(T childValue) {
		HierarchyNode<T> child = new HierarchyNode<T>(childValue, this);
		this.children.add(child);
		return child;
	}
	
	public T getValue() {
		return value;
	}

	public HierarchyNode<T> getParent() {
		return parent;
	}

	public HierarchyNode<T> getChild(T value) {
		for (HierarchyNode<T> child : children) {
			if (child.value == null) {
				if (value == null) {
					return child;
				}
			} else if (child.value.equals(value)) {
				return child;
			}
		}
		return null;
	}
	
	public void write(Writer writer) throws IOException {
		writer.write("\n");
		innerWrite(writer, "- ");
	}
	
	protected void innerWrite(Writer writer, String tabulation) throws IOException {
		writer.write(tabulation + (value != null ? value.toString() : "root") + "\n");
		String childTabulation = "  " + tabulation;
		for(HierarchyNode<T> child : children) {
			child.innerWrite(writer, childTabulation);
		}
	}
}
