package org.iiter.continuum.protos.agent;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.StringTokenizer;

/**
 *
 */
public class AdaptorKey extends WeakReference<ClassLoader> {
	private final int loaderHashCode, sysHashCode, hashValue;
	private final String loaderClass;
	private static final String AOP_XML = "META-INF/aop.xml;META-INF/aop-ajc.xml;org/aspectj/aop.xml";

	/**
	 * @param loader
	 */
	public AdaptorKey(ClassLoader loader) {
		super(loader);
		loaderHashCode = loader.hashCode();
		sysHashCode = System.identityHashCode(loader);
		loaderClass = loader.getClass().getName();
		hashValue = loaderHashCode + sysHashCode + loaderClass.hashCode();
	}

	/**
	 * @return Classloader
	 */
	public ClassLoader getClassLoader() {
		ClassLoader instance = get();
		// Assert instance!=null - shouldn't be asked for after a GC of the referent has occurred !
		return instance;
	}

	public boolean equals(Object obj) {
		if (!(obj instanceof AdaptorKey)) {
			return false;
		}
		AdaptorKey other = (AdaptorKey) obj;
		return (other.loaderHashCode == loaderHashCode)
				&&  (other.sysHashCode == sysHashCode)
				&& loaderClass.equals(other.loaderClass);
	}

	public int hashCode() {
		return hashValue;
	}

	@Override
	public String toString() {
		return "AdaptorKey [sysHashCode=" + sysHashCode + ", loaderClass=" + loaderClass + ", containsConfiguration=" + containsConfiguration() +", hasParent=" + (get().getParent() != null) + "]";
	}
	
	public boolean containsConfiguration() {
		StringTokenizer st = new StringTokenizer(AOP_XML, ";");
		while (st.hasMoreTokens()) {
			String nextDefinition = st.nextToken();
			ClassLoader loader = get();
			URL url = loader.getResource(nextDefinition);
			if (url != null) {
				return true;
			}
		}
		return false;
	}
	
}
