package de.scrum_master.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/**
 * See https://stackoverflow.com/a/54730041/1082681
 */

@Aspect
public class ConverterAspect {
  @Around("execution(* *..Converter+.convert(*)) && args(input)")
  public Object adviceStringConverter(ProceedingJoinPoint joinPoint, String input) throws Throwable {
      System.out.println(joinPoint + " -> " + input);
      return joinPoint.proceed();
  }

  @Around("execution(* *..Converter+.convert(String))")
  // Does not match because method type is not String but generic type T -> Object
  public Object adviceStringConverterNoMatch(ProceedingJoinPoint joinPoint) throws Throwable {
      System.out.println(joinPoint);
      return joinPoint.proceed();
  }
}
