package com.ericsson.aspectlib;

import java.util.Set;

/**
 * Data related to one detected invocation of a deprecated class and method.
 */
class DeprecatedMethodData {

    private String callingClassName;
    private String callingMethodName;
    private String targetClassName;
    private String deprecatedClassName;
    private String deprecatedMethodName;
    private String stackTrace;
    private Access access;
    private Set<String> repos;
    private String user;
    private String userDir;

    protected String getCallingClassName() {
        return callingClassName;
    }

    protected void setCallingClassName(String callingClassName) {
        this.callingClassName = callingClassName;
    }

    protected String getTargetClassName() {
        return targetClassName;
    }

    protected void setTargetClassName(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    protected String getDeprecatedClassName() {
        return deprecatedClassName;
    }

    protected void setDeprecatedClassName(String deprecatedClassName) {
        this.deprecatedClassName = deprecatedClassName;
    }

    protected String getDeprecatedMethodName() {
        return deprecatedMethodName;
    }

    protected void setDeprecatedMethodName(String deprecatedMethodName) {
        this.deprecatedMethodName = deprecatedMethodName;
    }

    protected Access getAccess() {
        return access;
    }

    protected void setAccess(Access access) {
        this.access = access;
    }

    protected String getCallingMethodName() {
        return callingMethodName;
    }

    protected void setCallingMethodName(String callingMethodName) {
        this.callingMethodName = callingMethodName;
    }

    protected String getStackTrace() {
        return stackTrace;
    }

    protected void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    protected Set<String> getRepos() {
        return repos;
    }

    protected void setRepos(Set<String> repos) {
        this.repos = repos;
    }

    protected String getUser() {
        return user;
    }

    protected void setUser(String user) {
        this.user = user;
    }

    protected String getUserDir() {
        return userDir;
    }

    protected void setUserDir(String userDir) {
        this.userDir = userDir;
    }

}
