package com.ericsson.aspectlib;

import java.util.ArrayList;
import java.util.List;


aspect DeprecatedMethodLogger {


    //Instantiated once so we can get information here that only needs to be fetched once.
    public DeprecatedMethodLogger() {
        

    }

    pointcut deprecated() :
        @annotation(Deprecated) && (call(public * *(..)) || call(*.new(..)));

    pointcut beta() :
        @annotation(com.google.common.annotations.Beta);

    pointcut deprecatedMethods() :
        deprecated() && !beta();

    before() : deprecatedMethods() {
        DeprecatedMethodData deprecatedMethodData = new DeprecatedMethodData();
        System.out.println(
                "Deprecated method " + thisJoinPoint.getSignature() +
                        " called by " + thisEnclosingJoinPointStaticPart.getSignature());
        deprecatedMethodData.setDeprecatedClassName(thisJoinPoint.getSignature().toString());
        deprecatedMethodData.setCallingClassName(thisEnclosingJoinPointStaticPart.getSignature().toString());
        deprecatedMethodData.setAccess(Access.EXTERNAL);
        deprecatedMethodData.setUser(JavaProperties.USER);
        deprecatedMethodData.setUserDir(JavaProperties.USER_DIR);
        
    }

  

  
}

