/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the compiler and core tools for the AspectJ(tm)
 * programming language; see http://aspectj.org
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is AspectJ.
 *
 * The Initial Developer of the Original Code is Xerox Corporation. Portions
 * created by Xerox Corporation are Copyright (C) 1999-2001 Xerox Corporation.
 * All Rights Reserved.
 *
 * Contributor(s):
 */

package org.aspectj.tools.ajdoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;

import java.util.*;

import org.aspectj.tools.ide.SymbolManager;
import org.aspectj.tools.ide.Declaration;
import org.aspectj.tools.ide.SourceLine;
class Phase2 {
     static void callJavadoc( String[] javadocargs ) {
        final SecurityManager defaultSecurityManager = System.getSecurityManager();

        System.setSecurityManager( new SecurityManager() {
            public void checkExit(int status) {
                if (status == 0) {
                   throw new SecurityException();
                }
                else {
                     System.setSecurityManager(defaultSecurityManager);
                //System.out.println("Error: javadoc exited unexpectedly");
                     System.exit(0);
                     throw new SecurityException();
                }
            }
            public void checkPermission( java.security.Permission permission ) {
               if ( defaultSecurityManager  != null )
                defaultSecurityManager.checkPermission( permission );
            }
             public void checkPermission( java.security.Permission permission,
					  Object context ) {
               if ( defaultSecurityManager  != null )
                 defaultSecurityManager.checkPermission( permission, context );
            }
            } );

        try {
            com.sun.tools.javadoc.Main.main( javadocargs );
        }
        catch ( SecurityException se ) {
            // Do nothing since we expect it to be thrown
            //System.out.println( ">> se: " + se.getMessage() );
        }
        // Set the security manager back
        System.setSecurityManager( defaultSecurityManager );
    }
}
