package org.eclipse.birt.rcp.viewer;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;


public class Perspective implements IPerspectiveFactory {

	public void createInitialLayout(IPageLayout layout) {
		
		//defineActions(layout);

		String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(false);
		
		layout.addStandaloneView(NavigationView.ID,  false, IPageLayout.LEFT, 0.50f, editorArea);
		
		IFolderLayout folder = layout.createFolder("parameters", IPageLayout.TOP, 0.5f, editorArea);
		folder.addPlaceholder(ParameterView.ID + ":*");
		folder.addView(ParameterView.ID);
		
		layout.getViewLayout(NavigationView.ID).setCloseable(false);
	}


}
