package org.eclipse.birt.rcp.viewer;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class NavigationView extends ViewPart {
    
	public static final String ID = "org.eclipse.birt.rcp.viewer.navigationView";
    
    private transient Text reportLocation = null;
    private transient Button browseFolderButton = null;
    private Composite lParent;
    private GridData gridData;
	public static final String BIRT_HOME   = "C:/birt-runtime-2_0_1/Report Engine";
	public static final String REPORT_FILE = "C:/test/testSampleDB.rptdesign";
	private Browser browser;
	private ProgressBar progressBar;
	
	
    /* (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        // TODO Auto-generated method stub
    	lParent = parent;
        parent.setLayout(new GridLayout());
        GridData gd = new GridData(GridData.FILL_HORIZONTAL);
        gridData = gd;           
        Group reportGroup = new Group(parent,SWT.SHADOW_IN);
        reportGroup.setText("Select report:");
        GridLayout layout = new GridLayout(2, false);        
        reportGroup.setLayout(layout);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        reportGroup.setLayoutData(gd);
        
        gd = new GridData();
        gd.horizontalSpan = 2;
                
        Label label = new Label(reportGroup, SWT.NONE);
        label.setText("Full Path:");
        
        label.setLayoutData(gd);

        reportLocation = new Text(reportGroup, SWT.BORDER);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        reportLocation.setLayoutData(gd);
        //setPageComplete(false);
        reportLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e)
            {
            	//
            }
            
        });
        
        browseFolderButton = new Button(reportGroup, SWT.RIGHT);
        browseFolderButton.setText("..."); //$NON-NLS-1$
        browseFolderButton.addSelectionListener(new SelectionAdapter(){

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetSelected(SelectionEvent e)
            {
            	FileDialog dialog = new FileDialog(reportLocation.getShell());
            	String [] extension = { "*.rptdesign"};
            	dialog.setFilterExtensions(extension);
                if(reportLocation.getText() != null && reportLocation.getText().trim().length() > 0)
                {
               	
                    dialog.setFilterPath(reportLocation.getText());
                   
                }
                
                String selectedLocation = dialog.open();
                if(selectedLocation != null)
                {
                	reportLocation.setText(selectedLocation);
                }
            }
            
        });
                
        Button showReport = new Button(reportGroup, SWT.PUSH);
        showReport.setText("Run Report");
         
        showReport.addSelectionListener(new SelectionListener(){
          
            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetSelected(SelectionEvent e) {
            	previewReport();
            	//addReportParameters(lParent, gridData);
                //openReportRunner();
            }
            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetDefaultSelected(SelectionEvent e) {
                // TODO Auto-generated method stub

            }
        });
        
    
		browser = new Browser( parent, SWT.NONE );
		gd = new GridData( GridData.FILL_BOTH );
		gd.horizontalSpan = 2;
		browser.setLayoutData( gd );
		browser.addLocationListener( new LocationAdapter( ) {

			public void changed( final LocationEvent e )
			{
				progressBar.setVisible( false );
			}

			public void changing( final LocationEvent e )
			{
				progressBar.setVisible( true );
			}
		} );

		gd = new GridData( GridData.END, GridData.CENTER, false, false );
		//gd = new GridData( GridData.FILL_BOTH );
		gd.heightHint = 10;
		gd.widthHint = 100;  
		progressBar = new ProgressBar( parent, SWT.INDETERMINATE );
		progressBar.setLayoutData( gd );
		progressBar.setVisible( false ); 

		//super.createPartControl( browser );

		WebViewer.startup( browser );
        
    }
    /* (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchPart#setFocus()
     */
    public void setFocus() {
        // TODO Auto-generated method stub

    }

    private void previewReport(){

    	String report = reportLocation.getText();
 
    	if (report.length() != 0) {
    		
    		//addReportParameters(this.lParent,new GridData( GridData.END, GridData.CENTER, false, false ));
    		
    		PreviewBirtAction preview = new PreviewBirtAction();
    		preview.setReportName(report);
    		preview.setBrowser(browser);
    		preview.run();
    		preview.dispose();
    	}
    }
 // the other aproach I tried was to dynamicaly add contrils to the sam view.
  // no success :(
    private void addReportParameters(Composite parent, GridData gridData)
    {
 	   String report = reportLocation.getText();
 	   try {
 	    getReportParameters(report, parent, gridData);
 	   } catch (EngineException e)
 	   {
 		   
 	   }
    }
    //To Be Done
    private static void getReportParameters(String name, Composite parent, GridData gridData) throws EngineException
	
    {
		// The EngineConfig is used to set up engine-wide configuration
		// information.
		EngineConfig config = new EngineConfig( );

	
		config.setEngineHome( BIRT_HOME );
		ReportEngine engine = new ReportEngine( config );
		
//		Open a report design 
		IReportRunnable design = engine.openReportDesign(name); 
		
		IGetParameterDefinitionTask task = engine.createGetParameterDefinitionTask( design );
		Collection params = task.getParameterDefns( true );

		Iterator iter = params.iterator( );
//		Iterate over all parameters
		while ( iter.hasNext( ) )
		{
			IParameterDefnBase param = (IParameterDefnBase) iter.next( );
			//Group section found
			if ( param instanceof IParameterGroupDefn )
			{
				//Get Group Name
				IParameterGroupDefn group = (IParameterGroupDefn) param;
				System.out.println( "Parameter Group: " + group.getName( ) );
				
				//Get the parameters within a group
				Iterator i2 = group.getContents( ).iterator( );
				while ( i2.hasNext( ) )
				{
					IScalarParameterDefn scalar = (IScalarParameterDefn) i2.next( );
					System.out.println("	" + scalar.getName());
				}
			}
			else
			{
				//Parameters are not in a group
				IScalarParameterDefn scalar = (IScalarParameterDefn) param;
				System.out.println(param.getName());
				
				//Parameter is a List Box
				if(scalar.getControlType() ==  IScalarParameterDefn.LIST_BOX)
				{
				    Collection selectionList = task.getSelectionList( param.getName() );
				    //Selection contains data    
					if ( selectionList != null )
					{
						for ( Iterator sliter = selectionList.iterator( ); sliter.hasNext( ); )
						{
							//Print out the selection choices
							IParameterSelectionChoice selectionItem = (IParameterSelectionChoice) sliter.next( );
							String value = (String)selectionItem.getValue( );
							String label = selectionItem.getLabel( );
							System.out.println( label + "--" + value);
						}
					}		        
				}   
			}
		}
		gridData = new GridData();
		
		Group paramGroup = new Group(parent,SWT.SHADOW_IN);
		paramGroup.setText("Report parameters:");
        GridLayout layout = new GridLayout(2, false);        
        paramGroup.setLayout(layout);
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        paramGroup.setLayoutData(gridData);
        
        gridData = new GridData();
        gridData.horizontalSpan = 2;
                
        Label label = new Label(paramGroup, SWT.NONE);
        label.setText("This report does not have parameters.");
        
        label.setLayoutData(gridData);
        
		task.close();
		engine.destroy( );
    }
  
 
}







