import java.io.IOException;

import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;


public class Hello {
	/**
	 * http://www.antlr.org/wiki/pages/viewpage.action?pageId=789
	 * @param args
	 */
	public static void main(String[] args) {
		System.out.println("Test de C.g");
		try {
			CharStream inputTxt = new ANTLRFileStream("hello.c");
			CLexer clexer=new CLexer(inputTxt);
			CommonTokenStream tokens = new CommonTokenStream();
			tokens.setTokenSource(clexer);
			CParser cparser=new CParser(tokens);
			cparser.translation_unit();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (RecognitionException e) {
			e.printStackTrace();
		}
		System.out.println("Test de MyDsl.g backtrack=true memoize=false");
		try {
			CharStream inputTxt = new ANTLRFileStream("hello.c");
			MyDslLexer clexer=new MyDslLexer(inputTxt);
			CommonTokenStream tokens = new CommonTokenStream();
			tokens.setTokenSource(clexer);
			MyDslParser cparser=new MyDslParser(tokens);
			cparser.translation_unit();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (RecognitionException e) {
			e.printStackTrace();
		}
		System.out.println("Test de MyDsl.g backtrack=true memoize=true");
		try {
			CharStream inputTxt = new ANTLRFileStream("hello.c");
			MyDslLexerMemoize clexer=new MyDslLexerMemoize(inputTxt);
			CommonTokenStream tokens = new CommonTokenStream();
			tokens.setTokenSource(clexer);
			MyDslParserMemoize cparser=new MyDslParserMemoize(tokens);
			cparser.translation_unit();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (RecognitionException e) {
			e.printStackTrace();
		}
		System.out.println("Test de MyDsl.g backtrack=true memoize=false et syntactic predicates");
		try {
			CharStream inputTxt = new ANTLRFileStream("hello.c");
			MyDslLexerPred clexer=new MyDslLexerPred(inputTxt);
			CommonTokenStream tokens = new CommonTokenStream();
			tokens.setTokenSource(clexer);
			MyDslParserPred cparser=new MyDslParserPred(tokens);
			cparser.translation_unit();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (RecognitionException e) {
			e.printStackTrace();
		}
	}
}
