/*
* MOBILE-PLAN Next Generation
* Copyright  initplan GmbH - All rights reserved.
*/

package com.example.rap.editor.internal.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class DemoEditor extends EditorPart
{
  private Text _text;
  private boolean _dirty = false;

  @Override
  public void createPartControl(final Composite parent)
  {
    _text = new Text(parent, SWT.MULTI);
    _text.addModifyListener(new ModifyListener()
    {
      @Override
      public void modifyText(final ModifyEvent event)
      {
        _dirty = true;
        firePropertyChange(PROP_DIRTY);
      }
    });
  }

  @Override
  public void doSave(final IProgressMonitor monitor)
  {
    // Saving is not implemented.
  }

  @Override
  public void doSaveAs()
  {
    // Saving is not implemented.
  }

  @Override
  public void init(final IEditorSite site, final IEditorInput input) throws PartInitException
  {
    setSite(site);
    setInput(input);
    setPartName(input.getName());
    setTitleToolTip(input.getToolTipText());
  }

  @Override
  public boolean isDirty()
  {
    return _dirty;
  }

  @Override
  public boolean isSaveAsAllowed()
  {
    return false;
  }

  @Override
  public void setFocus()
  {
    _text.setFocus();
  }
}
