/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.data.oda.subjdbc;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;

import org.eclipse.birt.report.data.oda.i18n.ResourceConstants;
import org.eclipse.birt.report.data.oda.jdbc.*;
import org.eclipse.birt.report.data.oda.jdbc.Connection.Constants;
import org.eclipse.datatools.connectivity.oda.OdaException;
import java.util.Properties;
import java.util.HashMap;


import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.logging.Level;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
/**
 * This class implements IDriver, which is the entry point for the
 * ODA consumer.
 * 
 */
public class SubOdaJdbcDriver extends OdaJdbcDriver
{
	private Connection passedInConnection;


	public void setAppContext( Object context ) throws OdaException
	{
	    HashMap ctx = (HashMap)context;
	    passedInConnection = (java.sql.Connection)ctx.get("org.eclipse.birt.report.data.oda.subjdbc.SubOdaJdbcDriver");

	}	
	
	public IConnection getConnection(String connectionClassName) throws OdaException
	{
		if( passedInConnection != null){
			return new appContextDBConnection();
		}else{
			return new org.eclipse.birt.report.data.oda.jdbc.Connection();
		}
	}
	
	public int getMaxConnections() throws OdaException
	{
		//No limit is imposed on the connections
		return(0);
	}

	private class appContextDBConnection extends org.eclipse.birt.report.data.oda.jdbc.Connection
	{
	
			
		public void open(Properties connProperties) throws OdaException
		{
			super.jdbcConn = passedInConnection;			
		
		}
		
		public void close( ) throws OdaException
		{
			if ( jdbcConn == null )
			{
				return;
			}
			//should have call to return connection to the pool
			jdbcConn = null;						
		}				
		
		
		
	}
	
	
}