



import java.util.HashMap;

import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.api.EngineConstants;

import java.sql.*;

public class ExecuteConnectionPool {
	
	
	private java.sql.Connection setupJdbcConnection(){
		java.sql.Connection conn = null;
		
	    	try{
	    		Class.forName( "com.mysql.jdbc.Driver" );
	    		conn = java.sql.DriverManager.getConnection(
	    				"jdbc:mysql://localhost/classicmodels", "root", "root");
	    	}	
	    	catch ( Exception e )
			{
	    		e.printStackTrace();
	    		System.exit(0);
			}
    		return( conn );
	    	
	}
	
	public void executeReport() throws EngineException
	{
		//Engine Configuration - set and get temp dir, BIRT home, Servlet context
		EngineConfig config = new EngineConfig();
		config.setEngineHome( "C:/birt-runtime-2_0_0/birt-runtime-2_0_0/Report Engine" );	
		
		//Create the report engine
		ReportEngine engine = new ReportEngine( config );
		
		//Open a report design - use design to modify design, retrieve embedded images etc. 
		IReportRunnable design = engine.openReportDesign("C:/work/birt/connectionpool/AppContextTest.rptdesign"); 
		
		//Create task to run the report - use the task to execute and run the report,
		//retrieve report parameter values from ParameterDefinitionTask();
		IRunAndRenderTask task = engine.createRunAndRenderTask(design); 
		
		//Set Render context to handle url and image locataions
		HTMLRenderContext renderContext = new HTMLRenderContext();
		renderContext.setImageDirectory("image");
		HashMap contextMap = new HashMap();
		contextMap.put( EngineConstants.APPCONTEXT_HTML_RENDER_CONTEXT, renderContext );

		//add the connection object to the map
		contextMap.put( "org.eclipse.birt.report.data.oda.subjdbc.SubOdaJdbcDriver", setupJdbcConnection() );
		
		task.setAppContext( contextMap );
		
		//Set rendering options - such as file or stream output, 
		//output format, whether it is embeddable, etc
		HTMLRenderOption options = new HTMLRenderOption();
		//options.setOutputStream(System.out);
		options.setOutputFileName("C:/work/birt/connectionpool/AppContextTest.html");
		options.setOutputFormat("html");
		task.setRenderOption(options);
		
		//run the report and destroy the engine
		task.run();
		engine.destroy();
	}	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try
		{
			ExecuteConnectionPool ecp = new ExecuteConnectionPool();
			ecp.executeReport( );
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}
	}

}
