/******************************************************************************
 * Copyright (c) 2011, 2012 Piotr J. Puczynski (DTU Informatics).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Piotr J. Puczynski (DTU Informatics) - initial API and implementation 
 *    
 ****************************************************************************/

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

/**
 * Testing methods help
 * 
 * @author Piotr. J. Puczynski (piotr.puczynski)
 * 
 */
public class TestUtils {

	private static boolean umlInit = false;

	/**
	 * Loads resource file as UML2 model
	 * 
	 * @param modelFileName
	 * @return resource
	 */
	public static Resource getUMLResource(String modelFileName) {
		String path = System.getProperty("user.dir");
		ResourceSet resourceSet = new ResourceSetImpl();
		resourceSet.getPackageRegistry().put(UMLPackage.eNS_URI, UMLPackage.eINSTANCE);

		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(UMLResource.FILE_EXTENSION, UMLResource.Factory.INSTANCE);

		// Map uriMap = resourceSet.getURIConverter().getURIMap();
		if (!umlInit) {
			System.setProperty("org.eclipse.ocl.uml", path + "/libs/ocl");
			System.setProperty("org.eclipse.uml2.uml.resources", path +  "/libs/uml");
			String result = org.eclipse.ocl.uml.OCL.initialize(null); // null for global init
			assert result == null;
			// org.eclipse.ocl.uml.OCL.initialize(resourceSet);
			Environment.Registry.INSTANCE.registerEnvironment(
					new UMLEnvironmentFactory().createEnvironment());
			umlInit = true;
		}

		URI uri = URI.createURI("file:/" + path  + "/" +  modelFileName);

		Resource result = resourceSet.getResource(uri, true);

		return result;
	}


	public static InstanceSpecification getInstanceSpecification(Resource model, final String instanceName) {
		InstanceSpecification instance = null;
		instance = (InstanceSpecification) UML2Util.findEObject(model.getAllContents(), new UML2Util.EObjectMatcher() {
			public boolean matches(EObject eObject) {
				if (eObject.eClass().getName().equals("InstanceSpecification")) {
					return ((InstanceSpecification) eObject).getName().equals(instanceName);
				}
				return false;
			}
		});
		return instance;
	}
}
