import static org.junit.Assert.*;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.options.EvaluationOptions;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.options.EvaluationMode;
import org.eclipse.ocl.uml.options.UMLEvaluationOptions;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.junit.Test;

/******************************************************************************
 * Copyright (c) 2011, 2012 Piotr J. Puczynski (DTU Informatics).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Piotr J. Puczynski (DTU Informatics) - initial API and implementation 
 *    
 ****************************************************************************/

/**
 * @author Piotr J. Puczynski
 *
 */
public class OCLTest {

	private Resource model = TestUtils.getUMLResource("Simple08.uml");
	
	@Test
	public void test() throws ParserException {
		InstanceSpecification instance = TestUtils.getInstanceSpecification(model, "C1");
		UMLEnvironmentFactory envFactory = new UMLEnvironmentFactory(model.getResourceSet());
		UMLEnvironment env = envFactory.createEnvironment();
		org.eclipse.ocl.uml.OCL myOCL = org.eclipse.ocl.uml.OCL.newInstance(env);
		EvaluationEnvironment<?, ?, ?, ?, ?> evalEnv = myOCL.getEvaluationEnvironment();
		EvaluationOptions.setOption(evalEnv, UMLEvaluationOptions.EVALUATION_MODE, EvaluationMode.RUNTIME_OBJECTS);
		evalEnv.add("c", 3);
		OCLExpression<?> oclConstraint = null;
			myOCL.setEvaluationTracingEnabled(true);
			myOCL.setParseTracingEnabled(true);

		OCLHelper<?, ?, ?, ?> helper = myOCL.createOCLHelper();
		helper.setInstanceContext(instance);
		String body = "c = 3";
		oclConstraint = helper.createQuery(body);
		@SuppressWarnings("unchecked")
		Object result = myOCL.evaluate(instance, (OCLExpression<Classifier>) oclConstraint);
		assertTrue(result instanceof Boolean);
		assertTrue((Boolean) result);
	}

}
