/**
 * <copyright>
 * </copyright>
 *

 */
package arden.xtext.xText.util;

import arden.xtext.xText.*;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see arden.xtext.xText.XTextPackage
 * @generated
 */
public class XTextSwitch<T> extends Switch<T>
{
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static XTextPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public XTextSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = XTextPackage.eINSTANCE;
    }
  }

  /**
   * Checks whether this is a switch for the given package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @parameter ePackage the package in question.
   * @return whether this is a switch for the given package.
   * @generated
   */
  @Override
  protected boolean isSwitchFor(EPackage ePackage)
  {
    return ePackage == modelPackage;
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  @Override
  protected T doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case XTextPackage.PROGRAM:
      {
        program program = (program)theEObject;
        T result = caseprogram(program);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.MLMS:
      {
        mlms mlms = (mlms)theEObject;
        T result = casemlms(mlms);
        if (result == null) result = caseprogram(mlms);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.PMLM:
      {
        P_mlm p_mlm = (P_mlm)theEObject;
        T result = caseP_mlm(p_mlm);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.MAINTENANCE_CATEGORY:
      {
        maintenance_category maintenance_category = (maintenance_category)theEObject;
        T result = casemaintenance_category(maintenance_category);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.MAINTENANCE_BODY:
      {
        maintenance_body maintenance_body = (maintenance_body)theEObject;
        T result = casemaintenance_body(maintenance_body);
        if (result == null) result = casemaintenance_category(maintenance_body);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.LIBRARY_CATEGORY:
      {
        library_category library_category = (library_category)theEObject;
        T result = caselibrary_category(library_category);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.LIBRARY_BODY:
      {
        library_body library_body = (library_body)theEObject;
        T result = caselibrary_body(library_body);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.KNOWLEDGE_CATEGORY:
      {
        knowledge_category knowledge_category = (knowledge_category)theEObject;
        T result = caseknowledge_category(knowledge_category);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.KNOWLEDGE_BODY:
      {
        knowledge_body knowledge_body = (knowledge_body)theEObject;
        T result = caseknowledge_body(knowledge_body);
        if (result == null) result = caseknowledge_category(knowledge_body);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.TITLE_SLOT:
      {
        title_slot title_slot = (title_slot)theEObject;
        T result = casetitle_slot(title_slot);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.DATA_SLOT:
      {
        data_slot data_slot = (data_slot)theEObject;
        T result = casedata_slot(data_slot);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EVOKE_SLOT:
      {
        evoke_slot evoke_slot = (evoke_slot)theEObject;
        T result = caseevoke_slot(evoke_slot);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.LOGIC_SLOT:
      {
        logic_slot logic_slot = (logic_slot)theEObject;
        T result = caselogic_slot(logic_slot);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.ACTION_SLOT:
      {
        action_slot action_slot = (action_slot)theEObject;
        T result = caseaction_slot(action_slot);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.LOGIC_BLOCK:
      {
        logic_block logic_block = (logic_block)theEObject;
        T result = caselogic_block(logic_block);
        if (result == null) result = caselogic_slot(logic_block);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.LOGIC_STATEMENT:
      {
        logic_statement logic_statement = (logic_statement)theEObject;
        T result = caselogic_statement(logic_statement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.LOGIC_IF_THEN_ELSE2:
      {
        logic_if_then_else2 logic_if_then_else2 = (logic_if_then_else2)theEObject;
        T result = caselogic_if_then_else2(logic_if_then_else2);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.LOGIC_ELSEIF:
      {
        logic_elseif logic_elseif = (logic_elseif)theEObject;
        T result = caselogic_elseif(logic_elseif);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.LOGIC_ASSIGNMENT:
      {
        logic_assignment logic_assignment = (logic_assignment)theEObject;
        T result = caselogic_assignment(logic_assignment);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.CALL_PHRASE:
      {
        call_phrase call_phrase = (call_phrase)theEObject;
        T result = casecall_phrase(call_phrase);
        if (result == null) result = caselogic_assignment(call_phrase);
        if (result == null) result = casedata_assign_phrase(call_phrase);
        if (result == null) result = caseaction_statement(call_phrase);
        if (result == null) result = casedata_assignment(call_phrase);
        if (result == null) result = casedata_statement(call_phrase);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR:
      {
        expr expr = (expr)theEObject;
        T result = caseexpr(expr);
        if (result == null) result = casecall_phrase(expr);
        if (result == null) result = casedata_if_then_else2(expr);
        if (result == null) result = casenew_object_phrase(expr);
        if (result == null) result = caselogic_assignment(expr);
        if (result == null) result = casedata_assign_phrase(expr);
        if (result == null) result = caseaction_statement(expr);
        if (result == null) result = casedata_assignment(expr);
        if (result == null) result = casedata_statement(expr);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_LEFT:
      {
        expr_left expr_left = (expr_left)theEObject;
        T result = caseexpr_left(expr_left);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_SORT:
      {
        expr_sort expr_sort = (expr_sort)theEObject;
        T result = caseexpr_sort(expr_sort);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_WHERE:
      {
        expr_where expr_where = (expr_where)theEObject;
        T result = caseexpr_where(expr_where);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_RANGE:
      {
        expr_range expr_range = (expr_range)theEObject;
        T result = caseexpr_range(expr_range);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_OR:
      {
        expr_or expr_or = (expr_or)theEObject;
        T result = caseexpr_or(expr_or);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_AND:
      {
        expr_and expr_and = (expr_and)theEObject;
        T result = caseexpr_and(expr_and);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_NOT:
      {
        expr_not expr_not = (expr_not)theEObject;
        T result = caseexpr_not(expr_not);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_COMPARISON:
      {
        expr_comparison expr_comparison = (expr_comparison)theEObject;
        T result = caseexpr_comparison(expr_comparison);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_FIND_STRING:
      {
        expr_find_string expr_find_string = (expr_find_string)theEObject;
        T result = caseexpr_find_string(expr_find_string);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.STRING_SEARCH_START:
      {
        string_search_start string_search_start = (string_search_start)theEObject;
        T result = casestring_search_start(string_search_start);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_STRING:
      {
        expr_string expr_string = (expr_string)theEObject;
        T result = caseexpr_string(expr_string);
        if (result == null) result = casemain_comp_op(expr_string);
        if (result == null) result = casetemporal_comp_op(expr_string);
        if (result == null) result = casein_comp_op(expr_string);
        if (result == null) result = caseexpr_comparison(expr_string);
        if (result == null) result = caseread_where(expr_string);
        if (result == null) result = caseread_phrase(expr_string);
        if (result == null) result = casedata_assign_phrase(expr_string);
        if (result == null) result = casedata_assignment(expr_string);
        if (result == null) result = casedata_statement(expr_string);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_STRING_LEFT:
      {
        expr_string_left expr_string_left = (expr_string_left)theEObject;
        T result = caseexpr_string_left(expr_string_left);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.SUBSTRING_START:
      {
        substring_start substring_start = (substring_start)theEObject;
        T result = casesubstring_start(substring_start);
        if (result == null) result = caseexpr_string(substring_start);
        if (result == null) result = casemain_comp_op(substring_start);
        if (result == null) result = casetemporal_comp_op(substring_start);
        if (result == null) result = casein_comp_op(substring_start);
        if (result == null) result = caseexpr_comparison(substring_start);
        if (result == null) result = caseread_where(substring_start);
        if (result == null) result = caseread_phrase(substring_start);
        if (result == null) result = casedata_assign_phrase(substring_start);
        if (result == null) result = casedata_assignment(substring_start);
        if (result == null) result = casedata_statement(substring_start);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_PLUS:
      {
        expr_plus expr_plus = (expr_plus)theEObject;
        T result = caseexpr_plus(expr_plus);
        if (result == null) result = casestring_search_start(expr_plus);
        if (result == null) result = caseexpr_string(expr_plus);
        if (result == null) result = caseexpr_string_left(expr_plus);
        if (result == null) result = casemain_comp_op(expr_plus);
        if (result == null) result = casetemporal_comp_op(expr_plus);
        if (result == null) result = casein_comp_op(expr_plus);
        if (result == null) result = caseexpr_comparison(expr_plus);
        if (result == null) result = caseread_where(expr_plus);
        if (result == null) result = caseread_phrase(expr_plus);
        if (result == null) result = casedata_assign_phrase(expr_plus);
        if (result == null) result = casedata_assignment(expr_plus);
        if (result == null) result = casedata_statement(expr_plus);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_PLUS_LEFT:
      {
        expr_plus_left expr_plus_left = (expr_plus_left)theEObject;
        T result = caseexpr_plus_left(expr_plus_left);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_TIMES:
      {
        expr_times expr_times = (expr_times)theEObject;
        T result = caseexpr_times(expr_times);
        if (result == null) result = caseexpr_plus(expr_times);
        if (result == null) result = caseexpr_plus_left(expr_times);
        if (result == null) result = casestring_search_start(expr_times);
        if (result == null) result = caseexpr_string(expr_times);
        if (result == null) result = caseexpr_string_left(expr_times);
        if (result == null) result = casemain_comp_op(expr_times);
        if (result == null) result = casetemporal_comp_op(expr_times);
        if (result == null) result = casein_comp_op(expr_times);
        if (result == null) result = caseexpr_comparison(expr_times);
        if (result == null) result = caseread_where(expr_times);
        if (result == null) result = caseread_phrase(expr_times);
        if (result == null) result = casedata_assign_phrase(expr_times);
        if (result == null) result = casedata_assignment(expr_times);
        if (result == null) result = casedata_statement(expr_times);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_TIMES_LEFT:
      {
        expr_times_left expr_times_left = (expr_times_left)theEObject;
        T result = caseexpr_times_left(expr_times_left);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_POWER:
      {
        expr_power expr_power = (expr_power)theEObject;
        T result = caseexpr_power(expr_power);
        if (result == null) result = caseexpr_times(expr_power);
        if (result == null) result = caseexpr_times_left(expr_power);
        if (result == null) result = caseexpr_plus(expr_power);
        if (result == null) result = caseexpr_plus_left(expr_power);
        if (result == null) result = casestring_search_start(expr_power);
        if (result == null) result = caseexpr_string(expr_power);
        if (result == null) result = caseexpr_string_left(expr_power);
        if (result == null) result = casemain_comp_op(expr_power);
        if (result == null) result = casetemporal_comp_op(expr_power);
        if (result == null) result = casein_comp_op(expr_power);
        if (result == null) result = caseexpr_comparison(expr_power);
        if (result == null) result = caseread_where(expr_power);
        if (result == null) result = caseread_phrase(expr_power);
        if (result == null) result = casedata_assign_phrase(expr_power);
        if (result == null) result = casedata_assignment(expr_power);
        if (result == null) result = casedata_statement(expr_power);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_BEFORE:
      {
        expr_before expr_before = (expr_before)theEObject;
        T result = caseexpr_before(expr_before);
        if (result == null) result = caseexpr_power(expr_before);
        if (result == null) result = caseexpr_times(expr_before);
        if (result == null) result = caseexpr_times_left(expr_before);
        if (result == null) result = caseexpr_plus(expr_before);
        if (result == null) result = caseexpr_plus_left(expr_before);
        if (result == null) result = casestring_search_start(expr_before);
        if (result == null) result = caseexpr_string(expr_before);
        if (result == null) result = caseexpr_string_left(expr_before);
        if (result == null) result = casemain_comp_op(expr_before);
        if (result == null) result = casetemporal_comp_op(expr_before);
        if (result == null) result = casein_comp_op(expr_before);
        if (result == null) result = caseexpr_comparison(expr_before);
        if (result == null) result = caseread_where(expr_before);
        if (result == null) result = caseread_phrase(expr_before);
        if (result == null) result = casedata_assign_phrase(expr_before);
        if (result == null) result = casedata_assignment(expr_before);
        if (result == null) result = casedata_statement(expr_before);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_AGO:
      {
        expr_ago expr_ago = (expr_ago)theEObject;
        T result = caseexpr_ago(expr_ago);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_DURATION:
      {
        expr_duration expr_duration = (expr_duration)theEObject;
        T result = caseexpr_duration(expr_duration);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_FUNCTION:
      {
        expr_function expr_function = (expr_function)theEObject;
        T result = caseexpr_function(expr_function);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_FACTOR:
      {
        expr_factor expr_factor = (expr_factor)theEObject;
        T result = caseexpr_factor(expr_factor);
        if (result == null) result = casesubstring_start(expr_factor);
        if (result == null) result = caseexpr_function(expr_factor);
        if (result == null) result = caseexpr_string(expr_factor);
        if (result == null) result = casemain_comp_op(expr_factor);
        if (result == null) result = casetemporal_comp_op(expr_factor);
        if (result == null) result = casein_comp_op(expr_factor);
        if (result == null) result = caseexpr_comparison(expr_factor);
        if (result == null) result = caseread_where(expr_factor);
        if (result == null) result = caseread_phrase(expr_factor);
        if (result == null) result = casedata_assign_phrase(expr_factor);
        if (result == null) result = casedata_assignment(expr_factor);
        if (result == null) result = casedata_statement(expr_factor);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EXPR_FACTOR_ATOM:
      {
        expr_factor_atom expr_factor_atom = (expr_factor_atom)theEObject;
        T result = caseexpr_factor_atom(expr_factor_atom);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.MAIN_COMP_OP:
      {
        main_comp_op main_comp_op = (main_comp_op)theEObject;
        T result = casemain_comp_op(main_comp_op);
        if (result == null) result = caseexpr_comparison(main_comp_op);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.TEMPORAL_COMP_OP:
      {
        temporal_comp_op temporal_comp_op = (temporal_comp_op)theEObject;
        T result = casetemporal_comp_op(temporal_comp_op);
        if (result == null) result = caseexpr_comparison(temporal_comp_op);
        if (result == null) result = caseread_where(temporal_comp_op);
        if (result == null) result = caseread_phrase(temporal_comp_op);
        if (result == null) result = casedata_assign_phrase(temporal_comp_op);
        if (result == null) result = casedata_assignment(temporal_comp_op);
        if (result == null) result = casedata_statement(temporal_comp_op);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.IN_COMP_OP:
      {
        in_comp_op in_comp_op = (in_comp_op)theEObject;
        T result = casein_comp_op(in_comp_op);
        if (result == null) result = caseexpr_comparison(in_comp_op);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.DATA_BLOCK:
      {
        data_block data_block = (data_block)theEObject;
        T result = casedata_block(data_block);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.DATA_BLOCK_LEFT:
      {
        data_block_left data_block_left = (data_block_left)theEObject;
        T result = casedata_block_left(data_block_left);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.DATA_STATEMENT:
      {
        data_statement data_statement = (data_statement)theEObject;
        T result = casedata_statement(data_statement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.DATA_IF_THEN_ELSE2:
      {
        data_if_then_else2 data_if_then_else2 = (data_if_then_else2)theEObject;
        T result = casedata_if_then_else2(data_if_then_else2);
        if (result == null) result = casedata_statement(data_if_then_else2);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.DATA_ELSEIF:
      {
        data_elseif data_elseif = (data_elseif)theEObject;
        T result = casedata_elseif(data_elseif);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.DATA_ASSIGNMENT:
      {
        data_assignment data_assignment = (data_assignment)theEObject;
        T result = casedata_assignment(data_assignment);
        if (result == null) result = casedata_statement(data_assignment);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.DATA_ASSIGN_PHRASE:
      {
        data_assign_phrase data_assign_phrase = (data_assign_phrase)theEObject;
        T result = casedata_assign_phrase(data_assign_phrase);
        if (result == null) result = casedata_assignment(data_assign_phrase);
        if (result == null) result = casedata_statement(data_assign_phrase);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.READ_PHRASE:
      {
        read_phrase read_phrase = (read_phrase)theEObject;
        T result = caseread_phrase(read_phrase);
        if (result == null) result = casedata_assign_phrase(read_phrase);
        if (result == null) result = casedata_assignment(read_phrase);
        if (result == null) result = casedata_statement(read_phrase);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.READ_WHERE:
      {
        read_where read_where = (read_where)theEObject;
        T result = caseread_where(read_where);
        if (result == null) result = caseread_phrase(read_where);
        if (result == null) result = casedata_assign_phrase(read_where);
        if (result == null) result = casedata_assignment(read_where);
        if (result == null) result = casedata_statement(read_where);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.NEW_OBJECT_PHRASE:
      {
        new_object_phrase new_object_phrase = (new_object_phrase)theEObject;
        T result = casenew_object_phrase(new_object_phrase);
        if (result == null) result = caselogic_assignment(new_object_phrase);
        if (result == null) result = casedata_assign_phrase(new_object_phrase);
        if (result == null) result = caseaction_statement(new_object_phrase);
        if (result == null) result = casedata_assignment(new_object_phrase);
        if (result == null) result = casedata_statement(new_object_phrase);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EVOKE_BLOCK:
      {
        evoke_block evoke_block = (evoke_block)theEObject;
        T result = caseevoke_block(evoke_block);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EVOKE_BLOCK_LEFT:
      {
        evoke_block_left evoke_block_left = (evoke_block_left)theEObject;
        T result = caseevoke_block_left(evoke_block_left);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.EVOKE_STATEMENT:
      {
        evoke_statement evoke_statement = (evoke_statement)theEObject;
        T result = caseevoke_statement(evoke_statement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.QUALIFIED_EVOKE_CYCLE:
      {
        qualified_evoke_cycle qualified_evoke_cycle = (qualified_evoke_cycle)theEObject;
        T result = casequalified_evoke_cycle(qualified_evoke_cycle);
        if (result == null) result = caseevoke_statement(qualified_evoke_cycle);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.SIMPLE_EVOKE_CYCLE:
      {
        simple_evoke_cycle simple_evoke_cycle = (simple_evoke_cycle)theEObject;
        T result = casesimple_evoke_cycle(simple_evoke_cycle);
        if (result == null) result = casequalified_evoke_cycle(simple_evoke_cycle);
        if (result == null) result = caseevoke_statement(simple_evoke_cycle);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.ACTION_BLOCK:
      {
        action_block action_block = (action_block)theEObject;
        T result = caseaction_block(action_block);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.ACTION_BLOCK_LEFT:
      {
        action_block_left action_block_left = (action_block_left)theEObject;
        T result = caseaction_block_left(action_block_left);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.ACTION_STATEMENT:
      {
        action_statement action_statement = (action_statement)theEObject;
        T result = caseaction_statement(action_statement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.ACTION_IF_THEN_ELSE2:
      {
        action_if_then_else2 action_if_then_else2 = (action_if_then_else2)theEObject;
        T result = caseaction_if_then_else2(action_if_then_else2);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case XTextPackage.ACTION_ELSEIF:
      {
        action_elseif action_elseif = (action_elseif)theEObject;
        T result = caseaction_elseif(action_elseif);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>program</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>program</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseprogram(program object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>mlms</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>mlms</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casemlms(mlms object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Pmlm</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Pmlm</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseP_mlm(P_mlm object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>maintenance category</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>maintenance category</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casemaintenance_category(maintenance_category object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>maintenance body</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>maintenance body</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casemaintenance_body(maintenance_body object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>library category</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>library category</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caselibrary_category(library_category object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>library body</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>library body</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caselibrary_body(library_body object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>knowledge category</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>knowledge category</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseknowledge_category(knowledge_category object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>knowledge body</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>knowledge body</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseknowledge_body(knowledge_body object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>title slot</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>title slot</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casetitle_slot(title_slot object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>data slot</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>data slot</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casedata_slot(data_slot object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>evoke slot</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>evoke slot</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseevoke_slot(evoke_slot object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>logic slot</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>logic slot</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caselogic_slot(logic_slot object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>action slot</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>action slot</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseaction_slot(action_slot object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>logic block</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>logic block</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caselogic_block(logic_block object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>logic statement</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>logic statement</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caselogic_statement(logic_statement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>logic if then else2</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>logic if then else2</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caselogic_if_then_else2(logic_if_then_else2 object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>logic elseif</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>logic elseif</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caselogic_elseif(logic_elseif object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>logic assignment</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>logic assignment</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caselogic_assignment(logic_assignment object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>call phrase</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>call phrase</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casecall_phrase(call_phrase object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr(expr object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr left</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr left</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_left(expr_left object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr sort</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr sort</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_sort(expr_sort object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr where</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr where</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_where(expr_where object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr range</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr range</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_range(expr_range object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr or</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr or</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_or(expr_or object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr and</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr and</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_and(expr_and object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr not</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr not</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_not(expr_not object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr comparison</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr comparison</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_comparison(expr_comparison object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr find string</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr find string</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_find_string(expr_find_string object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>string search start</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>string search start</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casestring_search_start(string_search_start object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr string</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr string</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_string(expr_string object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr string left</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr string left</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_string_left(expr_string_left object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>substring start</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>substring start</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casesubstring_start(substring_start object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr plus</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr plus</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_plus(expr_plus object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr plus left</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr plus left</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_plus_left(expr_plus_left object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr times</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr times</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_times(expr_times object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr times left</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr times left</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_times_left(expr_times_left object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr power</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr power</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_power(expr_power object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr before</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr before</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_before(expr_before object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr ago</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr ago</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_ago(expr_ago object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr duration</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr duration</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_duration(expr_duration object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr function</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr function</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_function(expr_function object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr factor</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr factor</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_factor(expr_factor object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>expr factor atom</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>expr factor atom</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseexpr_factor_atom(expr_factor_atom object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>main comp op</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>main comp op</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casemain_comp_op(main_comp_op object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>temporal comp op</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>temporal comp op</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casetemporal_comp_op(temporal_comp_op object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>in comp op</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>in comp op</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casein_comp_op(in_comp_op object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>data block</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>data block</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casedata_block(data_block object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>data block left</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>data block left</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casedata_block_left(data_block_left object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>data statement</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>data statement</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casedata_statement(data_statement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>data if then else2</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>data if then else2</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casedata_if_then_else2(data_if_then_else2 object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>data elseif</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>data elseif</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casedata_elseif(data_elseif object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>data assignment</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>data assignment</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casedata_assignment(data_assignment object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>data assign phrase</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>data assign phrase</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casedata_assign_phrase(data_assign_phrase object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>read phrase</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>read phrase</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseread_phrase(read_phrase object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>read where</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>read where</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseread_where(read_where object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>new object phrase</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>new object phrase</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casenew_object_phrase(new_object_phrase object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>evoke block</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>evoke block</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseevoke_block(evoke_block object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>evoke block left</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>evoke block left</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseevoke_block_left(evoke_block_left object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>evoke statement</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>evoke statement</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseevoke_statement(evoke_statement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>qualified evoke cycle</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>qualified evoke cycle</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casequalified_evoke_cycle(qualified_evoke_cycle object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>simple evoke cycle</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>simple evoke cycle</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casesimple_evoke_cycle(simple_evoke_cycle object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>action block</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>action block</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseaction_block(action_block object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>action block left</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>action block left</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseaction_block_left(action_block_left object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>action statement</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>action statement</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseaction_statement(action_statement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>action if then else2</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>action if then else2</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseaction_if_then_else2(action_if_then_else2 object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>action elseif</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>action elseif</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseaction_elseif(action_elseif object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  @Override
  public T defaultCase(EObject object)
  {
    return null;
  }

} //XTextSwitch
