package arden.xtext.serializer;

import arden.xtext.services.XTextGrammarAccess;
import arden.xtext.xText.P_mlm;
import arden.xtext.xText.XTextPackage;
import arden.xtext.xText.action_block;
import arden.xtext.xText.action_block_left;
import arden.xtext.xText.action_elseif;
import arden.xtext.xText.action_if_then_else2;
import arden.xtext.xText.action_slot;
import arden.xtext.xText.action_statement;
import arden.xtext.xText.call_phrase;
import arden.xtext.xText.data_block;
import arden.xtext.xText.data_block_left;
import arden.xtext.xText.data_elseif;
import arden.xtext.xText.data_slot;
import arden.xtext.xText.data_statement;
import arden.xtext.xText.evoke_block;
import arden.xtext.xText.evoke_block_left;
import arden.xtext.xText.evoke_slot;
import arden.xtext.xText.evoke_statement;
import arden.xtext.xText.expr;
import arden.xtext.xText.expr_ago;
import arden.xtext.xText.expr_and;
import arden.xtext.xText.expr_before;
import arden.xtext.xText.expr_comparison;
import arden.xtext.xText.expr_duration;
import arden.xtext.xText.expr_factor;
import arden.xtext.xText.expr_factor_atom;
import arden.xtext.xText.expr_find_string;
import arden.xtext.xText.expr_function;
import arden.xtext.xText.expr_left;
import arden.xtext.xText.expr_not;
import arden.xtext.xText.expr_or;
import arden.xtext.xText.expr_plus_left;
import arden.xtext.xText.expr_power;
import arden.xtext.xText.expr_range;
import arden.xtext.xText.expr_sort;
import arden.xtext.xText.expr_string;
import arden.xtext.xText.expr_string_left;
import arden.xtext.xText.expr_times_left;
import arden.xtext.xText.expr_where;
import arden.xtext.xText.knowledge_body;
import arden.xtext.xText.library_body;
import arden.xtext.xText.library_category;
import arden.xtext.xText.logic_block;
import arden.xtext.xText.logic_elseif;
import arden.xtext.xText.logic_if_then_else2;
import arden.xtext.xText.logic_statement;
import arden.xtext.xText.main_comp_op;
import arden.xtext.xText.maintenance_body;
import arden.xtext.xText.mlms;
import arden.xtext.xText.simple_evoke_cycle;
import arden.xtext.xText.temporal_comp_op;
import arden.xtext.xText.title_slot;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("restriction")
public class AbstractXTextSemanticSequencer extends AbstractSemanticSequencer {

	@Inject
	protected XTextGrammarAccess grammarAccess;
	
	@Inject
	protected ISemanticSequencerDiagnosticProvider diagnosticProvider;
	
	@Inject
	protected ITransientValueService transientValues;
	
	@Inject
	@GenericSequencer
	protected Provider<ISemanticSequencer> genericSequencerProvider;
	
	protected ISemanticSequencer genericSequencer;
	
	
	@Override
	public void init(ISemanticSequencer sequencer, ISemanticSequenceAcceptor sequenceAcceptor, Acceptor errorAcceptor) {
		super.init(sequencer, sequenceAcceptor, errorAcceptor);
		this.genericSequencer = genericSequencerProvider.get();
		this.genericSequencer.init(sequencer, sequenceAcceptor, errorAcceptor);
	}
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == XTextPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case XTextPackage.PMLM:
				if(context == grammarAccess.getP_mlmRule()) {
					sequence_P_mlm(context, (P_mlm) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.ACTION_BLOCK:
				if(context == grammarAccess.getAction_blockRule()) {
					sequence_action_block(context, (action_block) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.ACTION_BLOCK_LEFT:
				if(context == grammarAccess.getAction_block_leftRule()) {
					sequence_action_block_left(context, (action_block_left) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.ACTION_ELSEIF:
				if(context == grammarAccess.getAction_elseifRule()) {
					sequence_action_elseif(context, (action_elseif) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.ACTION_IF_THEN_ELSE2:
				if(context == grammarAccess.getAction_if_then_else2Rule()) {
					sequence_action_if_then_else2(context, (action_if_then_else2) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.ACTION_SLOT:
				if(context == grammarAccess.getAction_slotRule()) {
					sequence_action_slot(context, (action_slot) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.ACTION_STATEMENT:
				if(context == grammarAccess.getAction_statementRule()) {
					sequence_action_statement(context, (action_statement) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.CALL_PHRASE:
				if(context == grammarAccess.getAction_statementRule() ||
				   context == grammarAccess.getCall_phraseRule() ||
				   context == grammarAccess.getData_assign_phraseRule() ||
				   context == grammarAccess.getData_assignmentRule() ||
				   context == grammarAccess.getData_statementRule() ||
				   context == grammarAccess.getLogic_assignmentRule()) {
					sequence_logic_assignment(context, (call_phrase) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.DATA_BLOCK:
				if(context == grammarAccess.getData_blockRule()) {
					sequence_data_block(context, (data_block) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.DATA_BLOCK_LEFT:
				if(context == grammarAccess.getData_block_leftRule()) {
					sequence_data_block_left(context, (data_block_left) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.DATA_ELSEIF:
				if(context == grammarAccess.getData_elseifRule()) {
					sequence_data_elseif(context, (data_elseif) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.DATA_SLOT:
				if(context == grammarAccess.getData_slotRule()) {
					sequence_data_slot(context, (data_slot) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.DATA_STATEMENT:
				if(context == grammarAccess.getData_statementRule()) {
					sequence_data_statement(context, (data_statement) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EVOKE_BLOCK:
				if(context == grammarAccess.getEvoke_blockRule()) {
					sequence_evoke_block(context, (evoke_block) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EVOKE_BLOCK_LEFT:
				if(context == grammarAccess.getEvoke_block_leftRule()) {
					sequence_evoke_block_left(context, (evoke_block_left) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EVOKE_SLOT:
				if(context == grammarAccess.getEvoke_slotRule()) {
					sequence_evoke_slot(context, (evoke_slot) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EVOKE_STATEMENT:
				if(context == grammarAccess.getEvoke_statementRule()) {
					sequence_evoke_statement(context, (evoke_statement) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR:
				if(context == grammarAccess.getAction_statementRule()) {
					sequence_action_statement(context, (expr) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getData_if_then_else2Rule()) {
					sequence_data_if_then_else2(context, (expr) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getCall_phraseRule() ||
				   context == grammarAccess.getData_assign_phraseRule() ||
				   context == grammarAccess.getData_assignmentRule() ||
				   context == grammarAccess.getData_statementRule() ||
				   context == grammarAccess.getExprRule() ||
				   context == grammarAccess.getLogic_assignmentRule() ||
				   context == grammarAccess.getNew_object_phraseRule()) {
					sequence_expr(context, (expr) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_AGO:
				if(context == grammarAccess.getExpr_agoRule()) {
					sequence_expr_ago(context, (expr_ago) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_AND:
				if(context == grammarAccess.getExpr_andRule()) {
					sequence_expr_and(context, (expr_and) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_BEFORE:
				if(context == grammarAccess.getExpr_beforeRule() ||
				   context == grammarAccess.getExpr_powerRule()) {
					sequence_expr_before(context, (expr_before) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_comparisonRule()) {
					sequence_expr_comparison(context, (expr_before) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_plusRule() ||
				   context == grammarAccess.getString_search_startRule()) {
					sequence_expr_plus(context, (expr_before) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_plus_leftRule()) {
					sequence_expr_plus_left(context, (expr_before) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getData_assign_phraseRule() ||
				   context == grammarAccess.getData_assignmentRule() ||
				   context == grammarAccess.getData_statementRule() ||
				   context == grammarAccess.getExpr_stringRule() ||
				   context == grammarAccess.getIn_comp_opRule() ||
				   context == grammarAccess.getMain_comp_opRule() ||
				   context == grammarAccess.getRead_phraseRule() ||
				   context == grammarAccess.getRead_whereRule() ||
				   context == grammarAccess.getTemporal_comp_opRule()) {
					sequence_expr_string(context, (expr_before) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_string_leftRule()) {
					sequence_expr_string_left(context, (expr_before) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_timesRule()) {
					sequence_expr_times(context, (expr_before) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_times_leftRule()) {
					sequence_expr_times_left(context, (expr_before) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_COMPARISON:
				if(context == grammarAccess.getExpr_comparisonRule()) {
					sequence_expr_comparison(context, (expr_comparison) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_DURATION:
				if(context == grammarAccess.getExpr_durationRule()) {
					sequence_expr_duration(context, (expr_duration) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_FACTOR:
				if(context == grammarAccess.getExpr_comparisonRule()) {
					sequence_expr_comparison(context, (expr_factor) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_factorRule() ||
				   context == grammarAccess.getExpr_functionRule() ||
				   context == grammarAccess.getSubstring_startRule()) {
					sequence_expr_factor(context, (expr_factor) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getData_assign_phraseRule() ||
				   context == grammarAccess.getData_assignmentRule() ||
				   context == grammarAccess.getData_statementRule() ||
				   context == grammarAccess.getExpr_stringRule() ||
				   context == grammarAccess.getIn_comp_opRule() ||
				   context == grammarAccess.getMain_comp_opRule() ||
				   context == grammarAccess.getRead_phraseRule() ||
				   context == grammarAccess.getRead_whereRule() ||
				   context == grammarAccess.getTemporal_comp_opRule()) {
					sequence_expr_string(context, (expr_factor) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_FACTOR_ATOM:
				if(context == grammarAccess.getExpr_factor_atomRule()) {
					sequence_expr_factor_atom(context, (expr_factor_atom) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_FIND_STRING:
				if(context == grammarAccess.getExpr_find_stringRule()) {
					sequence_expr_find_string(context, (expr_find_string) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_FUNCTION:
				if(context == grammarAccess.getExpr_functionRule()) {
					sequence_expr_function(context, (expr_function) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_LEFT:
				if(context == grammarAccess.getExpr_leftRule()) {
					sequence_expr_left(context, (expr_left) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_NOT:
				if(context == grammarAccess.getExpr_notRule()) {
					sequence_expr_not(context, (expr_not) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_OR:
				if(context == grammarAccess.getExpr_orRule()) {
					sequence_expr_or(context, (expr_or) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_PLUS_LEFT:
				if(context == grammarAccess.getExpr_plus_leftRule()) {
					sequence_expr_plus_left(context, (expr_plus_left) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_POWER:
				if(context == grammarAccess.getExpr_comparisonRule()) {
					sequence_expr_comparison(context, (expr_power) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_plusRule() ||
				   context == grammarAccess.getString_search_startRule()) {
					sequence_expr_plus(context, (expr_power) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_plus_leftRule()) {
					sequence_expr_plus_left(context, (expr_power) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_powerRule()) {
					sequence_expr_power(context, (expr_power) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getData_assign_phraseRule() ||
				   context == grammarAccess.getData_assignmentRule() ||
				   context == grammarAccess.getData_statementRule() ||
				   context == grammarAccess.getExpr_stringRule() ||
				   context == grammarAccess.getIn_comp_opRule() ||
				   context == grammarAccess.getMain_comp_opRule() ||
				   context == grammarAccess.getRead_phraseRule() ||
				   context == grammarAccess.getRead_whereRule() ||
				   context == grammarAccess.getTemporal_comp_opRule()) {
					sequence_expr_string(context, (expr_power) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_string_leftRule()) {
					sequence_expr_string_left(context, (expr_power) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_timesRule()) {
					sequence_expr_times(context, (expr_power) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getExpr_times_leftRule()) {
					sequence_expr_times_left(context, (expr_power) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_RANGE:
				if(context == grammarAccess.getExpr_rangeRule()) {
					sequence_expr_range(context, (expr_range) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_SORT:
				if(context == grammarAccess.getExpr_sortRule()) {
					sequence_expr_sort(context, (expr_sort) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_STRING:
				if(context == grammarAccess.getExpr_comparisonRule()) {
					sequence_expr_comparison(context, (expr_string) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getData_assign_phraseRule() ||
				   context == grammarAccess.getData_assignmentRule() ||
				   context == grammarAccess.getData_statementRule() ||
				   context == grammarAccess.getExpr_stringRule() ||
				   context == grammarAccess.getIn_comp_opRule() ||
				   context == grammarAccess.getMain_comp_opRule() ||
				   context == grammarAccess.getRead_phraseRule() ||
				   context == grammarAccess.getRead_whereRule() ||
				   context == grammarAccess.getTemporal_comp_opRule()) {
					sequence_expr_string(context, (expr_string) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_STRING_LEFT:
				if(context == grammarAccess.getExpr_string_leftRule()) {
					sequence_expr_string_left(context, (expr_string_left) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_TIMES_LEFT:
				if(context == grammarAccess.getExpr_times_leftRule()) {
					sequence_expr_times_left(context, (expr_times_left) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.EXPR_WHERE:
				if(context == grammarAccess.getExpr_whereRule()) {
					sequence_expr_where(context, (expr_where) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.KNOWLEDGE_BODY:
				if(context == grammarAccess.getKnowledge_bodyRule() ||
				   context == grammarAccess.getKnowledge_categoryRule()) {
					sequence_knowledge_body(context, (knowledge_body) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.LIBRARY_BODY:
				if(context == grammarAccess.getLibrary_bodyRule()) {
					sequence_library_body(context, (library_body) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.LIBRARY_CATEGORY:
				if(context == grammarAccess.getLibrary_categoryRule()) {
					sequence_library_category(context, (library_category) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.LOGIC_BLOCK:
				if(context == grammarAccess.getLogic_blockRule() ||
				   context == grammarAccess.getLogic_slotRule()) {
					sequence_logic_block(context, (logic_block) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.LOGIC_ELSEIF:
				if(context == grammarAccess.getLogic_elseifRule()) {
					sequence_logic_elseif(context, (logic_elseif) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.LOGIC_IF_THEN_ELSE2:
				if(context == grammarAccess.getLogic_if_then_else2Rule()) {
					sequence_logic_if_then_else2(context, (logic_if_then_else2) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.LOGIC_STATEMENT:
				if(context == grammarAccess.getLogic_statementRule()) {
					sequence_logic_statement(context, (logic_statement) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.MAIN_COMP_OP:
				if(context == grammarAccess.getExpr_comparisonRule()) {
					sequence_expr_comparison(context, (main_comp_op) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getMain_comp_opRule()) {
					sequence_main_comp_op(context, (main_comp_op) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.MAINTENANCE_BODY:
				if(context == grammarAccess.getMaintenance_bodyRule() ||
				   context == grammarAccess.getMaintenance_categoryRule()) {
					sequence_maintenance_body(context, (maintenance_body) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.MLMS:
				if(context == grammarAccess.getMlmsRule() ||
				   context == grammarAccess.getProgramRule()) {
					sequence_mlms(context, (mlms) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.SIMPLE_EVOKE_CYCLE:
				if(context == grammarAccess.getEvoke_statementRule() ||
				   context == grammarAccess.getQualified_evoke_cycleRule() ||
				   context == grammarAccess.getSimple_evoke_cycleRule()) {
					sequence_simple_evoke_cycle(context, (simple_evoke_cycle) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.TEMPORAL_COMP_OP:
				if(context == grammarAccess.getExpr_comparisonRule()) {
					sequence_expr_comparison(context, (temporal_comp_op) semanticObject); 
					return; 
				}
				else if(context == grammarAccess.getData_assign_phraseRule() ||
				   context == grammarAccess.getData_assignmentRule() ||
				   context == grammarAccess.getData_statementRule() ||
				   context == grammarAccess.getRead_phraseRule() ||
				   context == grammarAccess.getRead_whereRule() ||
				   context == grammarAccess.getTemporal_comp_opRule()) {
					sequence_temporal_comp_op(context, (temporal_comp_op) semanticObject); 
					return; 
				}
				else break;
			case XTextPackage.TITLE_SLOT:
				if(context == grammarAccess.getTitle_slotRule()) {
					sequence_title_slot(context, (title_slot) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (maint=maintenance_category lib=library_category knowl=knowledge_category)
	 *
	 * Features:
	 *    maint[1, 1]
	 *    lib[1, 1]
	 *    knowl[1, 1]
	 */
	protected void sequence_P_mlm(EObject context, P_mlm semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.PMLM__MAINT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.PMLM__MAINT));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.PMLM__LIB) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.PMLM__LIB));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.PMLM__KNOWL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.PMLM__KNOWL));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getP_mlmAccess().getMaintMaintenance_categoryParserRuleCall_0_0(), semanticObject.getMaint());
		feeder.accept(grammarAccess.getP_mlmAccess().getLibLibrary_categoryParserRuleCall_1_0(), semanticObject.getLib());
		feeder.accept(grammarAccess.getP_mlmAccess().getKnowlKnowledge_categoryParserRuleCall_2_0(), semanticObject.getKnowl());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (ast=action_statement abl=action_block_left)
	 *
	 * Features:
	 *    ast[1, 1]
	 *    abl[1, 1]
	 */
	protected void sequence_action_block(EObject context, action_block semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.ACTION_BLOCK__AST) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.ACTION_BLOCK__AST));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.ACTION_BLOCK__ABL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.ACTION_BLOCK__ABL));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getAction_blockAccess().getAstAction_statementParserRuleCall_0_0(), semanticObject.getAst());
		feeder.accept(grammarAccess.getAction_blockAccess().getAblAction_block_leftParserRuleCall_1_0(), semanticObject.getAbl());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {action_block_left}
	 *
	 * Features:
	 */
	protected void sequence_action_block_left(EObject context, action_block_left semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     {action_elseif}
	 *
	 * Features:
	 */
	protected void sequence_action_elseif(EObject context, action_elseif semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (ex3=expr abl4=action_block aei=action_elseif)
	 *
	 * Features:
	 *    ex3[1, 1]
	 *    abl4[1, 1]
	 *    aei[1, 1]
	 */
	protected void sequence_action_if_then_else2(EObject context, action_if_then_else2 semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.ACTION_IF_THEN_ELSE2__EX3) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.ACTION_IF_THEN_ELSE2__EX3));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.ACTION_IF_THEN_ELSE2__ABL4) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.ACTION_IF_THEN_ELSE2__ABL4));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.ACTION_IF_THEN_ELSE2__AEI) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.ACTION_IF_THEN_ELSE2__AEI));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getAction_if_then_else2Access().getEx3ExprParserRuleCall_0_0(), semanticObject.getEx3());
		feeder.accept(grammarAccess.getAction_if_then_else2Access().getAbl4Action_blockParserRuleCall_2_0(), semanticObject.getAbl4());
		feeder.accept(grammarAccess.getAction_if_then_else2Access().getAeiAction_elseifParserRuleCall_4_0(), semanticObject.getAei());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     a=action_block
	 *
	 * Features:
	 *    a[1, 1]
	 */
	protected void sequence_action_slot(EObject context, action_slot semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.ACTION_SLOT__A) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.ACTION_SLOT__A));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getAction_slotAccess().getAAction_blockParserRuleCall_1_0(), semanticObject.getA());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {action_statement}
	 *
	 * Features:
	 */
	protected void sequence_action_statement(EObject context, action_statement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (((s=expr_sort x=expr_left) | (s=expr_sort x=expr_left)) abl3=action_block)
	 *
	 * Features:
	 *    s[0, 2]
	 *    x[0, 2]
	 *    abl3[1, 1]
	 */
	protected void sequence_action_statement(EObject context, expr semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (stm=data_statement dbl=data_block_left)
	 *
	 * Features:
	 *    stm[1, 1]
	 *    dbl[1, 1]
	 */
	protected void sequence_data_block(EObject context, data_block semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.DATA_BLOCK__STM) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.DATA_BLOCK__STM));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.DATA_BLOCK__DBL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.DATA_BLOCK__DBL));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getData_blockAccess().getStmData_statementParserRuleCall_0_0(), semanticObject.getStm());
		feeder.accept(grammarAccess.getData_blockAccess().getDblData_block_leftParserRuleCall_1_0(), semanticObject.getDbl());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {data_block_left}
	 *
	 * Features:
	 */
	protected void sequence_data_block_left(EObject context, data_block_left semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (s=data_block | e=data_if_then_else2)?
	 *
	 * Features:
	 *    s[0, 1]
	 *         EXCLUDE_IF_SET e
	 *    e[0, 1]
	 *         EXCLUDE_IF_SET s
	 */
	protected void sequence_data_elseif(EObject context, data_elseif semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (((s=expr_sort x=expr_left) | (s=expr_sort x=expr_left)) d=data_block e=data_elseif)
	 *
	 * Features:
	 *    s[0, 2]
	 *    x[0, 2]
	 *    d[1, 1]
	 *    e[1, 1]
	 */
	protected void sequence_data_if_then_else2(EObject context, expr semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     d=data_block
	 *
	 * Features:
	 *    d[1, 1]
	 */
	protected void sequence_data_slot(EObject context, data_slot semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.DATA_SLOT__D) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.DATA_SLOT__D));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getData_slotAccess().getDData_blockParserRuleCall_1_0(), semanticObject.getD());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {data_statement}
	 *
	 * Features:
	 */
	protected void sequence_data_statement(EObject context, data_statement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (stm=evoke_statement l=evoke_block_left)
	 *
	 * Features:
	 *    stm[1, 1]
	 *    l[1, 1]
	 */
	protected void sequence_evoke_block(EObject context, evoke_block semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.EVOKE_BLOCK__STM) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.EVOKE_BLOCK__STM));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.EVOKE_BLOCK__L) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.EVOKE_BLOCK__L));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getEvoke_blockAccess().getStmEvoke_statementParserRuleCall_0_0(), semanticObject.getStm());
		feeder.accept(grammarAccess.getEvoke_blockAccess().getLEvoke_block_leftParserRuleCall_1_0(), semanticObject.getL());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {evoke_block_left}
	 *
	 * Features:
	 */
	protected void sequence_evoke_block_left(EObject context, evoke_block_left semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     e=evoke_block
	 *
	 * Features:
	 *    e[1, 1]
	 */
	protected void sequence_evoke_slot(EObject context, evoke_slot semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.EVOKE_SLOT__E) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.EVOKE_SLOT__E));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getEvoke_slotAccess().getEEvoke_blockParserRuleCall_1_0(), semanticObject.getE());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {evoke_statement}
	 *
	 * Features:
	 */
	protected void sequence_evoke_statement(EObject context, evoke_statement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (func=expr_function | d=expr_duration | d=expr_duration)
	 *
	 * Features:
	 *    func[0, 1]
	 *         EXCLUDE_IF_SET d
	 *         EXCLUDE_IF_SET d
	 *    d[0, 2]
	 *         EXCLUDE_IF_SET func
	 */
	protected void sequence_expr_ago(EObject context, expr_ago semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ((n=expr_not a=expr_and) | n=expr_not)
	 *
	 * Features:
	 *    n[0, 2]
	 *    a[0, 1]
	 *         EXCLUDE_IF_UNSET n
	 *         MANDATORY_IF_SET n
	 *         EXCLUDE_IF_SET n
	 */
	protected void sequence_expr_and(EObject context, expr_and semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (a=expr_ago | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago))
	 *
	 * Features:
	 *    a[0, 4]
	 *    d[0, 3]
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_before(EObject context, expr_before semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         s=expr_string 
	 *         (a=expr_ago | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago)) 
	 *         tl=expr_times_left 
	 *         pl=expr_plus_left 
	 *         sl=expr_string_left
	 *     )
	 *
	 * Features:
	 *    s[1, 1]
	 *    sl[1, 1]
	 *    pl[1, 1]
	 *    tl[1, 1]
	 *    a[0, 4]
	 *    d[0, 3]
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_comparison(EObject context, expr_before semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         s=expr_string | 
	 *         f=expr_find_string | 
	 *         (first_string=expr_string second_string=expr_string) | 
	 *         (s=expr_string i=in_comp_op) | 
	 *         (first_string=expr_string second_string=expr_string)
	 *     )
	 *
	 * Features:
	 *    s[0, 2]
	 *         EXCLUDE_IF_SET f
	 *         EXCLUDE_IF_SET first_string
	 *         EXCLUDE_IF_SET second_string
	 *         EXCLUDE_IF_SET first_string
	 *         EXCLUDE_IF_SET second_string
	 *    f[0, 1]
	 *         EXCLUDE_IF_SET s
	 *         EXCLUDE_IF_SET first_string
	 *         EXCLUDE_IF_SET second_string
	 *         EXCLUDE_IF_SET s
	 *         EXCLUDE_IF_SET i
	 *         EXCLUDE_IF_SET first_string
	 *         EXCLUDE_IF_SET second_string
	 *    first_string[0, 2]
	 *         EXCLUDE_IF_SET s
	 *         EXCLUDE_IF_SET f
	 *         EXCLUDE_IF_SET s
	 *         EXCLUDE_IF_SET i
	 *    second_string[0, 2]
	 *         EXCLUDE_IF_SET s
	 *         EXCLUDE_IF_SET f
	 *         EXCLUDE_IF_SET s
	 *         EXCLUDE_IF_SET i
	 *    i[0, 1]
	 *         EXCLUDE_IF_UNSET s
	 *         MANDATORY_IF_SET s
	 *         EXCLUDE_IF_SET s
	 *         EXCLUDE_IF_SET f
	 *         EXCLUDE_IF_SET first_string
	 *         EXCLUDE_IF_SET second_string
	 *         EXCLUDE_IF_SET first_string
	 *         EXCLUDE_IF_SET second_string
	 */
	protected void sequence_expr_comparison(EObject context, expr_comparison semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (s=expr_string charcount=expr_plus (f=expr_factor_atom | (f=expr_factor_atom e=expr)) inputstr=expr_plus sl=expr_string_left)
	 *
	 * Features:
	 *    s[1, 1]
	 *    f[0, 2]
	 *    charcount[1, 1]
	 *    inputstr[1, 1]
	 *    sl[1, 1]
	 *    e[0, 1]
	 *         EXCLUDE_IF_UNSET f
	 *         MANDATORY_IF_SET f
	 *         EXCLUDE_IF_SET f
	 */
	protected void sequence_expr_comparison(EObject context, expr_factor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         s=expr_string 
	 *         base=expr_function 
	 *         exp=expr_function 
	 *         tl=expr_times_left 
	 *         pl=expr_plus_left 
	 *         sl=expr_string_left
	 *     )
	 *
	 * Features:
	 *    s[1, 1]
	 *    sl[1, 1]
	 *    pl[1, 1]
	 *    tl[1, 1]
	 *    base[1, 1]
	 *    exp[1, 1]
	 */
	protected void sequence_expr_comparison(EObject context, expr_power semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (s=expr_string charcount=expr_plus inputstr=expr_plus sl=expr_string_left)
	 *
	 * Features:
	 *    s[1, 1]
	 *    charcount[1, 1]
	 *    inputstr[1, 1]
	 *    sl[1, 1]
	 */
	protected void sequence_expr_comparison(EObject context, expr_string semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (s=expr_string (tco=temporal_comp_op | ico=in_comp_op))
	 *
	 * Features:
	 *    s[1, 1]
	 *    tco[0, 1]
	 *         EXCLUDE_IF_SET ico
	 *    ico[0, 1]
	 *         EXCLUDE_IF_SET tco
	 */
	protected void sequence_expr_comparison(EObject context, main_comp_op semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         s=expr_string 
	 *         (
	 *             (left=expr_string right=expr_string) | 
	 *             (left=expr_string right=expr_string) | 
	 *             (left=expr_string right=expr_string) | 
	 *             (lower=expr_string upper=expr_string)
	 *         )
	 *     )
	 *
	 * Features:
	 *    s[1, 1]
	 *    left[0, 3]
	 *         EXCLUDE_IF_SET lower
	 *         EXCLUDE_IF_SET upper
	 *    right[0, 3]
	 *         EXCLUDE_IF_SET lower
	 *         EXCLUDE_IF_SET upper
	 *    lower[0, 1]
	 *         EXCLUDE_IF_UNSET upper
	 *         MANDATORY_IF_SET upper
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *    upper[0, 1]
	 *         EXCLUDE_IF_UNSET lower
	 *         MANDATORY_IF_SET lower
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 */
	protected void sequence_expr_comparison(EObject context, temporal_comp_op semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     func=expr_function
	 *
	 * Features:
	 *    func[1, 1]
	 */
	protected void sequence_expr_duration(EObject context, expr_duration semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.EXPR_DURATION__FUNC) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.EXPR_DURATION__FUNC));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getExpr_durationAccess().getFuncExpr_functionParserRuleCall_0_0(), semanticObject.getFunc());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     ((s=expr_sort x=expr_left) | (s=expr_sort x=expr_left))
	 *
	 * Features:
	 *    s[0, 2]
	 *    x[0, 2]
	 */
	protected void sequence_expr(EObject context, expr semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ex=expr?
	 *
	 * Features:
	 *    ex[0, 1]
	 */
	protected void sequence_expr_factor_atom(EObject context, expr_factor_atom semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (f=expr_factor_atom | (f=expr_factor_atom e=expr))
	 *
	 * Features:
	 *    f[0, 2]
	 *    e[0, 1]
	 *         EXCLUDE_IF_UNSET f
	 *         MANDATORY_IF_SET f
	 *         EXCLUDE_IF_SET f
	 */
	protected void sequence_expr_factor(EObject context, expr_factor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ((substring=expr_string fullstring=expr_string s=string_search_start?) | (substring=expr_string fullstring=expr_string s=string_search_start?))
	 *
	 * Features:
	 *    substring[0, 2]
	 *    fullstring[0, 2]
	 *    s[0, 2]
	 */
	protected void sequence_expr_find_string(EObject context, expr_find_string semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     func=expr_function
	 *
	 * Features:
	 *    func[1, 1]
	 */
	protected void sequence_expr_function(EObject context, expr_function semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.EXPR_FUNCTION__FUNC) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.EXPR_FUNCTION__FUNC));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getExpr_functionAccess().getFuncExpr_functionParserRuleCall_1_1_0(), semanticObject.getFunc());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {expr_left}
	 *
	 * Features:
	 */
	protected void sequence_expr_left(EObject context, expr_left semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (c=expr_comparison | c=expr_comparison)
	 *
	 * Features:
	 *    c[0, 2]
	 */
	protected void sequence_expr_not(EObject context, expr_not semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ((a=expr_and o=expr_or) | a=expr_and)
	 *
	 * Features:
	 *    a[0, 2]
	 *    o[0, 1]
	 *         EXCLUDE_IF_UNSET a
	 *         MANDATORY_IF_SET a
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_or(EObject context, expr_or semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ((a=expr_ago | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago)) tl=expr_times_left pl=expr_plus_left)
	 *
	 * Features:
	 *    pl[1, 1]
	 *    tl[1, 1]
	 *    a[0, 4]
	 *    d[0, 3]
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_plus(EObject context, expr_before semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (base=expr_function exp=expr_function tl=expr_times_left pl=expr_plus_left)
	 *
	 * Features:
	 *    pl[1, 1]
	 *    tl[1, 1]
	 *    base[1, 1]
	 *    exp[1, 1]
	 */
	protected void sequence_expr_plus(EObject context, expr_power semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (a=expr_ago | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago)) 
	 *         tl=expr_times_left 
	 *         pl2=expr_plus_left
	 *     )
	 *
	 * Features:
	 *    pl2[1, 1]
	 *    tl[1, 1]
	 *    a[0, 4]
	 *    d[0, 3]
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_plus_left(EObject context, expr_before semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     {expr_plus_left}
	 *
	 * Features:
	 */
	protected void sequence_expr_plus_left(EObject context, expr_plus_left semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (base=expr_function exp=expr_function tl=expr_times_left pl2=expr_plus_left)
	 *
	 * Features:
	 *    pl2[1, 1]
	 *    tl[1, 1]
	 *    base[1, 1]
	 *    exp[1, 1]
	 */
	protected void sequence_expr_plus_left(EObject context, expr_power semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (base=expr_function exp=expr_function)
	 *
	 * Features:
	 *    base[1, 1]
	 *    exp[1, 1]
	 */
	protected void sequence_expr_power(EObject context, expr_power semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (o=expr_or | (o=expr_or p=expr_or))
	 *
	 * Features:
	 *    o[0, 2]
	 *    p[0, 1]
	 *         EXCLUDE_IF_UNSET o
	 *         MANDATORY_IF_SET o
	 *         EXCLUDE_IF_SET o
	 */
	protected void sequence_expr_range(EObject context, expr_range semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (w=expr_where | (w=expr_where s=expr_sort) | s=expr_sort)
	 *
	 * Features:
	 *    w[0, 2]
	 *         EXCLUDE_IF_SET s
	 *    s[0, 2]
	 *         EXCLUDE_IF_SET w
	 */
	protected void sequence_expr_sort(EObject context, expr_sort semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (a=expr_ago | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago)) 
	 *         tl=expr_times_left 
	 *         pl=expr_plus_left 
	 *         sl=expr_string_left
	 *     )
	 *
	 * Features:
	 *    sl[1, 1]
	 *    pl[1, 1]
	 *    tl[1, 1]
	 *    a[0, 4]
	 *    d[0, 3]
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_string(EObject context, expr_before semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (charcount=expr_plus (f=expr_factor_atom | (f=expr_factor_atom e=expr)) inputstr=expr_plus sl=expr_string_left)
	 *
	 * Features:
	 *    f[0, 2]
	 *    charcount[1, 1]
	 *    inputstr[1, 1]
	 *    sl[1, 1]
	 *    e[0, 1]
	 *         EXCLUDE_IF_UNSET f
	 *         MANDATORY_IF_SET f
	 *         EXCLUDE_IF_SET f
	 */
	protected void sequence_expr_string(EObject context, expr_factor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (base=expr_function exp=expr_function tl=expr_times_left pl=expr_plus_left sl=expr_string_left)
	 *
	 * Features:
	 *    sl[1, 1]
	 *    pl[1, 1]
	 *    tl[1, 1]
	 *    base[1, 1]
	 *    exp[1, 1]
	 */
	protected void sequence_expr_string(EObject context, expr_power semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (charcount=expr_plus inputstr=expr_plus sl=expr_string_left)
	 *
	 * Features:
	 *    charcount[1, 1]
	 *    inputstr[1, 1]
	 *    sl[1, 1]
	 */
	protected void sequence_expr_string(EObject context, expr_string semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (a=expr_ago | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago)) 
	 *         tl=expr_times_left 
	 *         pl=expr_plus_left 
	 *         sl2=expr_string_left
	 *     )
	 *
	 * Features:
	 *    sl2[1, 1]
	 *    pl[1, 1]
	 *    tl[1, 1]
	 *    a[0, 4]
	 *    d[0, 3]
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_string_left(EObject context, expr_before semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (base=expr_function exp=expr_function tl=expr_times_left pl=expr_plus_left sl2=expr_string_left)
	 *
	 * Features:
	 *    sl2[1, 1]
	 *    pl[1, 1]
	 *    tl[1, 1]
	 *    base[1, 1]
	 *    exp[1, 1]
	 */
	protected void sequence_expr_string_left(EObject context, expr_power semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     {expr_string_left}
	 *
	 * Features:
	 */
	protected void sequence_expr_string_left(EObject context, expr_string_left semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ((a=expr_ago | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago)) tl=expr_times_left)
	 *
	 * Features:
	 *    tl[1, 1]
	 *    a[0, 4]
	 *    d[0, 3]
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_times(EObject context, expr_before semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (base=expr_function exp=expr_function tl=expr_times_left)
	 *
	 * Features:
	 *    tl[1, 1]
	 *    base[1, 1]
	 *    exp[1, 1]
	 */
	protected void sequence_expr_times(EObject context, expr_power semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ((a=expr_ago | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago) | (d=expr_duration a=expr_ago)) tl2=expr_times_left)
	 *
	 * Features:
	 *    tl2[1, 1]
	 *    a[0, 4]
	 *    d[0, 3]
	 *         EXCLUDE_IF_SET a
	 */
	protected void sequence_expr_times_left(EObject context, expr_before semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (base=expr_function exp=expr_function tl2=expr_times_left)
	 *
	 * Features:
	 *    tl2[1, 1]
	 *    base[1, 1]
	 *    exp[1, 1]
	 */
	protected void sequence_expr_times_left(EObject context, expr_power semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     {expr_times_left}
	 *
	 * Features:
	 */
	protected void sequence_expr_times_left(EObject context, expr_times_left semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (r=expr_range | (r=expr_range s=expr_range))
	 *
	 * Features:
	 *    r[0, 2]
	 *    s[0, 1]
	 *         EXCLUDE_IF_UNSET r
	 *         MANDATORY_IF_SET r
	 *         EXCLUDE_IF_SET r
	 */
	protected void sequence_expr_where(EObject context, expr_where semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         data=data_slot 
	 *         prior=priority_slot 
	 *         evoke=evoke_slot 
	 *         logic=logic_slot 
	 *         action=action_slot 
	 *         urg=urgency_slot
	 *     )
	 *
	 * Features:
	 *    data[1, 1]
	 *    prior[1, 1]
	 *    evoke[1, 1]
	 *    logic[1, 1]
	 *    action[1, 1]
	 *    urg[1, 1]
	 */
	protected void sequence_knowledge_body(EObject context, knowledge_body semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__DATA) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__DATA));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__PRIOR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__PRIOR));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__EVOKE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__EVOKE));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__LOGIC) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__LOGIC));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__ACTION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__ACTION));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__URG) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.KNOWLEDGE_BODY__URG));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getKnowledge_bodyAccess().getDataData_slotParserRuleCall_1_0(), semanticObject.getData());
		feeder.accept(grammarAccess.getKnowledge_bodyAccess().getPriorPriority_slotParserRuleCall_2_0(), semanticObject.getPrior());
		feeder.accept(grammarAccess.getKnowledge_bodyAccess().getEvokeEvoke_slotParserRuleCall_3_0(), semanticObject.getEvoke());
		feeder.accept(grammarAccess.getKnowledge_bodyAccess().getLogicLogic_slotParserRuleCall_4_0(), semanticObject.getLogic());
		feeder.accept(grammarAccess.getKnowledge_bodyAccess().getActionAction_slotParserRuleCall_5_0(), semanticObject.getAction());
		feeder.accept(grammarAccess.getKnowledge_bodyAccess().getUrgUrgency_slotParserRuleCall_6_0(), semanticObject.getUrg());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (purp=purpose_slot expl=explanation_slot keyw=keywords_slot cit=citations_slot? links=links_slot?)
	 *
	 * Features:
	 *    purp[1, 1]
	 *    expl[1, 1]
	 *    keyw[1, 1]
	 *    cit[0, 1]
	 *    links[0, 1]
	 */
	protected void sequence_library_body(EObject context, library_body semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     lib=library_body
	 *
	 * Features:
	 *    lib[1, 1]
	 */
	protected void sequence_library_category(EObject context, library_category semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.LIBRARY_CATEGORY__LIB) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.LIBRARY_CATEGORY__LIB));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getLibrary_categoryAccess().getLibLibrary_bodyParserRuleCall_1_0(), semanticObject.getLib());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {call_phrase}
	 *
	 * Features:
	 */
	protected void sequence_logic_assignment(EObject context, call_phrase semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     lstmt=logic_statement
	 *
	 * Features:
	 *    lstmt[1, 1]
	 */
	protected void sequence_logic_block(EObject context, logic_block semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.LOGIC_BLOCK__LSTMT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.LOGIC_BLOCK__LSTMT));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getLogic_blockAccess().getLstmtLogic_statementParserRuleCall_1_0(), semanticObject.getLstmt());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {logic_elseif}
	 *
	 * Features:
	 */
	protected void sequence_logic_elseif(EObject context, logic_elseif semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (e=expr l=logic_block ei=logic_elseif)
	 *
	 * Features:
	 *    e[1, 1]
	 *    l[1, 1]
	 *    ei[1, 1]
	 */
	protected void sequence_logic_if_then_else2(EObject context, logic_if_then_else2 semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.LOGIC_IF_THEN_ELSE2__E) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.LOGIC_IF_THEN_ELSE2__E));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.LOGIC_IF_THEN_ELSE2__L) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.LOGIC_IF_THEN_ELSE2__L));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.LOGIC_IF_THEN_ELSE2__EI) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.LOGIC_IF_THEN_ELSE2__EI));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getLogic_if_then_else2Access().getEExprParserRuleCall_0_0(), semanticObject.getE());
		feeder.accept(grammarAccess.getLogic_if_then_else2Access().getLLogic_blockParserRuleCall_2_0(), semanticObject.getL());
		feeder.accept(grammarAccess.getLogic_if_then_else2Access().getEiLogic_elseifParserRuleCall_4_0(), semanticObject.getEi());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     {logic_statement}
	 *
	 * Features:
	 */
	protected void sequence_logic_statement(EObject context, logic_statement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (tco=temporal_comp_op | ico=in_comp_op)?
	 *
	 * Features:
	 *    tco[0, 1]
	 *         EXCLUDE_IF_SET ico
	 *    ico[0, 1]
	 *         EXCLUDE_IF_SET tco
	 */
	protected void sequence_main_comp_op(EObject context, main_comp_op semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         title=title_slot 
	 *         mlmname=mlmname_slot 
	 *         arden_ver=arden_version_slot 
	 *         ver=version_slot 
	 *         inst=institution_slot 
	 *         author=author_slot 
	 *         specialist=specialist_slot 
	 *         date=date_slot
	 *     )
	 *
	 * Features:
	 *    title[1, 1]
	 *    mlmname[1, 1]
	 *    arden_ver[1, 1]
	 *    ver[1, 1]
	 *    inst[1, 1]
	 *    author[1, 1]
	 *    specialist[1, 1]
	 *    date[1, 1]
	 */
	protected void sequence_maintenance_body(EObject context, maintenance_body semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__TITLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__TITLE));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__MLMNAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__MLMNAME));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__ARDEN_VER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__ARDEN_VER));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__VER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__VER));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__INST) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__INST));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__AUTHOR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__AUTHOR));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__SPECIALIST) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__SPECIALIST));
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__DATE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.MAINTENANCE_BODY__DATE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getMaintenance_bodyAccess().getTitleTitle_slotParserRuleCall_0_0(), semanticObject.getTitle());
		feeder.accept(grammarAccess.getMaintenance_bodyAccess().getMlmnameMlmname_slotParserRuleCall_1_0(), semanticObject.getMlmname());
		feeder.accept(grammarAccess.getMaintenance_bodyAccess().getArden_verArden_version_slotParserRuleCall_2_0(), semanticObject.getArden_ver());
		feeder.accept(grammarAccess.getMaintenance_bodyAccess().getVerVersion_slotParserRuleCall_3_0(), semanticObject.getVer());
		feeder.accept(grammarAccess.getMaintenance_bodyAccess().getInstInstitution_slotParserRuleCall_4_0(), semanticObject.getInst());
		feeder.accept(grammarAccess.getMaintenance_bodyAccess().getAuthorAuthor_slotParserRuleCall_5_0(), semanticObject.getAuthor());
		feeder.accept(grammarAccess.getMaintenance_bodyAccess().getSpecialistSpecialist_slotParserRuleCall_6_0(), semanticObject.getSpecialist());
		feeder.accept(grammarAccess.getMaintenance_bodyAccess().getDateDate_slotParserRuleCall_7_0(), semanticObject.getDate());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     m+=P_mlm+
	 *
	 * Features:
	 *    m[1, *]
	 */
	protected void sequence_mlms(EObject context, mlms semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (dur_l=evoke_duration dur_r=evoke_duration)
	 *
	 * Features:
	 *    dur_l[1, 1]
	 *    dur_r[1, 1]
	 */
	protected void sequence_simple_evoke_cycle(EObject context, simple_evoke_cycle semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (left=expr_string right=expr_string) | 
	 *         (left=expr_string right=expr_string) | 
	 *         (left=expr_string right=expr_string) | 
	 *         (lower=expr_string upper=expr_string)
	 *     )
	 *
	 * Features:
	 *    left[0, 3]
	 *         EXCLUDE_IF_SET lower
	 *         EXCLUDE_IF_SET upper
	 *    right[0, 3]
	 *         EXCLUDE_IF_SET lower
	 *         EXCLUDE_IF_SET upper
	 *    lower[0, 1]
	 *         EXCLUDE_IF_UNSET upper
	 *         MANDATORY_IF_SET upper
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *    upper[0, 1]
	 *         EXCLUDE_IF_UNSET lower
	 *         MANDATORY_IF_SET lower
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 *         EXCLUDE_IF_SET left
	 *         EXCLUDE_IF_SET right
	 */
	protected void sequence_temporal_comp_op(EObject context, temporal_comp_op semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     x=text
	 *
	 * Features:
	 *    x[1, 1]
	 */
	protected void sequence_title_slot(EObject context, title_slot semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, XTextPackage.Literals.TITLE_SLOT__X) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, XTextPackage.Literals.TITLE_SLOT__X));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getTitle_slotAccess().getXTextParserRuleCall_1_0(), semanticObject.getX());
		feeder.finish();
	}
}
