 
package test;

import jakarta.inject.Inject;
import jakarta.annotation.PostConstruct;

import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class MyView {
	@Inject
	private EPartService partService;

	@Inject
	private MApplication application;
	
	@Inject
	public MyView() {
		
	}
	
	@PostConstruct
	public void postConstruct(Composite parent) {
		MPart part = partService.createPart("com.example.e4.view");
        part.setLabel("Dynamically Created Part");
        partService.showPart(part, EPartService.PartState.ACTIVATE);
		Button pushButton = ButtonFactory.newButton(SWT.PUSH).text("Press me").create(parent);
		Button checkButton= ButtonFactory.newButton(SWT.CHECK).onSelect(t -> pushButton.setEnabled(!pushButton.getEnabled())).text("Press me").create(parent);
		checkButton.setSelection(true);
	}
	
}