package lifeCycle;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;

/**
 * This is a stub implementation containing e4 LifeCycle annotated
 * methods.<br />
 * There is a corresponding entry in <em>plugin.xml</em> (under the
 * <em>org.eclipse.core.runtime.products' extension point</em>) that references
 * this class.
 **/
@SuppressWarnings("restriction")
public class E4LifeCycle {

	@PostContextCreate
	void postContextCreate(IEclipseContext workbenchContext) {
		System.out.println("postcontext created!");
	}

	@PreSave
	void preSave(IEclipseContext workbenchContext) {
	}

	@ProcessAdditions
	void processAdditions(IEclipseContext workbenchContext) {
	}

	@ProcessRemovals
	void processRemovals(IEclipseContext workbenchContext) {
	}

	@Inject
	@Optional
	private void onStartup(@UIEventTopic(UIEvents.UILifeCycle.APP_STARTUP_COMPLETE) MApplication app) {		
		 System.out.println("Application startup complete, applying theme...");
		    IEclipseContext context = app.getContext();
		    IThemeEngine themeEngine = context.get(IThemeEngine.class);
		    if (themeEngine != null) {
		        themeEngine.setTheme("TestCSS.theme", true);
		        System.out.println("Theme applied successfully.");
		    } else {
		        System.out.println("Failed to retrieve IThemeEngine.");
		    }
	}
}
