// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 8.1.0
// for test (test@test-VirtualBox) on Sun Jun 26 20:01:06 2022

// Copyright (c) 2000-2021 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "dummy.hh"

namespace dummy {

/* Prototypes of static functions */

static void pre_init_module();
static void post_init_module();
static boolean init_comp_type(const char *component_type, boolean init_base_comps);
static boolean init_system_port(const char* component_type, const char* port_name);
static boolean start_ptc_function(const char *function_name, Text_Buf& function_arguments);

/* Literal string constants */

static const OCTETSTRING os_0(0, NULL);
static const CHARSTRING cs_0(4, "ABAB");
static const unsigned char module_checksum[] = { 0x12, 0x09, 0x72, 0xa2, 0x98, 0xad, 0xb9, 0x43, 0x9a, 0x6f, 0xfe, 0xe9, 0x63, 0x67, 0xbc, 0xf3 };

/* Global variable definitions */

static TCPasp__Types::ASP__TCP_template template_receive__any__packet;
const TCPasp__Types::ASP__TCP_template& receive__any__packet = template_receive__any__packet;
const XERdescriptor_t       resp_attachCnt_xer_ = { {"attachCnt>\n", "attachCnt>\n"}, {11, 11}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_Typedescriptor_t resp_attachCnt_descr_ = { "@dummy.resp.attachCnt", &INTEGER_ber_, &INTEGER_raw_, &INTEGER_text_, &resp_attachCnt_xer_, &INTEGER_json_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING resp_attachCnt_default_coding("JSON");
const XERdescriptor_t       resp_noiseLevel_xer_ = { {"noiseLevel>\n", "noiseLevel>\n"}, {12, 12}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const int resp_noiseLevel_oer_ext_arr_[0] = {};
const int resp_noiseLevel_oer_p_[0] = {};
const TTCN_OERdescriptor_t resp_noiseLevel_oer_ = { -1, TRUE, -1, FALSE, 0, 0, resp_noiseLevel_oer_ext_arr_, 0, resp_noiseLevel_oer_p_};
const TTCN_Typedescriptor_t resp_noiseLevel_descr_ = { "@dummy.resp.noiseLevel", &FLOAT_ber_, &FLOAT_raw_, NULL, &resp_noiseLevel_xer_, &FLOAT_json_, &resp_noiseLevel_oer_, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING resp_noiseLevel_default_coding("JSON");
const XERdescriptor_t       resp_signalLevel_xer_ = { {"signalLevel>\n", "signalLevel>\n"}, {13, 13}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const int resp_signalLevel_oer_ext_arr_[0] = {};
const int resp_signalLevel_oer_p_[0] = {};
const TTCN_OERdescriptor_t resp_signalLevel_oer_ = { -1, TRUE, -1, FALSE, 0, 0, resp_signalLevel_oer_ext_arr_, 0, resp_signalLevel_oer_p_};
const TTCN_Typedescriptor_t resp_signalLevel_descr_ = { "@dummy.resp.signalLevel", &FLOAT_ber_, &FLOAT_raw_, NULL, &resp_signalLevel_xer_, &FLOAT_json_, &resp_signalLevel_oer_, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING resp_signalLevel_default_coding("JSON");
const XERdescriptor_t       resp_userData_xer_ = { {"userData>\n", "userData>\n"}, {10, 10}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_Typedescriptor_t resp_userData_descr_ = { "@dummy.resp.userData", NULL, &CHARSTRING_raw_, &CHARSTRING_text_, &resp_userData_xer_, &CHARSTRING_json_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING resp_userData_default_coding("JSON");
// No XER for resp
const TTCN_JSONdescriptor_t resp_json_ = { FALSE, NULL, FALSE, { JD_UNSET, NULL, NULL }, FALSE, FALSE, FALSE, 0, NULL, FALSE, ESCAPE_AS_SHORT };
const TTCN_Typedescriptor_t resp_descr_ = { "@dummy.resp", NULL, NULL, NULL, NULL, &resp_json_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING resp_default_coding("JSON");
const TTCN_Typedescriptor_t& TcpNode__CT_descr_ = COMPONENT_descr_;
TCPasp__PortType::TCPasp__PT TcpNode__CT_component_tcp__port("tcp_port");
const TTCN_Typedescriptor_t& MC_descr_ = COMPONENT_descr_;
TCPasp__PortType::TCPasp__PT MC_component_tcp__port("tcp_port");
// No XER for resps
const TTCN_Typedescriptor_t resps_descr_ = { "@dummy.resps", NULL, NULL, NULL, NULL, NULL, NULL, &resp_descr_, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING resps_0_default_coding("JSON");
TTCN_Module module_object("dummy", __DATE__, __TIME__, module_checksum, pre_init_module, NULL, 0U, 4294967295U, 4294967295U, 4294967295U, NULL, 0LU, 0, post_init_module, NULL, NULL, NULL, init_comp_type, init_system_port, start_ptc_function, NULL);

static const RuntimeVersionChecker ver_checker(  current_runtime_version.requires_major_version_8,
  current_runtime_version.requires_minor_version_1,
  current_runtime_version.requires_patch_level_0,  current_runtime_version.requires_runtime_1);

/* Member functions of C++ classes */

resp::resp()
{
}

resp::resp(const INTEGER& par_attachCnt,
    const FLOAT& par_noiseLevel,
    const FLOAT& par_signalLevel,
    const CHARSTRING& par_userData)
  :   field_attachCnt(par_attachCnt),
  field_noiseLevel(par_noiseLevel),
  field_signalLevel(par_signalLevel),
  field_userData(par_userData)
{
}

resp::resp(const resp& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @dummy.resp.");
if (other_value.attachCnt().is_bound()) field_attachCnt = other_value.attachCnt();
else field_attachCnt.clean_up();
if (other_value.noiseLevel().is_bound()) field_noiseLevel = other_value.noiseLevel();
else field_noiseLevel.clean_up();
if (other_value.signalLevel().is_bound()) field_signalLevel = other_value.signalLevel();
else field_signalLevel.clean_up();
if (other_value.userData().is_bound()) field_userData = other_value.userData();
else field_userData.clean_up();
}

void resp::clean_up()
{
field_attachCnt.clean_up();
field_noiseLevel.clean_up();
field_signalLevel.clean_up();
field_userData.clean_up();
}

const TTCN_Typedescriptor_t* resp::get_descriptor() const { return &resp_descr_; }
resp& resp::operator=(const resp& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @dummy.resp.");
  if (other_value.attachCnt().is_bound()) field_attachCnt = other_value.attachCnt();
  else field_attachCnt.clean_up();
  if (other_value.noiseLevel().is_bound()) field_noiseLevel = other_value.noiseLevel();
  else field_noiseLevel.clean_up();
  if (other_value.signalLevel().is_bound()) field_signalLevel = other_value.signalLevel();
  else field_signalLevel.clean_up();
  if (other_value.userData().is_bound()) field_userData = other_value.userData();
  else field_userData.clean_up();
}
return *this;
}

boolean resp::operator==(const resp& other_value) const
{
return field_attachCnt==other_value.field_attachCnt
  && field_noiseLevel==other_value.field_noiseLevel
  && field_signalLevel==other_value.field_signalLevel
  && field_userData==other_value.field_userData;
}

boolean resp::is_bound() const
{
return (field_attachCnt.is_bound())
  || (field_noiseLevel.is_bound())
  || (field_signalLevel.is_bound())
  || (field_userData.is_bound());
}
boolean resp::is_value() const
{
return field_attachCnt.is_value()
  && field_noiseLevel.is_value()
  && field_signalLevel.is_value()
  && field_userData.is_value();
}
void resp::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ attachCnt := ");
field_attachCnt.log();
TTCN_Logger::log_event_str(", noiseLevel := ");
field_noiseLevel.log();
TTCN_Logger::log_event_str(", signalLevel := ");
field_signalLevel.log();
TTCN_Logger::log_event_str(", userData := ");
field_userData.log();
TTCN_Logger::log_event_str(" }");
}

void resp::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @dummy.resp has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attachCnt().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) noiseLevel().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) signalLevel().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) userData().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attachCnt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attachCnt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "noiseLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          noiseLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signalLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signalLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @dummy.resp: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@dummy.resp");
  }
}

void resp::set_implicit_omit()
{
if (attachCnt().is_bound()) attachCnt().set_implicit_omit();
if (noiseLevel().is_bound()) noiseLevel().set_implicit_omit();
if (signalLevel().is_bound()) signalLevel().set_implicit_omit();
if (userData().is_bound()) userData().set_implicit_omit();
}

void resp::encode_text(Text_Buf& text_buf) const
{
field_attachCnt.encode_text(text_buf);
field_noiseLevel.encode_text(text_buf);
field_signalLevel.encode_text(text_buf);
field_userData.encode_text(text_buf);
}

void resp::decode_text(Text_Buf& text_buf)
{
field_attachCnt.decode_text(text_buf);
field_noiseLevel.decode_text(text_buf);
field_signalLevel.decode_text(text_buf);
field_userData.decode_text(text_buf);
}

void resp::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void resp::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int resp::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @dummy.resp.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "attachCnt");
    enc_len += field_attachCnt.JSON_encode(resp_attachCnt_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "noiseLevel");
    enc_len += field_noiseLevel.JSON_encode(resp_noiseLevel_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "signalLevel");
    enc_len += field_signalLevel.JSON_encode(resp_signalLevel_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "userData");
    enc_len += field_userData.JSON_encode(resp_userData_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int resp::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const resp*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean attachCnt_found = FALSE;
  boolean noiseLevel_found = FALSE;
  boolean signalLevel_found = FALSE;
  boolean userData_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (9 == name_len && 0 == strncmp(fld_name, "attachCnt", name_len)) {
        attachCnt_found = TRUE;
         int ret_val = field_attachCnt.JSON_decode(resp_attachCnt_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "attachCnt");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "noiseLevel", name_len)) {
        noiseLevel_found = TRUE;
         int ret_val = field_noiseLevel.JSON_decode(resp_noiseLevel_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "noiseLevel");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "signalLevel", name_len)) {
        signalLevel_found = TRUE;
         int ret_val = field_signalLevel.JSON_decode(resp_signalLevel_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "signalLevel");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "userData", name_len)) {
        userData_found = TRUE;
         int ret_val = field_userData.JSON_decode(resp_userData_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "userData");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!attachCnt_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "attachCnt");
    return JSON_ERROR_FATAL;
  }
  if (!noiseLevel_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "noiseLevel");
    return JSON_ERROR_FATAL;
  }
  if (!signalLevel_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "signalLevel");
    return JSON_ERROR_FATAL;
  }
  if (!userData_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "userData");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

struct resp_template::single_value_struct {
INTEGER_template field_attachCnt;
FLOAT_template field_noiseLevel;
FLOAT_template field_signalLevel;
CHARSTRING_template field_userData;
};

void resp_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_attachCnt = ANY_VALUE;
single_value->field_noiseLevel = ANY_VALUE;
single_value->field_signalLevel = ANY_VALUE;
single_value->field_userData = ANY_VALUE;
}
}
}

void resp_template::copy_value(const resp& other_value)
{
single_value = new single_value_struct;
if (other_value.attachCnt().is_bound()) {
  single_value->field_attachCnt = other_value.attachCnt();
} else {
  single_value->field_attachCnt.clean_up();
}
if (other_value.noiseLevel().is_bound()) {
  single_value->field_noiseLevel = other_value.noiseLevel();
} else {
  single_value->field_noiseLevel.clean_up();
}
if (other_value.signalLevel().is_bound()) {
  single_value->field_signalLevel = other_value.signalLevel();
} else {
  single_value->field_signalLevel.clean_up();
}
if (other_value.userData().is_bound()) {
  single_value->field_userData = other_value.userData();
} else {
  single_value->field_userData.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void resp_template::copy_template(const resp_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.attachCnt().get_selection()) {
single_value->field_attachCnt = other_value.attachCnt();
} else {
single_value->field_attachCnt.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.noiseLevel().get_selection()) {
single_value->field_noiseLevel = other_value.noiseLevel();
} else {
single_value->field_noiseLevel.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.signalLevel().get_selection()) {
single_value->field_signalLevel = other_value.signalLevel();
} else {
single_value->field_signalLevel.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.userData().get_selection()) {
single_value->field_userData = other_value.userData();
} else {
single_value->field_userData.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new resp_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new resp_template(*other_value.implication_.precondition);
implication_.implied_template = new resp_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @dummy.resp.");
break;
}
set_selection(other_value);
}

resp_template::resp_template()
{
}

resp_template::resp_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

resp_template::resp_template(const resp& other_value)
{
copy_value(other_value);
}

resp_template::resp_template(const OPTIONAL<resp>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const resp&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @dummy.resp from an unbound optional field.");
}
}

resp_template::resp_template(resp_template* p_precondition, resp_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

resp_template::resp_template(Dynamic_Match_Interface<resp>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<resp>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

resp_template::resp_template(const resp_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

resp_template::~resp_template()
{
clean_up();
}

resp_template& resp_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

resp_template& resp_template::operator=(const resp& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

resp_template& resp_template::operator=(const OPTIONAL<resp>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const resp&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @dummy.resp.");
}
return *this;
}

resp_template& resp_template::operator=(const resp_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean resp_template::match(const resp& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.attachCnt().is_bound()) return FALSE;
if(!single_value->field_attachCnt.match(other_value.attachCnt(), legacy))return FALSE;
if(!other_value.noiseLevel().is_bound()) return FALSE;
if(!single_value->field_noiseLevel.match(other_value.noiseLevel(), legacy))return FALSE;
if(!other_value.signalLevel().is_bound()) return FALSE;
if(!single_value->field_signalLevel.match(other_value.signalLevel(), legacy))return FALSE;
if(!other_value.userData().is_bound()) return FALSE;
if(!single_value->field_userData.match(other_value.userData(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @dummy.resp.");
}
return FALSE;
}

boolean resp_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_attachCnt.is_bound()

 ||single_value->field_noiseLevel.is_bound()

 ||single_value->field_signalLevel.is_bound()

 ||single_value->field_userData.is_bound()
;
}

boolean resp_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_attachCnt.is_value()
 &&single_value->field_noiseLevel.is_value()
 &&single_value->field_signalLevel.is_value()
 &&single_value->field_userData.is_value();
}

void resp_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

resp resp_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @dummy.resp.");
resp ret_val;
if (single_value->field_attachCnt.is_bound()) {
ret_val.attachCnt() = single_value->field_attachCnt.valueof();
}
if (single_value->field_noiseLevel.is_bound()) {
ret_val.noiseLevel() = single_value->field_noiseLevel.valueof();
}
if (single_value->field_signalLevel.is_bound()) {
ret_val.signalLevel() = single_value->field_signalLevel.valueof();
}
if (single_value->field_userData.is_bound()) {
ret_val.userData() = single_value->field_userData.valueof();
}
return ret_val;
}

void resp_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @dummy.resp.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new resp_template[list_length];
}

resp_template& resp_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @dummy.resp.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @dummy.resp.");
return value_list.list_value[list_index];
}

INTEGER_template& resp_template::attachCnt()
{
set_specific();
return single_value->field_attachCnt;
}

const INTEGER_template& resp_template::attachCnt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field attachCnt of a non-specific template of type @dummy.resp.");
return single_value->field_attachCnt;
}

FLOAT_template& resp_template::noiseLevel()
{
set_specific();
return single_value->field_noiseLevel;
}

const FLOAT_template& resp_template::noiseLevel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field noiseLevel of a non-specific template of type @dummy.resp.");
return single_value->field_noiseLevel;
}

FLOAT_template& resp_template::signalLevel()
{
set_specific();
return single_value->field_signalLevel;
}

const FLOAT_template& resp_template::signalLevel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field signalLevel of a non-specific template of type @dummy.resp.");
return single_value->field_signalLevel;
}

CHARSTRING_template& resp_template::userData()
{
set_specific();
return single_value->field_userData;
}

const CHARSTRING_template& resp_template::userData() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field userData of a non-specific template of type @dummy.resp.");
return single_value->field_userData;
}

int resp_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @dummy.resp which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @dummy.resp containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @dummy.resp containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @dummy.resp containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @dummy.resp containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @dummy.resp containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @dummy.resp containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @dummy.resp containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @dummy.resp containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @dummy.resp.");
  }
  return 0;
}

void resp_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ attachCnt := ");
single_value->field_attachCnt.log();
TTCN_Logger::log_event_str(", noiseLevel := ");
single_value->field_noiseLevel.log();
TTCN_Logger::log_event_str(", signalLevel := ");
single_value->field_signalLevel.log();
TTCN_Logger::log_event_str(", userData := ");
single_value->field_userData.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void resp_template::log_match(const resp& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_attachCnt.match(match_value.attachCnt(), legacy)){
TTCN_Logger::log_logmatch_info(".attachCnt");
single_value->field_attachCnt.log_match(match_value.attachCnt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_noiseLevel.match(match_value.noiseLevel(), legacy)){
TTCN_Logger::log_logmatch_info(".noiseLevel");
single_value->field_noiseLevel.log_match(match_value.noiseLevel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_signalLevel.match(match_value.signalLevel(), legacy)){
TTCN_Logger::log_logmatch_info(".signalLevel");
single_value->field_signalLevel.log_match(match_value.signalLevel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_userData.match(match_value.userData(), legacy)){
TTCN_Logger::log_logmatch_info(".userData");
single_value->field_userData.log_match(match_value.userData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ attachCnt := ");
single_value->field_attachCnt.log_match(match_value.attachCnt(), legacy);
TTCN_Logger::log_event_str(", noiseLevel := ");
single_value->field_noiseLevel.log_match(match_value.noiseLevel(), legacy);
TTCN_Logger::log_event_str(", signalLevel := ");
single_value->field_signalLevel.log_match(match_value.signalLevel(), legacy);
TTCN_Logger::log_event_str(", userData := ");
single_value->field_userData.log_match(match_value.userData(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void resp_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_attachCnt.encode_text(text_buf);
single_value->field_noiseLevel.encode_text(text_buf);
single_value->field_signalLevel.encode_text(text_buf);
single_value->field_userData.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @dummy.resp.");
}
}

void resp_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_attachCnt.decode_text(text_buf);
single_value->field_noiseLevel.decode_text(text_buf);
single_value->field_signalLevel.decode_text(text_buf);
single_value->field_userData.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new resp_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @dummy.resp.");
}
}

void resp_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    resp_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @dummy.resp has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) attachCnt().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) noiseLevel().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) signalLevel().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) userData().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "attachCnt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          attachCnt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "noiseLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          noiseLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signalLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signalLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userData")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userData().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @dummy.resp: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    resp_template* precondition = new resp_template;
    precondition->set_param(*param.get_elem(0));
    resp_template* implied_template = new resp_template;
    implied_template->set_param(*param.get_elem(1));
    *this = resp_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@dummy.resp");
  }
  is_ifpresent = param.get_ifpresent();
}

void resp_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_attachCnt.check_restriction(t_res, t_name ? t_name : "@dummy.resp");
single_value->field_noiseLevel.check_restriction(t_res, t_name ? t_name : "@dummy.resp");
single_value->field_signalLevel.check_restriction(t_res, t_name ? t_name : "@dummy.resp");
single_value->field_userData.check_restriction(t_res, t_name ? t_name : "@dummy.resp");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@dummy.resp");
}

boolean resp_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean resp_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const resp resps::UNBOUND_ELEM;
resps::resps()
{
val_ptr = NULL;
}

resps::resps(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

resps::resps(const resps& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @dummy.resps.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

resps::~resps()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void resps::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

resps& resps::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

resps& resps::operator=(const resps& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @dummy.resps.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean resps::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @dummy.resps.");
return val_ptr->n_elements == 0 ;
}

boolean resps::operator==(const resps& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @dummy.resps.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @dummy.resps.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

resp& resps::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @dummy.resps using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (resp**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new resp(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new resp;
}
return *val_ptr->value_elements[index_value];
}

resp& resps::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @dummy.resps.");
return (*this)[(int)index_value];
}

const resp& resps::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @dummy.resps.");
if (index_value < 0) TTCN_error("Accessing an element of type @dummy.resps using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @dummy.resps: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const resp& resps::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @dummy.resps.");
return (*this)[(int)index_value];
}

resps resps::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

resps resps::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

resps resps::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

resps resps::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @dummy.resps.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
resps ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new resp(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

resps resps::operator+(const resps& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @dummy.resps concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
resps ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new resp(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new resp(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

resps resps::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @dummy.resps.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@dummy.resps","element");
resps ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new resp(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

resps resps::replace(int index, int len, const resps& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @dummy.resps.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @dummy.resps.");
check_replace_arguments(val_ptr->n_elements, index, len, "@dummy.resps","element");
resps ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new resp(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new resp(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new resp(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

resps resps::replace(int index, int len, const resps_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void resps::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @dummy.resps.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (resp**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new resp(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (resp**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @dummy.resps: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (resp**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean resps::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int resps::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @dummy.resps.");
return val_ptr->n_elements;
}

int resps::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @dummy.resps.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void resps::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void resps::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@dummy.resps");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@dummy.resps");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void resps::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void resps::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @dummy.resps.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void resps::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @dummy.resps.");
val_ptr->value_elements = (resp**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new resp;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void resps_template::copy_value(const resps& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @dummy.resps with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (resp_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new resp_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new resp_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void resps_template::copy_template(const resps_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (resp_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new resp_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new resp_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new resps_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new resps_template(*other_value.implication_.precondition);
implication_.implied_template = new resps_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @dummy.resps.");
break;
}
set_selection(other_value);
}

boolean resps_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const resps_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const resps*)value_ptr)[value_index], legacy);
else return ((const resps_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

resps_template::resps_template()
{
}

resps_template::resps_template(template_sel other_value)
 : Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

resps_template::resps_template(null_type)
 : Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

resps_template::resps_template(const resps& other_value)
{
copy_value(other_value);
}

resps_template::resps_template(const OPTIONAL<resps>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const resps&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @dummy.resps from an unbound optional field.");
}
}

resps_template::resps_template(resps_template* p_precondition, resps_template* p_implied_template)
 : Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

resps_template::resps_template(Dynamic_Match_Interface<resps>* p_dyn_match)
 : Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<resps>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

resps_template::resps_template(const resps_template& other_value)
 : Record_Of_Template()
{
copy_template(other_value);
}

resps_template::~resps_template()
{
clean_up();
}

void resps_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

resps_template& resps_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

resps_template& resps_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

resps_template& resps_template::operator=(const resps& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

resps_template& resps_template::operator=(const OPTIONAL<resps>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const resps&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @dummy.resps.");
}
return *this;
}

resps_template& resps_template::operator=(const resps_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

resp_template& resps_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @dummy.resps using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @dummy.resps.");
    break;
}
return *single_value.value_elements[index_value];
}

resp_template& resps_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @dummy.resps.");
return (*this)[(int)index_value];
}

const resp_template& resps_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @dummy.resps using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @dummy.resps.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @dummy.resps: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const resp_template& resps_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @dummy.resps.");
return (*this)[(int)index_value];
}

void resps_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @dummy.resps.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (resp_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new resp_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new resp_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (resp_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int resps_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int resps_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @dummy.resps which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @dummy.resps containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @dummy.resps containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @dummy.resps containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @dummy.resps containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @dummy.resps containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @dummy.resps.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @dummy.resps");
}

boolean resps_template::match(const resps& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @dummy.resps.");
}
return FALSE;
}

boolean resps_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

resps resps_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @dummy.resps.");
resps ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

resps resps_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

resps resps_template::replace(int index, int len, const resps_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

resps resps_template::replace(int index, int len, const resps& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void resps_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new resps_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @dummy.resps.");
}
set_selection(template_type);
}

resps_template& resps_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @dummy.resps.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @dummy.resps.");
return value_list.list_value[list_index];
}

void resps_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void resps_template::log_match(const resps& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void resps_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @dummy.resps.");
}
}

void resps_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @dummy.resps.");
single_value.value_elements = (resp_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new resp_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new resps_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @dummy.resps.");
}
}

boolean resps_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean resps_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void resps_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    resps_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    resps_template* precondition = new resps_template;
    precondition->set_param(*param.get_elem(0));
    resps_template* implied_template = new resps_template;
    implied_template->set_param(*param.get_elem(1));
    *this = resps_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@dummy.resps");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void resps_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@dummy.resps");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@dummy.resps");
}

boolean resps_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}

/* Bodies of functions, altsteps and testcases */

resp dec__resp(const OCTETSTRING& p__stream)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_resp(): Stream before decoding: ");
p__stream.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_ERROR);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(p__stream);
resp ret_val;
ret_val.decode(resp_descr_, ttcn_buffer, TTCN_EncDec::CT_JSON);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_resp(): Decoded @dummy.resp: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_resp(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

OCTETSTRING enc__resp(const resp& p__resp)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_resp(): Encoding @dummy.resp: ");
p__resp.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_ERROR);
TTCN_Buffer ttcn_buffer;
p__resp.encode(resp_descr_, ttcn_buffer, TTCN_EncDec::CT_JSON, 1);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_resp(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

void resp_attachCnt_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(resp_attachCnt_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER resp_attachCnt_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(resp_attachCnt_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void resp_noiseLevel_encoder(const FLOAT& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `float' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(resp_noiseLevel_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER resp_noiseLevel_decoder(OCTETSTRING& input_stream, FLOAT& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `float' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(resp_noiseLevel_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void resp_signalLevel_encoder(const FLOAT& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `float' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(resp_signalLevel_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER resp_signalLevel_decoder(OCTETSTRING& input_stream, FLOAT& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `float' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(resp_signalLevel_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void resp_userData_encoder(const CHARSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `charstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(resp_userData_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER resp_userData_decoder(OCTETSTRING& input_stream, CHARSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `charstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(resp_userData_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void resp_encoder(const resp& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@dummy.resp' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(resp_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER resp_decoder(OCTETSTRING& input_stream, resp& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_JSON) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@dummy.resp' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(resp_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void f__sink__recv(const INTEGER& p__num)
{
TTCN_Location current_location("dummy.ttcn", 46, TTCN_Location::LOCATION_FUNCTION, "f_sink_recv");
current_location.update_lineno(47);
/* dummy.ttcn, line 47 */
TCPasp__Types::ASP__TCP v__tcp__msg;
{
current_location.update_lineno(48);
/* dummy.ttcn, line 48 */
INTEGER i(0);
current_location.update_lineno(48);
/* dummy.ttcn, line 48 */
for ( ; ; ) {
current_location.update_lineno(48);
/* dummy.ttcn, line 48 */
if (!(i < p__num)) break;
current_location.update_lineno(49);
/* dummy.ttcn, line 49 */
{
tmp_0:
alt_status alt_flag = ALT_UNCHECKED, default_flag = ALT_UNCHECKED;
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (alt_flag != ALT_NO) {
alt_flag = TcpNode__CT_component_tcp__port.receive(receive__any__packet, &(v__tcp__msg), any_compref, NULL, NULL, NULL);
if (alt_flag == ALT_YES) break;
}
if (default_flag != ALT_NO) {
default_flag = TTCN_Default::try_altsteps();
if (default_flag == ALT_YES || default_flag == ALT_BREAK) break;
else if (default_flag == ALT_REPEAT) goto tmp_0;
}
current_location.update_lineno(49);
/* dummy.ttcn, line 49 */
if (alt_flag == ALT_NO && default_flag == ALT_NO) TTCN_error("Stand-alone receive statement failed in file dummy.ttcn, line 49.");
TTCN_Snapshot::take_new(TRUE);
}
}
{
try {
TTCN_TryBlock try_block;
current_location.update_lineno(51);
/* dummy.ttcn, line 51 */
OCTETSTRING s(os_0);
current_location.update_lineno(52);
/* dummy.ttcn, line 52 */
s = const_cast< const TCPasp__Types::ASP__TCP&>(v__tcp__msg).data();
current_location.update_lineno(53);
/* dummy.ttcn, line 53 */
resp r(dec__resp(s));
current_location.update_lineno(54);
/* dummy.ttcn, line 54 */
try {
TTCN_Logger::begin_event(TTCN_USER);
r.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
current_location.update_lineno(55);
/* dummy.ttcn, line 55 */
TTCN_Runtime::setverdict(PASS,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("succes @ "),i.log(),TTCN_Logger::end_event_log2str()));
}
catch (const TTCN_Error& ttcn_error) {
current_location.update_lineno(56);
/* dummy.ttcn, line 56 */
CHARSTRING e;
e = ttcn_error.get_message();
current_location.update_lineno(57);
/* dummy.ttcn, line 57 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("error decoding @ "),i.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(58);
/* dummy.ttcn, line 58 */
try {
TTCN_Logger::begin_event(TTCN_USER);
e.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
}
}
current_location.update_lineno(48);
/* dummy.ttcn, line 48 */
{
INTEGER tmp_2;
++i;
}
}
}
}

void start_f__sink__recv(const COMPONENT& component_reference, const INTEGER& p__num)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_sink_recv(");
p__num.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "dummy", "f_sink_recv", text_buf);
p__num.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

boolean operator==(null_type, const resps& other_value)
{
if (other_value.val_ptr == NULL)
TTCN_error("The right operand of comparison is an unbound value of type @dummy.resps.");
return other_value.val_ptr->n_elements == 0;
}

void f__src__send(const INTEGER& p__num)
{
TTCN_Location current_location("dummy.ttcn", 66, TTCN_Location::LOCATION_FUNCTION, "f_src_send");
current_location.update_lineno(68);
/* dummy.ttcn, line 68 */
resps rs;
rs.set_size(3);
{
resp& tmp_3 = rs[0];
tmp_3.attachCnt() = 0;
tmp_3.noiseLevel() = 2.83768966441098e-13;
tmp_3.signalLevel() = 5.0e-2;
tmp_3.userData() = cs_0;
}
{
resp& tmp_4 = rs[1];
tmp_4.attachCnt() = 0;
tmp_4.noiseLevel() = 2.83768966441098e-13;
tmp_4.signalLevel() = 2.75218270395783e-9;
tmp_4.userData() = cs_0;
}
{
resp& tmp_5 = rs[2];
tmp_5.attachCnt() = 0;
tmp_5.noiseLevel() = 2.75218270395783e-9;
tmp_5.signalLevel() = 5.0e-2;
tmp_5.userData() = cs_0;
}
current_location.update_lineno(88);
/* dummy.ttcn, line 88 */
TCPasp__Types::ASP__TCP tcp__send;
{
current_location.update_lineno(90);
/* dummy.ttcn, line 90 */
INTEGER i(0);
current_location.update_lineno(90);
/* dummy.ttcn, line 90 */
for ( ; ; ) {
current_location.update_lineno(90);
/* dummy.ttcn, line 90 */
if (!(i < p__num)) break;
current_location.update_lineno(91);
/* dummy.ttcn, line 91 */
tcp__send.data() = enc__resp(const_cast< const resps&>(rs)[mod(i, 3)]);
current_location.update_lineno(94);
/* dummy.ttcn, line 94 */
TcpNode__CT_component_tcp__port.send(tcp__send, NULL);
current_location.update_lineno(90);
/* dummy.ttcn, line 90 */
{
INTEGER tmp_7;
++i;
}
}
}
}

void start_f__src__send(const COMPONENT& component_reference, const INTEGER& p__num)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_src_send(");
p__num.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "dummy", "f_src_send", text_buf);
p__num.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

verdicttype testcase_TC__dummy(boolean has_timer, double timer_value)
{
TTCN_Runtime::check_begin_testcase(has_timer, timer_value);
TTCN_Location current_location("dummy.ttcn", 99, TTCN_Location::LOCATION_TESTCASE, "TC_dummy");
try {
TTCN_Runtime::begin_testcase("dummy", "TC_dummy", "dummy", "MC", "dummy", "MC", has_timer, timer_value);
current_location.update_lineno(100);
/* dummy.ttcn, line 100 */
COMPONENT sink(TTCN_Runtime::create_component("dummy", "TcpNode_CT", "sink", NULL, FALSE));
current_location.update_lineno(101);
/* dummy.ttcn, line 101 */
COMPONENT src(TTCN_Runtime::create_component("dummy", "TcpNode_CT", "src", NULL, FALSE));
current_location.update_lineno(102);
/* dummy.ttcn, line 102 */
{
Map_Params tmp_8(0);
TTCN_Runtime::map_port(src, TcpNode__CT_component_tcp__port.get_name(), SYSTEM_COMPREF, MC_component_tcp__port.get_name(), tmp_8);
}
current_location.update_lineno(103);
/* dummy.ttcn, line 103 */
{
Map_Params tmp_9(0);
TTCN_Runtime::map_port(sink, TcpNode__CT_component_tcp__port.get_name(), SYSTEM_COMPREF, MC_component_tcp__port.get_name(), tmp_9);
}
current_location.update_lineno(104);
/* dummy.ttcn, line 104 */
start_f__src__send(src, 3);
current_location.update_lineno(105);
/* dummy.ttcn, line 105 */
start_f__sink__recv(sink, 3);
current_location.update_lineno(107);
/* dummy.ttcn, line 107 */
{
tmp_10:
alt_status alt_flag = ALT_UNCHECKED, default_flag = ALT_UNCHECKED;
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (alt_flag != ALT_NO) {
alt_flag = src.done(NULL, NULL);
if (alt_flag == ALT_YES) break;
else if (alt_flag == ALT_REPEAT) goto tmp_10;
}
if (default_flag != ALT_NO) {
default_flag = TTCN_Default::try_altsteps();
if (default_flag == ALT_YES || default_flag == ALT_BREAK) break;
else if (default_flag == ALT_REPEAT) goto tmp_10;
}
current_location.update_lineno(107);
/* dummy.ttcn, line 107 */
if (alt_flag == ALT_NO && default_flag == ALT_NO) TTCN_error("Stand-alone done statement failed in file dummy.ttcn, line 107.");
TTCN_Snapshot::take_new(TRUE);
}
}
} catch (const TC_Error& tc_error) {
} catch (const TC_End& tc_end) {
TTCN_Logger::log_str(TTCN_FUNCTION, "Test case TC_dummy was stopped.");
}
return TTCN_Runtime::end_testcase();
}


/* Bodies of static functions */

static void pre_init_module()
{
TTCN_Location current_location("dummy.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "dummy");
TCPasp__PortType::module_object.pre_init_module();
module_object.add_function("dec_resp", (genericfunc_t)&dec__resp, NULL);
module_object.add_function("enc_resp", (genericfunc_t)&enc__resp, NULL);
module_object.add_function("f_sink_recv", (genericfunc_t)&f__sink__recv, (genericfunc_t)&start_f__sink__recv);
module_object.add_function("f_src_send", (genericfunc_t)&f__src__send, (genericfunc_t)&start_f__src__send);
module_object.add_testcase_nonpard("TC_dummy", testcase_TC__dummy);
}

static void post_init_module()
{
TTCN_Location current_location("dummy.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "dummy");
TCPasp__PortType::module_object.post_init_module();
current_location.update_lineno(5);
/* dummy.ttcn, line 5 */
template_receive__any__packet.client__id() = ANY_OR_OMIT;
template_receive__any__packet.data() = ANY_VALUE;
}

static boolean init_comp_type(const char *component_type, boolean init_base_comps)
{
(void)init_base_comps;
if (!strcmp(component_type, "TcpNode_CT")) {
TcpNode__CT_component_tcp__port.activate_port();
return TRUE;
} else if (!strcmp(component_type, "MC")) {
MC_component_tcp__port.activate_port();
return TRUE;
} else return FALSE;
}

static boolean init_system_port(const char* component_type, const char* port_name)
{
if (!strcmp(component_type, "TcpNode_CT")) {
if (!strcmp(port_name, "tcp_port")) {
TcpNode__CT_component_tcp__port.safe_start();
return TRUE;
}
}
else if (!strcmp(component_type, "MC")) {
if (!strcmp(port_name, "tcp_port")) {
MC_component_tcp__port.safe_start();
return TRUE;
}
}
return FALSE;
}

static boolean start_ptc_function(const char *function_name, Text_Buf& function_arguments)
{
if (!strcmp(function_name, "f_sink_recv")) {
INTEGER p__num;
p__num.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_sink_recv(");
p__num.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__sink__recv(p__num);
TTCN_Runtime::function_finished("f_sink_recv");
return TRUE;
} else if (!strcmp(function_name, "f_src_send")) {
INTEGER p__num;
p__num.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_src_send(");
p__num.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__src__send(p__num);
TTCN_Runtime::function_finished("f_src_send");
return TRUE;
} else return FALSE;
}


} /* end of namespace */
