// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 8.1.0
// for test (test@test-VirtualBox) on Sun Jun 26 19:41:53 2022

// Copyright (c) 2000-2021 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "TCPasp_PortType.hh"

namespace TCPasp__PortType {

/* Prototypes of static functions */

static void pre_init_module();
static void post_init_module();

/* Literal string constants */

static const unsigned char module_checksum[] = { 0x31, 0xec, 0xe6, 0xcd, 0x80, 0x8b, 0xeb, 0x20, 0x05, 0xc6, 0x51, 0x19, 0x24, 0xe0, 0xe8, 0xe8 };

/* Global variable definitions */

TTCN_Module module_object("TCPasp_PortType", __DATE__, __TIME__, module_checksum, pre_init_module, NULL, 0U, 4294967295U, 4294967295U, 4294967295U, NULL, 0LU, 0, post_init_module, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

static const RuntimeVersionChecker ver_checker(  current_runtime_version.requires_major_version_8,
  current_runtime_version.requires_minor_version_1,
  current_runtime_version.requires_patch_level_0,  current_runtime_version.requires_runtime_1);

/* Member functions of C++ classes */

void TCPasp__PT::remove_msg_queue_head()
{
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
switch (my_head->item_selection) {
case MESSAGE_0:
delete (my_head)->message_0;
break;
case MESSAGE_1:
delete (my_head)->message_1;
break;
case MESSAGE_2:
delete (my_head)->message_2;
break;
case MESSAGE_3:
delete (my_head)->message_3;
break;
case MESSAGE_4:
delete (my_head)->message_4;
break;
case MESSAGE_5:
delete (my_head)->message_5;
break;
default:
TTCN_error("Internal error: Invalid message selector in the queue of port %s.", port_name);
}
msg_queue_item_base *next_item = msg_queue_head->next_item;
delete (msg_queue_item*)msg_queue_head;
msg_queue_head = next_item;
if (next_item == NULL) msg_queue_tail = NULL;
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::extract__msg, port_name, 0, ++msg_head_count, CHARSTRING(0,NULL), CHARSTRING(0,NULL));}

void TCPasp__PT::clear_queue()
{
while (msg_queue_head != NULL) remove_msg_queue_head();
}

TCPasp__PT::TCPasp__PT(const char *par_port_name)
 : TCPasp__PT_PROVIDER(par_port_name)
{
msg_queue_head = NULL;
msg_queue_tail = NULL;
mapped_ports = NULL;
n_mapped_ports = 0;
}

TCPasp__PT::~TCPasp__PT()
{
clear_queue();
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Connect& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Sending a message on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of send operation.");
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMSEND:TTCN_Logger::PORTEVENT_MCSEND;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_send(port_name, destination_component,
(TTCN_Logger::begin_event(log_sev, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Connect : "),
send_par.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) {
(void)get_default_destination();
outgoing_send(send_par);
}
else {
Text_Buf text_buf;
prepare_message(text_buf, "@TCPasp_Types.ASP_TCP_Connect");
send_par.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Connect& send_par, FLOAT* timestamp_redirect)
{
send(send_par, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Connect_template& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP__Connect& send_par_value = TCPasp__Types::ASP__TCP__Connect(send_par.valueof());
send(send_par_value, destination_component, timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Connect_template& send_par, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP__Connect& send_par_value = TCPasp__Types::ASP__TCP__Connect(send_par.valueof());
send(send_par_value, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Listen& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Sending a message on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of send operation.");
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMSEND:TTCN_Logger::PORTEVENT_MCSEND;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_send(port_name, destination_component,
(TTCN_Logger::begin_event(log_sev, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Listen : "),
send_par.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) {
(void)get_default_destination();
outgoing_send(send_par);
}
else {
Text_Buf text_buf;
prepare_message(text_buf, "@TCPasp_Types.ASP_TCP_Listen");
send_par.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Listen& send_par, FLOAT* timestamp_redirect)
{
send(send_par, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Listen_template& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP__Listen& send_par_value = TCPasp__Types::ASP__TCP__Listen(send_par.valueof());
send(send_par_value, destination_component, timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Listen_template& send_par, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP__Listen& send_par_value = TCPasp__Types::ASP__TCP__Listen(send_par.valueof());
send(send_par_value, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Shutdown& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Sending a message on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of send operation.");
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMSEND:TTCN_Logger::PORTEVENT_MCSEND;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_send(port_name, destination_component,
(TTCN_Logger::begin_event(log_sev, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Shutdown : "),
send_par.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) {
(void)get_default_destination();
outgoing_send(send_par);
}
else {
Text_Buf text_buf;
prepare_message(text_buf, "@TCPasp_Types.ASP_TCP_Shutdown");
send_par.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Shutdown& send_par, FLOAT* timestamp_redirect)
{
send(send_par, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Shutdown_template& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP__Shutdown& send_par_value = TCPasp__Types::ASP__TCP__Shutdown(send_par.valueof());
send(send_par_value, destination_component, timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Shutdown_template& send_par, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP__Shutdown& send_par_value = TCPasp__Types::ASP__TCP__Shutdown(send_par.valueof());
send(send_par_value, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const CHARSTRING& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Sending a message on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of send operation.");
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMSEND:TTCN_Logger::PORTEVENT_MCSEND;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_send(port_name, destination_component,
(TTCN_Logger::begin_event(log_sev, TRUE), TTCN_Logger::log_event_str(" charstring : "),
send_par.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) {
(void)get_default_destination();
outgoing_send(send_par);
}
else {
Text_Buf text_buf;
prepare_message(text_buf, "charstring");
send_par.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void TCPasp__PT::send(const CHARSTRING& send_par, FLOAT* timestamp_redirect)
{
send(send_par, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const CHARSTRING_template& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
const CHARSTRING& send_par_value = CHARSTRING(send_par.valueof());
send(send_par_value, destination_component, timestamp_redirect);
}

void TCPasp__PT::send(const CHARSTRING_template& send_par, FLOAT* timestamp_redirect)
{
const CHARSTRING& send_par_value = CHARSTRING(send_par.valueof());
send(send_par_value, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Sending a message on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of send operation.");
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMSEND:TTCN_Logger::PORTEVENT_MCSEND;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_send(port_name, destination_component,
(TTCN_Logger::begin_event(log_sev, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP : "),
send_par.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) {
(void)get_default_destination();
outgoing_send(send_par);
}
else {
Text_Buf text_buf;
prepare_message(text_buf, "@TCPasp_Types.ASP_TCP");
send_par.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP& send_par, FLOAT* timestamp_redirect)
{
send(send_par, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP_template& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP& send_par_value = TCPasp__Types::ASP__TCP(send_par.valueof());
send(send_par_value, destination_component, timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP_template& send_par, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP& send_par_value = TCPasp__Types::ASP__TCP(send_par.valueof());
send(send_par_value, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Close& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Sending a message on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of send operation.");
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMSEND:TTCN_Logger::PORTEVENT_MCSEND;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_send(port_name, destination_component,
(TTCN_Logger::begin_event(log_sev, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Close : "),
send_par.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) {
(void)get_default_destination();
outgoing_send(send_par);
}
else {
Text_Buf text_buf;
prepare_message(text_buf, "@TCPasp_Types.ASP_TCP_Close");
send_par.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Close& send_par, FLOAT* timestamp_redirect)
{
send(send_par, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Close_template& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP__Close& send_par_value = TCPasp__Types::ASP__TCP__Close(send_par.valueof());
send(send_par_value, destination_component, timestamp_redirect);
}

void TCPasp__PT::send(const TCPasp__Types::ASP__TCP__Close_template& send_par, FLOAT* timestamp_redirect)
{
const TCPasp__Types::ASP__TCP__Close& send_par_value = TCPasp__Types::ASP__TCP__Close(send_par.valueof());
send(send_par_value, COMPONENT(get_default_destination()), timestamp_redirect);
}

void TCPasp__PT::add_port(PORT* p)
{
++n_mapped_ports;
mapped_ports = static_cast<PORT**>(Realloc(mapped_ports, n_mapped_ports * sizeof(PORT*)));
mapped_ports[n_mapped_ports - 1] = p;
}

void TCPasp__PT::remove_port(PORT* p)
{
size_t new_size = n_mapped_ports;
for (size_t i = 0; i < n_mapped_ports; ++i) {
if (mapped_ports[i] == p) {
mapped_ports[i] = NULL;
--new_size;
}
}
if (new_size != n_mapped_ports) {
PORT** new_list = static_cast<PORT**>(Malloc(new_size * sizeof(PORT*)));
for (size_t i = 0, j = 0; i < n_mapped_ports; ++i) {
if (mapped_ports[i] != NULL) {
new_list[j] = mapped_ports[i];
++j;
}
}
Free(mapped_ports);
mapped_ports = new_list;
n_mapped_ports = new_size;
}
}

void TCPasp__PT::reset_port_variables()
{
Free(mapped_ports);
mapped_ports = NULL;
n_mapped_ports = 0;
}

void TCPasp__PT::outgoing_public_send(const TCPasp__Types::ASP__TCP__Connect& send_par) {
outgoing_send(send_par);
}

void TCPasp__PT::outgoing_public_send(const TCPasp__Types::ASP__TCP__Listen& send_par) {
outgoing_send(send_par);
}

void TCPasp__PT::outgoing_public_send(const TCPasp__Types::ASP__TCP__Shutdown& send_par) {
outgoing_send(send_par);
}

void TCPasp__PT::outgoing_public_send(const CHARSTRING& send_par) {
outgoing_send(send_par);
}

void TCPasp__PT::outgoing_public_send(const TCPasp__Types::ASP__TCP& send_par) {
outgoing_send(send_par);
}

void TCPasp__PT::outgoing_public_send(const TCPasp__Types::ASP__TCP__Close& send_par) {
outgoing_send(send_par);
}

alt_status TCPasp__PT::receive(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else {
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
switch (my_head->item_selection) {
case MESSAGE_0:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connect_result: "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_1:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connected: "),
my_head->message_1->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_2:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Listen_result: "),
my_head->message_2->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_3:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Send_error: "),
my_head->message_3->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_4:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP: "),
my_head->message_4->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_5:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Close: "),
my_head->message_5->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
default:
TTCN_error("Internal error: unknown message");
}
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::check_receive(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else {
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
switch (my_head->item_selection) {
case MESSAGE_0:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connect_result: "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_1:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connected: "),
my_head->message_1->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_2:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Listen_result: "),
my_head->message_2->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_3:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Send_error: "),
my_head->message_3->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_4:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP: "),
my_head->message_4->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_5:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Close: "),
my_head->message_5->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
default:
TTCN_error("Internal error: unknown message");
}
}
return ALT_YES;
}
}

alt_status TCPasp__PT::trigger(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
switch (my_head->item_selection) {
case MESSAGE_0:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connect_result: "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_1:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connected: "),
my_head->message_1->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_2:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Listen_result: "),
my_head->message_2->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_3:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Send_error: "),
my_head->message_3->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_4:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP: "),
my_head->message_4->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
case MESSAGE_5:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Close: "),
my_head->message_5->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
default:
TTCN_error("Internal error: unknown message");
}
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::receive(const TCPasp__Types::ASP__TCP__Connect__result_template& value_template, TCPasp__Types::ASP__TCP__Connect__result *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_0) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Connect_result.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_0)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_0;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connect_result : "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::check_receive(const TCPasp__Types::ASP__TCP__Connect__result_template& value_template, TCPasp__Types::ASP__TCP__Connect__result *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Check-receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_0) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Connect_result.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_0)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_0;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connect_result : "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status TCPasp__PT::trigger(const TCPasp__Types::ASP__TCP__Connect__result_template& value_template, TCPasp__Types::ASP__TCP__Connect__result *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Trigger operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else if (my_head->item_selection != MESSAGE_0) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s will drop a message: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Connect_result.", port_name);
remove_msg_queue_head();
return ALT_REPEAT;
} else if (!value_template.match(*my_head->message_0)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_0;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connect_result : "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::receive(const TCPasp__Types::ASP__TCP__Connected_template& value_template, TCPasp__Types::ASP__TCP__Connected *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_1) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Connected.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_1)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_1),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_1;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_1),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connected : "),
my_head->message_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::check_receive(const TCPasp__Types::ASP__TCP__Connected_template& value_template, TCPasp__Types::ASP__TCP__Connected *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Check-receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_1) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Connected.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_1)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_1),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_1;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_1),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connected : "),
my_head->message_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status TCPasp__PT::trigger(const TCPasp__Types::ASP__TCP__Connected_template& value_template, TCPasp__Types::ASP__TCP__Connected *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Trigger operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else if (my_head->item_selection != MESSAGE_1) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s will drop a message: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Connected.", port_name);
remove_msg_queue_head();
return ALT_REPEAT;
} else if (!value_template.match(*my_head->message_1)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_1),
 TTCN_Logger::end_event_log2str()));
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_1;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_1),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Connected : "),
my_head->message_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::receive(const TCPasp__Types::ASP__TCP__Listen__result_template& value_template, TCPasp__Types::ASP__TCP__Listen__result *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_2) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Listen_result.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_2)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_2),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_2;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_2),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Listen_result : "),
my_head->message_2->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::check_receive(const TCPasp__Types::ASP__TCP__Listen__result_template& value_template, TCPasp__Types::ASP__TCP__Listen__result *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Check-receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_2) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Listen_result.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_2)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_2),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_2;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_2),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Listen_result : "),
my_head->message_2->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status TCPasp__PT::trigger(const TCPasp__Types::ASP__TCP__Listen__result_template& value_template, TCPasp__Types::ASP__TCP__Listen__result *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Trigger operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else if (my_head->item_selection != MESSAGE_2) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s will drop a message: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Listen_result.", port_name);
remove_msg_queue_head();
return ALT_REPEAT;
} else if (!value_template.match(*my_head->message_2)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_2),
 TTCN_Logger::end_event_log2str()));
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_2;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_2),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Listen_result : "),
my_head->message_2->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::receive(const TCPasp__Types::ASP__TCP__Send__error_template& value_template, TCPasp__Types::ASP__TCP__Send__error *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_3) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Send_error.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_3)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_3),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_3;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_3),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Send_error : "),
my_head->message_3->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::check_receive(const TCPasp__Types::ASP__TCP__Send__error_template& value_template, TCPasp__Types::ASP__TCP__Send__error *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Check-receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_3) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Send_error.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_3)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_3),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_3;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_3),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Send_error : "),
my_head->message_3->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status TCPasp__PT::trigger(const TCPasp__Types::ASP__TCP__Send__error_template& value_template, TCPasp__Types::ASP__TCP__Send__error *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Trigger operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else if (my_head->item_selection != MESSAGE_3) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s will drop a message: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Send_error.", port_name);
remove_msg_queue_head();
return ALT_REPEAT;
} else if (!value_template.match(*my_head->message_3)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_3),
 TTCN_Logger::end_event_log2str()));
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_3;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_3),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Send_error : "),
my_head->message_3->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::receive(const TCPasp__Types::ASP__TCP_template& value_template, TCPasp__Types::ASP__TCP *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_4) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_4)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_4),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_4;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_4),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP : "),
my_head->message_4->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::check_receive(const TCPasp__Types::ASP__TCP_template& value_template, TCPasp__Types::ASP__TCP *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Check-receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_4) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_4)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_4),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_4;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_4),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP : "),
my_head->message_4->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status TCPasp__PT::trigger(const TCPasp__Types::ASP__TCP_template& value_template, TCPasp__Types::ASP__TCP *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Trigger operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else if (my_head->item_selection != MESSAGE_4) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s will drop a message: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP.", port_name);
remove_msg_queue_head();
return ALT_REPEAT;
} else if (!value_template.match(*my_head->message_4)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_4),
 TTCN_Logger::end_event_log2str()));
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_4;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_4),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP : "),
my_head->message_4->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::receive(const TCPasp__Types::ASP__TCP__Close_template& value_template, TCPasp__Types::ASP__TCP__Close *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_5) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Close.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_5)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_5),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_5;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_5),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Close : "),
my_head->message_5->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status TCPasp__PT::check_receive(const TCPasp__Types::ASP__TCP__Close_template& value_template, TCPasp__Types::ASP__TCP__Close *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Check-receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_5) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Close.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_5)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_5),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_5;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_5),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Close : "),
my_head->message_5->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status TCPasp__PT::trigger(const TCPasp__Types::ASP__TCP__Close_template& value_template, TCPasp__Types::ASP__TCP__Close *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Trigger operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else if (my_head->item_selection != MESSAGE_5) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s will drop a message: Type of the first message in the queue is not @TCPasp_Types.ASP_TCP_Close.", port_name);
remove_msg_queue_head();
return ALT_REPEAT;
} else if (!value_template.match(*my_head->message_5)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_5),
 TTCN_Logger::end_event_log2str()));
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_5;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_5),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @TCPasp_Types.ASP_TCP_Close : "),
my_head->message_5->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Connect__result& incoming_par, component sender_component)
{
for (size_t i = 0; i < n_mapped_ports; i++) {
if (mapped_ports[i] != NULL && mapped_ports[i]->incoming_message_handler(&incoming_par, "@TCPasp_Types.ASP_TCP_Connect_result", sender_component, FLOAT())) {
return;
}
}
if (!is_started) {
if (is_halted) {
TTCN_warning("A message that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a message has arrived on it.", port_name);
}
}
msg_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_MQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__msg, port_name, sender_component, msg_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_MQUEUE, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Connect_result : "), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
msg_queue_item *new_item = new msg_queue_item;
new_item->item_selection = MESSAGE_0;
new_item->message_0 = new TCPasp__Types::ASP__TCP__Connect__result(incoming_par);
new_item->sender_component = sender_component;
append_to_msg_queue(new_item);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Connected& incoming_par, component sender_component)
{
for (size_t i = 0; i < n_mapped_ports; i++) {
if (mapped_ports[i] != NULL && mapped_ports[i]->incoming_message_handler(&incoming_par, "@TCPasp_Types.ASP_TCP_Connected", sender_component, FLOAT())) {
return;
}
}
if (!is_started) {
if (is_halted) {
TTCN_warning("A message that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a message has arrived on it.", port_name);
}
}
msg_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_MQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__msg, port_name, sender_component, msg_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_MQUEUE, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Connected : "), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
msg_queue_item *new_item = new msg_queue_item;
new_item->item_selection = MESSAGE_1;
new_item->message_1 = new TCPasp__Types::ASP__TCP__Connected(incoming_par);
new_item->sender_component = sender_component;
append_to_msg_queue(new_item);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Listen__result& incoming_par, component sender_component)
{
for (size_t i = 0; i < n_mapped_ports; i++) {
if (mapped_ports[i] != NULL && mapped_ports[i]->incoming_message_handler(&incoming_par, "@TCPasp_Types.ASP_TCP_Listen_result", sender_component, FLOAT())) {
return;
}
}
if (!is_started) {
if (is_halted) {
TTCN_warning("A message that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a message has arrived on it.", port_name);
}
}
msg_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_MQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__msg, port_name, sender_component, msg_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_MQUEUE, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Listen_result : "), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
msg_queue_item *new_item = new msg_queue_item;
new_item->item_selection = MESSAGE_2;
new_item->message_2 = new TCPasp__Types::ASP__TCP__Listen__result(incoming_par);
new_item->sender_component = sender_component;
append_to_msg_queue(new_item);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Send__error& incoming_par, component sender_component)
{
for (size_t i = 0; i < n_mapped_ports; i++) {
if (mapped_ports[i] != NULL && mapped_ports[i]->incoming_message_handler(&incoming_par, "@TCPasp_Types.ASP_TCP_Send_error", sender_component, FLOAT())) {
return;
}
}
if (!is_started) {
if (is_halted) {
TTCN_warning("A message that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a message has arrived on it.", port_name);
}
}
msg_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_MQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__msg, port_name, sender_component, msg_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_MQUEUE, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Send_error : "), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
msg_queue_item *new_item = new msg_queue_item;
new_item->item_selection = MESSAGE_3;
new_item->message_3 = new TCPasp__Types::ASP__TCP__Send__error(incoming_par);
new_item->sender_component = sender_component;
append_to_msg_queue(new_item);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP& incoming_par, component sender_component)
{
for (size_t i = 0; i < n_mapped_ports; i++) {
if (mapped_ports[i] != NULL && mapped_ports[i]->incoming_message_handler(&incoming_par, "@TCPasp_Types.ASP_TCP", sender_component, FLOAT())) {
return;
}
}
if (!is_started) {
if (is_halted) {
TTCN_warning("A message that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a message has arrived on it.", port_name);
}
}
msg_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_MQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__msg, port_name, sender_component, msg_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_MQUEUE, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP : "), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
msg_queue_item *new_item = new msg_queue_item;
new_item->item_selection = MESSAGE_4;
new_item->message_4 = new TCPasp__Types::ASP__TCP(incoming_par);
new_item->sender_component = sender_component;
append_to_msg_queue(new_item);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Close& incoming_par, component sender_component)
{
for (size_t i = 0; i < n_mapped_ports; i++) {
if (mapped_ports[i] != NULL && mapped_ports[i]->incoming_message_handler(&incoming_par, "@TCPasp_Types.ASP_TCP_Close", sender_component, FLOAT())) {
return;
}
}
if (!is_started) {
if (is_halted) {
TTCN_warning("A message that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a message has arrived on it.", port_name);
}
}
msg_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_MQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__msg, port_name, sender_component, msg_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_MQUEUE, TRUE), TTCN_Logger::log_event_str(" @TCPasp_Types.ASP_TCP_Close : "), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
msg_queue_item *new_item = new msg_queue_item;
new_item->item_selection = MESSAGE_5;
new_item->message_5 = new TCPasp__Types::ASP__TCP__Close(incoming_par);
new_item->sender_component = sender_component;
append_to_msg_queue(new_item);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Connect__result& incoming_par)
{
incoming_message(incoming_par, SYSTEM_COMPREF);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Connected& incoming_par)
{
incoming_message(incoming_par, SYSTEM_COMPREF);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Listen__result& incoming_par)
{
incoming_message(incoming_par, SYSTEM_COMPREF);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Send__error& incoming_par)
{
incoming_message(incoming_par, SYSTEM_COMPREF);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP& incoming_par)
{
incoming_message(incoming_par, SYSTEM_COMPREF);
}

void TCPasp__PT::incoming_message(const TCPasp__Types::ASP__TCP__Close& incoming_par)
{
incoming_message(incoming_par, SYSTEM_COMPREF);
}

boolean TCPasp__PT::process_message(const char *message_type, Text_Buf& incoming_buf, component sender_component, OCTETSTRING&)
{
if (!strcmp(message_type, "@TCPasp_Types.ASP_TCP_Connect_result")) {
TCPasp__Types::ASP__TCP__Connect__result incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_message(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(message_type, "@TCPasp_Types.ASP_TCP_Connected")) {
TCPasp__Types::ASP__TCP__Connected incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_message(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(message_type, "@TCPasp_Types.ASP_TCP_Listen_result")) {
TCPasp__Types::ASP__TCP__Listen__result incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_message(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(message_type, "@TCPasp_Types.ASP_TCP_Send_error")) {
TCPasp__Types::ASP__TCP__Send__error incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_message(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(message_type, "@TCPasp_Types.ASP_TCP")) {
TCPasp__Types::ASP__TCP incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_message(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(message_type, "@TCPasp_Types.ASP_TCP_Close")) {
TCPasp__Types::ASP__TCP__Close incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_message(incoming_par, sender_component);
return TRUE;
} else return FALSE;
}


/* Bodies of static functions */

static void pre_init_module()
{
TTCN_Location current_location("TCPasp_PortType.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "TCPasp_PortType");
TCPasp__Types::module_object.pre_init_module();
}

static void post_init_module()
{
TTCN_Location current_location("TCPasp_PortType.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "TCPasp_PortType");
TCPasp__Types::module_object.post_init_module();
}


} /* end of namespace */
