/**
 * generated by Xtext 2.25.0
 */
package pivot;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>State Machine</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * StateMachines can be used to express event-driven behaviors of parts of a system. Behavior is modeled as a traversal of a graph of Vertices interconnected by one or more joined Transition arcs that are triggered by the dispatching of successive Event occurrences. During this traversal, the StateMachine may execute a sequence of Behaviors associated with various elements of the StateMachine.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link pivot.StateMachine#getExtendedStateMachines <em>Extended State Machines</em>}</li>
 *   <li>{@link pivot.StateMachine#getOwnedConnectionPoints <em>Owned Connection Points</em>}</li>
 *   <li>{@link pivot.StateMachine#getOwnedRegions <em>Owned Regions</em>}</li>
 *   <li>{@link pivot.StateMachine#getSubmachineStates <em>Submachine States</em>}</li>
 * </ul>
 *
 * @see pivot.PivotPackage#getStateMachine()
 * @model
 * @generated
 */
public interface StateMachine extends Behavior {
	/**
	 * Returns the value of the '<em><b>Extended State Machines</b></em>' reference list.
	 * The list contents are of type {@link pivot.StateMachine}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The StateMachines of which this is an extension.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Extended State Machines</em>' reference list.
	 * @see pivot.PivotPackage#getStateMachine_ExtendedStateMachines()
	 * @model ordered="false"
	 * @generated
	 */
	EList<StateMachine> getExtendedStateMachines();

	/**
	 * Returns the value of the '<em><b>Owned Connection Points</b></em>' containment reference list.
	 * The list contents are of type {@link pivot.Pseudostate}.
	 * It is bidirectional and its opposite is '{@link pivot.Pseudostate#getOwningStateMachine <em>Owning State Machine</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The connection points defined for this StateMachine. They represent the interface of the StateMachine when used as part of submachine State
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Owned Connection Points</em>' containment reference list.
	 * @see pivot.PivotPackage#getStateMachine_OwnedConnectionPoints()
	 * @see pivot.Pseudostate#getOwningStateMachine
	 * @model opposite="owningStateMachine" containment="true" ordered="false"
	 * @generated
	 */
	EList<Pseudostate> getOwnedConnectionPoints();

	/**
	 * Returns the value of the '<em><b>Owned Regions</b></em>' containment reference list.
	 * The list contents are of type {@link pivot.Region}.
	 * It is bidirectional and its opposite is '{@link pivot.Region#getOwningStateMachine <em>Owning State Machine</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The Regions owned directly by the StateMachine.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Owned Regions</em>' containment reference list.
	 * @see pivot.PivotPackage#getStateMachine_OwnedRegions()
	 * @see pivot.Region#getOwningStateMachine
	 * @model opposite="owningStateMachine" containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<Region> getOwnedRegions();

	/**
	 * Returns the value of the '<em><b>Submachine States</b></em>' reference list.
	 * The list contents are of type {@link pivot.State}.
	 * It is bidirectional and its opposite is '{@link pivot.State#getSubmachines <em>Submachines</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * References the submachine(s) in case of a submachine State. Multiple machines are referenced in case of a concurrent State.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Submachine States</em>' reference list.
	 * @see pivot.PivotPackage#getStateMachine_SubmachineStates()
	 * @see pivot.State#getSubmachines
	 * @model opposite="submachines" ordered="false"
	 * @generated
	 */
	EList<State> getSubmachineStates();

} // StateMachine
