/**
 * Copyright (c) 2013 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *     Adolfo Sanchez-Barbudo Herrera (University of York) - bug397429
 */
package org.eclipse.ocl.examples.build.xtend;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.FlowAnalysis;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public abstract class GenerateVisitorsXtend extends GenerateVisitors {
  /**
   * Abstract«projectPrefix»«generic»Visitor
   */
  protected void generateAbstractGenericVisitor(final EPackage ePackage, final String generic, final Class<?> returnClass, final Class<?> contextClass) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter(((((this.outputFolder + "Abstract") + this.projectPrefix) + generic) + "Visitor.java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import ");
      String _name = returnClass.getName();
      _builder.append(_name);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.Nullable;");
      _builder.newLine();
      _builder.append("import ");
      String _name_1 = contextClass.getName();
      _builder.append(_name_1);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      {
        if (isDerived) {
          _builder.append("import ");
          _builder.append(this.superVisitorPackageName);
          _builder.append("ities.");
          _builder.append(this.superProjectPrefix);
          _builder.append(generic);
          _builder.append("Visitor;");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An Abstract");
      _builder.append(this.projectPrefix, " ");
      _builder.append(generic, " ");
      _builder.append("Visitor provides a default implementation for each");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* visitXxx method that delegates to the visitYyy method of the first");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* super class, (or transitively its first super class\' first super class");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* until a non-interface super-class is found). In the absence of any");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* suitable first super class, the method delegates to visiting().");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class Abstract");
      _builder.append(this.projectPrefix);
      _builder.append(generic);
      _builder.append("Visitor");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      {
        if (isDerived) {
          _builder.append("extends ");
          _builder.append(this.superProjectPrefix, "\t");
          _builder.append(generic, "\t");
          _builder.append("Visitor");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<");
      String _simpleName = returnClass.getSimpleName();
      _builder.append(_simpleName, "\t");
      _builder.append(">");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Initializes me with an initial value for my result.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param context my initial result value");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected Abstract");
      _builder.append(this.projectPrefix, "\t");
      _builder.append(generic, "\t");
      _builder.append("Visitor(");
      String _emitNonNull = this.emitNonNull(contextClass.getSimpleName());
      _builder.append(_emitNonNull, "\t");
      _builder.append(" context) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(context);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.append("\t");
          EClass firstSuperClass = GenerateVisitors.firstSuperClass(eClass, eClass);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public ");
          String _emitNullable = this.emitNullable(returnClass.getSimpleName());
          _builder.append(_emitNullable, "\t");
          _builder.append(" visit");
          String _name_2 = eClass.getName();
          _builder.append(_name_2, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull_1 = this.emitNonNull(_plus);
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _equals = Objects.equal(firstSuperClass, eClass);
            if (_equals) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visiting(object);");
              _builder.newLine();
            } else {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visit");
              String _name_3 = firstSuperClass.getName();
              _builder.append(_name_3, "\t\t");
              _builder.append("(object);");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * AbstractDelegatingVisitor
   */
  protected void generateAbstractDelegatingVisitor(final EPackage ePackage) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter((((this.outputFolder + "AbstractDelegating") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An AbstractDelegating");
      _builder.append(this.visitorClassName, " ");
      _builder.append(" delegates all visits.");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class AbstractDelegating");
      _builder.append(this.visitorClassName);
      _builder.append("<R, C, @NonNull D extends ");
      _builder.append(this.visitorClassName);
      _builder.append("<R>>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("extends ");
      {
        if (isDerived) {
          _builder.append(this.superVisitorPackageName, "\t");
          _builder.append(".AbstractDelegating");
          _builder.append(this.superVisitorClassName, "\t");
          _builder.append("<R, C, D>");
        } else {
          {
            if (isDerived) {
              _builder.append(this.superVisitorClassName, "\t");
            } else {
              _builder.append("Abstract");
              _builder.append(this.visitorClassName, "\t");
            }
          }
          _builder.append("<R, C>");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<R>");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      {
        if (isDerived) {
          _builder.append("\t");
          _builder.append("protected AbstractDelegating");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("(@NonNull D delegate, C context) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("super(delegate, context);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        } else {
          _builder.append("\t");
          _builder.append("protected final @NonNull D delegate;");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected AbstractDelegating");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("(@NonNull D delegate, C context) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("super(context);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\tassert delegate != null : \"cannot decorate a null visitor\"; //$NON-NLS-1$");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("this.delegate = delegate;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\tdelegate.setUndecoratedVisitor(this);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Delegates to my decorated visitor.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\tpublic @NonNull Decorable");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("<R> createNestedVisitor() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("//\t\treturn delegate.createNestedVisitor();");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\t}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Obtains the visitor that I decorate.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return my decorated visitor");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected final @NonNull D getDelegate() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return delegate;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        if ((isDerived || needsOverride)) {
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
        }
      }
      _builder.append("\t");
      _builder.append("public R visiting(");
      String _emitNonNull = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
      _builder.append(_emitNonNull, "\t");
      _builder.append(" visitable) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("return delegate.visiting(visitable);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public R visit");
          String _name = eClass.getName();
          _builder.append(_name, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull_1 = this.emitNonNull(_plus);
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return delegate.visit");
          String _name_1 = eClass.getName();
          _builder.append(_name_1, "\t\t");
          _builder.append("(object);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * AbstractExtendingDelegatingVisitor
   */
  protected void generateAbstractExtendingDelegatingVisitor(final EPackage ePackage) {
    try {
      MergeWriter writer = new MergeWriter((((this.outputFolder + "AbstractExtendingDelegating") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.Nullable;");
      _builder.newLine();
      _builder.append("import ");
      _builder.append(this.superVisitorPackageName);
      _builder.append(".AbstractDelegating");
      _builder.append(this.superVisitorClassName);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      _builder.append(this.superVisitorPackageName);
      _builder.append(".");
      _builder.append(this.superVisitorClassName);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An AbstractExtendingDelegating");
      _builder.append(this.visitorClassName, " ");
      _builder.append(" provides a default implementation for each");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* visitXxx method that delegates to the supertype if the supertype is in the same package as");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* the visited type, otherwise it delegates to the delegate.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class AbstractExtendingDelegating");
      _builder.append(this.visitorClassName);
      _builder.append("<R, C, D extends ");
      _builder.append(this.superVisitorClassName);
      _builder.append("<R>>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("extends AbstractDelegating");
      _builder.append(this.superVisitorClassName, "\t");
      _builder.append("<R, C, D>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<R>");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      {
        if (true) {
          _builder.append("\t");
          _builder.append("protected AbstractExtendingDelegating");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("(@NonNull D delegate, C context) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("super(delegate, context);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        } else {
          _builder.append("\t");
          _builder.append("protected final D delegate;");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected AbstractExtendingDelegating");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("(@NonNull D delegate, C context) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("super(context);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\tassert delegate != null : \"cannot decorate a null visitor\"; //$NON-NLS-1$");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("this.delegate = delegate;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\tdelegate.setUndecoratedVisitor(this);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Delegates to my decorated visitor.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\tpublic Decorable");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("<R> createNestedVisitor() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("//\t\treturn delegate.createNestedVisitor();");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\t}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Obtains the visitor that I decorate.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return my decorated visitor");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected final D getDelegate() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return delegate;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public R visiting(");
      String _emitNonNull = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
      _builder.append(_emitNonNull, "\t");
      _builder.append(" visitable) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("return delegate.visiting(visitable);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.append("\t");
          EClass firstSuperClass = GenerateVisitors.firstSuperClass(eClass, eClass);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            boolean _needsOverride = this.needsOverride();
            if (_needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public R visit");
          String _name = eClass.getName();
          _builder.append(_name, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull_1 = this.emitNonNull(_plus);
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _equals = Objects.equal(firstSuperClass, eClass);
            if (_equals) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visiting(object);");
              _builder.newLine();
            } else {
              EPackage _ePackage = firstSuperClass.getEPackage();
              EPackage _ePackage_1 = eClass.getEPackage();
              boolean _equals_1 = Objects.equal(_ePackage, _ePackage_1);
              if (_equals_1) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return visit");
                String _name_1 = firstSuperClass.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("(object);");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return delegate.visit");
                String _name_2 = firstSuperClass.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append("(object);");
                _builder.newLineIfNotEmpty();
              }
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * AbstractExtendingVisitor
   */
  protected void generateAbstractExtendingVisitor(final EPackage ePackage) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter((((this.outputFolder + "AbstractExtending") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An AbstractExtending");
      _builder.append(this.visitorClassName, " ");
      _builder.append(" provides a default implementation for each");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* visitXxx method that delegates to the visitYyy method of the first");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* super class, (or transitively its first super class\' first super class");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* until a non-interface super-class is found). In the absence of any");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* suitable first super class, the method delegates to visiting().");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class AbstractExtending");
      _builder.append(this.visitorClassName);
      _builder.append("<R, C>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("extends ");
      {
        if (isDerived) {
          _builder.append(this.superVisitorPackageName, "\t");
          _builder.append(".AbstractExtending");
          _builder.append(this.superVisitorClassName, "\t");
        } else {
          _builder.append("Abstract");
          _builder.append(this.visitorClassName, "\t");
        }
      }
      _builder.append("<R, C>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<R>");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Initializes me with an initial value for my result.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param context my initial result value");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected AbstractExtending");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("(C context) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(context);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.append("\t");
          EClass firstSuperClass = GenerateVisitors.firstSuperClass(eClass, eClass);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public R visit");
          String _name = eClass.getName();
          _builder.append(_name, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull = this.emitNonNull(_plus);
          _builder.append(_emitNonNull, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _equals = Objects.equal(firstSuperClass, eClass);
            if (_equals) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visiting(object);");
              _builder.newLine();
            } else {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visit");
              String _name_1 = firstSuperClass.getName();
              _builder.append(_name_1, "\t\t");
              _builder.append("(object);");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * AbstractMergedVisitor
   */
  protected void generateAbstractMergedVisitor(final EPackage ePackage) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter((((this.outputFolder + "AbstractMerged") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An AbstractMerged");
      _builder.append(this.visitorClassName, " ");
      _builder.append(" merges all visits direct to visiting().");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* This can be used by a decorating visitor to execute shared code before redispatching to a decorated visitor.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class AbstractMerged");
      _builder.append(this.visitorClassName);
      _builder.append("<R, C>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("extends ");
      {
        if (isDerived) {
          _builder.append(this.superVisitorPackageName, "\t");
          _builder.append(".AbstractMerged");
          _builder.append(this.superVisitorClassName, "\t");
          _builder.append("<R, C>");
        } else {
          {
            if (isDerived) {
              _builder.append(this.superVisitorClassName, "\t");
            } else {
              _builder.append("Abstract");
              _builder.append(this.visitorClassName, "\t");
            }
          }
          _builder.append("<R, C>");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<R>");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected AbstractMerged");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("(C context) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(context);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public R visit");
          String _name = eClass.getName();
          _builder.append(_name, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull = this.emitNonNull(_plus);
          _builder.append(_emitNonNull, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return visiting(object);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * AbstractNonNullExtendingVisitor
   */
  protected void generateAbstractNonNullExtendingVisitor(final EPackage ePackage) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter((((this.outputFolder + "AbstractNonNullExtending") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An AbstractExtendingNonNull");
      _builder.append(this.visitorClassName, " ");
      _builder.append(" provides a default implementation for each");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* visitXxx method that delegates to the visitYyy method of the first");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* super class, (or transitively its first super class first super class");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* until a non-interface super-class is found). In the absence of any");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* suitable first super class, the method delegates to visiting().");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* The return is annotated as @NonNull.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* @deprecated Explicit \'NonNull\' functionality is obsolete with Java 8 @NonNull annotations.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("@Deprecated");
      _builder.newLine();
      _builder.append("public abstract class AbstractNonNullExtending");
      _builder.append(this.visitorClassName);
      _builder.append("<R, C>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("extends ");
      {
        if (isDerived) {
          _builder.append(this.superVisitorPackageName, "\t");
          _builder.append(".AbstractNonNullExtending");
          _builder.append(this.superVisitorClassName, "\t");
        } else {
          _builder.append("Abstract");
          _builder.append(this.visitorClassName, "\t");
        }
      }
      _builder.append("<R, C>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<R>");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Initializes me with an initial value for my result.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param context my initial result value");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected AbstractNonNullExtending");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("(C context) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(context);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        if ((!isDerived)) {
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Perform a visit to the specified visitable.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @param visitable a visitable");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return the non-null result of visiting it");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public @NonNull R visit(");
          String _emitNonNull = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNonNull, "\t");
          _builder.append(" visitable) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("R result = visitable.accept(this);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("if (result == null) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("throw new IllegalStateException(\"null return from non-null \" + getClass().getName());");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return result;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.append("\t");
          EClass firstSuperClass = GenerateVisitors.firstSuperClass(eClass, eClass);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public @NonNull R visit");
          String _name = eClass.getName();
          _builder.append(_name, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull_1 = this.emitNonNull(_plus);
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _equals = Objects.equal(firstSuperClass, eClass);
            if (_equals) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visiting(object);");
              _builder.newLine();
            } else {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visit");
              String _name_1 = firstSuperClass.getName();
              _builder.append(_name_1, "\t\t");
              _builder.append("(object);");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      {
        if ((!isDerived)) {
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Return the result of visiting a visitable for which no more specific pivot type method");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* is available.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public abstract @NonNull R visiting(");
          String _emitNonNull_2 = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNonNull_2, "\t");
          _builder.append(" visitable);");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * AbstractNullVisitor
   */
  protected void generateAbstractNullVisitor(final EPackage ePackage) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter((((this.outputFolder + "AbstractNull") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.Nullable;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An AbstractNull");
      _builder.append(this.visitorClassName, " ");
      _builder.append(" provides a default implementation for each");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* visitXxx method that returns null.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* @deprecated Explicit \'Null\' functionality is obsolete with Java 8 @Nullable annotations.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("@Deprecated");
      _builder.newLine();
      _builder.append("public abstract class AbstractNull");
      _builder.append(this.visitorClassName);
      _builder.append("<@Nullable R, C>");
      _builder.newLineIfNotEmpty();
      {
        if ((!isDerived)) {
          _builder.append("\t");
          _builder.append("extends Abstract");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("<R, C>");
          _builder.newLineIfNotEmpty();
        } else {
          _builder.append("\t");
          _builder.append("extends ");
          _builder.append(this.superVisitorPackageName, "\t");
          _builder.append(".AbstractNull");
          _builder.append(this.superVisitorClassName, "\t");
          _builder.append("<R, C> implements ");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("<R>");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Initializes me with an initial value for my result.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param context my initial result value");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected AbstractNull");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("(C context) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(context);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public R visit");
          String _name = eClass.getName();
          _builder.append(_name, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull = this.emitNonNull(_plus);
          _builder.append(_emitNonNull, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return null;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Abstract«projectPrefix»«generic»FlowAnalysisDeducerFromTrueVisitor
   */
  protected void generateAbstractFlowAnalysisDeducerVisitor(final EPackage ePackage, final String generic, final Class<?> returnClass, final Class<?> contextClass, final boolean isNull) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter(((((this.outputFolder + "Abstract") + this.projectPrefix) + generic) + "Visitor.java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import ");
      String _name = returnClass.getName();
      _builder.append(_name);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.Nullable;");
      _builder.newLine();
      _builder.append("import ");
      String _name_1 = contextClass.getName();
      _builder.append(_name_1);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      {
        if ((isDerived && (!this.superProjectPrefix.equals("")))) {
          _builder.append("import ");
          _builder.append(this.superVisitorPackageName);
          _builder.append("ities.");
          _builder.append(this.superProjectPrefix);
          _builder.append(generic);
          _builder.append("Visitor;");
        }
      }
      _builder.newLineIfNotEmpty();
      {
        if ((isDerived && this.superProjectPrefix.equals(""))) {
          _builder.append("import ");
          String _name_2 = FlowAnalysis.class.getName();
          _builder.append(_name_2);
          _builder.append(";");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An Abstract");
      _builder.append(this.projectPrefix, " ");
      _builder.append(generic, " ");
      _builder.append("Visitor provides a default implementation for each");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* visitXxx method that delegates to the visitYyy method of the first");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* super class, (or transitively its first super class\' first super class");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* until a non-interface super-class is found). In the absence of any");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* suitable first super class, the method delegates to visiting().");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class Abstract");
      _builder.append(this.projectPrefix);
      _builder.append(generic);
      _builder.append("Visitor");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      {
        if (isDerived) {
          _builder.append("extends ");
          _builder.append(this.superProjectPrefix, "\t");
          _builder.append(generic, "\t");
          _builder.append("Visitor");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<");
      String _simpleName = returnClass.getSimpleName();
      _builder.append(_simpleName, "\t");
      _builder.append(">");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Initializes me with an initial value for my result.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param context my initial result value");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected Abstract");
      _builder.append(this.projectPrefix, "\t");
      _builder.append(generic, "\t");
      _builder.append("Visitor(");
      String _emitNonNull = this.emitNonNull(contextClass.getSimpleName());
      _builder.append(_emitNonNull, "\t");
      _builder.append(" flowAnalysis");
      {
        if (isNull) {
          _builder.append(", boolean isNull");
        }
      }
      _builder.append(") {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(flowAnalysis");
      {
        if (isNull) {
          _builder.append(", isNull");
        }
      }
      _builder.append(");");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.append("\t");
          EClass firstSuperClass = GenerateVisitors.firstSuperClass(eClass, eClass);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public ");
          String _emitNullable = this.emitNullable(returnClass.getSimpleName());
          _builder.append(_emitNullable, "\t");
          _builder.append(" visit");
          String _name_3 = eClass.getName();
          _builder.append(_name_3, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull_1 = this.emitNonNull(_plus);
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _equals = Objects.equal(firstSuperClass, eClass);
            if (_equals) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visiting(object);");
              _builder.newLine();
            } else {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visit");
              String _name_4 = firstSuperClass.getName();
              _builder.append(_name_4, "\t\t");
              _builder.append("(object);");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Abstract«projectPrefix»«generic»TemplateParameterSubstitutionVisitor
   */
  protected void generateAbstractTemplateParameterSubstitutionVisitor(final EPackage ePackage, final String generic, final Class<?> returnClass, final Class<?> contextClass) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter(((((this.outputFolder + "Abstract") + this.projectPrefix) + generic) + "Visitor.java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import ");
      String _name = returnClass.getName();
      _builder.append(_name);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.Nullable;");
      _builder.newLine();
      _builder.append("import ");
      String _name_1 = Type.class.getName();
      _builder.append(_name_1);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_2 = contextClass.getName();
      _builder.append(_name_2);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      {
        if ((isDerived && (!this.superProjectPrefix.equals("")))) {
          _builder.append("import ");
          _builder.append(this.superVisitorPackageName);
          _builder.append("ities.");
          _builder.append(this.superProjectPrefix);
          _builder.append(generic);
          _builder.append("Visitor;");
        }
      }
      _builder.newLineIfNotEmpty();
      {
        if ((isDerived && this.superProjectPrefix.equals(""))) {
          _builder.append("import ");
          String _name_3 = TemplateParameterSubstitutionVisitor.class.getName();
          _builder.append(_name_3);
          _builder.append(";");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An Abstract");
      _builder.append(this.projectPrefix, " ");
      _builder.append(generic, " ");
      _builder.append("Visitor provides a default implementation for each");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* visitXxx method that delegates to the visitYyy method of the first");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* super class, (or transitively its first super class\' first super class");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* until a non-interface super-class is found). In the absence of any");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* suitable first super class, the method delegates to visiting().");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class Abstract");
      _builder.append(this.projectPrefix);
      _builder.append(generic);
      _builder.append("Visitor");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      {
        if (isDerived) {
          _builder.append("extends ");
          _builder.append(this.superProjectPrefix, "\t");
          _builder.append(generic, "\t");
          _builder.append("Visitor");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<");
      String _simpleName = returnClass.getSimpleName();
      _builder.append(_simpleName, "\t");
      _builder.append(">");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Initializes me with an initial value for my result.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param context my initial result value");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected Abstract");
      _builder.append(this.projectPrefix, "\t");
      _builder.append(generic, "\t");
      _builder.append("Visitor(");
      String _emitNonNull = this.emitNonNull(contextClass.getSimpleName());
      _builder.append(_emitNonNull, "\t");
      _builder.append(" environmentFactory, @Nullable Type selfType, @Nullable Type selfTypeValue) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(environmentFactory, selfType, selfTypeValue);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.append("\t");
          EClass firstSuperClass = GenerateVisitors.firstSuperClass(eClass, eClass);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public ");
          String _emitNullable = this.emitNullable(returnClass.getSimpleName());
          _builder.append(_emitNullable, "\t");
          _builder.append(" visit");
          String _name_4 = eClass.getName();
          _builder.append(_name_4, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull_1 = this.emitNonNull(_plus);
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          {
            boolean _equals = Objects.equal(firstSuperClass, eClass);
            if (_equals) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visiting(object);");
              _builder.newLine();
            } else {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return visit");
              String _name_5 = firstSuperClass.getName();
              _builder.append(_name_5, "\t\t");
              _builder.append("(object);");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * AbstractVisitor
   */
  protected void generateAbstractVisitor(final EPackage ePackage) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter((((this.outputFolder + "Abstract") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        if ((!isDerived)) {
          _builder.append("import org.eclipse.jdt.annotation.NonNull;");
          _builder.newLine();
          _builder.append("import org.eclipse.jdt.annotation.Nullable;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("/*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An Abstract");
      _builder.append(this.visitorClassName, " ");
      _builder.append(" provides a default implementation of the visitor framework");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* but n implementations of the visitXXX methods..");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class Abstract");
      _builder.append(this.visitorClassName);
      _builder.append("<R, C>");
      _builder.newLineIfNotEmpty();
      {
        if (isDerived) {
          _builder.append("\t");
          _builder.append("extends ");
          _builder.append(this.superVisitorPackageName, "\t");
          _builder.append(".Abstract");
          _builder.append(this.superVisitorClassName, "\t");
          _builder.append("<R, C>");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<R>");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      {
        if ((!isDerived)) {
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Context for the AST visitation.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected final C context;");
          _builder.newLine();
          _builder.newLine();
        }
      }
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Initializes me with an initial value for my result.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param context my initial result value");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected Abstract");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("(C context) {");
      _builder.newLineIfNotEmpty();
      {
        if ((!isDerived)) {
          _builder.append("\t\t");
          _builder.append("this.context = context;");
          _builder.newLine();
        } else {
          _builder.append("\t\t");
          _builder.append("super(context);");
          _builder.newLine();
        }
      }
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        if ((!isDerived)) {
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@SuppressWarnings(\"unchecked\")");
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public <A> @Nullable A getAdapter(@NonNull Class<A> adapter) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("if (adapter.isAssignableFrom(getClass())) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("return (A) this;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("else {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("return null;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* A null-safe visitation of the specified visitable.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @param v a visitable, or <code>null</code>");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return <code>null</code> if the visitable is <code>null</code>;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*\t otherwise, the result of visiting it");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public @Nullable R safeVisit(");
          String _emitNullable = this.emitNullable(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNullable, "\t");
          _builder.append(" v) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return (v == null) ? null : v.accept(this);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Perform a visit to the specified visitable.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @param v a visitable, or <code>null</code>");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return <code>null</code> if the visitable is <code>null</code>;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*\t otherwise, the result of visiting it");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public R visit(");
          String _emitNonNull = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNonNull, "\t");
          _builder.append(" v) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return v.accept(this);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\tpublic R visiting(");
          String _emitNonNull_1 = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" visitable) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("//\t\treturn null;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\t}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * AbstractWrappingVisitor
   */
  protected void generateAbstractWrappingVisitor(final EPackage ePackage) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter((((this.outputFolder + "AbstractWrapping") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.Nullable;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* An AbstractWrapping");
      _builder.append(this.visitorClassName, " ");
      _builder.append(" delegates all visits wrapping the delegation in a call to a preVisit function and a postVisit function.");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public abstract class AbstractWrapping");
      _builder.append(this.visitorClassName);
      _builder.append("<R, C, @NonNull D extends ");
      _builder.append(this.visitorClassName);
      _builder.append("<R>, P>");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("extends ");
      {
        if (isDerived) {
          _builder.append(this.superVisitorPackageName, "\t");
          _builder.append(".AbstractWrapping");
          _builder.append(this.superVisitorClassName, "\t");
          _builder.append("<R, C, D, P>");
        } else {
          {
            if (isDerived) {
              _builder.append(this.superVisitorClassName, "\t");
            } else {
              _builder.append("Abstract");
              _builder.append(this.visitorClassName, "\t");
            }
          }
          _builder.append("<R, C>");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("implements ");
      _builder.append(this.visitorClassName, "\t");
      _builder.append("<R>");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      {
        if (isDerived) {
          _builder.append("\t");
          _builder.append("protected AbstractWrapping");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("(@NonNull D delegate, C context) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("super(delegate, context);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        } else {
          _builder.append("\t");
          _builder.append("protected final @NonNull D delegate;");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected AbstractWrapping");
          _builder.append(this.visitorClassName, "\t");
          _builder.append("(@NonNull D delegate, C context) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("super(context);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("this.delegate = delegate;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("//\tdelegate.setUndecoratedVisitor(this);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Intercept an exception thrown by the delegated visit to perform some post-functionality that may use the visitable object,");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* the result of preVisit and the thrown exception to determine the overall wrapped result.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return a rethrown RuntimeException or a RuntimeException-wrapped non-RuntimeException.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected R badVisit(");
          String _emitNonNull = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNonNull, "\t");
          _builder.append(" visitable, @Nullable P prologue, @NonNull Throwable e) throws RuntimeException {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("if (e instanceof Exception) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("throw (RuntimeException)e;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("else {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("throw new RuntimeException(e);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Obtains the visitor that I wrap.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return my wrapped visitor");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected @NonNull D getDelegate() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return delegate;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Intercept the result of the delegated visit to perform some post-functionality that may use the visitable object,");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* the result of preVisit and the result of the delegated visit to determine the overall wrapped result.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return the epilogue result, which defaults to the delegated result.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected R postVisit(");
          String _emitNonNull_1 = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" visitable, @Nullable P prologue, R result) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return result;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Compute and return some value before performing the delegated visit.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return the prologue result, which defauilts to null.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("protected @Nullable P preVisit(");
          String _emitNonNull_2 = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNonNull_2, "\t");
          _builder.append(" visitable) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return null;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public R visiting(");
          String _emitNonNull_3 = this.emitNonNull(((this.visitablePackageName + ".") + this.visitableClassName));
          _builder.append(_emitNonNull_3, "\t");
          _builder.append(" visitable) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("throw new UnsupportedOperationException();\t\t// Cannot happen since all methods delegate.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.newLine();
          {
            if (needsOverride) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("public R visit");
          String _name = eClass.getName();
          _builder.append(_name, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull_4 = this.emitNonNull(_plus);
          _builder.append(_emitNonNull_4, "\t");
          _builder.append(" object) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("@Nullable P prologue = preVisit(object);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("try {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("R result = delegate.visit");
          String _name_1 = eClass.getName();
          _builder.append(_name_1, "\t\t\t");
          _builder.append("(object);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("return postVisit(object, prologue, result);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("catch (Throwable e) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("return badVisit(object, prologue, e);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * DecorableVisitorInterface
   */
  protected void generateDecorableVisitorInterface(final EPackage ePackage, final String visitorRootClass) {
    try {
      boolean isDerived = this.isDerived();
      boolean needsOverride = this.needsOverride();
      MergeWriter writer = new MergeWriter((((this.outputFolder + "Decorable") + this.visitorClassName) + ".java"));
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public interface Decorable");
      _builder.append(this.visitorClassName);
      _builder.append("<R> extends ");
      _builder.append(this.visitorClassName);
      _builder.append("<R>");
      {
        if (isDerived) {
          _builder.append(", ");
          _builder.append(this.superVisitorPackageName);
          _builder.append(".Decorable");
          _builder.append(this.superVisitorClassName);
          _builder.append("<R>");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      {
        if ((isDerived && needsOverride)) {
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
        }
      }
      _builder.append("\t");
      _builder.append("void setUndecoratedVisitor(");
      String _emitNonNull = this.emitNonNull(visitorRootClass);
      _builder.append(_emitNonNull, "\t");
      _builder.append("<R> visitor);");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected String generateHeader(final EPackage ePackage, final String javaPackage) {
    return this.generateHeader(ePackage, javaPackage, null);
  }
  
  protected String generateHeaderWithTemplate(final EPackage ePackage, final String javaPackage) {
    return this.generateHeader(ePackage, javaPackage, this.getClass().getCanonicalName());
  }
  
  protected String generateHeader(final EPackage ePackage, final String javaPackage, final String template) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/*******************************************************************************");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* ");
    String _replace = MergeWriter.getCopyright(this.copyright).replace("\n", "\n* ").replace("\n* \n", "\n*\n");
    _builder.append(_replace, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* This code is auto-generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* from: ");
    _builder.append(this.projectName, " ");
    _builder.append("/");
    _builder.append(this.sourceFile, " ");
    _builder.newLineIfNotEmpty();
    {
      if ((template != null)) {
        _builder.append(" ");
        _builder.append("* template: ");
        _builder.append(template, " ");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Only the copyright statement is editable.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*******************************************************************************/");
    _builder.newLine();
    _builder.append("package\t");
    _builder.append(javaPackage);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected void generateVisitableInterface(final GenPackage genPackage) {
    try {
      GenModel genModel = genPackage.getGenModel();
      String directoryURI = this.getInterfaceModelDirectory(genModel);
      String visitableClassName2 = this.getVisitableClassName(genModel);
      String visitablePackageName2 = this.getVisitablePackageName(genModel);
      EPackage ePackage = genPackage.getEcorePackage();
      String _replace = visitablePackageName2.replace(".", "/");
      String _plus = (directoryURI + _replace);
      String _plus_1 = (_plus + "/");
      String _plus_2 = (_plus_1 + visitableClassName2);
      String _plus_3 = (_plus_2 + ".java");
      MergeWriter writer = new MergeWriter(_plus_3);
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, visitablePackageName2);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.EClass;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(visitableClassName2);
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Returns the result of accepting a visit from a visitor.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Implementations typically invoke a derived-class-specific");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* variant of visitXXX() to facilitate derived-class-specific");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* processing or just visit() when no such method is available.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* <p>");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Implementations of visit() may use the EcoreSwitch to perform");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* derived-class-specific processing.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* <p>");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Derived implementations of accept() may use getAdapter() to obtain");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* richer visitor interfaces.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param <R>");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param visitor");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @return the result of the visit.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("<R> R accept(");
      String _emitNonNull = this.emitNonNull(((this.visitorPackageName + ".") + this.visitorClassName));
      _builder.append(_emitNonNull, "\t");
      _builder.append("<R> visitor);");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("EClass eClass();");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected void generateVisitorInterface(final GenPackage genPackage) {
    try {
      GenModel genModel = genPackage.getGenModel();
      String directoryURI = this.getInterfaceModelDirectory(genModel);
      String visitableClassName2 = this.getVisitableClassName(genModel);
      String visitablePackageName2 = this.getVisitablePackageName(genModel);
      String visitorClassName2 = this.visitorClassName;
      String visitorPackageName2 = this.visitorPackageName;
      boolean isDerived = this.isDerived();
      EPackage ePackage = genPackage.getEcorePackage();
      String _replace = visitorPackageName2.replace(".", "/");
      String _plus = (directoryURI + _replace);
      String _plus_1 = (_plus + "/");
      String _plus_2 = (_plus_1 + visitorClassName2);
      String _plus_3 = (_plus_2 + ".java");
      MergeWriter writer = new MergeWriter(_plus_3);
      StringConcatenation _builder = new StringConcatenation();
      String _generateHeader = this.generateHeader(ePackage, this.visitorPackageName);
      _builder.append(_generateHeader);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      {
        if ((!isDerived)) {
          _builder.append("import org.eclipse.jdt.annotation.Nullable;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* @noimplement This interface is not intended to be implemented by clients.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(visitorClassName2);
      _builder.append("<R>");
      {
        if (isDerived) {
          _builder.append(" extends ");
          _builder.append(this.superVisitorPackageName);
          _builder.append(".");
          _builder.append(this.superVisitorClassName);
          _builder.append("<R>");
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      {
        if ((!isDerived)) {
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Returns an object which is an instance of the given class");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* associated with this object. Returns <code>null</code> if");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* no such object can be found.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @param adapter the adapter class to look up");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return an object of the given class,");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*    or <code>null</code> if this object does not");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*    have an adapter for the given class");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Nullable <A> A getAdapter(@NonNull Class<A> adapter);");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Return the result of visiting a visitable for which no more specific pivot type method");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* is available.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("R visiting(");
          String _emitNonNull = this.emitNonNull(((visitablePackageName2 + ".") + visitableClassName2));
          _builder.append(_emitNonNull, "\t");
          _builder.append(" visitable);");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
        }
      }
      {
        List<EClass> _sortedEClasses = GenerateVisitors.getSortedEClasses(ePackage);
        for(final EClass eClass : _sortedEClasses) {
          _builder.append("\t");
          _builder.append("R visit");
          String _name = eClass.getName();
          _builder.append(_name, "\t");
          _builder.append("(");
          String _templatedName = GenerateVisitors.getTemplatedName(eClass);
          String _plus_4 = ((this.modelPackageName + ".") + _templatedName);
          String _emitNonNull_1 = this.emitNonNull(_plus_4);
          _builder.append(_emitNonNull_1, "\t");
          _builder.append(" object);");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("}");
      _builder.newLine();
      writer.append(_builder.toString());
      writer.close();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
