/**
 * Copyright (c) 2013, 2017 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.xtend;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class GenerateOCLstdlibXtend extends GenerateOCLstdlib {
  @Override
  protected String declareClassTypes(final Model root, final Collection<String> excludedEClassifierNames) {
    String _xblockexpression = null;
    {
      Map<org.eclipse.ocl.pivot.Package, List<org.eclipse.ocl.pivot.Class>> pkge2classTypes = this.getSortedClassTypes(root);
      boolean _isEmpty = pkge2classTypes.isEmpty();
      if (_isEmpty) {
        return "";
      }
      org.eclipse.ocl.pivot.Package pkg = this.findPackage(root.getOwnedPackages());
      List<org.eclipse.ocl.pivot.Package> sortedPackages = this.getSortedPackages(root, pkge2classTypes.keySet());
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final org.eclipse.ocl.pivot.Package pkge : sortedPackages) {
          _builder.newLine();
          {
            List<org.eclipse.ocl.pivot.Class> _nullFree = ClassUtil.<org.eclipse.ocl.pivot.Class>nullFree(pkge2classTypes.get(pkge));
            for(final org.eclipse.ocl.pivot.Class type : _nullFree) {
              {
                if ((Objects.equal(pkg, pkge) && (!excludedEClassifierNames.contains(type.getName())))) {
                  _builder.append("private final @NonNull ");
                  String _name = type.eClass().getName();
                  _builder.append(_name);
                  _builder.append(" ");
                  String _partialName = this.partialName(type);
                  String _plus = ("_" + _partialName);
                  String _prefixedSymbolName = this.getPrefixedSymbolName(type, _plus);
                  _builder.append(_prefixedSymbolName);
                  _builder.append(" = create");
                  String _name_1 = type.eClass().getName();
                  _builder.append(_name_1);
                  _builder.append("(");
                  String _ecoreLiteral = this.getEcoreLiteral(type);
                  _builder.append(_ecoreLiteral);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("private final @NonNull ");
                  String _name_2 = type.eClass().getName();
                  _builder.append(_name_2);
                  _builder.append(" ");
                  String _partialName_1 = this.partialName(type);
                  String _plus_1 = ("_" + _partialName_1);
                  String _prefixedSymbolNameWithoutNormalization = this.getPrefixedSymbolNameWithoutNormalization(type, _plus_1);
                  _builder.append(_prefixedSymbolNameWithoutNormalization);
                  _builder.append(" = create");
                  String _name_3 = type.eClass().getName();
                  _builder.append(_name_3);
                  _builder.append("(\"");
                  String _name_4 = type.getName();
                  _builder.append(_name_4);
                  _builder.append("\");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  @Override
  protected String declareCollectionTypes(final Model root) {
    String _xblockexpression = null;
    {
      Map<org.eclipse.ocl.pivot.Package, List<CollectionType>> pkge2collectionTypes = this.getSortedCollectionTypes(root);
      boolean _isEmpty = pkge2collectionTypes.isEmpty();
      if (_isEmpty) {
        return "";
      }
      List<org.eclipse.ocl.pivot.Package> sortedPackages = this.getSortedPackages(root, pkge2collectionTypes.keySet());
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final org.eclipse.ocl.pivot.Package pkge : sortedPackages) {
          _builder.newLine();
          {
            List<CollectionType> _nullFree = ClassUtil.<CollectionType>nullFree(pkge2collectionTypes.get(pkge));
            for(final CollectionType type : _nullFree) {
              String _name = type.getName();
              String _plus = ("_" + _name);
              String _plus_1 = (_plus + "_");
              String _partialName = this.partialName(type.getElementType());
              String _plus_2 = (_plus_1 + _partialName);
              String _xifexpression = null;
              boolean _isIsNullFree = type.isIsNullFree();
              if (_isIsNullFree) {
                _xifexpression = "_NullFree";
              } else {
                _xifexpression = "";
              }
              String _plus_3 = (_plus_2 + _xifexpression);
              String typeName = this.getPrefixedSymbolName(type, _plus_3);
              _builder.newLineIfNotEmpty();
              {
                TemplateSignature _ownedSignature = type.getOwnedSignature();
                boolean _tripleNotEquals = (_ownedSignature != null);
                if (_tripleNotEquals) {
                  _builder.append("private final @NonNull ");
                  String _name_1 = type.eClass().getName();
                  _builder.append(_name_1);
                  _builder.append(" ");
                  _builder.append(typeName);
                  _builder.append(" = create");
                  String _name_2 = type.eClass().getName();
                  _builder.append(_name_2);
                  _builder.append("(");
                  String _ecoreLiteral = this.getEcoreLiteral(type);
                  _builder.append(_ecoreLiteral);
                  {
                    TemplateSignature _ownedSignature_1 = type.getOwnedSignature();
                    boolean _tripleNotEquals_1 = (_ownedSignature_1 != null);
                    if (_tripleNotEquals_1) {
                      {
                        List<TemplateParameter> _ownedParameters = type.getOwnedSignature().getOwnedParameters();
                        for(final TemplateParameter templateParameter : _ownedParameters) {
                          _builder.append(", ");
                          String _symbolName = this.getSymbolName(templateParameter);
                          _builder.append(_symbolName);
                        }
                      }
                    }
                  }
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          {
            List<CollectionType> _nullFree_1 = ClassUtil.<CollectionType>nullFree(pkge2collectionTypes.get(pkge));
            for(final CollectionType type_1 : _nullFree_1) {
              String _name_3 = type_1.getName();
              String _plus_4 = ("_" + _name_3);
              String _plus_5 = (_plus_4 + "_");
              String _partialName_1 = this.partialName(type_1.getElementType());
              String _plus_6 = (_plus_5 + _partialName_1);
              String _xifexpression_1 = null;
              boolean _isIsNullFree_1 = type_1.isIsNullFree();
              if (_isIsNullFree_1) {
                _xifexpression_1 = "_NullFree";
              } else {
                _xifexpression_1 = "";
              }
              String _plus_7 = (_plus_6 + _xifexpression_1);
              String typeName_1 = this.getPrefixedSymbolName(type_1, _plus_7);
              _builder.newLineIfNotEmpty();
              {
                TemplateSignature _ownedSignature_2 = type_1.getOwnedSignature();
                boolean _tripleEquals = (_ownedSignature_2 == null);
                if (_tripleEquals) {
                  _builder.append("private final @NonNull ");
                  String _name_4 = type_1.eClass().getName();
                  _builder.append(_name_4);
                  _builder.append(" ");
                  _builder.append(typeName_1);
                  _builder.append(" = create");
                  String _name_5 = type_1.eClass().getName();
                  _builder.append(_name_5);
                  _builder.append("(");
                  String _symbolName_1 = this.getSymbolName(type_1.getUnspecializedElement());
                  _builder.append(_symbolName_1);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  @Override
  protected String declareMapTypes(final Model root) {
    String _xblockexpression = null;
    {
      Map<org.eclipse.ocl.pivot.Package, List<MapType>> pkge2mapTypes = this.getSortedMapTypes(root);
      boolean _isEmpty = pkge2mapTypes.isEmpty();
      if (_isEmpty) {
        return "";
      }
      List<org.eclipse.ocl.pivot.Package> sortedPackages = this.getSortedPackages(root, pkge2mapTypes.keySet());
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      {
        for(final org.eclipse.ocl.pivot.Package pkge : sortedPackages) {
          {
            List<MapType> _nullFree = ClassUtil.<MapType>nullFree(pkge2mapTypes.get(pkge));
            for(final MapType type : _nullFree) {
              {
                TemplateSignature _ownedSignature = type.getOwnedSignature();
                boolean _tripleNotEquals = (_ownedSignature != null);
                if (_tripleNotEquals) {
                  _builder.append("private final @NonNull ");
                  String _name = type.eClass().getName();
                  _builder.append(_name);
                  _builder.append(" ");
                  String _name_1 = type.getName();
                  String _plus = ("_" + _name_1);
                  String _plus_1 = (_plus + "_");
                  String _partialName = this.partialName(type.getKeyType());
                  String _plus_2 = (_plus_1 + _partialName);
                  String _plus_3 = (_plus_2 + "_");
                  String _partialName_1 = this.partialName(type.getValueType());
                  String _plus_4 = (_plus_3 + _partialName_1);
                  String _prefixedSymbolName = this.getPrefixedSymbolName(type, _plus_4);
                  _builder.append(_prefixedSymbolName);
                  _builder.append(" = create");
                  String _name_2 = type.eClass().getName();
                  _builder.append(_name_2);
                  _builder.append("(");
                  String _ecoreLiteral = this.getEcoreLiteral(type);
                  _builder.append(_ecoreLiteral);
                  {
                    TemplateSignature _ownedSignature_1 = type.getOwnedSignature();
                    boolean _tripleNotEquals_1 = (_ownedSignature_1 != null);
                    if (_tripleNotEquals_1) {
                      {
                        List<TemplateParameter> _ownedParameters = type.getOwnedSignature().getOwnedParameters();
                        for(final TemplateParameter templateParameter : _ownedParameters) {
                          _builder.append(", ");
                          String _symbolName = this.getSymbolName(templateParameter);
                          _builder.append(_symbolName);
                        }
                      }
                    }
                  }
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          {
            List<MapType> _nullFree_1 = ClassUtil.<MapType>nullFree(pkge2mapTypes.get(pkge));
            for(final MapType type_1 : _nullFree_1) {
              {
                TemplateSignature _ownedSignature_2 = type_1.getOwnedSignature();
                boolean _tripleEquals = (_ownedSignature_2 == null);
                if (_tripleEquals) {
                  _builder.append("private final @NonNull ");
                  String _name_3 = type_1.eClass().getName();
                  _builder.append(_name_3);
                  _builder.append(" ");
                  String _name_4 = type_1.getName();
                  String _plus_5 = ("_" + _name_4);
                  String _plus_6 = (_plus_5 + "_");
                  String _partialName_2 = this.partialName(type_1.getKeyType());
                  String _plus_7 = (_plus_6 + _partialName_2);
                  String _plus_8 = (_plus_7 + "_");
                  String _partialName_3 = this.partialName(type_1.getValueType());
                  String _plus_9 = (_plus_8 + _partialName_3);
                  String _prefixedSymbolName_1 = this.getPrefixedSymbolName(type_1, _plus_9);
                  _builder.append(_prefixedSymbolName_1);
                  _builder.append(" = create");
                  String _name_5 = type_1.eClass().getName();
                  _builder.append(_name_5);
                  _builder.append("(");
                  String _symbolName_1 = this.getSymbolName(type_1.getUnspecializedElement());
                  _builder.append(_symbolName_1);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  @Override
  protected String declarePrimitiveTypes(final Model root) {
    String _xblockexpression = null;
    {
      Map<org.eclipse.ocl.pivot.Package, List<PrimitiveType>> pkge2primitiveTypes = this.getSortedPrimitiveTypes(root);
      boolean _isEmpty = pkge2primitiveTypes.isEmpty();
      if (_isEmpty) {
        return "";
      }
      org.eclipse.ocl.pivot.Package pkg = this.findPackage(root.getOwnedPackages());
      List<org.eclipse.ocl.pivot.Package> sortedPackages = this.getSortedPackages(root, pkge2primitiveTypes.keySet());
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final org.eclipse.ocl.pivot.Package pkge : sortedPackages) {
          _builder.newLine();
          {
            List<PrimitiveType> _nullFree = ClassUtil.<PrimitiveType>nullFree(pkge2primitiveTypes.get(pkge));
            for(final PrimitiveType type : _nullFree) {
              {
                if ((Objects.equal(pkg, pkge) && (!this.excludedEClassifierNames.contains(type.getName())))) {
                  _builder.append("private final @NonNull PrimitiveType ");
                  String _partialName = this.partialName(type);
                  String _plus = ("_" + _partialName);
                  String _prefixedSymbolNameWithoutNormalization = this.getPrefixedSymbolNameWithoutNormalization(type, _plus);
                  _builder.append(_prefixedSymbolNameWithoutNormalization);
                  _builder.append(" = createPrimitiveType(");
                  String _ecoreLiteral = this.getEcoreLiteral(type);
                  _builder.append(_ecoreLiteral);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("private final @NonNull PrimitiveType ");
                  String _partialName_1 = this.partialName(type);
                  String _plus_1 = ("_" + _partialName_1);
                  String _prefixedSymbolNameWithoutNormalization_1 = this.getPrefixedSymbolNameWithoutNormalization(type, _plus_1);
                  _builder.append(_prefixedSymbolNameWithoutNormalization_1);
                  _builder.append(" = createPrimitiveType(\"");
                  String _name = type.getName();
                  _builder.append(_name);
                  _builder.append("\");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  protected String defineConstantType(final DataType type) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _equals = "Boolean".equals(type.getName());
      if (_equals) {
        _builder.append("private void PrimitiveType ");
        String _partialName = this.partialName(type);
        String _plus = ("_" + _partialName);
        String _prefixedSymbolName = this.getPrefixedSymbolName(type, _plus);
        _builder.append(_prefixedSymbolName);
        _builder.append(" = OCLstdlib._Boolean;");
      } else {
        boolean _equals_1 = "Classifier".equals(type.getName());
        if (_equals_1) {
          _builder.newLineIfNotEmpty();
          _builder.append("private void PrimitiveType ");
          String _partialName_1 = this.partialName(type);
          String _plus_1 = ("_" + _partialName_1);
          String _prefixedSymbolName_1 = this.getPrefixedSymbolName(type, _plus_1);
          _builder.append(_prefixedSymbolName_1);
          _builder.append(" = OCLstdlib._Classifier;");
        } else {
          boolean _equals_2 = "Integer".equals(type.getName());
          if (_equals_2) {
            _builder.newLineIfNotEmpty();
            _builder.append("private void PrimitiveType ");
            String _partialName_2 = this.partialName(type);
            String _plus_2 = ("_" + _partialName_2);
            String _prefixedSymbolName_2 = this.getPrefixedSymbolName(type, _plus_2);
            _builder.append(_prefixedSymbolName_2);
            _builder.append(" = OCLstdlib._Integer;");
          } else {
            boolean _equals_3 = "Real".equals(type.getName());
            if (_equals_3) {
              _builder.newLineIfNotEmpty();
              _builder.append("private void PrimitiveType ");
              String _partialName_3 = this.partialName(type);
              String _plus_3 = ("_" + _partialName_3);
              String _prefixedSymbolName_3 = this.getPrefixedSymbolName(type, _plus_3);
              _builder.append(_prefixedSymbolName_3);
              _builder.append(" = OCLstdlib._Real;");
            } else {
              boolean _equals_4 = "String".equals(type.getName());
              if (_equals_4) {
                _builder.newLineIfNotEmpty();
                _builder.append("private void PrimitiveType ");
                String _partialName_4 = this.partialName(type);
                String _plus_4 = ("_" + _partialName_4);
                String _prefixedSymbolName_4 = this.getPrefixedSymbolName(type, _plus_4);
                _builder.append(_prefixedSymbolName_4);
                _builder.append(" = OCLstdlib._String;");
              } else {
                boolean _equals_5 = "UnlimitedNatural".equals(type.getName());
                if (_equals_5) {
                  _builder.newLineIfNotEmpty();
                  _builder.append("private void PrimitiveType ");
                  String _partialName_5 = this.partialName(type);
                  String _plus_5 = ("_" + _partialName_5);
                  String _prefixedSymbolName_5 = this.getPrefixedSymbolName(type, _plus_5);
                  _builder.append(_prefixedSymbolName_5);
                  _builder.append(" = OCLstdlib._UnlimitedNatural;");
                } else {
                  _builder.newLineIfNotEmpty();
                  _builder.append("private void DataType ");
                  String _partialName_6 = this.partialName(type);
                  String _plus_6 = ("_" + _partialName_6);
                  String _prefixedSymbolName_6 = this.getPrefixedSymbolName(type, _plus_6);
                  _builder.append(_prefixedSymbolName_6);
                  _builder.append(" = createDataType(\"");
                  String _name = type.getName();
                  _builder.append(_name);
                  _builder.append("\");");
                }
              }
            }
          }
        }
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  /**
   * @NonNull
   */
  @Override
  protected String generateMetamodel(final Model root, final Collection<String> excludedEClassifierNames) {
    String _xblockexpression = null;
    {
      this.thisModel = root;
      Library lib = ClassUtil.<Library>nonNullState(this.getLibrary(root));
      List<org.eclipse.ocl.pivot.Package> externalPackages = this.getSortedExternalPackages(root);
      int year = new GregorianCalendar().get(GregorianCalendar.YEAR);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/*******************************************************************************");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Copyright (c) 2010, ");
      _builder.append(year, " ");
      _builder.append(" Willink Transformations and others.");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* All rights reserved. This program and the accompanying materials");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* are made available under the terms of the Eclipse Public License v2.0");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* which accompanies this distribution, and is available at");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* http://www.eclipse.org/legal/epl-v20.html");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Contributors:");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*     E.D.Willink - initial API and implementation");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*******************************************************************************");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* This code is 100% auto-generated");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* from: ");
      _builder.append(this.sourceFile, " ");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* by: org.eclipse.ocl.examples.build.xtend.generateOCLstdlib.xtend");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* and: org.eclipse.ocl.examples.build.GenerateOCLstdlibModel.mwe2");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Do not edit it.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*******************************************************************************/");
      _builder.newLine();
      _builder.append("package\t");
      _builder.append(this.javaPackageName);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import java.io.IOException;");
      _builder.newLine();
      _builder.append("import java.util.ArrayList;");
      _builder.newLine();
      _builder.append("import java.util.List;");
      _builder.newLine();
      _builder.append("import java.util.Map;");
      _builder.newLine();
      _builder.append("import java.util.Set;");
      _builder.newLine();
      _builder.append("import java.util.WeakHashMap;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import org.eclipse.emf.common.notify.Notification;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.common.notify.NotificationChain;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.common.util.TreeIterator;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.common.util.URI;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.EObject;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.EPackage;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.EReference;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.impl.BasicEObjectImpl;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.resource.Resource;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.resource.ResourceSet;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.Nullable;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.*;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.Class;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.Package;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.ids.IdManager;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.ids.PackageId;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.utilities.AbstractContents;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.model.OCLmetamodel;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.utilities.ClassUtil;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.utilities.MetamodelManager;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.utilities.PivotConstants;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.utilities.PivotUtil;");
      _builder.newLine();
      {
        if (((externalPackages != null) && (!externalPackages.isEmpty()))) {
          _builder.newLine();
          {
            for(final org.eclipse.ocl.pivot.Package externalPackage : externalPackages) {
              String _declarePackageImport = this.declarePackageImport(externalPackage);
              _builder.append(_declarePackageImport);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* This is the ");
      _builder.append(this.uri, " ");
      _builder.append(" Standard Library");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* auto-generated from ");
      _builder.append(this.sourceFile, " ");
      _builder.append(".");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* It facilitates efficient library loading without the overheads of model reading.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* <p>");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* This Standard Library may be registered as the definition of a Standard Library for");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* the OCL evaluation framework by invoking {@link #install}.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* <p>");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* The Standard Library is normally activated when the MetamodelManager attempts");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* to locate a library type when its default Standard Library URI is the same");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* as this Standard Library.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("@SuppressWarnings(\"unused\")");
      _builder.newLine();
      _builder.append("public class ");
      _builder.append(this.javaClassName);
      _builder.append(" extends ASResourceImpl");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe static package-of-types pivot model of the Standard Library.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("private static ");
      _builder.append(this.javaClassName, "\t");
      _builder.append(" INSTANCE = null;");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe URI of this Standard Library.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static final @NonNull String STDLIB_URI = \"");
      _builder.append(this.uri, "\t");
      _builder.append("\";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe URI of the AS representation of this Standard Library.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static final @NonNull URI STDLIB_AS_URI = URI.createURI(\"");
      _builder.append(this.uri, "\t");
      _builder.append("\" + PivotConstants.DOT_OCL_AS_FILE_EXTENSION);");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Return the default ");
      _builder.append(this.uri, "\t ");
      _builder.append(" standard Library Resource");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("* if it jas been created, or null if not.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*  This static definition auto-generated from ");
      _builder.append(this.sourceFile, "\t ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  is used as the default when no overriding copy is registered.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* It cannot be unloaded or rather unloading has no effect.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static @Nullable ");
      _builder.append(this.javaClassName, "\t");
      _builder.append(" basicGetDefault() {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("return INSTANCE;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Return the default ");
      _builder.append(this.uri, "\t ");
      _builder.append(" standard Library Resource.");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  This static definition auto-generated from ");
      _builder.append(this.sourceFile, "\t ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  is used as the default when no overriding copy is registered.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* It cannot be unloaded or rather unloading has no effect.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static @NonNull ");
      _builder.append(this.javaClassName, "\t");
      _builder.append(" getDefault() {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append(this.javaClassName, "\t\t");
      _builder.append(" oclstdlib = INSTANCE;");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("if (oclstdlib == null) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("Contents contents = new Contents(\"");
      String _uRI = lib.getURI();
      _builder.append(_uRI, "\t\t\t");
      _builder.append("\");");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      _builder.append("String asURI = STDLIB_URI + PivotConstants.DOT_OCL_AS_FILE_EXTENSION;");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("oclstdlib = INSTANCE = new ReadOnly(asURI, contents.getModel());");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return oclstdlib;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Return the default ");
      _builder.append(this.uri, "\t ");
      _builder.append(" standard Library model.");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  This static definition auto-generated from ");
      _builder.append(this.sourceFile, "\t ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  is used as the default when no overriding copy is registered.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static @NonNull Model getDefaultModel() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("Model model = (Model)(getDefault().getContents().get(0));");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("assert model != null;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return model;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        int _size = externalPackages.size();
        boolean _equals = (_size == 2);
        if (_equals) {
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Return the default ");
          _builder.append(this.uri, "\t ");
          _builder.append(" standard Library package.");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*  This static definition auto-generated from ");
          _builder.append(this.sourceFile, "\t ");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*  is used as the default when no overriding copy is registered.");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public static @NonNull Package getDefaultPackage() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("Package pkge = getDefaultModel().getOwnedPackages().get(0);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("assert pkge != null;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return pkge;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Install this library in the {@link StandardLibraryContribution#REGISTRY}");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* and the {@link OCLASResourceFactory#REGISTRY}.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* This method may be invoked by standalone applications to replicate");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* the registration that should appear as a standard_library plugin");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* extension when running within Eclipse.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static void install() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("EPackage.Registry.INSTANCE.put(OCLstdlibPackage.eNS_URI, OCLstdlibPackage.eINSTANCE);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("Loader contribution = new Loader();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("StandardLibraryContribution.REGISTRY.put(STDLIB_URI, contribution);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("OCLASResourceFactory.REGISTRY.put(STDLIB_AS_URI, contribution);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Install this library in the {@link StandardLibraryContribution#REGISTRY}");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* and the {@link OCLASResourceFactory#REGISTRY}");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* unless some other library contribution has already been installed.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static void lazyInstall() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("if (StandardLibraryContribution.REGISTRY.get(STDLIB_URI) == null) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("install();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Uninstall this library from the {@link StandardLibraryContribution#REGISTRY}");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* and the {@link OCLASResourceFactory#REGISTRY}.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* This method may be invoked by standalone applications to release the library");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* resources for garbage collection and memory leakage detection.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static void uninstall() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("StandardLibraryContribution.REGISTRY.remove(STDLIB_URI);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("OCLASResourceFactory.REGISTRY.remove(STDLIB_AS_URI);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("INSTANCE = null;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* The Loader shares the Standard Library instance whenever this default library");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* is loaded from the registry of Standard Libraries populated by the standard_library");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* extension point.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static class Loader implements StandardLibraryContribution");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public @NonNull StandardLibraryContribution getContribution() {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return this;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public @NonNull Resource getResource() {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return getDefault();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* A ReadOnly ");
      _builder.append(this.javaClassName, "\t ");
      _builder.append(" overrides inherited functionality to impose immutable shared behaviour.");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected static class ReadOnly extends ");
      _builder.append(this.javaClassName, "\t");
      _builder.append(" implements ImmutableResource");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected ReadOnly(@NonNull String asURI, @NonNull Model libraryModel) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("super(asURI, libraryModel);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("setSaveable(false);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("* Overridden to inhibit entry of the shared instance in any ResourceSet.");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return notifications;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("* Overridden to inhibit unloading of the shared instance.");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected void doUnload() {}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public boolean isCompatibleWith(@NonNull String metamodelURI) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return OCLmetamodel.PIVOT_URI.equals(metamodelURI);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("* Overridden to trivialise loading of the shared instance.");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public void load(Map<?, ?> options) throws IOException {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("if (this != INSTANCE) {");
      _builder.newLine();
      _builder.append("\t\t\t\t");
      _builder.append("super.load(options);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("else {");
      _builder.newLine();
      _builder.append("\t\t\t\t");
      _builder.append("setLoaded(true);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("* Overridden to inhibit unloading of the shared instance.");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected Notification setLoaded(boolean isLoaded) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("if (isLoaded) {");
      _builder.newLine();
      _builder.append("\t\t\t\t");
      _builder.append("return super.setLoaded(isLoaded);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("else {");
      _builder.newLine();
      _builder.append("\t\t\t\t");
      _builder.append("return null;");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tConstruct a copy of the OCL Standard Library with specified resource URI,");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*  and package name, prefix and namespace URI.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static @NonNull ");
      _builder.append(this.javaClassName, "\t");
      _builder.append(" create(@NonNull String asURI) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("Contents contents = new Contents(asURI);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return new ");
      _builder.append(this.javaClassName, "\t\t");
      _builder.append("(asURI, contents.getModel());");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tConstruct an OCL Standard Library with specified resource URI and library content.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("private ");
      _builder.append(this.javaClassName, "\t");
      _builder.append("(@NonNull String asURI, @NonNull Model libraryModel) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(ClassUtil.nonNullState(URI.createURI(asURI)), OCLASResourceFactory.getInstance());");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("assert PivotUtilInternal.isASURI(asURI);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("getContents().add(libraryModel);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("private static class Contents extends AbstractContents");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("private final @NonNull Model ");
      String _prefixedSymbolName = this.getPrefixedSymbolName(root, "model");
      _builder.append(_prefixedSymbolName, "\t\t");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      {
        List<org.eclipse.ocl.pivot.Package> _sortedPackages = this.getSortedPackages(root);
        for(final org.eclipse.ocl.pivot.Package pkge : _sortedPackages) {
          _builder.append("\t\t");
          _builder.append("private final @NonNull ");
          String _name = pkge.eClass().getName();
          _builder.append(_name, "\t\t");
          _builder.append(" ");
          String _xifexpression = null;
          org.eclipse.ocl.pivot.Package _orphanPackage = this.getOrphanPackage(root);
          boolean _equals_1 = Objects.equal(pkge, _orphanPackage);
          if (_equals_1) {
            _xifexpression = "orphanage";
          } else {
            _xifexpression = pkge.getName();
          }
          String _prefixedSymbolName_1 = this.getPrefixedSymbolName(pkge, _xifexpression);
          _builder.append(_prefixedSymbolName_1, "\t\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("private Contents(@NonNull String asURI)");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t\t");
      String _symbolName = this.getSymbolName(root);
      _builder.append(_symbolName, "\t\t\t");
      _builder.append(" = createModel(asURI);");
      _builder.newLineIfNotEmpty();
      {
        List<org.eclipse.ocl.pivot.Package> _sortedPackages_1 = this.getSortedPackages(root);
        for(final org.eclipse.ocl.pivot.Package pkge_1 : _sortedPackages_1) {
          _builder.append("\t\t\t");
          String _symbolName_1 = this.getSymbolName(pkge_1);
          _builder.append(_symbolName_1, "\t\t\t");
          _builder.append(" = create");
          String _name_1 = pkge_1.eClass().getName();
          _builder.append(_name_1, "\t\t\t");
          _builder.append("(\"");
          String _name_2 = pkge_1.getName();
          _builder.append(_name_2, "\t\t\t");
          _builder.append("\", \"");
          String _nsPrefix = pkge_1.getNsPrefix();
          _builder.append(_nsPrefix, "\t\t\t");
          _builder.append("\", \"");
          String _uRI_1 = pkge_1.getURI();
          _builder.append(_uRI_1, "\t\t\t");
          _builder.append("\", ");
          String _generatedPackageId = this.getGeneratedPackageId(pkge_1);
          _builder.append(_generatedPackageId, "\t\t\t");
          _builder.append(", ");
          String _ecoreLiteral = this.getEcoreLiteral(pkge_1);
          _builder.append(_ecoreLiteral, "\t\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t\t\t");
      String _installPackages = this.installPackages(root);
      _builder.append(_installPackages, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installClassTypes = this.installClassTypes(root);
      _builder.append(_installClassTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installPrimitiveTypes = this.installPrimitiveTypes(root);
      _builder.append(_installPrimitiveTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installEnumerations = this.installEnumerations(root);
      _builder.append(_installEnumerations, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installCollectionTypes = this.installCollectionTypes(root);
      _builder.append(_installCollectionTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installMapTypes = this.installMapTypes(root);
      _builder.append(_installMapTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installLambdaTypes = this.installLambdaTypes(root);
      _builder.append(_installLambdaTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installTupleTypes = this.installTupleTypes(root);
      _builder.append(_installTupleTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installOperations = this.installOperations(root);
      _builder.append(_installOperations, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installIterations = this.installIterations(root);
      _builder.append(_installIterations, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installCoercions = this.installCoercions(root);
      _builder.append(_installCoercions, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installProperties = this.installProperties(root);
      _builder.append(_installProperties, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installTemplateBindings = this.installTemplateBindings(root);
      _builder.append(_installTemplateBindings, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installPrecedences = this.installPrecedences(root);
      _builder.append(_installPrecedences, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installComments = this.installComments(root);
      _builder.append(_installComments, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public @NonNull Model getModel() {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return ");
      String _symbolName_2 = this.getSymbolName(root);
      _builder.append(_symbolName_2, "\t\t\t");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      String _defineExternals = this.defineExternals(root);
      _builder.append(_defineExternals, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _definePackages = this.definePackages(root);
      _builder.append(_definePackages, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareClassTypes = this.declareClassTypes(root, excludedEClassifierNames);
      _builder.append(_declareClassTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declarePrimitiveTypes = this.declarePrimitiveTypes(root);
      _builder.append(_declarePrimitiveTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareEnumerations = this.declareEnumerations(root);
      _builder.append(_declareEnumerations, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineTemplateParameters = this.defineTemplateParameters(root);
      _builder.append(_defineTemplateParameters, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareTupleTypes = this.declareTupleTypes(root);
      _builder.append(_declareTupleTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareCollectionTypes = this.declareCollectionTypes(root);
      _builder.append(_declareCollectionTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareMapTypes = this.declareMapTypes(root);
      _builder.append(_declareMapTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineClassTypes = this.defineClassTypes(root);
      _builder.append(_defineClassTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _definePrimitiveTypes = this.definePrimitiveTypes(root);
      _builder.append(_definePrimitiveTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineEnumerations = this.defineEnumerations(root);
      _builder.append(_defineEnumerations, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineCollectionTypes = this.defineCollectionTypes(root);
      _builder.append(_defineCollectionTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineMapTypes = this.defineMapTypes(root);
      _builder.append(_defineMapTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineTupleTypes = this.defineTupleTypes(root);
      _builder.append(_defineTupleTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineLambdaTypes = this.defineLambdaTypes(root);
      _builder.append(_defineLambdaTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineOperations = this.defineOperations(root);
      _builder.append(_defineOperations, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineIterations = this.defineIterations(root);
      _builder.append(_defineIterations, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineCoercions = this.defineCoercions(root);
      _builder.append(_defineCoercions, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineProperties = this.defineProperties(root);
      _builder.append(_defineProperties, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineTemplateBindings = this.defineTemplateBindings(root);
      _builder.append(_defineTemplateBindings, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _definePrecedences = this.definePrecedences(root);
      _builder.append(_definePrecedences, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineComments = this.defineComments(root);
      _builder.append(_defineComments, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
}
