/**
 * Copyright (c) 2013, 2017 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.xtend;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class GenerateOCLmetamodelXtend extends GenerateOCLmetamodel {
  @Override
  protected String declareClassTypes(final Model root, final Collection<String> excludedEClassifierNames) {
    String _xblockexpression = null;
    {
      Map<org.eclipse.ocl.pivot.Package, List<org.eclipse.ocl.pivot.Class>> pkge2classTypes = this.getSortedClassTypes(root);
      boolean _isEmpty = pkge2classTypes.isEmpty();
      if (_isEmpty) {
        return "";
      }
      org.eclipse.ocl.pivot.Package pkg = this.findPackage(root.getOwnedPackages());
      List<org.eclipse.ocl.pivot.Package> sortedPackages = this.getSortedPackages(root, pkge2classTypes.keySet());
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final org.eclipse.ocl.pivot.Package pkge : sortedPackages) {
          _builder.newLine();
          {
            boolean _equals = Objects.equal(pkg, pkge);
            if (_equals) {
              {
                List<org.eclipse.ocl.pivot.Class> _nullFree = ClassUtil.<org.eclipse.ocl.pivot.Class>nullFree(pkge2classTypes.get(pkge));
                for(final org.eclipse.ocl.pivot.Class type : _nullFree) {
                  _builder.append("private final @NonNull ");
                  String _name = type.eClass().getName();
                  _builder.append(_name);
                  _builder.append(" ");
                  String _partialName = this.partialName(type);
                  String _plus = ("_" + _partialName);
                  String _prefixedSymbolName = this.getPrefixedSymbolName(type, _plus);
                  _builder.append(_prefixedSymbolName);
                  _builder.append(" = create");
                  String _name_1 = type.eClass().getName();
                  _builder.append(_name_1);
                  _builder.append("(");
                  String _ecoreLiteral = this.getEcoreLiteral(type);
                  _builder.append(_ecoreLiteral);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            } else {
              {
                List<org.eclipse.ocl.pivot.Class> _nullFree_1 = ClassUtil.<org.eclipse.ocl.pivot.Class>nullFree(pkge2classTypes.get(pkge));
                for(final org.eclipse.ocl.pivot.Class type_1 : _nullFree_1) {
                  _builder.append("private final @NonNull ");
                  String _name_2 = type_1.eClass().getName();
                  _builder.append(_name_2);
                  _builder.append(" ");
                  String _partialName_1 = this.partialName(type_1);
                  String _plus_1 = ("_" + _partialName_1);
                  String _prefixedSymbolNameWithoutNormalization = this.getPrefixedSymbolNameWithoutNormalization(type_1, _plus_1);
                  _builder.append(_prefixedSymbolNameWithoutNormalization);
                  _builder.append(" = create");
                  String _name_3 = type_1.eClass().getName();
                  _builder.append(_name_3);
                  _builder.append("(\"");
                  String _name_4 = type_1.getName();
                  _builder.append(_name_4);
                  _builder.append("\");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  @Override
  protected String declareEnumerations(final Model root) {
    String _xblockexpression = null;
    {
      Map<org.eclipse.ocl.pivot.Package, List<Enumeration>> pkge2enumerations = this.getSortedEnumerations(root);
      boolean _isEmpty = pkge2enumerations.isEmpty();
      if (_isEmpty) {
        return "";
      }
      List<org.eclipse.ocl.pivot.Package> sortedPackages = this.getSortedPackages(root, pkge2enumerations.keySet());
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      {
        for(final org.eclipse.ocl.pivot.Package pkge : sortedPackages) {
          {
            List<Enumeration> _nullFree = ClassUtil.<Enumeration>nullFree(pkge2enumerations.get(pkge));
            for(final Enumeration enumeration : _nullFree) {
              String _partialName = this.partialName(enumeration);
              String _plus = ("_" + _partialName);
              String enumerationName = this.getPrefixedSymbolName(enumeration, _plus);
              _builder.newLineIfNotEmpty();
              _builder.append("private final @NonNull Enumeration ");
              _builder.append(enumerationName);
              _builder.append(" = createEnumeration(");
              String _ecoreLiteral = this.getEcoreLiteral(enumeration);
              _builder.append(_ecoreLiteral);
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              {
                List<EnumerationLiteral> _ownedLiterals = enumeration.getOwnedLiterals();
                for(final EnumerationLiteral enumerationLiteral : _ownedLiterals) {
                  _builder.append("private final @NonNull EnumerationLiteral ");
                  String _name = enumerationLiteral.getName();
                  String _plus_1 = ((("el_" + enumerationName) + "_") + _name);
                  String _prefixedSymbolName = this.getPrefixedSymbolName(enumerationLiteral, _plus_1);
                  _builder.append(_prefixedSymbolName);
                  _builder.append(" = createEnumerationLiteral(");
                  String _ecoreLiteral_1 = this.getEcoreLiteral(enumerationLiteral);
                  _builder.append(_ecoreLiteral_1);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  @Override
  protected String generateMetamodel(final Model root, final Collection<String> excludedEClassifierNames) {
    String _xblockexpression = null;
    {
      this.thisModel = root;
      org.eclipse.ocl.pivot.Package pkg = this.findPackage(root.getOwnedPackages());
      if ((pkg == null)) {
        return null;
      }
      List<org.eclipse.ocl.pivot.Package> externalPackages = this.getSortedExternalPackages(root);
      int year = new GregorianCalendar().get(GregorianCalendar.YEAR);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/*******************************************************************************");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Copyright (c) 2010, ");
      _builder.append(year, " ");
      _builder.append(" Willink Transformations and others.");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* All rights reserved. This program and the accompanying materials");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* are made available under the terms of the Eclipse Public License v2.0");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* which accompanies this distribution, and is available at");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* http://www.eclipse.org/legal/epl-v20.html");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Contributors:");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*   E.D.Willink - initial API and implementation");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*******************************************************************************");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* This code is 100% auto-generated");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* from: ");
      _builder.append(this.sourceFile, " ");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* by: org.eclipse.ocl.examples.build.xtend.GenerateOCLmetamodel.xtend");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* and: org.eclipse.ocl.examples.build.GeneratePivotMetamodel.mwe2");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Do not edit it.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*******************************************************************************/");
      _builder.newLine();
      _builder.append("package\t");
      _builder.append(this.javaPackageName);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import java.io.IOException;");
      _builder.newLine();
      _builder.append("import java.math.BigInteger;");
      _builder.newLine();
      _builder.append("import java.util.List;");
      _builder.newLine();
      _builder.append("import java.util.Map;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import org.eclipse.emf.common.notify.Notification;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.common.notify.NotificationChain;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.common.util.URI;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.resource.Resource;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.resource.ResourceSet;");
      _builder.newLine();
      _builder.append("import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.NonNull;");
      _builder.newLine();
      _builder.append("import org.eclipse.jdt.annotation.Nullable;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.*;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.Class;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.Package;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.ids.IdManager;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.utilities.AbstractContents;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.library.LibraryFeature;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.model.OCLstdlib;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.utilities.ClassUtil;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.utilities.PivotConstants;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;");
      _builder.newLine();
      _builder.append("import org.eclipse.ocl.pivot.utilities.PivotUtil;");
      _builder.newLine();
      {
        if (((externalPackages != null) && (!externalPackages.isEmpty()))) {
          _builder.newLine();
          {
            for(final org.eclipse.ocl.pivot.Package externalPackage : externalPackages) {
              String _declarePackageImport = this.declarePackageImport(externalPackage);
              _builder.append(_declarePackageImport);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* This is the pivot representation of the ");
      _builder.append(this.uri, " ");
      _builder.append(" metamodel");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* auto-generated from ");
      _builder.append(this.sourceFile, " ");
      _builder.append(".");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* It facilitates efficient model loading without the overheads of model reading.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("@SuppressWarnings(\"unused\")");
      _builder.newLine();
      _builder.append("public class ");
      _builder.append(this.javaClassName);
      _builder.append(" extends ASResourceImpl");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe static package-of-types pivot model of the Pivot Metamodel.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("private static ");
      _builder.append(this.javaClassName, "\t");
      _builder.append(" INSTANCE = null;");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe URI of this Metamodel.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static final @NonNull String PIVOT_URI = \"");
      _builder.append(this.uri, "\t");
      _builder.append("\";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe URI of the AS representation of this Metamodel.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static final @NonNull URI PIVOT_AS_URI = URI.createURI(\"");
      _builder.append(this.uri, "\t");
      _builder.append("\" + PivotConstants.DOT_OCL_AS_FILE_EXTENSION);");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static @NonNull Package create(@NonNull StandardLibraryInternal standardLibrary, @NonNull String name, @Nullable String nsPrefix, @NonNull String nsURI) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append(this.javaClassName, "\t\t");
      _builder.append(" resource = new ReadOnly(PIVOT_AS_URI);");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("Package standardLibraryPackage = standardLibrary.getOclAnyType().getOwningPackage();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("assert standardLibraryPackage != null;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("Contents contents = new Contents(standardLibraryPackage, name, nsPrefix, nsURI);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("Model model = contents.getModel();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("resource.getContents().add(model);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@SuppressWarnings(\"null\")@NonNull Package pkge = model.getOwnedPackages().get(0);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return pkge;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Return the default ");
      _builder.append(this.uri, "\t ");
      _builder.append(" metamodel Resource using the default OCL Standard Library. ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  This static definition auto-generated from ");
      _builder.append(this.sourceFile, "\t ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  is used as the default when no overriding copy is registered. ");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static @NonNull ");
      _builder.append(this.javaClassName, "\t");
      _builder.append(" getDefault() {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append(this.javaClassName, "\t\t");
      _builder.append(" metamodel = INSTANCE;");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("if (metamodel == null) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("metamodel = INSTANCE = new ReadOnly(PIVOT_AS_URI);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("Contents contents = new Contents(OCLstdlib.getDefaultPackage(), \"");
      String _name = pkg.getName();
      _builder.append(_name, "\t\t\t");
      _builder.append("\", \"");
      String _nsPrefix = pkg.getNsPrefix();
      _builder.append(_nsPrefix, "\t\t\t");
      _builder.append("\", PIVOT_URI);");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      _builder.append("metamodel.getContents().add(contents.getModel());");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return metamodel;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Return the default ");
      _builder.append(this.uri, "\t ");
      _builder.append(" metamodel Model using the default OCL Standard Library. ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  This static definition auto-generated from ");
      _builder.append(this.sourceFile, "\t ");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*  is used as the default when no overriding copy is registered. ");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static @NonNull Model getDefaultModel() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("Model model = (Model)(getDefault().getContents().get(0));");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("assert model != null;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return model;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        int _size = externalPackages.size();
        boolean _equals = (_size == 2);
        if (_equals) {
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Return the default ");
          _builder.append(this.uri, "\t ");
          _builder.append(" metamodel Package using the default OCL Standard Library. ");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*  This static definition auto-generated from ");
          _builder.append(this.sourceFile, "\t ");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*  is used as the default when no overriding copy is registered. ");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public static @NonNull Package getDefaultPackage() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("Package pkge = getDefaultModel().getOwnedPackages().get(0);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("assert pkge != null;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return pkge;");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Install this metamodel in the {@link OCLASResourceFactory#REGISTRY}.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* This method may be invoked by standalone applications to replicate");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* the registration that should appear as a standard_library plugin");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* extension when running within Eclipse.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static void install() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("Loader contribution = new Loader();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("OCLASResourceFactory.REGISTRY.put(PIVOT_AS_URI, contribution);");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Install this metamodel in the {@link OCLASResourceFactory#REGISTRY}");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* unless some other metamodel contribution has already been installed.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static void lazyInstall() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("if (OCLASResourceFactory.REGISTRY.get(PIVOT_AS_URI) == null) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("install();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Uninstall this metamodel from the {@link OCLASResourceFactory#REGISTRY}.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* This method may be invoked by standalone applications to release the library");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* resources for garbage collection and memory leakage detection.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static void uninstall() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("OCLASResourceFactory.REGISTRY.remove(PIVOT_AS_URI);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("INSTANCE = null;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected ");
      _builder.append(this.javaClassName, "\t");
      _builder.append("(@NonNull URI uri) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(uri, OCLASResourceFactory.getInstance());");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected static class LibraryContents extends AbstractContents");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected final @NonNull Package standardLibrary;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected LibraryContents(@NonNull Package standardLibrary) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("this.standardLibrary = standardLibrary;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* The Loader shares the metamodel instance whenever this default metamodel");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* is loaded from the registry of known pivot metamodels.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static class Loader implements StandardLibraryContribution");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public @NonNull StandardLibraryContribution getContribution() {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return this;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public @NonNull Resource getResource() {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return getDefault();");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* A ReadOnly ");
      _builder.append(this.javaClassName, "\t ");
      _builder.append(" overrides inherited functionality to impose immutable shared behaviour.");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected static class ReadOnly extends ");
      _builder.append(this.javaClassName, "\t");
      _builder.append(" implements ImmutableResource");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected ReadOnly(@NonNull URI uri) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("super(uri);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("setSaveable(false);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("* Overridden to inhibit entry of the shared instance in any ResourceSet.");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return notifications;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("* Overridden to inhibit unloading of the shared instance.");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected void doUnload() {}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public boolean isCompatibleWith(@NonNull String metamodelURI) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return PIVOT_URI.equals(metamodelURI);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("* Overridden to trivialise loading of the shared instance.");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public void load(Map<?, ?> options) throws IOException {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("if (this != INSTANCE) {");
      _builder.newLine();
      _builder.append("\t\t\t\t");
      _builder.append("super.load(options);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("else {");
      _builder.newLine();
      _builder.append("\t\t\t\t");
      _builder.append("setLoaded(true);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("* Overridden to inhibit unloading of the shared instance.");
      _builder.newLine();
      _builder.append("\t\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected Notification setLoaded(boolean isLoaded) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("if (isLoaded) {");
      _builder.newLine();
      _builder.append("\t\t\t\t");
      _builder.append("return super.setLoaded(isLoaded);");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("else {");
      _builder.newLine();
      _builder.append("\t\t\t\t");
      _builder.append("return null;");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("private static class Contents extends LibraryContents");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("private final @NonNull Model ");
      String _prefixedSymbolName = this.getPrefixedSymbolName(root, "root");
      _builder.append(_prefixedSymbolName, "\t\t");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      {
        List<org.eclipse.ocl.pivot.Package> _sortedPackages = this.getSortedPackages(root);
        for(final org.eclipse.ocl.pivot.Package pkge : _sortedPackages) {
          _builder.append("\t\t");
          _builder.append("private final @NonNull ");
          String _name_1 = pkge.eClass().getName();
          _builder.append(_name_1, "\t\t");
          _builder.append(" ");
          String _xifexpression = null;
          org.eclipse.ocl.pivot.Package _orphanPackage = this.getOrphanPackage(root);
          boolean _equals_1 = Objects.equal(pkge, _orphanPackage);
          if (_equals_1) {
            _xifexpression = "orphanage";
          } else {
            _xifexpression = pkge.getName();
          }
          String _prefixedSymbolName_1 = this.getPrefixedSymbolName(pkge, _xifexpression);
          _builder.append(_prefixedSymbolName_1, "\t\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("protected Contents(@NonNull Package standardLibrary, @NonNull String name, @Nullable String nsPrefix, @NonNull String nsURI) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("super(standardLibrary);");
      _builder.newLine();
      _builder.append("\t\t\t");
      String _symbolName = this.getSymbolName(root);
      _builder.append(_symbolName, "\t\t\t");
      _builder.append(" = createModel(\"");
      String _uRI = pkg.getURI();
      _builder.append(_uRI, "\t\t\t");
      _builder.append("\");");
      _builder.newLineIfNotEmpty();
      {
        List<org.eclipse.ocl.pivot.Package> _sortedPackages_1 = this.getSortedPackages(root);
        for(final org.eclipse.ocl.pivot.Package pkge_1 : _sortedPackages_1) {
          _builder.append("\t\t\t");
          String _symbolName_1 = this.getSymbolName(pkge_1);
          _builder.append(_symbolName_1, "\t\t\t");
          _builder.append(" = create");
          String _name_2 = pkge_1.eClass().getName();
          _builder.append(_name_2, "\t\t\t");
          _builder.append("(\"");
          String _name_3 = pkge_1.getName();
          _builder.append(_name_3, "\t\t\t");
          _builder.append("\", \"");
          String _nsPrefix_1 = pkge_1.getNsPrefix();
          _builder.append(_nsPrefix_1, "\t\t\t");
          _builder.append("\", \"");
          String _uRI_1 = pkge_1.getURI();
          _builder.append(_uRI_1, "\t\t\t");
          _builder.append("\", ");
          String _generatedPackageId = this.getGeneratedPackageId(pkge_1);
          _builder.append(_generatedPackageId, "\t\t\t");
          _builder.append(", ");
          String _ecoreLiteral = this.getEcoreLiteral(pkge_1);
          _builder.append(_ecoreLiteral, "\t\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t\t\t");
      String _installPackages = this.installPackages(root);
      _builder.append(_installPackages, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installClassTypes = this.installClassTypes(root);
      _builder.append(_installClassTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installPrimitiveTypes = this.installPrimitiveTypes(root);
      _builder.append(_installPrimitiveTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installEnumerations = this.installEnumerations(root);
      _builder.append(_installEnumerations, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installCollectionTypes = this.installCollectionTypes(root);
      _builder.append(_installCollectionTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installLambdaTypes = this.installLambdaTypes(root);
      _builder.append(_installLambdaTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installTupleTypes = this.installTupleTypes(root);
      _builder.append(_installTupleTypes, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installOperations = this.installOperations(root);
      _builder.append(_installOperations, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installIterations = this.installIterations(root);
      _builder.append(_installIterations, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installCoercions = this.installCoercions(root);
      _builder.append(_installCoercions, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installProperties = this.installProperties(root);
      _builder.append(_installProperties, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installTemplateBindings = this.installTemplateBindings(root);
      _builder.append(_installTemplateBindings, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installPrecedences = this.installPrecedences(root);
      _builder.append(_installPrecedences, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _installComments = this.installComments(root);
      _builder.append(_installComments, "\t\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public @NonNull Model getModel() {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return ");
      String _symbolName_2 = this.getSymbolName(root);
      _builder.append(_symbolName_2, "\t\t\t");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t\t");
      String _defineExternals = this.defineExternals(root);
      _builder.append(_defineExternals, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _definePackages = this.definePackages(root);
      _builder.append(_definePackages, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareClassTypes = this.declareClassTypes(root, excludedEClassifierNames);
      _builder.append(_declareClassTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declarePrimitiveTypes = this.declarePrimitiveTypes(root);
      _builder.append(_declarePrimitiveTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareEnumerations = this.declareEnumerations(root);
      _builder.append(_declareEnumerations, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineTemplateParameters = this.defineTemplateParameters(root);
      _builder.append(_defineTemplateParameters, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareCollectionTypes = this.declareCollectionTypes(root);
      _builder.append(_declareCollectionTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _declareTupleTypes = this.declareTupleTypes(root);
      _builder.append(_declareTupleTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineClassTypes = this.defineClassTypes(root);
      _builder.append(_defineClassTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _definePrimitiveTypes = this.definePrimitiveTypes(root);
      _builder.append(_definePrimitiveTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineEnumerations = this.defineEnumerations(root);
      _builder.append(_defineEnumerations, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineCollectionTypes = this.defineCollectionTypes(root);
      _builder.append(_defineCollectionTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineTupleTypes = this.defineTupleTypes(root);
      _builder.append(_defineTupleTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineLambdaTypes = this.defineLambdaTypes(root);
      _builder.append(_defineLambdaTypes, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineOperations = this.defineOperations(root);
      _builder.append(_defineOperations, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineIterations = this.defineIterations(root);
      _builder.append(_defineIterations, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineCoercions = this.defineCoercions(root);
      _builder.append(_defineCoercions, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineProperties = this.defineProperties(root);
      _builder.append(_defineProperties, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineTemplateBindings = this.defineTemplateBindings(root);
      _builder.append(_defineTemplateBindings, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _definePrecedences = this.definePrecedences(root);
      _builder.append(_definePrecedences, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      String _defineComments = this.defineComments(root);
      _builder.append(_defineComments, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
}
