/**
 * Copyright (c) 2015, 2017 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.xtend;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.xtext.base.utilities.AbstractGrammarResource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Annotation;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;
import org.eclipse.xtext.resource.XtextResourceSet;

@SuppressWarnings("all")
public class GenerateGrammarXtend extends GenerateGrammar {
  /**
   * @NonNull
   */
  @Override
  protected String generate(final Resource grammarResource) {
    String _xblockexpression = null;
    {
      int year = new GregorianCalendar().get(GregorianCalendar.YEAR);
      boolean hasEnumRules = this.hasRules(grammarResource, EnumRule.class);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/*******************************************************************************");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Copyright (c) 2015, ");
      _builder.append(year, " ");
      _builder.append(" Willink Transformations and others.");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* All rights reserved. This program and the accompanying materials");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* are made available under the terms of the Eclipse Public License v2.0");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* which accompanies this distribution, and is available at");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* http://www.eclipse.org/legal/epl-v20.html");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Contributors:");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*     E.D.Willink - initial API and implementation");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*******************************************************************************");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* This code is 100% auto-generated");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* from: ");
      _builder.append(this.sourceFile, " ");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* by: org.eclipse.ocl.examples.build.xtend.generateGrammar.xtend");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* Do not edit it.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*******************************************************************************/");
      _builder.newLine();
      _builder.append("package\t");
      _builder.append(this.javaPackageName);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import ");
      String _name = List.class.getName();
      _builder.append(_name);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import ");
      String _name_1 = URI.class.getName();
      _builder.append(_name_1);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_2 = NonNull.class.getName();
      _builder.append(_name_2);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_3 = EObject.class.getName();
      _builder.append(_name_3);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_4 = AbstractGrammarResource.class.getName();
      _builder.append(_name_4);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_5 = AbstractMetamodelDeclaration.class.getName();
      _builder.append(_name_5);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_6 = AbstractRule.class.getName();
      _builder.append(_name_6);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      {
        if (hasEnumRules) {
          _builder.append("import ");
          String _name_7 = EnumRule.class.getName();
          _builder.append(_name_7);
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("import ");
      String _name_8 = Grammar.class.getName();
      _builder.append(_name_8);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_9 = ParserRule.class.getName();
      _builder.append(_name_9);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_10 = ReferencedMetamodel.class.getName();
      _builder.append(_name_10);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_11 = TerminalRule.class.getName();
      _builder.append(_name_11);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_12 = XtextResourceSet.class.getName();
      _builder.append(_name_12);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import ");
      String _name_13 = Inject.class.getName();
      _builder.append(_name_13);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_14 = Provider.class.getName();
      _builder.append(_name_14);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import ");
      String _name_15 = Singleton.class.getName();
      _builder.append(_name_15);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* ");
      _builder.append(this.grammarFileStem, " ");
      _builder.append("GrammarResource provides a programmatically initialized ");
      _builder.append(this.languageName, " ");
      _builder.append(" Grammar model avoiding");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("* the speed limitations of the pre-Xtext 2.4 *.xmi models and the binary incompatibilities between differing *.xtextbin versions.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* <p>");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("* The grammar is immutable and is available as static INSTANCE and GRAMMAR fields.");
      _builder.newLine();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("public class ");
      _builder.append(this.grammarFileStem);
      _builder.append("GrammarResource extends AbstractGrammarResource");
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      {
        EList<EObject> _contents = grammarResource.getContents();
        for(final EObject grammar : _contents) {
          _builder.append("\t");
          _builder.append("private static final @NonNull Grammar ");
          String _emit = this.emit(((Grammar) grammar), ((Grammar) grammar));
          _builder.append(_emit, "\t");
          _builder.append(" = createGrammar(");
          String _emitValue = this.emitValue(((Grammar) grammar).getName());
          _builder.append(_emitValue, "\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe shared immutable instance of the ");
      _builder.append(this.languageName, "\t ");
      _builder.append(" Grammar resource.");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static final @NonNull ");
      _builder.append(this.grammarFileStem, "\t");
      _builder.append("GrammarResource INSTANCE = new ");
      _builder.append(this.grammarFileStem, "\t");
      _builder.append("GrammarResource();");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe shared immutable instance of the ");
      _builder.append(this.languageName, "\t ");
      _builder.append(" Grammar model.");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static final @NonNull Grammar GRAMMAR = (Grammar)INSTANCE.getContents().get(0);");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*\tThe name of the language supported by this grammar.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static final @NonNull String LANGUAGE_NAME = \"");
      _builder.append(this.languageName, "\t");
      _builder.append("\";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("protected ");
      _builder.append(this.grammarFileStem, "\t");
      _builder.append("GrammarResource() {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(URI.createURI(LANGUAGE_NAME));");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("List<EObject> contents = getContents();");
      _builder.newLine();
      {
        EList<EObject> _contents_1 = grammarResource.getContents();
        for(final EObject grammar_1 : _contents_1) {
          _builder.append("\t\t");
          _builder.append("contents.add(");
          String _grammarPackageName = this.getGrammarPackageName(((Grammar) grammar_1));
          _builder.append(_grammarPackageName, "\t\t");
          _builder.append(".initGrammar());");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* This class should be bound to org.eclipse.xtext.service.GrammarProvider.");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/ ");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Singleton");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public static class GrammarProvider extends org.eclipse.xtext.service.GrammarProvider");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Inject");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public GrammarProvider(Provider<XtextResourceSet> resourceSetProvider) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("super(LANGUAGE_NAME, resourceSetProvider);");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("public Grammar getGrammar(Object requestor) {");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return ");
      _builder.append(this.grammarFileStem, "\t\t\t");
      _builder.append("GrammarResource.GRAMMAR;");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      {
        EList<EObject> _contents_2 = grammarResource.getContents();
        for(final EObject grammar_2 : _contents_2) {
          _builder.append("\t");
          String _generateGrammarPackage = this.generateGrammarPackage(((Grammar) grammar_2));
          _builder.append(_generateGrammarPackage, "\t");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  /**
   * @NonNull
   */
  protected String generateEnumRules(final Grammar grammar, final Iterable<EnumRule> eObjects) {
    StringConcatenation _builder = new StringConcatenation();
    {
      for(final EnumRule eObject : eObjects) {
        _builder.append("private static final @NonNull EnumRule ER_");
        String _name = eObject.getName();
        _builder.append(_name);
        _builder.append(" = createEnumRule(");
        String _emitValue = this.emitValue(eObject.getName());
        _builder.append(_emitValue);
        _builder.append(", ");
        String _emit = this.emit(grammar, eObject.getType());
        _builder.append(_emit);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("private static void initEnumRules() {");
    _builder.newLine();
    {
      for(final EnumRule eObject_1 : eObjects) {
        _builder.append("\t");
        String _emit_1 = this.emit(grammar, eObject_1);
        _builder.append(_emit_1, "\t");
        _builder.append(".setAlternatives(");
        String _pushIndent = this.pushIndent();
        _builder.append(_pushIndent, "\t");
        String _emitIndent = this.emitIndent();
        _builder.append(_emitIndent, "\t");
        String _emit_2 = this.emit(grammar, eObject_1.getAlternatives());
        _builder.append(_emit_2, "\t");
        String _popIndent = this.popIndent();
        _builder.append(_popIndent, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder.toString();
  }
  
  /**
   * @NonNull
   */
  protected String generateGrammarPackage(final Grammar grammar) {
    String _xblockexpression = null;
    {
      List<TerminalRule> terminalRules = this.<TerminalRule>getSortedAbstractRules(grammar, TerminalRule.class);
      List<EnumRule> enumRules = this.<EnumRule>getSortedAbstractRules(grammar, EnumRule.class);
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      _builder.append("private static class ");
      String _grammarPackageName = this.getGrammarPackageName(grammar);
      _builder.append(_grammarPackageName);
      _builder.newLineIfNotEmpty();
      _builder.append("{");
      _builder.newLine();
      _builder.append("\t");
      String _generateReferencedMetamodels = this.generateReferencedMetamodels(grammar, this.getSortedReferencedMetamodels(grammar));
      _builder.append(_generateReferencedMetamodels, "\t");
      _builder.newLineIfNotEmpty();
      {
        int _size = terminalRules.size();
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          _builder.append("\t");
          String _generateTerminalRules = this.generateTerminalRules(grammar, terminalRules);
          _builder.append(_generateTerminalRules, "\t");
          _builder.newLineIfNotEmpty();
        }
      }
      {
        int _size_1 = enumRules.size();
        boolean _greaterThan_1 = (_size_1 > 0);
        if (_greaterThan_1) {
          _builder.append("\t");
          String _generateEnumRules = this.generateEnumRules(grammar, enumRules);
          _builder.append(_generateEnumRules, "\t");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t");
      String _generateParserRules = this.generateParserRules(grammar, this.<ParserRule>getSortedAbstractRules(grammar, ParserRule.class));
      _builder.append(_generateParserRules, "\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      int _size_2 = terminalRules.size();
      boolean _greaterThan_2 = (_size_2 > 0);
      int _size_3 = enumRules.size();
      boolean _greaterThan_3 = (_size_3 > 0);
      String _generateInitGrammar = this.generateInitGrammar(grammar, _greaterThan_2, _greaterThan_3);
      _builder.append(_generateInitGrammar, "\t");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  /**
   * @NonNull
   */
  protected String generateInitGrammar(final Grammar grammar, final boolean hasTerminals, final boolean hasEnumRules) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("private static @NonNull Grammar initGrammar() {");
    _builder.newLine();
    {
      if (hasTerminals) {
        _builder.append("\t");
        _builder.append("initTerminalRules();");
        _builder.newLine();
      }
    }
    {
      if (hasEnumRules) {
        _builder.append("\t");
        _builder.append("initEnumRules();");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("initParserRules();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Grammar grammar = ");
    String _emit = this.emit(grammar, grammar);
    _builder.append(_emit, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    {
      boolean _isDefinesHiddenTokens = grammar.isDefinesHiddenTokens();
      if (_isDefinesHiddenTokens) {
        _builder.append("\t");
        _builder.append("grammar.setDefinesHiddenTokens(true);");
        _builder.newLine();
      }
    }
    {
      int _size = grammar.getMetamodelDeclarations().size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("List<AbstractMetamodelDeclaration> metamodelDeclarations = grammar.getMetamodelDeclarations();");
        _builder.newLine();
        {
          EList<AbstractMetamodelDeclaration> _metamodelDeclarations = grammar.getMetamodelDeclarations();
          for(final AbstractMetamodelDeclaration element : _metamodelDeclarations) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("metamodelDeclarations.add(");
            String _emit_1 = this.emit(grammar, element);
            _builder.append(_emit_1, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      int _size_1 = grammar.getRules().size();
      boolean _greaterThan_1 = (_size_1 > 0);
      if (_greaterThan_1) {
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("List<AbstractRule> rules = grammar.getRules();");
        _builder.newLine();
        {
          EList<AbstractRule> _rules = grammar.getRules();
          for(final AbstractRule element_1 : _rules) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("rules.add(");
            String _emit_2 = this.emit(grammar, element_1);
            _builder.append(_emit_2, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      int _size_2 = grammar.getUsedGrammars().size();
      boolean _greaterThan_2 = (_size_2 > 0);
      if (_greaterThan_2) {
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("List<Grammar> usedGrammars = grammar.getUsedGrammars();");
        _builder.newLine();
        {
          EList<Grammar> _usedGrammars = grammar.getUsedGrammars();
          for(final Grammar element_2 : _usedGrammars) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("usedGrammars.add(");
            String _emit_3 = this.emit(grammar, element_2);
            _builder.append(_emit_3, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      int _size_3 = grammar.getHiddenTokens().size();
      boolean _greaterThan_3 = (_size_3 > 0);
      if (_greaterThan_3) {
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("List<AbstractRule> hiddenTokens = grammar.getHiddenTokens();");
        _builder.newLine();
        {
          EList<AbstractRule> _hiddenTokens = grammar.getHiddenTokens();
          for(final AbstractRule element_3 : _hiddenTokens) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("hiddenTokens.add(");
            String _emit_4 = this.emit(grammar, element_3);
            _builder.append(_emit_4, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return grammar;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  /**
   * @NonNull
   */
  protected String generateParserRules(final Grammar grammar, final Iterable<ParserRule> eObjects) {
    StringConcatenation _builder = new StringConcatenation();
    {
      for(final ParserRule eObject : eObjects) {
        _builder.append("private static final @NonNull ParserRule PR_");
        String _name = eObject.getName();
        _builder.append(_name);
        _builder.append(" = createParserRule(");
        String _emitValue = this.emitValue(eObject.getName());
        _builder.append(_emitValue);
        _builder.append(", ");
        String _emit = this.emit(grammar, eObject.getType());
        _builder.append(_emit);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("private static void initParserRules() {");
    _builder.newLine();
    {
      for(final ParserRule eObject_1 : eObjects) {
        _builder.append("\t");
        String _emit_1 = this.emit(grammar, eObject_1);
        _builder.append(_emit_1, "\t");
        _builder.append(".setAlternatives(");
        String _pushIndent = this.pushIndent();
        _builder.append(_pushIndent, "\t");
        String _emitIndent = this.emitIndent();
        _builder.append(_emitIndent, "\t");
        String _emit_2 = this.emit(grammar, eObject_1.getAlternatives());
        _builder.append(_emit_2, "\t");
        String _popIndent = this.popIndent();
        _builder.append(_popIndent, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        {
          EList<Annotation> _annotations = eObject_1.getAnnotations();
          for(final Annotation annotation : _annotations) {
            _builder.append("\t");
            _builder.append("addAnnotation(");
            String _emit_3 = this.emit(grammar, eObject_1);
            _builder.append(_emit_3, "\t");
            _builder.append(", \"");
            String _name_1 = annotation.getName();
            _builder.append(_name_1, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder.toString();
  }
  
  /**
   * @NonNull
   */
  protected String generateReferencedMetamodels(final Grammar grammar, final Iterable<ReferencedMetamodel> eObjects) {
    StringConcatenation _builder = new StringConcatenation();
    {
      for(final ReferencedMetamodel eObject : eObjects) {
        _builder.append("private static final @NonNull ReferencedMetamodel ");
        String _emit = this.emit(grammar, eObject);
        _builder.append(_emit);
        _builder.append(" = createReferencedMetamodel(");
        String _emit_1 = this.emit(grammar, eObject.getEPackage());
        _builder.append(_emit_1);
        _builder.append(", ");
        String _emitValue = this.emitValue(eObject.getAlias());
        _builder.append(_emitValue);
        _builder.append("); // ");
        String _nsURI = eObject.getEPackage().getNsURI();
        _builder.append(_nsURI);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    return _builder.toString();
  }
  
  /**
   * @NonNull
   */
  protected String generateTerminalRules(final Grammar grammar, final Iterable<TerminalRule> eObjects) {
    StringConcatenation _builder = new StringConcatenation();
    {
      for(final TerminalRule eObject : eObjects) {
        _builder.append("private static final @NonNull TerminalRule TR_");
        String _name = eObject.getName();
        _builder.append(_name);
        _builder.append(" = createTerminalRule(");
        String _emitValue = this.emitValue(eObject.getName());
        _builder.append(_emitValue);
        _builder.append(", ");
        String _emit = this.emit(grammar, eObject.getType());
        _builder.append(_emit);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("private static void initTerminalRules() {");
    _builder.newLine();
    {
      for(final TerminalRule eObject_1 : eObjects) {
        {
          boolean _isFragment = eObject_1.isFragment();
          if (_isFragment) {
            _builder.append("\t");
            String _emit_1 = this.emit(grammar, eObject_1);
            _builder.append(_emit_1, "\t");
            _builder.append(".setFragment(true);");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        String _emit_2 = this.emit(grammar, eObject_1);
        _builder.append(_emit_2, "\t");
        _builder.append(".setAlternatives(");
        String _pushIndent = this.pushIndent();
        _builder.append(_pushIndent, "\t");
        String _emitIndent = this.emitIndent();
        _builder.append(_emitIndent, "\t");
        String _emit_3 = this.emit(grammar, eObject_1.getAlternatives());
        _builder.append(_emit_3, "\t");
        String _popIndent = this.popIndent();
        _builder.append(_popIndent, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder.toString();
  }
  
  /**
   * @NonNull
   */
  protected String emit(final Grammar grammar, final EObject eObject) {
    boolean _matched = false;
    if (eObject instanceof Action) {
      _matched=true;
      return this.emitAction(grammar, ((Action)eObject));
    }
    if (!_matched) {
      if (eObject instanceof Alternatives) {
        _matched=true;
        return this.emitAlternatives(grammar, ((Alternatives)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof Assignment) {
        _matched=true;
        return this.emitAssignment(grammar, ((Assignment)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof CharacterRange) {
        _matched=true;
        return this.emitCharacterRange(grammar, ((CharacterRange)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof CrossReference) {
        _matched=true;
        return this.emitCrossReference(grammar, ((CrossReference)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof EClassifier) {
        _matched=true;
        return this.emitEClassifierLiteral(((EClassifier)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof EPackage) {
        _matched=true;
        return this.emitEPackageLiteral(((EPackage)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof EEnumLiteral) {
        _matched=true;
        return this.emitEEnumLiteral(((EEnumLiteral)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof EnumRule) {
        _matched=true;
        return this.emitEnumRuleLiteral(grammar, ((EnumRule)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof EnumLiteralDeclaration) {
        _matched=true;
        return this.emitEnumLiteralDeclaration(grammar, ((EnumLiteralDeclaration)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof Grammar) {
        _matched=true;
        String _grammarPackageName = this.getGrammarPackageName(((Grammar)eObject));
        return ("G" + _grammarPackageName);
      }
    }
    if (!_matched) {
      if (eObject instanceof Group) {
        _matched=true;
        return this.emitGroup(grammar, ((Group)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof Keyword) {
        _matched=true;
        return this.emitKeyword(((Keyword)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof NegatedToken) {
        _matched=true;
        return this.emitNegatedToken(grammar, ((NegatedToken)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof ParserRule) {
        _matched=true;
        return this.emitParserRuleLiteral(grammar, ((ParserRule)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof ReferencedMetamodel) {
        _matched=true;
        return this.emitReferencedMetamodelName(grammar, ((ReferencedMetamodel)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof RuleCall) {
        _matched=true;
        return this.emitRuleCall(grammar, ((RuleCall)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof TerminalRule) {
        _matched=true;
        return this.emitTerminalRuleLiteral(grammar, ((TerminalRule)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof TypeRef) {
        _matched=true;
        return this.emitTypeRef(grammar, ((TypeRef)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof UntilToken) {
        _matched=true;
        return this.emitUntilToken(grammar, ((UntilToken)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof UnorderedGroup) {
        _matched=true;
        return this.emitUnorderedGroup(grammar, ((UnorderedGroup)eObject));
      }
    }
    if (!_matched) {
      if (eObject instanceof Wildcard) {
        _matched=true;
        return this.emitWildcard(grammar, ((Wildcard)eObject));
      }
    }
    return this.emitSymbol(eObject.eClass(), eObject);
  }
  
  /**
   * @NonNull
   */
  protected String emitAction(final Grammar grammar, final Action eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createAction(");
    String _emitValue = this.emitValue(eObject.getFeature());
    _builder.append(_emitValue);
    _builder.append(", ");
    String _emitValue_1 = this.emitValue(eObject.getOperator());
    _builder.append(_emitValue_1);
    _builder.append(", ");
    String _emit = this.emit(grammar, eObject.getType());
    _builder.append(_emit);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitAlternatives(final Grammar grammar, final Alternatives eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createAlternatives(");
    String _pushIndent = this.pushIndent();
    _builder.append(_pushIndent);
    {
      EList<AbstractElement> _elements = eObject.getElements();
      boolean _hasElements = false;
      for(final AbstractElement element : _elements) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _emitIndent = this.emitIndent();
        _builder.append(_emitIndent);
        String _emit = this.emit(grammar, element);
        _builder.append(_emit);
      }
    }
    String _popIndent = this.popIndent();
    _builder.append(_popIndent);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitAssignment(final Grammar grammar, final Assignment eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createAssignment(");
    String _emitValue = this.emitValue(eObject.getFeature());
    _builder.append(_emitValue);
    _builder.append(", ");
    String _emitValue_1 = this.emitValue(eObject.getOperator());
    _builder.append(_emitValue_1);
    _builder.append(", ");
    String _emit = this.emit(grammar, eObject.getTerminal());
    _builder.append(_emit);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitCharacterRange(final Grammar grammar, final CharacterRange eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createCharacterRange(");
    String _emit = this.emit(grammar, eObject.getLeft());
    _builder.append(_emit);
    _builder.append(", ");
    String _emit_1 = this.emit(grammar, eObject.getRight());
    _builder.append(_emit_1);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitCrossReference(final Grammar grammar, final CrossReference eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createCrossReference(");
    String _pushIndent = this.pushIndent();
    _builder.append(_pushIndent);
    String _emitIndent = this.emitIndent();
    _builder.append(_emitIndent);
    String _emit = this.emit(grammar, eObject.getType());
    _builder.append(_emit);
    _builder.append(", ");
    String _emit_1 = this.emit(grammar, eObject.getTerminal());
    _builder.append(_emit_1);
    String _popIndent = this.popIndent();
    _builder.append(_popIndent);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitEnumLiteralDeclaration(final Grammar grammar, final EnumLiteralDeclaration eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createEnumLiteral(");
    String _emit = this.emit(grammar, eObject.getLiteral());
    _builder.append(_emit);
    _builder.append(", ");
    String _emit_1 = this.emit(grammar, eObject.getEnumLiteral());
    _builder.append(_emit_1);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitGroup(final Grammar grammar, final Group eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createGroup(");
    String _pushIndent = this.pushIndent();
    _builder.append(_pushIndent);
    {
      EList<AbstractElement> _elements = eObject.getElements();
      boolean _hasElements = false;
      for(final AbstractElement element : _elements) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _emitIndent = this.emitIndent();
        _builder.append(_emitIndent);
        String _emit = this.emit(grammar, element);
        _builder.append(_emit);
      }
    }
    String _popIndent = this.popIndent();
    _builder.append(_popIndent);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitKeyword(final Keyword eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createKeyword(");
    String _emitValue = this.emitValue(eObject.getValue());
    _builder.append(_emitValue);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitNegatedToken(final Grammar grammar, final NegatedToken eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createNegatedToken(");
    String _emit = this.emit(grammar, eObject.getTerminal());
    _builder.append(_emit);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitRuleCall(final Grammar grammar, final RuleCall eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createRuleCall(");
    String _emit = this.emit(grammar, eObject.getRule());
    _builder.append(_emit);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitTypeRef(final Grammar grammar, final TypeRef eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createTypeRef(");
    String _emit = this.emit(grammar, eObject.getMetamodel());
    _builder.append(_emit);
    _builder.append(", ");
    String _emit_1 = this.emit(grammar, eObject.getClassifier());
    _builder.append(_emit_1);
    _builder.append(")");
    return _builder.toString();
  }
  
  /**
   * @NonNull
   */
  protected String emitUnorderedGroup(final Grammar grammar, final UnorderedGroup eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createUnorderedGroup(");
    String _pushIndent = this.pushIndent();
    _builder.append(_pushIndent);
    {
      EList<AbstractElement> _elements = eObject.getElements();
      boolean _hasElements = false;
      for(final AbstractElement element : _elements) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _emitIndent = this.emitIndent();
        _builder.append(_emitIndent);
        String _emit = this.emit(grammar, element);
        _builder.append(_emit);
      }
    }
    String _popIndent = this.popIndent();
    _builder.append(_popIndent);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitUntilToken(final Grammar grammar, final UntilToken eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createUntilToken(");
    String _emit = this.emit(grammar, eObject.getTerminal());
    _builder.append(_emit);
    _builder.append(")");
    return this.wrapCardinality(eObject, this.wrapFirstSetPredicated(eObject, this.wrapPredicated(eObject, _builder.toString())));
  }
  
  /**
   * @NonNull
   */
  protected String emitWildcard(final Grammar grammar, final Wildcard eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("createWildcard()");
    return this.wrapCardinality(eObject, _builder.toString());
  }
  
  /**
   * @NonNull
   */
  protected String wrapCardinality(final AbstractElement eObject, final String generatedElement) {
    String cardinality = eObject.getCardinality();
    if ((cardinality == null)) {
      return generatedElement;
    } else {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("setCardinality(");
      String _emitValue = this.emitValue(cardinality);
      _builder.append(_emitValue);
      _builder.append(", ");
      _builder.append(generatedElement);
      _builder.append(")");
      return _builder.toString();
    }
  }
  
  /**
   * @NonNull
   */
  protected String wrapFirstSetPredicated(final AbstractElement eObject, final String generatedElement) {
    boolean _isFirstSetPredicated = eObject.isFirstSetPredicated();
    boolean _not = (!_isFirstSetPredicated);
    if (_not) {
      return generatedElement;
    } else {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("setFirstSetPredicated(");
      _builder.append(generatedElement);
      _builder.append(")");
      return _builder.toString();
    }
  }
  
  /**
   * @NonNull
   */
  protected String wrapPredicated(final AbstractElement eObject, final String generatedElement) {
    boolean _isPredicated = eObject.isPredicated();
    boolean _not = (!_isPredicated);
    if (_not) {
      return generatedElement;
    } else {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("setPredicated(");
      _builder.append(generatedElement);
      _builder.append(")");
      return _builder.toString();
    }
  }
}
