/**
 * Copyright (c) 2013 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.xtend;

import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EPackage;

@SuppressWarnings("all")
public class GenerateCSVisitors extends GenerateVisitorsXtend {
  @Override
  public void generateVisitors(final GenPackage genPackage) {
    EPackage ePackage = genPackage.getEcorePackage();
    boolean _isDerived = this.isDerived();
    boolean _not = (!_isDerived);
    if (_not) {
      this.generateVisitableInterface(genPackage);
    }
    this.generateVisitorInterface(genPackage);
    this.generateDecorableVisitorInterface(ePackage, "org.eclipse.ocl.xtext.basecs.util.BaseCSVisitor");
    this.generateAbstractVisitor(ePackage);
    this.generateAbstractNullVisitor(ePackage);
    this.generateAbstractDelegatingVisitor(ePackage);
    this.generateAbstractExtendingVisitor(ePackage);
  }
}
