/**
 * Copyright (c) 2013 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.xtend;

import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.pivot.internal.manager.FlowAnalysis;
import org.eclipse.ocl.pivot.internal.resource.ASSaver;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;

@SuppressWarnings("all")
public class GenerateASVisitors extends GenerateVisitorsXtend {
  @Override
  public void generateVisitors(final GenPackage genPackage) {
    EPackage ePackage = genPackage.getEcorePackage();
    boolean _isDerived = this.isDerived();
    boolean _not = (!_isDerived);
    if (_not) {
      this.generateVisitableInterface(genPackage);
    }
    this.generateVisitorInterface(genPackage);
    this.generateAbstractVisitor(ePackage);
    this.generateAbstractNullVisitor(ePackage);
    this.generateAbstractDelegatingVisitor(ePackage);
    this.generateAbstractExtendingVisitor(ePackage);
    this.generateAbstractMergedVisitor(ePackage);
    this.generateAbstractWrappingVisitor(ePackage);
    boolean _isDerived_1 = this.isDerived();
    if (_isDerived_1) {
      this.generateAbstractGenericVisitor(ePackage, "AS2Moniker", Object.class, AS2Moniker.class);
      this.generateAbstractGenericVisitor(ePackage, "ASSaverLocate", Object.class, ASSaver.class);
      this.generateAbstractGenericVisitor(ePackage, "ASSaverNormalize", Object.class, ASSaver.class);
      this.generateAbstractGenericVisitor(ePackage, "ASSaverResolve", Object.class, ASSaver.class);
      this.generateAbstractTemplateParameterSubstitutionVisitor(ePackage, "TemplateParameterSubstitution", Object.class, EnvironmentFactoryInternal.class);
      this.generateAbstractFlowAnalysisDeducerVisitor(ePackage, "FlowAnalysisDeducerFromFalse", Boolean.class, FlowAnalysis.class, false);
      this.generateAbstractFlowAnalysisDeducerVisitor(ePackage, "FlowAnalysisDeducerFromNull", Boolean.class, FlowAnalysis.class, true);
      this.generateAbstractFlowAnalysisDeducerVisitor(ePackage, "FlowAnalysisDeducerFromTrue", Boolean.class, FlowAnalysis.class, false);
    }
  }
}
