/**
 * Copyright (c) 2013, 2014 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.textile;

import java.util.List;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class GenerateTextileForLibraryXtend extends GenerateTextileForLibraryUtils {
  /**
   * @NonNull
   */
  @Override
  protected String generateTextile(final Model model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("h1(#StandardLibrary). The OCL Standard Library");
    _builder.newLine();
    _builder.newLine();
    _builder.append("This documentation on the OCL Standard Library is auto-generated from the");
    _builder.newLine();
    _builder.append("org.eclipse.ocl.pivot/model/OCL-2.5.oclstdlib that defines");
    _builder.newLine();
    _builder.append("the behaviour of the Pivot evaluator and the Xtext editors. It is similar to the OCL 2.4 functionality.");
    _builder.newLine();
    _builder.append("It is a prototype of functionality for OCL 2.5 where the use of models may eliminate ambiguities.");
    _builder.newLine();
    _builder.newLine();
    _builder.append("The library support for the Ecore and UML bindings in Luna has been upgraded so that the available operations");
    _builder.newLine();
    _builder.append("are similar to those documented here for the Pivot binding.");
    _builder.newLine();
    _builder.newLine();
    CharSequence _emitPrecedences = this.emitPrecedences(model);
    _builder.append(_emitPrecedences);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _emitClasses = this.emitClasses(model);
    _builder.append(_emitClasses);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected CharSequence emitAssociations(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Property> asAssociations = this.getSortedAssociations(asClass);
      CharSequence _xifexpression = null;
      int _size = asAssociations.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("*Associations*");
        _builder.newLine();
        {
          for(final Property asAssociation : asAssociations) {
            _builder.newLine();
            _builder.append("@");
            String _prettyPrint = this.prettyPrint(asAssociation, asClass);
            _builder.append(_prettyPrint);
            _builder.append("@");
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asAssociation, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitAttributes(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Property> asAttributes = this.getSortedAttributes(asClass);
      CharSequence _xifexpression = null;
      int _size = asAttributes.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("*Attributes*");
        _builder.newLine();
        {
          for(final Property asAttribute : asAttributes) {
            _builder.newLine();
            _builder.append("@");
            String _prettyPrint = this.prettyPrint(asAttribute, asClass);
            _builder.append(_prettyPrint);
            _builder.append("@");
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asAttribute, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitClasses(final Model asModel) {
    CharSequence _xblockexpression = null;
    {
      List<org.eclipse.ocl.pivot.Class> asClasses = this.getSortedClasses(asModel);
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final org.eclipse.ocl.pivot.Class asClass : asClasses) {
          _builder.newLine();
          _builder.append("h2(#");
          String _name = asClass.getName();
          _builder.append(_name);
          _builder.append("). **@");
          String _prettyPrint = this.prettyPrint(asClass, asClass);
          _builder.append(_prettyPrint);
          _builder.append("@**");
          _builder.newLineIfNotEmpty();
          CharSequence _emitComment = this.emitComment(asClass, asClass);
          _builder.append(_emitComment);
          _builder.newLineIfNotEmpty();
          {
            int _size = asClass.getSuperClasses().size();
            boolean _greaterThan = (_size > 0);
            if (_greaterThan) {
              _builder.newLine();
              _builder.append("conformsTo ");
              {
                List<org.eclipse.ocl.pivot.Class> _superClasses = asClass.getSuperClasses();
                boolean _hasElements = false;
                for(final org.eclipse.ocl.pivot.Class asSuperClass : _superClasses) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  _builder.append("\"@");
                  String _prettyPrint_1 = this.prettyPrint(asSuperClass, asSuperClass);
                  _builder.append(_prettyPrint_1);
                  _builder.append("@\":#");
                  String _name_1 = asSuperClass.getName();
                  _builder.append(_name_1);
                }
              }
              _builder.newLineIfNotEmpty();
            }
          }
          CharSequence _emitAttributes = this.emitAttributes(asClass);
          _builder.append(_emitAttributes);
          _builder.newLineIfNotEmpty();
          CharSequence _emitAssociations = this.emitAssociations(asClass);
          _builder.append(_emitAssociations);
          _builder.newLineIfNotEmpty();
          CharSequence _emitOperations = this.emitOperations(asClass);
          _builder.append(_emitOperations);
          _builder.newLineIfNotEmpty();
          CharSequence _emitIterations = this.emitIterations(asClass);
          _builder.append(_emitIterations);
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitComment(final Element asElement, final Namespace asNamespace) {
    CharSequence _xifexpression = null;
    int _size = asElement.getOwnedComments().size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      StringConcatenation _builder = new StringConcatenation();
      {
        List<Comment> _ownedComments = asElement.getOwnedComments();
        for(final Comment asComment : _ownedComments) {
          _builder.newLine();
          String _prettyPrint = this.prettyPrint(asComment, asNamespace);
          _builder.append(_prettyPrint);
          _builder.newLineIfNotEmpty();
        }
      }
      _xifexpression = _builder;
    }
    return _xifexpression;
  }
  
  protected CharSequence emitIterations(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Iteration> asIterations = this.getSortedIterations(asClass);
      CharSequence _xifexpression = null;
      int _size = asIterations.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("*Iterations*");
        _builder.newLine();
        {
          for(final Iteration asIteration : asIterations) {
            _builder.newLine();
            _builder.append("@");
            String _prettyPrint = this.prettyPrint(asIteration, asClass);
            _builder.append(_prettyPrint);
            _builder.append("@");
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asIteration, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
            {
              List<Constraint> _sortedConstraints = this.getSortedConstraints(asIteration);
              for(final Constraint asConstraint : _sortedConstraints) {
                _builder.newLine();
                _builder.append("bc.. ");
                _builder.newLine();
                String _prettyPrint_1 = this.prettyPrint(asConstraint, asClass);
                _builder.append(_prettyPrint_1);
                _builder.newLineIfNotEmpty();
                _builder.append("p. ");
                _builder.newLine();
              }
            }
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitOperations(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Operation> asOperations = this.getSortedOperations(asClass);
      CharSequence _xifexpression = null;
      int _size = asOperations.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("*Operations*");
        _builder.newLine();
        {
          for(final Operation asOperation : asOperations) {
            _builder.newLine();
            _builder.append("@");
            String _prettyPrint = this.prettyPrint(asOperation, asClass);
            _builder.append(_prettyPrint);
            {
              boolean _isIsInvalidating = asOperation.isIsInvalidating();
              if (_isIsInvalidating) {
                _builder.append(" invalidating");
              }
            }
            {
              boolean _isIsValidating = asOperation.isIsValidating();
              if (_isIsValidating) {
                _builder.append(" validating");
              }
            }
            _builder.append("@");
            _builder.newLineIfNotEmpty();
            {
              Precedence _precedence = asOperation.getPrecedence();
              boolean _tripleNotEquals = (_precedence != null);
              if (_tripleNotEquals) {
                _builder.append("precedence: @");
                String _name = asOperation.getPrecedence().getName();
                _builder.append(_name);
                _builder.append("@");
                _builder.newLineIfNotEmpty();
              }
            }
            CharSequence _emitComment = this.emitComment(asOperation, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
            {
              List<Constraint> _sortedPreconditions = this.getSortedPreconditions(asOperation);
              for(final Constraint asConstraint : _sortedPreconditions) {
                _builder.newLine();
                _builder.append("bc.. ");
                _builder.newLine();
                String _prettyPrint_1 = this.prettyPrint(asConstraint, asClass);
                _builder.append(_prettyPrint_1);
                _builder.newLineIfNotEmpty();
                _builder.append("p. ");
                _builder.newLine();
              }
            }
            {
              LanguageExpression _bodyExpression = asOperation.getBodyExpression();
              boolean _tripleNotEquals_1 = (_bodyExpression != null);
              if (_tripleNotEquals_1) {
                _builder.newLine();
                _builder.append("bc.. ");
                _builder.newLine();
                _builder.append("body: ");
                String _body = asOperation.getBodyExpression().getBody();
                _builder.append(_body);
                _builder.newLineIfNotEmpty();
                _builder.append("p. ");
                _builder.newLine();
              }
            }
            {
              List<Constraint> _sortedPostconditions = this.getSortedPostconditions(asOperation);
              for(final Constraint asConstraint_1 : _sortedPostconditions) {
                _builder.newLine();
                _builder.append("bc.. ");
                _builder.newLine();
                String _prettyPrint_2 = this.prettyPrint(asConstraint_1, asClass);
                _builder.append(_prettyPrint_2);
                _builder.newLineIfNotEmpty();
                _builder.append("p. ");
                _builder.newLine();
              }
            }
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitPrecedences(final Model asModel) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("h2(#Precedences). *Precedences*");
    _builder.newLine();
    _builder.newLine();
    {
      Iterable<Precedence> _precedences = this.getPrecedences(asModel);
      boolean _hasElements = false;
      for(final Precedence asPrecedence : _precedences) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(" > ", "");
        }
        _builder.append("@");
        String _name = asPrecedence.getName();
        _builder.append(_name);
        _builder.append("@");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
