/**
 * Copyright (c) 2014 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.latex;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;

@SuppressWarnings("all")
public class GenerateLaTeXForGrammarXtend extends GenerateLaTeXForGrammar {
  /**
   * @NonNull
   */
  @Override
  protected String generateLaTeX(final Grammar grammar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _emitExternalModels = this.emitExternalModels(grammar);
    _builder.append(_emitExternalModels);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _emitTerminalRules = this.emitTerminalRules(grammar);
    _builder.append(_emitTerminalRules);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _emitParserRules = this.emitParserRules(grammar);
    _builder.append(_emitParserRules);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected CharSequence emitExternalModels(final Grammar grammar) {
    CharSequence _xblockexpression = null;
    {
      List<ReferencedMetamodel> metamodelDeclarations = this.getSortedMetamodelDeclarations(grammar);
      StringConcatenation _builder = new StringConcatenation();
      String _emitHeading3 = this.emitHeading3("External Models", (this.labelPrefix + "ExternalModels"));
      _builder.append(_emitHeading3);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("The following aliases and metamodel URIs are used in the grammar.");
      _builder.newLine();
      _builder.newLine();
      {
        for(final ReferencedMetamodel metamodelDeclaration : metamodelDeclarations) {
          String _emitMetamodelDeclaration = this.emitMetamodelDeclaration(metamodelDeclaration);
          _builder.append(_emitMetamodelDeclaration);
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitParserRules(final Grammar grammar) {
    CharSequence _xblockexpression = null;
    {
      List<ParserRule> parserRules = this.getSortedParserRules(grammar);
      StringConcatenation _builder = new StringConcatenation();
      String _emitHeading3 = this.emitHeading3("Parser Rules", (this.labelPrefix + "ParserRules"));
      _builder.append(_emitHeading3);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("The parser rules define the parser mapping from parser tokens to generalized concrete syntax elements.");
      _builder.newLine();
      {
        for(final ParserRule parserRule : parserRules) {
          _builder.newLine();
          String _name = parserRule.getName();
          String _name_1 = parserRule.getName();
          String _plus = ((this.labelPrefix + "ParserRule:") + _name_1);
          String _emitHeading4 = this.emitHeading4(_name, _plus);
          _builder.append(_emitHeading4);
          _builder.newLineIfNotEmpty();
          String _emitComment = this.emitComment(parserRule);
          _builder.append(_emitComment);
          _builder.newLineIfNotEmpty();
          _builder.append("Token type: ");
          String _emitTypeRef = this.emitTypeRef(parserRule.getType());
          _builder.append(_emitTypeRef);
          _builder.newLineIfNotEmpty();
          String _emitAllTT = this.emitAllTT(this.emitAbstractElement(parserRule.getAlternatives(), true));
          _builder.append(_emitAllTT);
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitTerminalRules(final Grammar grammar) {
    CharSequence _xblockexpression = null;
    {
      List<TerminalRule> terminalRules = this.getSortedTerminalRules(grammar);
      StringConcatenation _builder = new StringConcatenation();
      String _emitHeading3 = this.emitHeading3("Terminal Rules", (this.labelPrefix + "TerminalRules"));
      _builder.append(_emitHeading3);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("The terminal rules define the lexer mapping from character sequences to parser tokens.");
      _builder.newLine();
      {
        for(final TerminalRule terminalRule : terminalRules) {
          _builder.newLine();
          String _name = terminalRule.getName();
          String _name_1 = terminalRule.getName();
          String _plus = ((this.labelPrefix + "TerminalRule:") + _name_1);
          String _emitHeading4 = this.emitHeading4(_name, _plus);
          _builder.append(_emitHeading4);
          _builder.newLineIfNotEmpty();
          String _emitComment = this.emitComment(terminalRule);
          _builder.append(_emitComment);
          _builder.newLineIfNotEmpty();
          _builder.append("Token type: ");
          String _emitTypeRef = this.emitTypeRef(terminalRule.getType());
          _builder.append(_emitTypeRef);
          _builder.newLineIfNotEmpty();
          String _emitAllTT = this.emitAllTT(this.emitAbstractElement(terminalRule.getAlternatives(), true));
          _builder.append(_emitAllTT);
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected String emitAbstractElement(final AbstractElement abstractElement, final boolean atRoot) {
    boolean _matched = false;
    if (abstractElement instanceof Action) {
      _matched=true;
      return this.emitAction(((Action)abstractElement));
    }
    if (!_matched) {
      if (abstractElement instanceof Alternatives) {
        _matched=true;
        return this.emitAlternatives(((Alternatives)abstractElement), atRoot);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof Assignment) {
        _matched=true;
        return this.emitAssignment(((Assignment)abstractElement));
      }
    }
    if (!_matched) {
      if (abstractElement instanceof CharacterRange) {
        _matched=true;
        return this.emitCharacterRange(((CharacterRange)abstractElement));
      }
    }
    if (!_matched) {
      if (abstractElement instanceof CrossReference) {
        _matched=true;
        return this.emitCrossReference(((CrossReference)abstractElement));
      }
    }
    if (!_matched) {
      if (abstractElement instanceof Group) {
        _matched=true;
        return this.emitGroup(((Group)abstractElement), atRoot);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof Keyword) {
        _matched=true;
        return this.emitKeyword(((Keyword)abstractElement));
      }
    }
    if (!_matched) {
      if (abstractElement instanceof NegatedToken) {
        _matched=true;
        String _emitAbstractElement = this.emitAbstractElement(((NegatedToken)abstractElement).getTerminal(), false);
        String _plus = ("!" + _emitAbstractElement);
        String _emitCardinality = this.emitCardinality(abstractElement);
        return (_plus + _emitCardinality);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof RuleCall) {
        _matched=true;
        String _name = ((RuleCall)abstractElement).getRule().getName();
        String _emitCardinality = this.emitCardinality(abstractElement);
        return (_name + _emitCardinality);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof UntilToken) {
        _matched=true;
        String _emitAbstractElement = this.emitAbstractElement(((UntilToken)abstractElement).getTerminal(), false);
        return ("-> " + _emitAbstractElement);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof Wildcard) {
        _matched=true;
        String _emitCardinality = this.emitCardinality(abstractElement);
        return ("." + _emitCardinality);
      }
    }
    String _name = abstractElement.eClass().getName();
    String _plus = ("<<<" + _name);
    return (_plus + ">>>");
  }
  
  protected String emitAction(final Action action) {
    String _feature = action.getFeature();
    boolean _tripleNotEquals = (_feature != null);
    if (_tripleNotEquals) {
      String _emitTypeRef = this.emitTypeRef(action.getType());
      String _plus = ("\n{" + _emitTypeRef);
      String _feature_1 = action.getFeature();
      String _plus_1 = (_plus + _feature_1);
      String _operator = action.getOperator();
      String _plus_2 = (_plus_1 + _operator);
      return (_plus_2 + "current}");
    } else {
      String _emitTypeRef_1 = this.emitTypeRef(action.getType());
      String _plus_3 = ("\n{" + _emitTypeRef_1);
      return (_plus_3 + "}");
    }
  }
  
  protected String emitAlternatives(final Alternatives alternatives, final boolean atRoot) {
    String _xifexpression = null;
    if ((atRoot && (alternatives.getCardinality() == null))) {
      StringConcatenation _builder = new StringConcatenation();
      {
        EList<AbstractElement> _elements = alternatives.getElements();
        boolean _hasElements = false;
        for(final AbstractElement element : _elements) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate("\n| ", "");
          }
          String _emitAbstractElement = this.emitAbstractElement(element, false);
          _builder.append(_emitAbstractElement);
        }
      }
      _xifexpression = _builder.toString();
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        EList<AbstractElement> _elements_1 = alternatives.getElements();
        boolean _hasElements_1 = false;
        for(final AbstractElement element_1 : _elements_1) {
          if (!_hasElements_1) {
            _hasElements_1 = true;
            _builder_1.append("(");
          } else {
            _builder_1.appendImmediate("\n| ", "");
          }
          String _emitAbstractElement_1 = this.emitAbstractElement(element_1, false);
          _builder_1.append(_emitAbstractElement_1);
        }
        if (_hasElements_1) {
          _builder_1.append(")");
        }
      }
      String _cardinality = alternatives.getCardinality();
      _builder_1.append(_cardinality);
      _xifexpression = _builder_1.toString();
    }
    return _xifexpression;
  }
  
  protected String emitAssignment(final Assignment assignment) {
    String _feature = assignment.getFeature();
    String _operator = assignment.getOperator();
    String _plus = (_feature + _operator);
    String _emitAbstractElement = this.emitAbstractElement(assignment.getTerminal(), false);
    String _plus_1 = (_plus + _emitAbstractElement);
    String _emitCardinality = this.emitCardinality(assignment);
    String _plus_2 = (_plus_1 + _emitCardinality);
    return (_plus_2 + "\n");
  }
  
  protected String emitCardinality(final AbstractElement abstractElement) {
    String _cardinality = abstractElement.getCardinality();
    boolean _tripleNotEquals = (_cardinality != null);
    if (_tripleNotEquals) {
      return abstractElement.getCardinality();
    } else {
      return "";
    }
  }
  
  protected String emitCharacterRange(final CharacterRange characterRange) {
    String _cardinality = characterRange.getCardinality();
    boolean _tripleEquals = (_cardinality == null);
    if (_tripleEquals) {
      String _emitKeyword = this.emitKeyword(characterRange.getLeft());
      String _plus = (_emitKeyword + "..");
      String _emitKeyword_1 = this.emitKeyword(characterRange.getRight());
      return (_plus + _emitKeyword_1);
    } else {
      String _emitKeyword_2 = this.emitKeyword(characterRange.getLeft());
      String _plus_1 = ("(" + _emitKeyword_2);
      String _plus_2 = (_plus_1 + "..");
      String _emitKeyword_3 = this.emitKeyword(characterRange.getRight());
      String _plus_3 = (_plus_2 + _emitKeyword_3);
      String _plus_4 = (_plus_3 + ")");
      String _cardinality_1 = characterRange.getCardinality();
      return (_plus_4 + _cardinality_1);
    }
  }
  
  protected String emitCrossReference(final CrossReference crossReference) {
    String _emitTypeRef = this.emitTypeRef(crossReference.getType());
    String _plus = ("[" + _emitTypeRef);
    String _plus_1 = (_plus + "|");
    String _emitAbstractElement = this.emitAbstractElement(crossReference.getTerminal(), false);
    String _plus_2 = (_plus_1 + _emitAbstractElement);
    String _plus_3 = (_plus_2 + "]");
    String _emitCardinality = this.emitCardinality(crossReference);
    return (_plus_3 + _emitCardinality);
  }
  
  protected String emitGroup(final Group group, final boolean atRoot) {
    String _xifexpression = null;
    if ((atRoot && (group.getCardinality() == null))) {
      StringConcatenation _builder = new StringConcatenation();
      {
        EList<AbstractElement> _elements = group.getElements();
        boolean _hasElements = false;
        for(final AbstractElement element : _elements) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(" ", "");
          }
          String _emitAbstractElement = this.emitAbstractElement(element, false);
          _builder.append(_emitAbstractElement);
        }
      }
      _xifexpression = _builder.toString();
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        EList<AbstractElement> _elements_1 = group.getElements();
        boolean _hasElements_1 = false;
        for(final AbstractElement element_1 : _elements_1) {
          if (!_hasElements_1) {
            _hasElements_1 = true;
            _builder_1.append("(");
          } else {
            _builder_1.appendImmediate(" ", "");
          }
          String _emitAbstractElement_1 = this.emitAbstractElement(element_1, false);
          _builder_1.append(_emitAbstractElement_1);
        }
        if (_hasElements_1) {
          _builder_1.append(")");
        }
      }
      String _cardinality = group.getCardinality();
      _builder_1.append(_cardinality);
      _xifexpression = _builder_1.toString();
    }
    return _xifexpression;
  }
  
  protected String emitKeyword(final Keyword keyword) {
    String _emitCharacters = this.emitCharacters(keyword.getValue());
    String _plus = ("\'" + _emitCharacters);
    String _plus_1 = (_plus + "\'");
    String _emitCardinality = this.emitCardinality(keyword);
    return (_plus_1 + _emitCardinality);
  }
  
  protected String emitMetamodelDeclaration(final AbstractMetamodelDeclaration metamodelDeclaration) {
    String _alias = metamodelDeclaration.getAlias();
    boolean _tripleEquals = (_alias == null);
    if (_tripleEquals) {
      String _nsURI = metamodelDeclaration.getEPackage().getNsURI();
      return (_nsURI + " (default)");
    } else {
      String _alias_1 = metamodelDeclaration.getAlias();
      String _plus = (_alias_1 + " : ");
      String _nsURI_1 = metamodelDeclaration.getEPackage().getNsURI();
      return (_plus + _nsURI_1);
    }
  }
  
  protected String emitTypeRef(final TypeRef typeRef) {
    if ((Objects.equal(typeRef.getMetamodel().getAlias(), "ecore") && Objects.equal(typeRef.getClassifier().getName(), "EString"))) {
      return "String";
    } else {
      if ((Objects.equal(typeRef.getMetamodel().getAlias(), "ecore") && Objects.equal(typeRef.getClassifier().getName(), "EInt"))) {
        return "Integer";
      } else {
        String _alias = typeRef.getMetamodel().getAlias();
        boolean _tripleEquals = (_alias == null);
        if (_tripleEquals) {
          return typeRef.getClassifier().getName();
        } else {
          String _alias_1 = typeRef.getMetamodel().getAlias();
          String _plus = (_alias_1 + "::");
          String _name = typeRef.getClassifier().getName();
          return (_plus + _name);
        }
      }
    }
  }
}
