/**
 * Copyright (c) 2014 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.latex;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;

@SuppressWarnings("all")
public class GenerateLaTeXForCSModelXtend extends GenerateLaTeXForCSModel {
  /**
   * @NonNull
   */
  @Override
  protected String generateLaTeX(final org.eclipse.ocl.pivot.Package asPackage, final Grammar grammar, final org.eclipse.ocl.pivot.Package cs2asPackage, final org.eclipse.ocl.pivot.Package cs2csPackage) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _emitClasses = this.emitClasses(asPackage, grammar, cs2asPackage, cs2csPackage);
    _builder.append(_emitClasses);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _emitExternalModels = this.emitExternalModels(grammar);
    _builder.append(_emitExternalModels);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _emitTerminalRules = this.emitTerminalRules(grammar);
    _builder.append(_emitTerminalRules);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected String emitAbstractElement(final AbstractElement abstractElement, final boolean atRoot) {
    boolean _matched = false;
    if (abstractElement instanceof Action) {
      _matched=true;
      return this.emitAction(((Action)abstractElement));
    }
    if (!_matched) {
      if (abstractElement instanceof Alternatives) {
        _matched=true;
        return this.emitAlternatives(((Alternatives)abstractElement), atRoot);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof Assignment) {
        _matched=true;
        return this.emitAssignment(((Assignment)abstractElement));
      }
    }
    if (!_matched) {
      if (abstractElement instanceof CharacterRange) {
        _matched=true;
        return this.emitCharacterRange(((CharacterRange)abstractElement));
      }
    }
    if (!_matched) {
      if (abstractElement instanceof CrossReference) {
        _matched=true;
        return this.emitCrossReference(((CrossReference)abstractElement));
      }
    }
    if (!_matched) {
      if (abstractElement instanceof Group) {
        _matched=true;
        return this.emitGroup(((Group)abstractElement), atRoot);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof Keyword) {
        _matched=true;
        return this.emitKeyword(((Keyword)abstractElement));
      }
    }
    if (!_matched) {
      if (abstractElement instanceof NegatedToken) {
        _matched=true;
        String _emitAbstractElement = this.emitAbstractElement(((NegatedToken)abstractElement).getTerminal(), false);
        String _plus = ("!" + _emitAbstractElement);
        String _emitCardinality = this.emitCardinality(abstractElement);
        return (_plus + _emitCardinality);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof RuleCall) {
        _matched=true;
        String _emitRuleRef = this.emitRuleRef(((RuleCall)abstractElement).getRule());
        String _emitCardinality = this.emitCardinality(abstractElement);
        return (_emitRuleRef + _emitCardinality);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof UntilToken) {
        _matched=true;
        String _emitAbstractElement = this.emitAbstractElement(((UntilToken)abstractElement).getTerminal(), false);
        return ("-> " + _emitAbstractElement);
      }
    }
    if (!_matched) {
      if (abstractElement instanceof Wildcard) {
        _matched=true;
        String _emitCardinality = this.emitCardinality(abstractElement);
        return ("." + _emitCardinality);
      }
    }
    String _name = abstractElement.eClass().getName();
    String _plus = ("<<<" + _name);
    return (_plus + ">>>");
  }
  
  protected String emitAction(final Action action) {
    String _feature = action.getFeature();
    boolean _tripleNotEquals = (_feature != null);
    if (_tripleNotEquals) {
      String _emitTypeRef = this.emitTypeRef(action.getType());
      String _plus = ("\n{" + _emitTypeRef);
      String _feature_1 = action.getFeature();
      String _plus_1 = (_plus + _feature_1);
      String _operator = action.getOperator();
      String _plus_2 = (_plus_1 + _operator);
      return (_plus_2 + "current}");
    } else {
      return "";
    }
  }
  
  protected String emitAlternatives(final Alternatives alternatives, final boolean atRoot) {
    String _xifexpression = null;
    if ((atRoot && (alternatives.getCardinality() == null))) {
      StringConcatenation _builder = new StringConcatenation();
      {
        EList<AbstractElement> _elements = alternatives.getElements();
        boolean _hasElements = false;
        for(final AbstractElement element : _elements) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate("\n| ", "");
          }
          String _emitAbstractElement = this.emitAbstractElement(element, false);
          _builder.append(_emitAbstractElement);
        }
      }
      _xifexpression = _builder.toString();
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        EList<AbstractElement> _elements_1 = alternatives.getElements();
        boolean _hasElements_1 = false;
        for(final AbstractElement element_1 : _elements_1) {
          if (!_hasElements_1) {
            _hasElements_1 = true;
            _builder_1.append("(");
          } else {
            _builder_1.appendImmediate("\n| ", "");
          }
          String _emitAbstractElement_1 = this.emitAbstractElement(element_1, false);
          _builder_1.append(_emitAbstractElement_1);
        }
        if (_hasElements_1) {
          _builder_1.append(")");
        }
      }
      String _cardinality = alternatives.getCardinality();
      _builder_1.append(_cardinality);
      _xifexpression = _builder_1.toString();
    }
    return _xifexpression;
  }
  
  protected String emitAssignment(final Assignment assignment) {
    String _feature = assignment.getFeature();
    String _operator = assignment.getOperator();
    String _plus = (_feature + _operator);
    String _emitAbstractElement = this.emitAbstractElement(assignment.getTerminal(), false);
    String _plus_1 = (_plus + _emitAbstractElement);
    String _emitCardinality = this.emitCardinality(assignment);
    String _plus_2 = (_plus_1 + _emitCardinality);
    return (_plus_2 + "\n");
  }
  
  protected CharSequence emitAssociations(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Property> asAssociations = this.getSortedAssociations(asClass);
      CharSequence _xifexpression = null;
      int _size = asAssociations.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _emitHeading0a = this.emitHeading0a("Associations");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        {
          for(final Property asAssociation : asAssociations) {
            _builder.newLine();
            String _emitHeading0b = this.emitHeading0b(this.prettyPrint(asAssociation, asClass));
            _builder.append(_emitHeading0b);
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asAssociation, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitAttributes(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Property> asAttributes = this.getSortedAttributes(asClass);
      CharSequence _xifexpression = null;
      int _size = asAttributes.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _emitHeading0a = this.emitHeading0a("Attributes");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        {
          for(final Property asAttribute : asAttributes) {
            _builder.newLine();
            String _emitHeading0b = this.emitHeading0b(this.prettyPrint(asAttribute, asClass));
            _builder.append(_emitHeading0b);
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asAttribute, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitCS2AS(final org.eclipse.ocl.pivot.Class asClass, final org.eclipse.ocl.pivot.Package cs2asPackage) {
    CharSequence _xblockexpression = null;
    {
      org.eclipse.ocl.pivot.Class cs2asClass = NameUtil.<org.eclipse.ocl.pivot.Class>getNameable(cs2asPackage.getOwnedClasses(), asClass.getName());
      CharSequence _xifexpression = null;
      if ((cs2asClass != null)) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _emitHeading0a = this.emitHeading0a("Abstract Syntax Synthesis");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        {
          List<Operation> _ownedOperations = ClassUtil.<org.eclipse.ocl.pivot.Class>nonNullState(cs2asClass).getOwnedOperations();
          for(final Operation asOperation : _ownedOperations) {
            _builder.newLine();
            String _emitHeading0b = this.emitHeading0b(this.prettyPrint(asOperation, cs2asClass));
            _builder.append(_emitHeading0b);
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asOperation, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
            {
              LanguageExpression _bodyExpression = asOperation.getBodyExpression();
              boolean _tripleNotEquals = (_bodyExpression != null);
              if (_tripleNotEquals) {
                String _emitAllTT = this.emitAllTT(asOperation.getBodyExpression().getBody().trim().replace("\n", "\n  "));
                _builder.append(_emitAllTT);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitCS2CS(final org.eclipse.ocl.pivot.Class asClass, final org.eclipse.ocl.pivot.Package cs2asPackage) {
    CharSequence _xblockexpression = null;
    {
      org.eclipse.ocl.pivot.Class cs2csClass = NameUtil.<org.eclipse.ocl.pivot.Class>getNameable(cs2asPackage.getOwnedClasses(), asClass.getName());
      CharSequence _xifexpression = null;
      if ((cs2csClass != null)) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _emitHeading0a = this.emitHeading0a("Concrete Syntax Disambiguation");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        {
          List<Operation> _ownedOperations = ClassUtil.<org.eclipse.ocl.pivot.Class>nonNullState(cs2csClass).getOwnedOperations();
          for(final Operation asOperation : _ownedOperations) {
            _builder.newLine();
            String _emitHeading0b = this.emitHeading0b(this.prettyPrint(asOperation, cs2csClass));
            _builder.append(_emitHeading0b);
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asOperation, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
            {
              LanguageExpression _bodyExpression = asOperation.getBodyExpression();
              boolean _tripleNotEquals = (_bodyExpression != null);
              if (_tripleNotEquals) {
                String _emitAllTT = this.emitAllTT(asOperation.getBodyExpression().getBody().trim().replace("\n", "\n  "));
                _builder.append(_emitAllTT);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected String emitCardinality(final AbstractElement abstractElement) {
    String _cardinality = abstractElement.getCardinality();
    boolean _tripleNotEquals = (_cardinality != null);
    if (_tripleNotEquals) {
      return abstractElement.getCardinality();
    } else {
      return "";
    }
  }
  
  protected String emitCharacterRange(final CharacterRange characterRange) {
    String _cardinality = characterRange.getCardinality();
    boolean _tripleEquals = (_cardinality == null);
    if (_tripleEquals) {
      String _emitKeyword = this.emitKeyword(characterRange.getLeft());
      String _plus = (_emitKeyword + "..");
      String _emitKeyword_1 = this.emitKeyword(characterRange.getRight());
      return (_plus + _emitKeyword_1);
    } else {
      String _emitKeyword_2 = this.emitKeyword(characterRange.getLeft());
      String _plus_1 = ("(" + _emitKeyword_2);
      String _plus_2 = (_plus_1 + "..");
      String _emitKeyword_3 = this.emitKeyword(characterRange.getRight());
      String _plus_3 = (_plus_2 + _emitKeyword_3);
      String _plus_4 = (_plus_3 + ")");
      String _cardinality_1 = characterRange.getCardinality();
      return (_plus_4 + _cardinality_1);
    }
  }
  
  protected CharSequence emitClasses(final org.eclipse.ocl.pivot.Package asPackage, final Grammar grammar, final org.eclipse.ocl.pivot.Package cs2asPackage, final org.eclipse.ocl.pivot.Package cs2csPackage) {
    CharSequence _xblockexpression = null;
    {
      List<org.eclipse.ocl.pivot.Class> asClasses = this.getSortedClasses(asPackage);
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final org.eclipse.ocl.pivot.Class asClass : asClasses) {
          _builder.newLine();
          String _emitHeading3 = this.emitHeading3(this.prettyPrint(asClass, asClass), null);
          String _emitClassDef = this.emitClassDef(asClass);
          String _plus = (_emitHeading3 + _emitClassDef);
          _builder.append(_plus);
          _builder.newLineIfNotEmpty();
          CharSequence _emitComment = this.emitComment(asClass, asClass);
          _builder.append(_emitComment);
          _builder.newLineIfNotEmpty();
          CharSequence _emitSuperclasses = this.emitSuperclasses(asClass);
          _builder.append(_emitSuperclasses);
          _builder.newLineIfNotEmpty();
          CharSequence _emitAttributes = this.emitAttributes(asClass);
          _builder.append(_emitAttributes);
          _builder.newLineIfNotEmpty();
          CharSequence _emitAssociations = this.emitAssociations(asClass);
          _builder.append(_emitAssociations);
          _builder.newLineIfNotEmpty();
          CharSequence _emitOperations = this.emitOperations(asClass);
          _builder.append(_emitOperations);
          _builder.newLineIfNotEmpty();
          CharSequence _emitParserRules = this.emitParserRules(asClass, grammar);
          _builder.append(_emitParserRules);
          _builder.newLineIfNotEmpty();
          {
            if ((cs2csPackage != null)) {
              CharSequence _emitCS2CS = this.emitCS2CS(asClass, ClassUtil.<org.eclipse.ocl.pivot.Package>nonNullState(cs2csPackage));
              _builder.append(_emitCS2CS);
              _builder.newLineIfNotEmpty();
            }
          }
          {
            if ((cs2asPackage != null)) {
              CharSequence _emitCS2AS = this.emitCS2AS(asClass, ClassUtil.<org.eclipse.ocl.pivot.Package>nonNullState(cs2asPackage));
              _builder.append(_emitCS2AS);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitComment(final Element asElement, final Namespace asNamespace) {
    CharSequence _xifexpression = null;
    int _size = asElement.getOwnedComments().size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      StringConcatenation _builder = new StringConcatenation();
      {
        List<Comment> _ownedComments = asElement.getOwnedComments();
        for(final Comment asComment : _ownedComments) {
          _builder.newLine();
          String _prettyPrint = this.prettyPrint(asComment, asNamespace);
          _builder.append(_prettyPrint);
          _builder.newLineIfNotEmpty();
        }
      }
      _xifexpression = _builder;
    }
    return _xifexpression;
  }
  
  protected String emitCrossReference(final CrossReference crossReference) {
    String _emitTypeRef = this.emitTypeRef(crossReference.getType());
    String _plus = ("[" + _emitTypeRef);
    String _plus_1 = (_plus + "|");
    String _emitAbstractElement = this.emitAbstractElement(crossReference.getTerminal(), false);
    String _plus_2 = (_plus_1 + _emitAbstractElement);
    String _plus_3 = (_plus_2 + "]");
    String _emitCardinality = this.emitCardinality(crossReference);
    return (_plus_3 + _emitCardinality);
  }
  
  protected String emitGroup(final Group group, final boolean atRoot) {
    String _xifexpression = null;
    if ((atRoot && (group.getCardinality() == null))) {
      StringConcatenation _builder = new StringConcatenation();
      {
        EList<AbstractElement> _elements = group.getElements();
        boolean _hasElements = false;
        for(final AbstractElement element : _elements) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(" ", "");
          }
          String _emitAbstractElement = this.emitAbstractElement(element, false);
          _builder.append(_emitAbstractElement);
        }
      }
      _xifexpression = _builder.toString();
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        EList<AbstractElement> _elements_1 = group.getElements();
        boolean _hasElements_1 = false;
        for(final AbstractElement element_1 : _elements_1) {
          if (!_hasElements_1) {
            _hasElements_1 = true;
            _builder_1.append("(");
          } else {
            _builder_1.appendImmediate(" ", "");
          }
          String _emitAbstractElement_1 = this.emitAbstractElement(element_1, false);
          _builder_1.append(_emitAbstractElement_1);
        }
        if (_hasElements_1) {
          _builder_1.append(")");
        }
      }
      String _cardinality = group.getCardinality();
      _builder_1.append(_cardinality);
      _xifexpression = _builder_1.toString();
    }
    return _xifexpression;
  }
  
  protected CharSequence emitExternalModels(final Grammar grammar) {
    CharSequence _xblockexpression = null;
    {
      List<ReferencedMetamodel> metamodelDeclarations = this.getSortedMetamodelDeclarations(grammar);
      StringConcatenation _builder = new StringConcatenation();
      String _emitHeading3 = this.emitHeading3("External Models", (this.labelPrefix + "ExternalModels"));
      _builder.append(_emitHeading3);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("The following aliases and metamodel URIs are used in the grammar.");
      _builder.newLine();
      _builder.newLine();
      {
        for(final ReferencedMetamodel metamodelDeclaration : metamodelDeclarations) {
          String _emitMetamodelDeclaration = this.emitMetamodelDeclaration(metamodelDeclaration);
          _builder.append(_emitMetamodelDeclaration);
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected String emitKeyword(final Keyword keyword) {
    String _emitCharacters = this.emitCharacters(keyword.getValue());
    String _plus = ("\'" + _emitCharacters);
    String _plus_1 = (_plus + "\'");
    String _emitCardinality = this.emitCardinality(keyword);
    return (_plus_1 + _emitCardinality);
  }
  
  protected String emitMetamodelDeclaration(final AbstractMetamodelDeclaration metamodelDeclaration) {
    String _alias = metamodelDeclaration.getAlias();
    boolean _tripleEquals = (_alias == null);
    if (_tripleEquals) {
      String _nsURI = metamodelDeclaration.getEPackage().getNsURI();
      return (_nsURI + " (default)");
    } else {
      String _alias_1 = metamodelDeclaration.getAlias();
      String _plus = (_alias_1 + " : ");
      String _nsURI_1 = metamodelDeclaration.getEPackage().getNsURI();
      return (_plus + _nsURI_1);
    }
  }
  
  protected CharSequence emitOperations(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Operation> asOperations = this.getSortedOperations(asClass);
      CharSequence _xifexpression = null;
      int _size = asOperations.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _emitHeading0a = this.emitHeading0a("Operations");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        {
          for(final Operation asOperation : asOperations) {
            _builder.newLine();
            String _emitHeading0b = this.emitHeading0b(this.prettyPrint(asOperation, asClass));
            _builder.append(_emitHeading0b);
            _builder.newLineIfNotEmpty();
            {
              Precedence _precedence = asOperation.getPrecedence();
              boolean _tripleNotEquals = (_precedence != null);
              if (_tripleNotEquals) {
                _builder.newLine();
                _builder.append("\t");
                _builder.append("precedence: ");
                String _emitHeading0b_1 = this.emitHeading0b(asOperation.getPrecedence().getName());
                _builder.append(_emitHeading0b_1, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
            CharSequence _emitComment = this.emitComment(asOperation, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
            {
              List<Constraint> _sortedPreconditions = this.getSortedPreconditions(asOperation);
              for(final Constraint asConstraint : _sortedPreconditions) {
                String _emitBeginDefinition = this.emitBeginDefinition();
                _builder.append(_emitBeginDefinition);
                _builder.newLineIfNotEmpty();
                String _prettyPrint = this.prettyPrint(asConstraint, asClass);
                _builder.append(_prettyPrint);
                _builder.newLineIfNotEmpty();
                String _emitEndDefinition = this.emitEndDefinition();
                _builder.append(_emitEndDefinition);
                _builder.newLineIfNotEmpty();
              }
            }
            {
              LanguageExpression _bodyExpression = asOperation.getBodyExpression();
              boolean _tripleNotEquals_1 = (_bodyExpression != null);
              if (_tripleNotEquals_1) {
                String _emitBeginDefinition_1 = this.emitBeginDefinition();
                _builder.append(_emitBeginDefinition_1);
                _builder.newLineIfNotEmpty();
                _builder.append("body: ");
                String _body = asOperation.getBodyExpression().getBody();
                _builder.append(_body);
                _builder.newLineIfNotEmpty();
                String _emitEndDefinition_1 = this.emitEndDefinition();
                _builder.append(_emitEndDefinition_1);
                _builder.newLineIfNotEmpty();
              }
            }
            {
              List<Constraint> _sortedPostconditions = this.getSortedPostconditions(asOperation);
              for(final Constraint asConstraint_1 : _sortedPostconditions) {
                String _emitBeginDefinition_2 = this.emitBeginDefinition();
                _builder.append(_emitBeginDefinition_2);
                _builder.newLineIfNotEmpty();
                String _prettyPrint_1 = this.prettyPrint(asConstraint_1, asClass);
                _builder.append(_prettyPrint_1);
                _builder.newLineIfNotEmpty();
                String _emitEndDefinition_2 = this.emitEndDefinition();
                _builder.append(_emitEndDefinition_2);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  /**
   * protected def String emitParserRule(@NonNull org.eclipse.ocl.pivot.Class asClass, @NonNull Collection<ParserRule> parserRules) {
   * '''
   * «asClass.name» ::=
   * «FOR parserRule : parserRules BEFORE " " SEPARATOR "\n|"» «parserRule.name»«ENDFOR»
   * '''
   * }
   */
  protected CharSequence emitParserRules(final Grammar grammar) {
    CharSequence _xblockexpression = null;
    {
      List<ParserRule> parserRules = this.getSortedParserRules(grammar);
      StringConcatenation _builder = new StringConcatenation();
      String _emitHeading3 = this.emitHeading3("Parser Rules", (this.labelPrefix + "ParserRules"));
      _builder.append(_emitHeading3);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("The parser rules define the parser mapping from parser tokens to generalized concrete syntax elements.");
      _builder.newLine();
      {
        for(final ParserRule parserRule : parserRules) {
          _builder.newLine();
          String _name = parserRule.getName();
          String _name_1 = parserRule.getName();
          String _plus = ((this.labelPrefix + "ParserRule:") + _name_1);
          String _emitHeading4 = this.emitHeading4(_name, _plus);
          _builder.append(_emitHeading4);
          _builder.newLineIfNotEmpty();
          String _emitComment = this.emitComment(parserRule);
          _builder.append(_emitComment);
          _builder.newLineIfNotEmpty();
          _builder.append("Token type: ");
          String _emitTypeRef = this.emitTypeRef(parserRule.getType());
          _builder.append(_emitTypeRef);
          _builder.newLineIfNotEmpty();
          String _emitAllTT = this.emitAllTT(this.emitAbstractElement(parserRule.getAlternatives(), true));
          _builder.append(_emitAllTT);
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitParserRules(final org.eclipse.ocl.pivot.Class asClass, final Grammar grammar) {
    CharSequence _xblockexpression = null;
    {
      List<ParserRule> parserRules = this.getSortedParserRules(asClass, grammar);
      CharSequence _xifexpression = null;
      int _size = parserRules.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        {
          int _size_1 = parserRules.size();
          boolean _greaterThan_1 = (_size_1 > 1);
          if (_greaterThan_1) {
            String _emitHeading0a = this.emitHeading0a("Parser Rules");
            _builder.append(_emitHeading0a);
            _builder.newLineIfNotEmpty();
          } else {
            String _emitHeading0a_1 = this.emitHeading0a("Parser Rule");
            _builder.append(_emitHeading0a_1);
            _builder.newLineIfNotEmpty();
          }
        }
        {
          for(final ParserRule parserRule : parserRules) {
            {
              int _size_2 = parserRules.size();
              boolean _greaterThan_2 = (_size_2 > 1);
              if (_greaterThan_2) {
                String _emitHeading0b = this.emitHeading0b(parserRule.getName());
                _builder.append(_emitHeading0b);
                _builder.newLineIfNotEmpty();
              }
            }
            String _emitComment = this.emitComment(parserRule);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
            String _emitRuleDef = this.emitRuleDef(parserRule);
            String _plus = (_emitRuleDef + " ::=\n");
            String _trim = this.emitAbstractElement(parserRule.getAlternatives(), true).trim();
            String _emitAllTT = this.emitAllTT((_plus + _trim).replace("\n", "\n  "));
            _builder.append(_emitAllTT);
            _builder.newLineIfNotEmpty();
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitSuperclasses(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<org.eclipse.ocl.pivot.Class> asSuperClasses = asClass.getSuperClasses();
      CharSequence _xifexpression = null;
      int _size = asSuperClasses.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        String _emitHeading0a = this.emitHeading0a("Superclasses");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        {
          boolean _hasElements = false;
          for(final org.eclipse.ocl.pivot.Class asSuperClass : asSuperClasses) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "\t");
            }
            String _emitClassRef = this.emitClassRef(asSuperClass);
            _builder.append(_emitClassRef, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitTerminalRules(final Grammar grammar) {
    CharSequence _xblockexpression = null;
    {
      List<TerminalRule> terminalRules = this.getSortedTerminalRules(grammar);
      StringConcatenation _builder = new StringConcatenation();
      String _emitHeading3 = this.emitHeading3("Terminal Rules", (this.labelPrefix + "TerminalRules"));
      _builder.append(_emitHeading3);
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("The terminal rules define the lexer mapping from character sequences to parser tokens.");
      _builder.newLine();
      {
        for(final TerminalRule terminalRule : terminalRules) {
          _builder.newLine();
          String _name = terminalRule.getName();
          String _name_1 = terminalRule.getName();
          String _plus = ((this.labelPrefix + "TerminalRule:") + _name_1);
          String _emitHeading4 = this.emitHeading4(_name, _plus);
          _builder.append(_emitHeading4);
          _builder.newLineIfNotEmpty();
          String _emitComment = this.emitComment(terminalRule);
          _builder.append(_emitComment);
          _builder.newLineIfNotEmpty();
          _builder.append("Token type: ");
          String _emitTypeRef = this.emitTypeRef(terminalRule.getType());
          _builder.append(_emitTypeRef);
          _builder.newLineIfNotEmpty();
          String _emitAllTT = this.emitAllTT(this.emitAbstractElement(terminalRule.getAlternatives(), true));
          _builder.append(_emitAllTT);
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected String emitTypeRef(final TypeRef typeRef) {
    if ((Objects.equal(typeRef.getMetamodel().getAlias(), "ecore") && Objects.equal(typeRef.getClassifier().getName(), "EString"))) {
      return "String";
    } else {
      if ((Objects.equal(typeRef.getMetamodel().getAlias(), "ecore") && Objects.equal(typeRef.getClassifier().getName(), "EInt"))) {
        return "Integer";
      } else {
        String _alias = typeRef.getMetamodel().getAlias();
        boolean _tripleEquals = (_alias == null);
        if (_tripleEquals) {
          return typeRef.getClassifier().getName();
        } else {
          String _alias_1 = typeRef.getMetamodel().getAlias();
          String _plus = (_alias_1 + "::");
          String _name = typeRef.getClassifier().getName();
          return (_plus + _name);
        }
      }
    }
  }
}
