/**
 * Copyright (c) 2014 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     E.D.Willink - initial API and implementation
 */
package org.eclipse.ocl.examples.build.latex;

import java.util.List;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class GenerateLaTeXForASModelXtend extends GenerateLaTeXForASModel {
  /**
   * @NonNull
   */
  @Override
  protected String generateLaTeX(final org.eclipse.ocl.pivot.Package asPackage) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _emitClasses = this.emitClasses(asPackage);
    _builder.append(_emitClasses);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected CharSequence emitAssociations(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Property> asAssociations = this.getSortedAssociations(asClass);
      CharSequence _xifexpression = null;
      int _size = asAssociations.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _emitHeading0a = this.emitHeading0a("Associations");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        {
          for(final Property asAssociation : asAssociations) {
            _builder.newLine();
            String _emitHeading0b = this.emitHeading0b(this.prettyPrint(asAssociation, asClass));
            _builder.append(_emitHeading0b);
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asAssociation, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitAttributes(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Property> asAttributes = this.getSortedAttributes(asClass);
      CharSequence _xifexpression = null;
      int _size = asAttributes.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _emitHeading0a = this.emitHeading0a("Attributes");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        {
          for(final Property asAttribute : asAttributes) {
            _builder.newLine();
            String _emitHeading0b = this.emitHeading0b(this.prettyPrint(asAttribute, asClass));
            _builder.append(_emitHeading0b);
            _builder.newLineIfNotEmpty();
            CharSequence _emitComment = this.emitComment(asAttribute, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitClasses(final org.eclipse.ocl.pivot.Package asPackage) {
    CharSequence _xblockexpression = null;
    {
      List<org.eclipse.ocl.pivot.Class> asClasses = this.getSortedClasses(asPackage);
      StringConcatenation _builder = new StringConcatenation();
      {
        for(final org.eclipse.ocl.pivot.Class asClass : asClasses) {
          _builder.newLine();
          String _emitHeading3 = this.emitHeading3(this.prettyPrint(asClass, asClass), asClass.getName());
          _builder.append(_emitHeading3);
          _builder.newLineIfNotEmpty();
          CharSequence _emitComment = this.emitComment(asClass, asClass);
          _builder.append(_emitComment);
          _builder.newLineIfNotEmpty();
          {
            int _size = asClass.getSuperClasses().size();
            boolean _greaterThan = (_size > 0);
            if (_greaterThan) {
              _builder.newLine();
              _builder.append("conformsTo ");
              {
                List<org.eclipse.ocl.pivot.Class> _superClasses = asClass.getSuperClasses();
                boolean _hasElements = false;
                for(final org.eclipse.ocl.pivot.Class asSuperClass : _superClasses) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  String _prettyPrint = this.prettyPrint(asSuperClass, asSuperClass);
                  _builder.append(_prettyPrint);
                }
              }
              _builder.newLineIfNotEmpty();
            }
          }
          CharSequence _emitAttributes = this.emitAttributes(asClass);
          _builder.append(_emitAttributes);
          _builder.newLineIfNotEmpty();
          CharSequence _emitAssociations = this.emitAssociations(asClass);
          _builder.append(_emitAssociations);
          _builder.newLineIfNotEmpty();
          CharSequence _emitOperations = this.emitOperations(asClass);
          _builder.append(_emitOperations);
          _builder.newLineIfNotEmpty();
        }
      }
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  protected CharSequence emitComment(final Element asElement, final Namespace asNamespace) {
    CharSequence _xifexpression = null;
    int _size = asElement.getOwnedComments().size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      StringConcatenation _builder = new StringConcatenation();
      {
        List<Comment> _ownedComments = asElement.getOwnedComments();
        for(final Comment asComment : _ownedComments) {
          _builder.newLine();
          String _prettyPrint = this.prettyPrint(asComment, asNamespace);
          _builder.append(_prettyPrint);
          _builder.newLineIfNotEmpty();
        }
      }
      _xifexpression = _builder;
    }
    return _xifexpression;
  }
  
  protected CharSequence emitOperations(final org.eclipse.ocl.pivot.Class asClass) {
    CharSequence _xblockexpression = null;
    {
      List<Operation> asOperations = this.getSortedOperations(asClass);
      CharSequence _xifexpression = null;
      int _size = asOperations.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        String _emitHeading0a = this.emitHeading0a("Operations");
        _builder.append(_emitHeading0a);
        _builder.newLineIfNotEmpty();
        {
          for(final Operation asOperation : asOperations) {
            _builder.newLine();
            String _emitHeading0b = this.emitHeading0b(this.prettyPrint(asOperation, asClass));
            _builder.append(_emitHeading0b);
            _builder.newLineIfNotEmpty();
            {
              Precedence _precedence = asOperation.getPrecedence();
              boolean _tripleNotEquals = (_precedence != null);
              if (_tripleNotEquals) {
                _builder.newLine();
                _builder.append("\t");
                _builder.append("precedence: ");
                String _emitHeading0b_1 = this.emitHeading0b(asOperation.getPrecedence().getName());
                _builder.append(_emitHeading0b_1, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
            CharSequence _emitComment = this.emitComment(asOperation, asClass);
            _builder.append(_emitComment);
            _builder.newLineIfNotEmpty();
            {
              List<Constraint> _sortedPreconditions = this.getSortedPreconditions(asOperation);
              for(final Constraint asConstraint : _sortedPreconditions) {
                String _emitBeginDefinition = this.emitBeginDefinition();
                _builder.append(_emitBeginDefinition);
                _builder.newLineIfNotEmpty();
                String _prettyPrint = this.prettyPrint(asConstraint, asClass);
                _builder.append(_prettyPrint);
                _builder.newLineIfNotEmpty();
                String _emitEndDefinition = this.emitEndDefinition();
                _builder.append(_emitEndDefinition);
                _builder.newLineIfNotEmpty();
              }
            }
            {
              LanguageExpression _bodyExpression = asOperation.getBodyExpression();
              boolean _tripleNotEquals_1 = (_bodyExpression != null);
              if (_tripleNotEquals_1) {
                String _emitBeginDefinition_1 = this.emitBeginDefinition();
                _builder.append(_emitBeginDefinition_1);
                _builder.newLineIfNotEmpty();
                _builder.append("body: ");
                String _body = asOperation.getBodyExpression().getBody();
                _builder.append(_body);
                _builder.newLineIfNotEmpty();
                String _emitEndDefinition_1 = this.emitEndDefinition();
                _builder.append(_emitEndDefinition_1);
                _builder.newLineIfNotEmpty();
              }
            }
            {
              List<Constraint> _sortedPostconditions = this.getSortedPostconditions(asOperation);
              for(final Constraint asConstraint_1 : _sortedPostconditions) {
                String _emitBeginDefinition_2 = this.emitBeginDefinition();
                _builder.append(_emitBeginDefinition_2);
                _builder.newLineIfNotEmpty();
                String _prettyPrint_1 = this.prettyPrint(asConstraint_1, asClass);
                _builder.append(_prettyPrint_1);
                _builder.newLineIfNotEmpty();
                String _emitEndDefinition_2 = this.emitEndDefinition();
                _builder.append(_emitEndDefinition_2);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
