/*******************************************************************************
 * Copyright (c) 2013, 2019 Willink Transformations and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.examples.build.genmodel;

import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenClassGeneratorAdapter;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.codegen.genmodel.OCLGenModelUtil;

//
//	Overridden to allow static templates to be invoked standalone.
//
public class OCLBuildGenClassGeneratorAdapter extends GenClassGeneratorAdapter
{
	public OCLBuildGenClassGeneratorAdapter(GeneratorAdapterFactory generatorAdapterFactory) {
		super(generatorAdapterFactory);
	}

	//
	//	Overridden to provide a super toString() wherever GenModel would have autogenerated one.
	//
	@Override
	protected void generateClass(GenClass genClass, Monitor monitor) {
		GenModel genModel = genClass.getGenModel();
		GenAnnotation genAnnotation = genModel.getGenAnnotation(OCLGenModelUtil.OCL_GENMODEL_TO_STRING_URI);
		if (genAnnotation != null) {
			if (genModel.isOperationReflection()) {
				throw new RuntimeException("OperationReflection must be false to use ToString GenAnnotation, since EObject operations are not eInvokeable");
			}
			String interfaceName = genClass.getQualifiedInterfaceName();
			String body = genAnnotation.getDetails().get(interfaceName);
			boolean getsToString = !genClass.getToStringGenFeatures().isEmpty();
			boolean hasToString = genClass.hasImplementedToStringGenOperation();
			if ((body != null) || (getsToString && !hasToString)) {
				EOperation eOp = EcoreFactory.eINSTANCE.createEOperation();
				eOp.setName("toString");
				eOp.setEType(EcorePackage.Literals.ESTRING);
				EcoreUtil.setAnnotation(eOp, GenModelPackage.eNS_URI, "body", body != null ? body : "return super.toString();");
				GenOperation genOp = GenModelFactory.eINSTANCE.createGenOperation();
				genOp.setEcoreOperation(eOp);
				genClass.getGenOperations().add(genOp);
				EcoreUtil.setSuppressedVisibility(eOp, true);	// Don't need toString() in interface
			}
		}
		super.generateClass(genClass, monitor);
	}
}
