/*
 * generated by Xtext 2.21.0
 */
package org.xtext.example.textual.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.xtext.example.textual.services.TextualGrammarAccess;
import org.xtext.example.textual.textual.Area;
import org.xtext.example.textual.textual.DarkArea;
import org.xtext.example.textual.textual.Forest;
import org.xtext.example.textual.textual.InitialArea;
import org.xtext.example.textual.textual.InitialPath;
import org.xtext.example.textual.textual.InternalPath;
import org.xtext.example.textual.textual.Path;
import org.xtext.example.textual.textual.PathElements;
import org.xtext.example.textual.textual.SpecialArea;
import org.xtext.example.textual.textual.SpecialAreaPath;
import org.xtext.example.textual.textual.Stop;
import org.xtext.example.textual.textual.TextualPackage;

@SuppressWarnings("all")
public class TextualSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private TextualGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == TextualPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case TextualPackage.AREA:
				sequence_Area(context, (Area) semanticObject); 
				return; 
			case TextualPackage.DARK_AREA:
				sequence_DarkArea(context, (DarkArea) semanticObject); 
				return; 
			case TextualPackage.FOREST:
				sequence_Forest(context, (Forest) semanticObject); 
				return; 
			case TextualPackage.INITIAL_AREA:
				sequence_InitialArea(context, (InitialArea) semanticObject); 
				return; 
			case TextualPackage.INITIAL_PATH:
				sequence_InitialPath(context, (InitialPath) semanticObject); 
				return; 
			case TextualPackage.INTERNAL_PATH:
				sequence_InternalPath(context, (InternalPath) semanticObject); 
				return; 
			case TextualPackage.PATH:
				sequence_Path(context, (Path) semanticObject); 
				return; 
			case TextualPackage.PATH_ELEMENTS:
				sequence_PathElements(context, (PathElements) semanticObject); 
				return; 
			case TextualPackage.SPECIAL_AREA:
				sequence_SpecialArea(context, (SpecialArea) semanticObject); 
				return; 
			case TextualPackage.SPECIAL_AREA_PATH:
				sequence_SpecialAreaPath(context, (SpecialAreaPath) semanticObject); 
				return; 
			case TextualPackage.STOP:
				sequence_Stop(context, (Stop) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Area returns Area
	 *     Location returns Area
	 *
	 * Constraint:
	 *     (
	 *         name=ID 
	 *         internalpath+=InternalPath* 
	 *         (areas+=Area areas+=Area*)* 
	 *         initialpath+=InitialPath* 
	 *         (darkarea+=DarkArea darkarea+=DarkArea*)* 
	 *         (path+=Path | specialareapath+=SpecialAreaPath)*
	 *     )
	 */
	protected void sequence_Area(ISerializationContext context, Area semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     DarkArea returns DarkArea
	 *     Location returns DarkArea
	 *
	 * Constraint:
	 *     name=ID
	 */
	protected void sequence_DarkArea(ISerializationContext context, DarkArea semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, TextualPackage.Literals.LOCATION__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TextualPackage.Literals.LOCATION__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDarkAreaAccess().getNameIDTerminalRuleCall_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Forest returns Forest
	 *
	 * Constraint:
	 *     (name=ID (areas+=Area areas+=Area*)* initialpath=InitialPath? (darkarea+=DarkArea darkarea+=DarkArea*)* path+=Path*)
	 */
	protected void sequence_Forest(ISerializationContext context, Forest semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     InitialArea returns InitialArea
	 *
	 * Constraint:
	 *     name='initial'
	 */
	protected void sequence_InitialArea(ISerializationContext context, InitialArea semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, TextualPackage.Literals.INITIAL_AREA__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TextualPackage.Literals.INITIAL_AREA__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getInitialAreaAccess().getNameInitialKeyword_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     InitialPath returns InitialPath
	 *     Paths returns InitialPath
	 *
	 * Constraint:
	 *     (name=ID? initialarea=InitialArea initialto=[Location|QualifiedName] pathelements=PathElements)
	 */
	protected void sequence_InitialPath(ISerializationContext context, InitialPath semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     InternalPath returns InternalPath
	 *
	 * Constraint:
	 *     (name=ID? pathelements=PathElements)
	 */
	protected void sequence_InternalPath(ISerializationContext context, InternalPath semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PathElements returns PathElements
	 *
	 * Constraint:
	 *     (stop=Stop? stop=Stop*)
	 */
	protected void sequence_PathElements(ISerializationContext context, PathElements semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Path returns Path
	 *     Paths returns Path
	 *
	 * Constraint:
	 *     ((name=ID | name=STRING)? from=[Location|QualifiedName] to=[Location|QualifiedName] pathelements=PathElements)
	 */
	protected void sequence_Path(ISerializationContext context, Path semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     SpecialAreaPath returns SpecialAreaPath
	 *     Paths returns SpecialAreaPath
	 *
	 * Constraint:
	 *     ((name=ID | name=STRING)? from=[Location|QualifiedName] to=SpecialArea pathelements=PathElements)
	 */
	protected void sequence_SpecialAreaPath(ISerializationContext context, SpecialAreaPath semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     SpecialArea returns SpecialArea
	 *
	 * Constraint:
	 *     name='specialarea'
	 */
	protected void sequence_SpecialArea(ISerializationContext context, SpecialArea semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, TextualPackage.Literals.SPECIAL_AREA__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TextualPackage.Literals.SPECIAL_AREA__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSpecialAreaAccess().getNameSpecialareaKeyword_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Stop returns Stop
	 *
	 * Constraint:
	 *     name=STRING
	 */
	protected void sequence_Stop(ISerializationContext context, Stop semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, TextualPackage.Literals.STOP__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TextualPackage.Literals.STOP__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStopAccess().getNameSTRINGTerminalRuleCall_2_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
}
