package org.home.experiments.hawk;

import java.io.File;
import java.util.Collections;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.etl.EtlModule;

public class ExamplePlainETL {

	public static void main(String[] args) throws Exception {
		new ExamplePlainETL();
	}

	public ExamplePlainETL() throws Exception {
		EMFUtil util = new EMFUtil();
		
		Resource rcompany = util.getResourceSet().createResource(URI.createFileURI("metamodels/company.ecore"));
		Resource rcompanyTab = util.getResourceSet().createResource(URI.createFileURI("metamodels/companyTab.ecore"));
		rcompany.load(Collections.EMPTY_MAP);
		rcompanyTab.load(Collections.EMPTY_MAP);
		
		util.registerPackage(rcompanyTab);
		util.registerPackage(rcompany);

		EmfModel inModel = new EmfModel();
		inModel.setMetamodelUri("https://www.home.org/company");
		inModel.setModelFile("models/company-1.model");
		inModel.setName("IN");
		inModel.setReadOnLoad(true);
		inModel.setStoredOnDisposal(false);
		inModel.load();

		EmfModel outModel = new EmfModel();
		outModel.setMetamodelUri("https://www.home.org/companyTab");
		outModel.setModelFile("models/companyTab-1.model");
		outModel.setName("OUT");
		outModel.setReadOnLoad(false);
		outModel.setStoredOnDisposal(true);
		outModel.load();

		EtlModule module = new EtlModule();
		module.parse(new File("transformation/company.etl"));
		module.getContext().getModelRepository().addModel(outModel);
		module.getContext().getModelRepository().addModel(inModel);
		module.execute();

		inModel.dispose();
		inModel.close();

		outModel.dispose();
		outModel.close();

	}
}
