package org.home.experiments.hawk;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.EtlModule;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.core.runtime.ModelIndexerImpl;
import org.eclipse.hawk.core.security.FileBasedCredentialsStore;
import org.eclipse.hawk.core.util.DefaultConsole;
import org.eclipse.hawk.emf.metamodel.EMFMetaModelResourceFactory;
import org.eclipse.hawk.emf.model.EMFModelResourceFactory;
import org.eclipse.hawk.emfresource.HawkResource;
import org.eclipse.hawk.emfresource.impl.LocalHawkResourceImpl;
import org.eclipse.hawk.epsilon.emc.AbstractHawkModel;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.graph.updater.GraphMetaModelUpdater;
import org.eclipse.hawk.graph.updater.GraphModelUpdater;
import org.eclipse.hawk.greycat.LevelDBGreycatDatabase;
import org.eclipse.hawk.localfolder.LocalFolder;

public class ExampleHawk {

	protected DefaultConsole console;
	protected IModelIndexer indexer;
	protected EOLQueryEngine queryEngine;
	protected IGraphDatabase db;

	protected File baseDir;

	public static void main(String[] args) throws Exception {
		new ExampleHawk();
	}

	public ExampleHawk() throws Exception {
		setupHawk();
		transform();
	}

	private void transform() throws Exception {
		List<String> patterns = new ArrayList<>();
		patterns.add("*");

		/* setup for transformation */
		ResourceSet rs = new ResourceSetImpl();

		LocalHawkResourceImpl resource = new LocalHawkResourceImpl(URI.createURI("models"), indexer, false, patterns, patterns);
		resource.basicSetResourceSet(rs, null);
		resource.load(Collections.EMPTY_MAP);

		EMFUtil util = new EMFUtil();
		
		Resource rcompanyTab = util.getResourceSet().createResource(URI.createFileURI("metamodels/companyTab.ecore"));
		rcompanyTab.load(Collections.EMPTY_MAP);
		
		util.registerPackage(rcompanyTab);

		IModel inModel = (IModel)indexer.getKnownQueryLanguages().get(EOLQueryEngine.class.getName());
		inModel.setName("IN");

		EmfModel outModel = new EmfModel();
		outModel.setMetamodelUri("https://www.home.org/companyTab");
		outModel.setModelFile("models/companyTab-1.model");
		outModel.setName("OUT");
		outModel.setReadOnLoad(false);
		outModel.setStoredOnDisposal(true);
		outModel.load();

		EtlModule module = new EtlModule();
		module.parse(new File("transformation/company.etl"));
		module.getContext().getModelRepository().addModel(outModel);
		module.getContext().getModelRepository().addModel(inModel);
		module.execute();

		inModel.dispose();
		inModel.close();

		outModel.dispose();
		outModel.close();
	}

	private void setupHawk() throws Exception {
		/* setup hawk and load */
		File indexedFolder = new File("indexerFolder/");
		File dbFolder = new File(indexedFolder + "dbFolder/");
		dbFolder.mkdir();

		db = new LevelDBGreycatDatabase();
		queryEngine = new EOLQueryEngine();

		console = new DefaultConsole();
		db.run(dbFolder, console);

		FileBasedCredentialsStore credStore = new FileBasedCredentialsStore(new File("keystore"), "admin".toCharArray());

		indexer = new ModelIndexerImpl("models", indexedFolder, credStore, console);
		indexer.addMetaModelResourceFactory(new EMFMetaModelResourceFactory());
		indexer.addModelResourceFactory(new EMFModelResourceFactory());

		indexer.setMetaModelUpdater(new GraphMetaModelUpdater());
		indexer.addModelUpdater(new GraphModelUpdater());

		indexer.setDB(db, true);

		indexer.registerMetamodels(new File("metamodels/company.ecore"));
		indexer.addQueryEngine(queryEngine);
		indexer.addIndexedAttribute("https://www.home.org/company", "Company", "name");
		indexer.init(0, 0);

		LocalFolder folder = new LocalFolder();
		folder.init(new File("models/").getCanonicalPath(), indexer);
		folder.run();
		indexer.addVCSManager(folder, true);
		
		Thread.sleep(5000); /* TODO improve */
	}
}
