package org.home.experiments.hawk;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.Resource.Factory.Registry;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class EMFUtil {

	private ResourceSet resourceSet = new ResourceSetImpl();

	public EMFUtil() {
		Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
		Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
		Registry.INSTANCE.getExtensionToFactoryMap().put("model", new EcoreResourceFactoryImpl());
		
		org.eclipse.emf.ecore.EPackage.Registry.INSTANCE.put(EcorePackage.eINSTANCE.getNsURI(), EcorePackage.eINSTANCE);
	}

	public EPackage registerPackage(Resource resource) {
		EPackage pkg = (EPackage)resource.getContents().get(0);
		registerPackage(pkg);
		return pkg;
	}

	public void registerPackage(EPackage pkg) {
		if(EPackage.Registry.INSTANCE.get(pkg.getNsURI()) == null) {
			EPackage.Registry.INSTANCE.put(pkg.getNsURI(), pkg);
			for (EPackage npkg : pkg.getESubpackages()) {
				registerPackage(npkg);
			}			
		}
	}

	public ResourceSet getResourceSet() {
		return resourceSet;
	}

}
