/*
 * Decompiled with CFR 0.152.
 */
package com.sixgroup.experiments.hawk;

import java.io.File;
import java.util.Collection;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IMetaModelUpdater;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.runtime.ModelIndexerImpl;
import org.eclipse.hawk.core.security.FileBasedCredentialsStore;
import org.eclipse.hawk.core.util.DefaultConsole;
import org.eclipse.hawk.emf.metamodel.EMFMetaModelResourceFactory;
import org.eclipse.hawk.emf.model.EMFModelResourceFactory;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.graph.updater.GraphMetaModelUpdater;
import org.eclipse.hawk.graph.updater.GraphModelUpdater;
import org.eclipse.hawk.greycat.LevelDBGreycatDatabase;
import org.eclipse.hawk.localfolder.LocalFolder;

public class Example00 {
    protected DefaultConsole console;
    protected IModelIndexer indexer;
    protected EOLQueryEngine queryEngine;
    protected IGraphDatabase db;
    protected File baseDir;

    public static void main(String[] args) throws Exception {
        new Example00();
    }

    public Example00() throws Exception {
        File indexedFolder = new File("indexerFolder/");
        File dbFolder = new File(indexedFolder + "dbFolder/");
        dbFolder.mkdir();
        this.db = new LevelDBGreycatDatabase();
        this.queryEngine = new EOLQueryEngine();
        this.console = new DefaultConsole();
        this.db.run(dbFolder, (IConsole)this.console);
        FileBasedCredentialsStore credStore = new FileBasedCredentialsStore(new File("keystore"), "admin".toCharArray());
        this.indexer = new ModelIndexerImpl("models", indexedFolder, (ICredentialsStore)credStore, (IConsole)this.console);
        this.indexer.addMetaModelResourceFactory((IMetaModelResourceFactory)new EMFMetaModelResourceFactory());
        this.indexer.addModelResourceFactory((IModelResourceFactory)new EMFModelResourceFactory());
        this.indexer.setMetaModelUpdater((IMetaModelUpdater)new GraphMetaModelUpdater());
        this.indexer.addModelUpdater((IModelUpdater)new GraphModelUpdater());
        this.indexer.setDB(this.db, true);
        this.indexer.registerMetamodels(new File[]{new File("metamodels/company.ecore")});
        this.indexer.addQueryEngine((IQueryEngine)this.queryEngine);
        this.indexer.addIndexedAttribute("https://www.home.org/company", "Company", "name");
        this.indexer.init(0, 0);
        LocalFolder folder = new LocalFolder();
        folder.init(new File("models/").getCanonicalPath(), this.indexer);
        folder.run();
        this.indexer.addVCSManager((IVcsManager)folder, true);
        this.indexer.scheduleTask(() -> {
            Object res = this.queryEngine.query(this.indexer, "return Company.all.println();", null);
            return null;
        }, 1000L);
        Collection r = this.indexer.getIndexes();
        boolean a = false;
    }
}

