/*
 *************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *  
 *************************************************************************
 */

package org.eclipse.birt.data.oda.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.data.oda.IResultSet;
import org.eclipse.birt.data.oda.IResultSetMetaData;
import org.eclipse.birt.data.oda.OdaException;

/**
 * Default implementation of IResultSet for a simple ODA runtime driver.
 */
public class SimpleResultSet implements IResultSet {
	private int m_maxRows;

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getMetaData()
	 */
	public IResultSetMetaData getMetaData() throws OdaException {
		return new SimpleResultSetMetaData();
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#setMaxRows(int)
	 */
	public void setMaxRows(int max) throws OdaException {
		m_maxRows = max;
	}

	/**
	 * Returns the maximum number of rows that can be fetched from this result
	 * set.
	 * 
	 * @return the maximum number of rows to fetch.
	 */
	protected int getMaxRows() {
		return m_maxRows;
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#next()
	 */
	public boolean next() throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#close()
	 */
	public void close() throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getRow()
	 */
	public int getRow() throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getString(int)
	 */
	public String getString(int index) throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	public byte[] getBytes(int index) throws OdaException {
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getString(java.lang.String)
	 */
	public String getString(String columnName) throws OdaException {
		return getString(findColumn(columnName));
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getInt(int)
	 */
	public int getInt(int index) throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getInt(java.lang.String)
	 */
	public int getInt(String columnName) throws OdaException {
		return getInt(findColumn(columnName));
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getDouble(int)
	 */
	public double getDouble(int index) throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getDouble(java.lang.String)
	 */
	public double getDouble(String columnName) throws OdaException {
		return getDouble(findColumn(columnName));
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getBigDecimal(int)
	 */
	public BigDecimal getBigDecimal(int index) throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getBigDecimal(java.lang.String)
	 */
	public BigDecimal getBigDecimal(String columnName) throws OdaException {
		return getBigDecimal(findColumn(columnName));
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getDate(int)
	 */
	public Date getDate(int index) throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getDate(java.lang.String)
	 */
	public Date getDate(String columnName) throws OdaException {
		return getDate(findColumn(columnName));
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getTime(int)
	 */
	public Time getTime(int index) throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getTime(java.lang.String)
	 */
	public Time getTime(String columnName) throws OdaException {
		return getTime(findColumn(columnName));
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getTimestamp(int)
	 */
	public Timestamp getTimestamp(int index) throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#getTimestamp(java.lang.String)
	 */
	public Timestamp getTimestamp(String columnName) throws OdaException {
		return getTimestamp(findColumn(columnName));
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#wasNull()
	 */
	public boolean wasNull() throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}

	/**
	 * @see org.eclipse.birt.data.oda.IResultSet#findColumn(java.lang.String)
	 */
	public int findColumn(String columnName) throws OdaException {
		// TODO data source dependent
		throw new UnsupportedOperationException(
				"Please override and implement me.");
	}
}
