package fr.liglab.vasco;

import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;

import metamodel.Entity;
import metamodel.MetamodelFactory;
import metamodel.Model;

public class Launcher {
	
	/**
	 * Validates a model using the OCL in ecore.
	 */
	public static Diagnostic validate(Model model) {	
		return Diagnostician.INSTANCE.validate(model);
	}
	
	public static void main(String[] args) {
		
		/*
		 * Activate OCL delegation
		 */
		EssentialOCLStandaloneSetup.doSetup();
		
		/*
		 * Create a valid model
		 */
		Model model = MetamodelFactory.eINSTANCE.createModel();
		Entity entity = MetamodelFactory.eINSTANCE.createEntity();
		entity.setName("Good");
		model.getEntities().add(entity);
				
		Diagnostic diagnostic = validate(model);
		System.out.println(message(diagnostic));
		assert diagnostic.getSeverity() == Diagnostic.OK;

		model = MetamodelFactory.eINSTANCE.createModel();
		entity = MetamodelFactory.eINSTANCE.createEntity();
		entity.setName("Bad");
		model.getEntities().add(entity);
				
		diagnostic = validate(model);
		System.out.println(message(diagnostic));
		assert diagnostic.getSeverity() == Diagnostic.ERROR;

	}

	private static final String message(Diagnostic diagnostic) {
		return message("",diagnostic);
	}
	
	private static final String message(String indent, Diagnostic diagnostic) {
		StringBuilder result = new StringBuilder();
		
		result.append(indent);
		result.append(diagnostic.getSeverity());
		result.append("-");
		result.append(diagnostic.getMessage());

		if (diagnostic.getException() != null) {
			result.append(" exception : ").append(diagnostic.getException().getLocalizedMessage());
		}

		result.append("[");
		boolean first = true;
		for (Object data : optional(diagnostic.getData())) {
			if (!first) {
				result.append(",");
			}
			result.append(data.toString());
			first = false;
		}
		result.append("]");
		
		
		result.append("\n").append(indent).append("{").append("\n");

		for (Diagnostic child : optional(diagnostic.getChildren())) {
			result.append(message(indent+"  ",child)).append("\n");
		}
		
		result.append(indent).append("}\n");
		return result.toString();
	}
	
	private static final <T>  List<T> optional(List<T> nullable) {
		return nullable != null ? nullable : Collections.emptyList();
	}
}
