/*
 * Decompiled with CFR 0.152.
 */
package com.insomniq.eclipse.jdt;

import com.insomniq.eclipse.jdt.LibContainer;
import com.insomniq.eclipse.jdt.LibContainerInitializer;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.dialogs.ResourceSorter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LibContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IJavaProject javaProject;
    private StringButtonDialogField fPathField;
    private SelectionButtonDialogField fRecurseField;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public LibContainerPage() {
        super("LibContainerDefaultPage");
        this.setTitle(LibContainer.getResourceString("selectfolder.title"));
        this.setDescription(LibContainer.getResourceString("selectfolder.description"));
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fRecurseField = new SelectionButtonDialogField(32);
        this.fRecurseField.setLabelText(LibContainer.getResourceString("recursefolders"));
        LibFolderAdapter adapter = new LibFolderAdapter();
        this.fPathField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fPathField.setButtonLabel(LibContainer.getResourceString("browsefolder"));
        this.fPathField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fPathField.setLabelText(LibContainer.getResourceString("librarypath"));
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo status = new StatusInfo();
        String str = this.fPathField.getText();
        if (str.length() == 0) {
            status.setError(LibContainer.getResourceString("path.error.missing"));
        } else if (!Path.ROOT.isValidPath(str)) {
            status.setError(LibContainer.getResourceString("path.error.invalid"));
        } else {
            Path path = new Path(str);
            if (path.segmentCount() == 0) {
                status.setError(LibContainer.getResourceString("path.error.noroot"));
            }
        }
        this.updateStatus((IStatus)status);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.fPathField, this.fRecurseField}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.fPathField.getTextControl(null));
        this.fPathField.setFocus();
        this.setControl((Control)composite);
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        String libPath = this.fPathField.getText();
        boolean recurse = this.fRecurseField.getSelectionButton(null).getSelection();
        System.out.println("recurse:" + recurse);
        IPath containerPath = LibContainerInitializer.buildContainerPath(libPath, recurse);
        return JavaCore.newContainerEntry((IPath)containerPath);
    }

    public void setSelection(IClasspathEntry containerEntry) {
    }

    private IFolder chooseLibraryFolder() {
        Object o;
        IProject project = this.javaProject.getProject();
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IContainer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.core.resources.IFolder;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        IProject[] allProjects = root.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)project)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSelection = null;
        if (this.fPathField.getText() != null) {
            initSelection = project.findMember(this.fPathField.getText());
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(NewWizardMessages.getString((String)"OutputLocationDialog.ChooseOutputFolder.title"));
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(NewWizardMessages.getString((String)"OutputLocationDialog.ChooseOutputFolder.description"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)root);
        dialog.setInitialSelection((Object)initSelection);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0 && (o = dialog.getFirstResult()) instanceof IFolder) {
            return (IFolder)o;
        }
        return null;
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.javaProject = project;
    }

    private void buildPathChangeControlPressed(DialogField field) {
        IFolder container;
        if (field == this.fPathField && (container = this.chooseLibraryFolder()) != null) {
            String s = container.getFullPath().toString();
            s = s.substring(s.indexOf(47) + 1);
            s = s.substring(s.indexOf(47) + 1);
            this.fPathField.setText(s);
        }
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fPathField) {
            this.validatePath();
        }
    }

    private class LibFolderAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        LibFolderAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            LibContainerPage.this.buildPathChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            LibContainerPage.this.buildPathDialogFieldChanged(field);
        }
    }
}

