/*
 * Decompiled with CFR 0.152.
 */
package com.insomniq.eclipse.jdt;

import com.insomniq.eclipse.jdt.LibClasspathContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class LibContainerInitializer
extends ClasspathContainerInitializer {
    public static final String RECURSE = "recurse";
    public static final String FLAT = "flat";
    public static final String DEFAULT_FOLDER = "lib";

    public static IPath buildContainerPath(String libPath, boolean recurse) {
        StringBuffer sb = new StringBuffer();
        sb.append("com.insomniq.eclipse.jdt.LIB_CONTAINER");
        sb.append("/");
        sb.append(recurse ? RECURSE : FLAT);
        sb.append("/");
        sb.append(libPath);
        Path path = new Path(sb.toString());
        return path;
    }

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        int size = containerPath.segmentCount();
        if (size > 0 && containerPath.segment(0).equals("com.insomniq.eclipse.jdt.LIB_CONTAINER")) {
            String libPath = DEFAULT_FOLDER;
            boolean recurse = false;
            if (size > 1 && RECURSE.equals(containerPath.segment(1))) {
                recurse = true;
            }
            if (size > 2) {
                StringBuffer sb = new StringBuffer();
                String[] segments = containerPath.segments();
                int i = 2;
                while (i < segments.length) {
                    String segment = segments[i];
                    sb.append(segment);
                    if (i < segments.length - 1) {
                        sb.append("/");
                    }
                    ++i;
                }
                libPath = sb.toString();
            }
            LibClasspathContainer container = new LibClasspathContainer(javaProject, libPath, recurse);
            new Path("com.insomniq.eclipse.jdt.LIB_CONTAINER");
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
        javaProject.getProject().refreshLocal(1, null);
    }
}

