/*
 * Decompiled with CFR 0.152.
 */
package com.insomniq.eclipse.jdt;

import com.insomniq.eclipse.jdt.LibContainer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class LibClasspathContainer
implements IClasspathContainer {
    private IClasspathEntry[] entries = new IClasspathEntry[0];
    private IJavaProject project;
    private String libPath;
    private boolean recurse;
    public static final String CLASSPATH_CONTAINER_ID = "com.insomniq.eclipse.jdt.LIB_CONTAINER";

    public LibClasspathContainer(IJavaProject project, String libPath, boolean recurse) {
        this.project = project;
        this.libPath = libPath;
        this.recurse = recurse;
    }

    public void reset() {
        this.entries = new IClasspathEntry[0];
    }

    public IClasspathEntry[] getClasspathEntries() {
        try {
            ArrayList entryList = new ArrayList();
            IFolder libFolder = this.project.getResource().getWorkspace().getRoot().getFolder(this.project.getPath().append(this.libPath));
            this.addJars(entryList, libFolder);
            this.entries = new IClasspathEntry[entryList.size()];
            this.entries = entryList.toArray(this.entries);
            return this.entries;
        }
        catch (Exception ex) {
            LibContainer.log(ex);
            return new IClasspathEntry[0];
        }
    }

    private void addJars(List entryList, IFolder folder) {
        try {
            IResource[] jars = folder.members();
            int i = 0;
            while (i < jars.length) {
                IResource jar = jars[i];
                if (jar.getType() == 1) {
                    IClasspathEntry entry;
                    String ext = jar.getFileExtension();
                    if (ext != null && ((ext = ext.toLowerCase()).equals("jar") || ext.equals("zip")) && (entry = JavaCore.newLibraryEntry((IPath)jar.getLocation(), null, null)) != null) {
                        entryList.add(entry);
                    }
                } else if (jar.getType() == 2 && this.recurse) {
                    this.addJars(entryList, this.project.getResource().getWorkspace().getRoot().getFolder(jar.getFullPath()));
                }
                ++i;
            }
        }
        catch (CoreException ex) {
            LibContainer.log(ex, "Error adding folder " + folder);
            return;
        }
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append(LibContainer.getResourceString("decoration.description"));
        sb.append(" [");
        sb.append(this.libPath);
        sb.append("]");
        return sb.toString();
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return new Path(CLASSPATH_CONTAINER_ID);
    }
}

