/**
 */
package CarRental.util;

import CarRental.*;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see CarRental.CarRentalPackage
 * @generated
 */
public class CarRentalValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final CarRentalValidator INSTANCE = new CarRentalValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "CarRental";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CarRentalValidator() {
		super();
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return CarRentalPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case CarRentalPackage.PERSON:
				return validatePerson((Person)value, diagnostics, context);
			case CarRentalPackage.CUSTOMER:
				return validateCustomer((Customer)value, diagnostics, context);
			case CarRentalPackage.EMPLOYEE:
				return validateEmployee((Employee)value, diagnostics, context);
			case CarRentalPackage.BRANCH:
				return validateBranch((Branch)value, diagnostics, context);
			case CarRentalPackage.RENTAL:
				return validateRental((Rental)value, diagnostics, context);
			case CarRentalPackage.CAR_GROUP:
				return validateCarGroup((CarGroup)value, diagnostics, context);
			case CarRentalPackage.CAR:
				return validateCar((Car)value, diagnostics, context);
			case CarRentalPackage.SERVICE_DEPOT:
				return validateServiceDepot((ServiceDepot)value, diagnostics, context);
			case CarRentalPackage.CHECK:
				return validateCheck((Check)value, diagnostics, context);
			case CarRentalPackage.DATE:
				return validateDate((Date)value, diagnostics, context);
			case CarRentalPackage.CAR_GROUP_KIND:
				return validateCarGroupKind((CarGroupKind)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePerson(Person person, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(person, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(person, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(person, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(person, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(person, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(person, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(person, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(person, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(person, diagnostics, context);
		if (result || diagnostics != null) result &= validatePerson_Person3(person, diagnostics, context);
		return result;
	}

	/**
	 * Validates the Person3 constraint of '<em>Person</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePerson_Person3(Person person, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "Person3", getObjectLabel(person, context) },
						 new Object[] { person },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCustomer(Customer customer, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(customer, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(customer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(customer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(customer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(customer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(customer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(customer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(customer, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(customer, diagnostics, context);
		if (result || diagnostics != null) result &= validatePerson_Person3(customer, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEmployee(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(employee, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validatePerson_Person3(employee, diagnostics, context);
		if (result || diagnostics != null) result &= validateEmployee_Employee1(employee, diagnostics, context);
		return result;
	}

	/**
	 * Validates the Employee1 constraint of '<em>Employee</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEmployee_Employee1(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "Employee1", getObjectLabel(employee, context) },
						 new Object[] { employee },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBranch(Branch branch, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(branch, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validateBranch_Branch1(branch, diagnostics, context);
		if (result || diagnostics != null) result &= validateBranch_Branch2(branch, diagnostics, context);
		return result;
	}

	/**
	 * Validates the Branch1 constraint of '<em>Branch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBranch_Branch1(Branch branch, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "Branch1", getObjectLabel(branch, context) },
						 new Object[] { branch },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * Validates the Branch2 constraint of '<em>Branch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBranch_Branch2(Branch branch, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "Branch2", getObjectLabel(branch, context) },
						 new Object[] { branch },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateRental(Rental rental, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(rental, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(rental, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(rental, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(rental, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(rental, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(rental, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(rental, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(rental, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(rental, diagnostics, context);
		if (result || diagnostics != null) result &= validateRental_Rental2(rental, diagnostics, context);
		return result;
	}

	/**
	 * Validates the Rental2 constraint of '<em>Rental</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateRental_Rental2(Rental rental, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "Rental2", getObjectLabel(rental, context) },
						 new Object[] { rental },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCarGroup(CarGroup carGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(carGroup, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validateCarGroup_CarGroup1(carGroup, diagnostics, context);
		if (result || diagnostics != null) result &= validateCarGroup_CarGroup2(carGroup, diagnostics, context);
		return result;
	}

	/**
	 * Validates the CarGroup1 constraint of '<em>Car Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCarGroup_CarGroup1(CarGroup carGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "CarGroup1", getObjectLabel(carGroup, context) },
						 new Object[] { carGroup },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * Validates the CarGroup2 constraint of '<em>Car Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCarGroup_CarGroup2(CarGroup carGroup, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "CarGroup2", getObjectLabel(carGroup, context) },
						 new Object[] { carGroup },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCar(Car car, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(car, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(car, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(car, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(car, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(car, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(car, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(car, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(car, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(car, diagnostics, context);
		if (result || diagnostics != null) result &= validateCar_Car1(car, diagnostics, context);
		return result;
	}

	/**
	 * Validates the Car1 constraint of '<em>Car</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCar_Car1(Car car, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "Car1", getObjectLabel(car, context) },
						 new Object[] { car },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateServiceDepot(ServiceDepot serviceDepot, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(serviceDepot, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCheck(Check check, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(check, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDate(Date date, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(date, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(date, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(date, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(date, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(date, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(date, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(date, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(date, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(date, diagnostics, context);
		if (result || diagnostics != null) result &= validateDate_DateErrorException(date, diagnostics, context);
		return result;
	}

	/**
	 * Validates the DateErrorException constraint of '<em>Date</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDate_DateErrorException(Date date, DiagnosticChain diagnostics, Map<Object, Object> context) {
		// TODO implement the constraint
		// -> specify the condition that violates the constraint
		// -> verify the diagnostic details, including severity, code, and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics.add
					(createDiagnostic
						(Diagnostic.ERROR,
						 DIAGNOSTIC_SOURCE,
						 0,
						 "_UI_GenericConstraint_diagnostic",
						 new Object[] { "DateErrorException", getObjectLabel(date, context) },
						 new Object[] { date },
						 context));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCarGroupKind(CarGroupKind carGroupKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //CarRentalValidator
