/**
 */
package CarRental;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * <copyright>
 * 
 * Copyright (c) 2012 Willink Transformations and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 * E.D.Willink - Initial API and implementation
 * 
 * </copyright>
 * 
 * This Ecore file contains a number of problems for diagnosis as part of the Complete OCL Tutorial.
 * <!-- end-model-doc -->
 * @see CarRental.CarRentalFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/OCL/Import ecore='http://www.eclipse.org/emf/2002/Ecore'"
 * @generated
 */
public interface CarRentalPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "CarRental";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///CarRental.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "CarRental";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	CarRentalPackage eINSTANCE = CarRental.impl.CarRentalPackageImpl.init();

	/**
	 * The meta object id for the '{@link CarRental.impl.PersonImpl <em>Person</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.PersonImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getPerson()
	 * @generated
	 */
	int PERSON = 0;

	/**
	 * The feature id for the '<em><b>Firstname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON__FIRSTNAME = 0;

	/**
	 * The feature id for the '<em><b>Lastname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON__LASTNAME = 1;

	/**
	 * The feature id for the '<em><b>Age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON__AGE = 2;

	/**
	 * The feature id for the '<em><b>Is Married</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON__IS_MARRIED = 3;

	/**
	 * The feature id for the '<em><b>Full Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON__FULL_NAME = 4;

	/**
	 * The number of structural features of the '<em>Person</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON_FEATURE_COUNT = 5;

	/**
	 * The operation id for the '<em>Email</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON___EMAIL = 0;

	/**
	 * The operation id for the '<em>Update Age</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON___UPDATE_AGE__INT = 1;

	/**
	 * The number of operations of the '<em>Person</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON_OPERATION_COUNT = 2;

	/**
	 * The meta object id for the '{@link CarRental.impl.CustomerImpl <em>Customer</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.CustomerImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getCustomer()
	 * @generated
	 */
	int CUSTOMER = 1;

	/**
	 * The feature id for the '<em><b>Firstname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER__FIRSTNAME = PERSON__FIRSTNAME;

	/**
	 * The feature id for the '<em><b>Lastname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER__LASTNAME = PERSON__LASTNAME;

	/**
	 * The feature id for the '<em><b>Age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER__AGE = PERSON__AGE;

	/**
	 * The feature id for the '<em><b>Is Married</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER__IS_MARRIED = PERSON__IS_MARRIED;

	/**
	 * The feature id for the '<em><b>Full Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER__FULL_NAME = PERSON__FULL_NAME;

	/**
	 * The feature id for the '<em><b>Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER__ADDRESS = PERSON_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Rental</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER__RENTAL = PERSON_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Customer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER_FEATURE_COUNT = PERSON_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Email</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER___EMAIL = PERSON___EMAIL;

	/**
	 * The operation id for the '<em>Update Age</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER___UPDATE_AGE__INT = PERSON___UPDATE_AGE__INT;

	/**
	 * The number of operations of the '<em>Customer</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUSTOMER_OPERATION_COUNT = PERSON_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link CarRental.impl.EmployeeImpl <em>Employee</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.EmployeeImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getEmployee()
	 * @generated
	 */
	int EMPLOYEE = 2;

	/**
	 * The feature id for the '<em><b>Firstname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__FIRSTNAME = PERSON__FIRSTNAME;

	/**
	 * The feature id for the '<em><b>Lastname</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__LASTNAME = PERSON__LASTNAME;

	/**
	 * The feature id for the '<em><b>Age</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__AGE = PERSON__AGE;

	/**
	 * The feature id for the '<em><b>Is Married</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__IS_MARRIED = PERSON__IS_MARRIED;

	/**
	 * The feature id for the '<em><b>Full Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__FULL_NAME = PERSON__FULL_NAME;

	/**
	 * The feature id for the '<em><b>Salary</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__SALARY = PERSON_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Managed Branch</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__MANAGED_BRANCH = PERSON_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Employer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__EMPLOYER = PERSON_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Max Salary</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE__MAX_SALARY = PERSON_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Employee</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE_FEATURE_COUNT = PERSON_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Email</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE___EMAIL = PERSON___EMAIL;

	/**
	 * The operation id for the '<em>Update Age</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE___UPDATE_AGE__INT = PERSON___UPDATE_AGE__INT;

	/**
	 * The operation id for the '<em>Raise Salary</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE___RAISE_SALARY__DOUBLE = PERSON_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Employee</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMPLOYEE_OPERATION_COUNT = PERSON_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link CarRental.impl.BranchImpl <em>Branch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.BranchImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getBranch()
	 * @generated
	 */
	int BRANCH = 3;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__LOCATION = 0;

	/**
	 * The feature id for the '<em><b>Manager</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__MANAGER = 1;

	/**
	 * The feature id for the '<em><b>Employee</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__EMPLOYEE = 2;

	/**
	 * The feature id for the '<em><b>Car</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__CAR = 3;

	/**
	 * The feature id for the '<em><b>Car Group</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__CAR_GROUP = 4;

	/**
	 * The feature id for the '<em><b>Rental</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__RENTAL = 5;

	/**
	 * The number of structural features of the '<em>Branch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Branch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link CarRental.impl.RentalImpl <em>Rental</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.RentalImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getRental()
	 * @generated
	 */
	int RENTAL = 4;

	/**
	 * The feature id for the '<em><b>Car</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__CAR = 0;

	/**
	 * The feature id for the '<em><b>Customer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__CUSTOMER = 1;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__BRANCH = 2;

	/**
	 * The feature id for the '<em><b>Car Group</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__CAR_GROUP = 3;

	/**
	 * The feature id for the '<em><b>From Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__FROM_DATE = 4;

	/**
	 * The feature id for the '<em><b>Until Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__UNTIL_DATE = 5;

	/**
	 * The feature id for the '<em><b>Rent Duration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__RENT_DURATION = 6;

	/**
	 * The number of structural features of the '<em>Rental</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL_FEATURE_COUNT = 7;

	/**
	 * The operation id for the '<em>Extend Rental</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL___EXTEND_RENTAL__INT = 0;

	/**
	 * The number of operations of the '<em>Rental</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link CarRental.impl.CarGroupImpl <em>Car Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.CarGroupImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getCarGroup()
	 * @generated
	 */
	int CAR_GROUP = 5;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_GROUP__KIND = 0;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_GROUP__BRANCH = 1;

	/**
	 * The feature id for the '<em><b>Car</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_GROUP__CAR = 2;

	/**
	 * The feature id for the '<em><b>Rental</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_GROUP__RENTAL = 3;

	/**
	 * The feature id for the '<em><b>Higher</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_GROUP__HIGHER = 4;

	/**
	 * The feature id for the '<em><b>Lower</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_GROUP__LOWER = 5;

	/**
	 * The number of structural features of the '<em>Car Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_GROUP_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Car Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link CarRental.impl.CarImpl <em>Car</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.CarImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getCar()
	 * @generated
	 */
	int CAR = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR__ID = 0;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR__BRANCH = 1;

	/**
	 * The feature id for the '<em><b>Car Group</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR__CAR_GROUP = 2;

	/**
	 * The feature id for the '<em><b>Rental</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR__RENTAL = 3;

	/**
	 * The number of structural features of the '<em>Car</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Car</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAR_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link CarRental.impl.ServiceDepotImpl <em>Service Depot</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.ServiceDepotImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getServiceDepot()
	 * @generated
	 */
	int SERVICE_DEPOT = 7;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_DEPOT__LOCATION = 0;

	/**
	 * The number of structural features of the '<em>Service Depot</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_DEPOT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Service Depot</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_DEPOT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link CarRental.impl.CheckImpl <em>Check</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.CheckImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getCheck()
	 * @generated
	 */
	int CHECK = 8;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK__DESCRIPTION = 0;

	/**
	 * The number of structural features of the '<em>Check</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Check</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHECK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link CarRental.impl.DateImpl <em>Date</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.impl.DateImpl
	 * @see CarRental.impl.CarRentalPackageImpl#getDate()
	 * @generated
	 */
	int DATE = 9;

	/**
	 * The feature id for the '<em><b>Year</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE__YEAR = 0;

	/**
	 * The feature id for the '<em><b>Day</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE__DAY = 1;

	/**
	 * The feature id for the '<em><b>Month</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE__MONTH = 2;

	/**
	 * The number of structural features of the '<em>Date</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE_FEATURE_COUNT = 3;

	/**
	 * The operation id for the '<em>Equals</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE___EQUALS__DATE = 0;

	/**
	 * The operation id for the '<em>Next</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE___NEXT = 1;

	/**
	 * The operation id for the '<em>Add Days</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE___ADD_DAYS__DATE = 2;

	/**
	 * The operation id for the '<em>Day Count</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE___DAY_COUNT = 3;

	/**
	 * The operation id for the '<em>Day Diff</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE___DAY_DIFF__DATE = 4;

	/**
	 * The number of operations of the '<em>Date</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATE_OPERATION_COUNT = 5;

	/**
	 * The meta object id for the '{@link CarRental.CarGroupKind <em>Car Group Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see CarRental.CarGroupKind
	 * @see CarRental.impl.CarRentalPackageImpl#getCarGroupKind()
	 * @generated
	 */
	int CAR_GROUP_KIND = 10;


	/**
	 * Returns the meta object for class '{@link CarRental.Person <em>Person</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Person</em>'.
	 * @see CarRental.Person
	 * @generated
	 */
	EClass getPerson();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Person#getFirstname <em>Firstname</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Firstname</em>'.
	 * @see CarRental.Person#getFirstname()
	 * @see #getPerson()
	 * @generated
	 */
	EAttribute getPerson_Firstname();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Person#getLastname <em>Lastname</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lastname</em>'.
	 * @see CarRental.Person#getLastname()
	 * @see #getPerson()
	 * @generated
	 */
	EAttribute getPerson_Lastname();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Person#getAge <em>Age</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Age</em>'.
	 * @see CarRental.Person#getAge()
	 * @see #getPerson()
	 * @generated
	 */
	EAttribute getPerson_Age();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Person#isIsMarried <em>Is Married</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Married</em>'.
	 * @see CarRental.Person#isIsMarried()
	 * @see #getPerson()
	 * @generated
	 */
	EAttribute getPerson_IsMarried();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Person#getFullName <em>Full Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Full Name</em>'.
	 * @see CarRental.Person#getFullName()
	 * @see #getPerson()
	 * @generated
	 */
	EAttribute getPerson_FullName();

	/**
	 * Returns the meta object for the '{@link CarRental.Person#email() <em>Email</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Email</em>' operation.
	 * @see CarRental.Person#email()
	 * @generated
	 */
	EOperation getPerson__Email();

	/**
	 * Returns the meta object for the '{@link CarRental.Person#updateAge(int) <em>Update Age</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Update Age</em>' operation.
	 * @see CarRental.Person#updateAge(int)
	 * @generated
	 */
	EOperation getPerson__UpdateAge__int();

	/**
	 * Returns the meta object for class '{@link CarRental.Customer <em>Customer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Customer</em>'.
	 * @see CarRental.Customer
	 * @generated
	 */
	EClass getCustomer();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Customer#getAddress <em>Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address</em>'.
	 * @see CarRental.Customer#getAddress()
	 * @see #getCustomer()
	 * @generated
	 */
	EAttribute getCustomer_Address();

	/**
	 * Returns the meta object for the reference list '{@link CarRental.Customer#getRental <em>Rental</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Rental</em>'.
	 * @see CarRental.Customer#getRental()
	 * @see #getCustomer()
	 * @generated
	 */
	EReference getCustomer_Rental();

	/**
	 * Returns the meta object for class '{@link CarRental.Employee <em>Employee</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Employee</em>'.
	 * @see CarRental.Employee
	 * @generated
	 */
	EClass getEmployee();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Employee#getSalary <em>Salary</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Salary</em>'.
	 * @see CarRental.Employee#getSalary()
	 * @see #getEmployee()
	 * @generated
	 */
	EAttribute getEmployee_Salary();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Employee#getManagedBranch <em>Managed Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Managed Branch</em>'.
	 * @see CarRental.Employee#getManagedBranch()
	 * @see #getEmployee()
	 * @generated
	 */
	EReference getEmployee_ManagedBranch();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Employee#getEmployer <em>Employer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Employer</em>'.
	 * @see CarRental.Employee#getEmployer()
	 * @see #getEmployee()
	 * @generated
	 */
	EReference getEmployee_Employer();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Employee#getMaxSalary <em>Max Salary</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Salary</em>'.
	 * @see CarRental.Employee#getMaxSalary()
	 * @see #getEmployee()
	 * @generated
	 */
	EAttribute getEmployee_MaxSalary();

	/**
	 * Returns the meta object for the '{@link CarRental.Employee#raiseSalary(double) <em>Raise Salary</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Raise Salary</em>' operation.
	 * @see CarRental.Employee#raiseSalary(double)
	 * @generated
	 */
	EOperation getEmployee__RaiseSalary__double();

	/**
	 * Returns the meta object for class '{@link CarRental.Branch <em>Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Branch</em>'.
	 * @see CarRental.Branch
	 * @generated
	 */
	EClass getBranch();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Branch#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Location</em>'.
	 * @see CarRental.Branch#getLocation()
	 * @see #getBranch()
	 * @generated
	 */
	EAttribute getBranch_Location();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Branch#getManager <em>Manager</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Manager</em>'.
	 * @see CarRental.Branch#getManager()
	 * @see #getBranch()
	 * @generated
	 */
	EReference getBranch_Manager();

	/**
	 * Returns the meta object for the reference list '{@link CarRental.Branch#getEmployee <em>Employee</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Employee</em>'.
	 * @see CarRental.Branch#getEmployee()
	 * @see #getBranch()
	 * @generated
	 */
	EReference getBranch_Employee();

	/**
	 * Returns the meta object for the reference list '{@link CarRental.Branch#getCar <em>Car</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Car</em>'.
	 * @see CarRental.Branch#getCar()
	 * @see #getBranch()
	 * @generated
	 */
	EReference getBranch_Car();

	/**
	 * Returns the meta object for the reference list '{@link CarRental.Branch#getCarGroup <em>Car Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Car Group</em>'.
	 * @see CarRental.Branch#getCarGroup()
	 * @see #getBranch()
	 * @generated
	 */
	EReference getBranch_CarGroup();

	/**
	 * Returns the meta object for the reference list '{@link CarRental.Branch#getRental <em>Rental</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Rental</em>'.
	 * @see CarRental.Branch#getRental()
	 * @see #getBranch()
	 * @generated
	 */
	EReference getBranch_Rental();

	/**
	 * Returns the meta object for class '{@link CarRental.Rental <em>Rental</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rental</em>'.
	 * @see CarRental.Rental
	 * @generated
	 */
	EClass getRental();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Rental#getCar <em>Car</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Car</em>'.
	 * @see CarRental.Rental#getCar()
	 * @see #getRental()
	 * @generated
	 */
	EReference getRental_Car();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Rental#getCustomer <em>Customer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Customer</em>'.
	 * @see CarRental.Rental#getCustomer()
	 * @see #getRental()
	 * @generated
	 */
	EReference getRental_Customer();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Rental#getBranch <em>Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Branch</em>'.
	 * @see CarRental.Rental#getBranch()
	 * @see #getRental()
	 * @generated
	 */
	EReference getRental_Branch();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Rental#getCarGroup <em>Car Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Car Group</em>'.
	 * @see CarRental.Rental#getCarGroup()
	 * @see #getRental()
	 * @generated
	 */
	EReference getRental_CarGroup();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Rental#getFromDate <em>From Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From Date</em>'.
	 * @see CarRental.Rental#getFromDate()
	 * @see #getRental()
	 * @generated
	 */
	EReference getRental_FromDate();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Rental#getUntilDate <em>Until Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Until Date</em>'.
	 * @see CarRental.Rental#getUntilDate()
	 * @see #getRental()
	 * @generated
	 */
	EReference getRental_UntilDate();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Rental#getRentDuration <em>Rent Duration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rent Duration</em>'.
	 * @see CarRental.Rental#getRentDuration()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_RentDuration();

	/**
	 * Returns the meta object for the '{@link CarRental.Rental#extendRental(int) <em>Extend Rental</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Extend Rental</em>' operation.
	 * @see CarRental.Rental#extendRental(int)
	 * @generated
	 */
	EOperation getRental__ExtendRental__int();

	/**
	 * Returns the meta object for class '{@link CarRental.CarGroup <em>Car Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Car Group</em>'.
	 * @see CarRental.CarGroup
	 * @generated
	 */
	EClass getCarGroup();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.CarGroup#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see CarRental.CarGroup#getKind()
	 * @see #getCarGroup()
	 * @generated
	 */
	EAttribute getCarGroup_Kind();

	/**
	 * Returns the meta object for the reference list '{@link CarRental.CarGroup#getBranch <em>Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Branch</em>'.
	 * @see CarRental.CarGroup#getBranch()
	 * @see #getCarGroup()
	 * @generated
	 */
	EReference getCarGroup_Branch();

	/**
	 * Returns the meta object for the reference list '{@link CarRental.CarGroup#getCar <em>Car</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Car</em>'.
	 * @see CarRental.CarGroup#getCar()
	 * @see #getCarGroup()
	 * @generated
	 */
	EReference getCarGroup_Car();

	/**
	 * Returns the meta object for the reference list '{@link CarRental.CarGroup#getRental <em>Rental</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Rental</em>'.
	 * @see CarRental.CarGroup#getRental()
	 * @see #getCarGroup()
	 * @generated
	 */
	EReference getCarGroup_Rental();

	/**
	 * Returns the meta object for the reference '{@link CarRental.CarGroup#getHigher <em>Higher</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Higher</em>'.
	 * @see CarRental.CarGroup#getHigher()
	 * @see #getCarGroup()
	 * @generated
	 */
	EReference getCarGroup_Higher();

	/**
	 * Returns the meta object for the reference '{@link CarRental.CarGroup#getLower <em>Lower</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Lower</em>'.
	 * @see CarRental.CarGroup#getLower()
	 * @see #getCarGroup()
	 * @generated
	 */
	EReference getCarGroup_Lower();

	/**
	 * Returns the meta object for class '{@link CarRental.Car <em>Car</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Car</em>'.
	 * @see CarRental.Car
	 * @generated
	 */
	EClass getCar();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Car#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see CarRental.Car#getId()
	 * @see #getCar()
	 * @generated
	 */
	EAttribute getCar_Id();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Car#getBranch <em>Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Branch</em>'.
	 * @see CarRental.Car#getBranch()
	 * @see #getCar()
	 * @generated
	 */
	EReference getCar_Branch();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Car#getCarGroup <em>Car Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Car Group</em>'.
	 * @see CarRental.Car#getCarGroup()
	 * @see #getCar()
	 * @generated
	 */
	EReference getCar_CarGroup();

	/**
	 * Returns the meta object for the reference '{@link CarRental.Car#getRental <em>Rental</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Rental</em>'.
	 * @see CarRental.Car#getRental()
	 * @see #getCar()
	 * @generated
	 */
	EReference getCar_Rental();

	/**
	 * Returns the meta object for class '{@link CarRental.ServiceDepot <em>Service Depot</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Depot</em>'.
	 * @see CarRental.ServiceDepot
	 * @generated
	 */
	EClass getServiceDepot();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.ServiceDepot#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Location</em>'.
	 * @see CarRental.ServiceDepot#getLocation()
	 * @see #getServiceDepot()
	 * @generated
	 */
	EAttribute getServiceDepot_Location();

	/**
	 * Returns the meta object for class '{@link CarRental.Check <em>Check</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Check</em>'.
	 * @see CarRental.Check
	 * @generated
	 */
	EClass getCheck();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Check#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see CarRental.Check#getDescription()
	 * @see #getCheck()
	 * @generated
	 */
	EAttribute getCheck_Description();

	/**
	 * Returns the meta object for class '{@link CarRental.Date <em>Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Date</em>'.
	 * @see CarRental.Date
	 * @generated
	 */
	EClass getDate();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Date#getYear <em>Year</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Year</em>'.
	 * @see CarRental.Date#getYear()
	 * @see #getDate()
	 * @generated
	 */
	EAttribute getDate_Year();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Date#getDay <em>Day</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Day</em>'.
	 * @see CarRental.Date#getDay()
	 * @see #getDate()
	 * @generated
	 */
	EAttribute getDate_Day();

	/**
	 * Returns the meta object for the attribute '{@link CarRental.Date#getMonth <em>Month</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Month</em>'.
	 * @see CarRental.Date#getMonth()
	 * @see #getDate()
	 * @generated
	 */
	EAttribute getDate_Month();

	/**
	 * Returns the meta object for the '{@link CarRental.Date#equals(CarRental.Date) <em>Equals</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Equals</em>' operation.
	 * @see CarRental.Date#equals(CarRental.Date)
	 * @generated
	 */
	EOperation getDate__Equals__Date();

	/**
	 * Returns the meta object for the '{@link CarRental.Date#next() <em>Next</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Next</em>' operation.
	 * @see CarRental.Date#next()
	 * @generated
	 */
	EOperation getDate__Next();

	/**
	 * Returns the meta object for the '{@link CarRental.Date#addDays(CarRental.Date) <em>Add Days</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Add Days</em>' operation.
	 * @see CarRental.Date#addDays(CarRental.Date)
	 * @generated
	 */
	EOperation getDate__AddDays__Date();

	/**
	 * Returns the meta object for the '{@link CarRental.Date#dayCount() <em>Day Count</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Day Count</em>' operation.
	 * @see CarRental.Date#dayCount()
	 * @generated
	 */
	EOperation getDate__DayCount();

	/**
	 * Returns the meta object for the '{@link CarRental.Date#dayDiff(CarRental.Date) <em>Day Diff</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Day Diff</em>' operation.
	 * @see CarRental.Date#dayDiff(CarRental.Date)
	 * @generated
	 */
	EOperation getDate__DayDiff__Date();

	/**
	 * Returns the meta object for enum '{@link CarRental.CarGroupKind <em>Car Group Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Car Group Kind</em>'.
	 * @see CarRental.CarGroupKind
	 * @generated
	 */
	EEnum getCarGroupKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	CarRentalFactory getCarRentalFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link CarRental.impl.PersonImpl <em>Person</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.PersonImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getPerson()
		 * @generated
		 */
		EClass PERSON = eINSTANCE.getPerson();

		/**
		 * The meta object literal for the '<em><b>Firstname</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERSON__FIRSTNAME = eINSTANCE.getPerson_Firstname();

		/**
		 * The meta object literal for the '<em><b>Lastname</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERSON__LASTNAME = eINSTANCE.getPerson_Lastname();

		/**
		 * The meta object literal for the '<em><b>Age</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERSON__AGE = eINSTANCE.getPerson_Age();

		/**
		 * The meta object literal for the '<em><b>Is Married</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERSON__IS_MARRIED = eINSTANCE.getPerson_IsMarried();

		/**
		 * The meta object literal for the '<em><b>Full Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERSON__FULL_NAME = eINSTANCE.getPerson_FullName();

		/**
		 * The meta object literal for the '<em><b>Email</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PERSON___EMAIL = eINSTANCE.getPerson__Email();

		/**
		 * The meta object literal for the '<em><b>Update Age</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PERSON___UPDATE_AGE__INT = eINSTANCE.getPerson__UpdateAge__int();

		/**
		 * The meta object literal for the '{@link CarRental.impl.CustomerImpl <em>Customer</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.CustomerImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getCustomer()
		 * @generated
		 */
		EClass CUSTOMER = eINSTANCE.getCustomer();

		/**
		 * The meta object literal for the '<em><b>Address</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CUSTOMER__ADDRESS = eINSTANCE.getCustomer_Address();

		/**
		 * The meta object literal for the '<em><b>Rental</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CUSTOMER__RENTAL = eINSTANCE.getCustomer_Rental();

		/**
		 * The meta object literal for the '{@link CarRental.impl.EmployeeImpl <em>Employee</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.EmployeeImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getEmployee()
		 * @generated
		 */
		EClass EMPLOYEE = eINSTANCE.getEmployee();

		/**
		 * The meta object literal for the '<em><b>Salary</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EMPLOYEE__SALARY = eINSTANCE.getEmployee_Salary();

		/**
		 * The meta object literal for the '<em><b>Managed Branch</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EMPLOYEE__MANAGED_BRANCH = eINSTANCE.getEmployee_ManagedBranch();

		/**
		 * The meta object literal for the '<em><b>Employer</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EMPLOYEE__EMPLOYER = eINSTANCE.getEmployee_Employer();

		/**
		 * The meta object literal for the '<em><b>Max Salary</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EMPLOYEE__MAX_SALARY = eINSTANCE.getEmployee_MaxSalary();

		/**
		 * The meta object literal for the '<em><b>Raise Salary</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation EMPLOYEE___RAISE_SALARY__DOUBLE = eINSTANCE.getEmployee__RaiseSalary__double();

		/**
		 * The meta object literal for the '{@link CarRental.impl.BranchImpl <em>Branch</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.BranchImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getBranch()
		 * @generated
		 */
		EClass BRANCH = eINSTANCE.getBranch();

		/**
		 * The meta object literal for the '<em><b>Location</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BRANCH__LOCATION = eINSTANCE.getBranch_Location();

		/**
		 * The meta object literal for the '<em><b>Manager</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH__MANAGER = eINSTANCE.getBranch_Manager();

		/**
		 * The meta object literal for the '<em><b>Employee</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH__EMPLOYEE = eINSTANCE.getBranch_Employee();

		/**
		 * The meta object literal for the '<em><b>Car</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH__CAR = eINSTANCE.getBranch_Car();

		/**
		 * The meta object literal for the '<em><b>Car Group</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH__CAR_GROUP = eINSTANCE.getBranch_CarGroup();

		/**
		 * The meta object literal for the '<em><b>Rental</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH__RENTAL = eINSTANCE.getBranch_Rental();

		/**
		 * The meta object literal for the '{@link CarRental.impl.RentalImpl <em>Rental</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.RentalImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getRental()
		 * @generated
		 */
		EClass RENTAL = eINSTANCE.getRental();

		/**
		 * The meta object literal for the '<em><b>Car</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RENTAL__CAR = eINSTANCE.getRental_Car();

		/**
		 * The meta object literal for the '<em><b>Customer</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RENTAL__CUSTOMER = eINSTANCE.getRental_Customer();

		/**
		 * The meta object literal for the '<em><b>Branch</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RENTAL__BRANCH = eINSTANCE.getRental_Branch();

		/**
		 * The meta object literal for the '<em><b>Car Group</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RENTAL__CAR_GROUP = eINSTANCE.getRental_CarGroup();

		/**
		 * The meta object literal for the '<em><b>From Date</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RENTAL__FROM_DATE = eINSTANCE.getRental_FromDate();

		/**
		 * The meta object literal for the '<em><b>Until Date</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RENTAL__UNTIL_DATE = eINSTANCE.getRental_UntilDate();

		/**
		 * The meta object literal for the '<em><b>Rent Duration</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__RENT_DURATION = eINSTANCE.getRental_RentDuration();

		/**
		 * The meta object literal for the '<em><b>Extend Rental</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation RENTAL___EXTEND_RENTAL__INT = eINSTANCE.getRental__ExtendRental__int();

		/**
		 * The meta object literal for the '{@link CarRental.impl.CarGroupImpl <em>Car Group</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.CarGroupImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getCarGroup()
		 * @generated
		 */
		EClass CAR_GROUP = eINSTANCE.getCarGroup();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CAR_GROUP__KIND = eINSTANCE.getCarGroup_Kind();

		/**
		 * The meta object literal for the '<em><b>Branch</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAR_GROUP__BRANCH = eINSTANCE.getCarGroup_Branch();

		/**
		 * The meta object literal for the '<em><b>Car</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAR_GROUP__CAR = eINSTANCE.getCarGroup_Car();

		/**
		 * The meta object literal for the '<em><b>Rental</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAR_GROUP__RENTAL = eINSTANCE.getCarGroup_Rental();

		/**
		 * The meta object literal for the '<em><b>Higher</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAR_GROUP__HIGHER = eINSTANCE.getCarGroup_Higher();

		/**
		 * The meta object literal for the '<em><b>Lower</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAR_GROUP__LOWER = eINSTANCE.getCarGroup_Lower();

		/**
		 * The meta object literal for the '{@link CarRental.impl.CarImpl <em>Car</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.CarImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getCar()
		 * @generated
		 */
		EClass CAR = eINSTANCE.getCar();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CAR__ID = eINSTANCE.getCar_Id();

		/**
		 * The meta object literal for the '<em><b>Branch</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAR__BRANCH = eINSTANCE.getCar_Branch();

		/**
		 * The meta object literal for the '<em><b>Car Group</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAR__CAR_GROUP = eINSTANCE.getCar_CarGroup();

		/**
		 * The meta object literal for the '<em><b>Rental</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CAR__RENTAL = eINSTANCE.getCar_Rental();

		/**
		 * The meta object literal for the '{@link CarRental.impl.ServiceDepotImpl <em>Service Depot</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.ServiceDepotImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getServiceDepot()
		 * @generated
		 */
		EClass SERVICE_DEPOT = eINSTANCE.getServiceDepot();

		/**
		 * The meta object literal for the '<em><b>Location</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVICE_DEPOT__LOCATION = eINSTANCE.getServiceDepot_Location();

		/**
		 * The meta object literal for the '{@link CarRental.impl.CheckImpl <em>Check</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.CheckImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getCheck()
		 * @generated
		 */
		EClass CHECK = eINSTANCE.getCheck();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHECK__DESCRIPTION = eINSTANCE.getCheck_Description();

		/**
		 * The meta object literal for the '{@link CarRental.impl.DateImpl <em>Date</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.impl.DateImpl
		 * @see CarRental.impl.CarRentalPackageImpl#getDate()
		 * @generated
		 */
		EClass DATE = eINSTANCE.getDate();

		/**
		 * The meta object literal for the '<em><b>Year</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATE__YEAR = eINSTANCE.getDate_Year();

		/**
		 * The meta object literal for the '<em><b>Day</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATE__DAY = eINSTANCE.getDate_Day();

		/**
		 * The meta object literal for the '<em><b>Month</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATE__MONTH = eINSTANCE.getDate_Month();

		/**
		 * The meta object literal for the '<em><b>Equals</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATE___EQUALS__DATE = eINSTANCE.getDate__Equals__Date();

		/**
		 * The meta object literal for the '<em><b>Next</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATE___NEXT = eINSTANCE.getDate__Next();

		/**
		 * The meta object literal for the '<em><b>Add Days</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATE___ADD_DAYS__DATE = eINSTANCE.getDate__AddDays__Date();

		/**
		 * The meta object literal for the '<em><b>Day Count</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATE___DAY_COUNT = eINSTANCE.getDate__DayCount();

		/**
		 * The meta object literal for the '<em><b>Day Diff</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation DATE___DAY_DIFF__DATE = eINSTANCE.getDate__DayDiff__Date();

		/**
		 * The meta object literal for the '{@link CarRental.CarGroupKind <em>Car Group Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see CarRental.CarGroupKind
		 * @see CarRental.impl.CarRentalPackageImpl#getCarGroupKind()
		 * @generated
		 */
		EEnum CAR_GROUP_KIND = eINSTANCE.getCarGroupKind();

	}

} //CarRentalPackage
