/**
 */
package entityrelationshipmetamodel;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see entityrelationshipmetamodel.EntityrelationshipmetamodelFactory
 * @model kind="package"
 * @generated
 */
public interface EntityrelationshipmetamodelPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "entityrelationshipmetamodel";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.example.org/entityrelationshipmetamodel";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "entityrelationshipmetamodel";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EntityrelationshipmetamodelPackage eINSTANCE = entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl
			.init();

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.SchemaImpl <em>Schema</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.SchemaImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getSchema()
	 * @generated
	 */
	int SCHEMA = 0;

	/**
	 * The feature id for the '<em><b>Is Min Max</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA__IS_MIN_MAX = 0;

	/**
	 * The feature id for the '<em><b>Node schema</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA__NODE_SCHEMA = 1;

	/**
	 * The feature id for the '<em><b>Link schema</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA__LINK_SCHEMA = 2;

	/**
	 * The feature id for the '<em><b>Is Chen</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA__IS_CHEN = 3;

	/**
	 * The number of structural features of the '<em>Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Schema</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCHEMA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.NodeImpl <em>Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.NodeImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getNode()
	 * @generated
	 */
	int NODE = 1;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__SCHEMA = 0;

	/**
	 * The number of structural features of the '<em>Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.ElementImpl <em>Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.ElementImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getElement()
	 * @generated
	 */
	int ELEMENT = 2;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__SCHEMA = NODE__SCHEMA;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__NAME = NODE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Subattributelinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT__SUBATTRIBUTELINKS = NODE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_FEATURE_COUNT = NODE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELEMENT_OPERATION_COUNT = NODE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.InheritanceImpl <em>Inheritance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.InheritanceImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getInheritance()
	 * @generated
	 */
	int INHERITANCE = 3;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE__SCHEMA = NODE__SCHEMA;

	/**
	 * The feature id for the '<em><b>Disjointness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE__DISJOINTNESS = NODE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Superclassglink</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE__SUPERCLASSGLINK = NODE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Subclassslinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE__SUBCLASSSLINKS = NODE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Inheritance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_FEATURE_COUNT = NODE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Inheritance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_OPERATION_COUNT = NODE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.CategoryImpl <em>Category</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.CategoryImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCategory()
	 * @generated
	 */
	int CATEGORY = 4;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY__SCHEMA = NODE__SCHEMA;

	/**
	 * The feature id for the '<em><b>Supercategoryglinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY__SUPERCATEGORYGLINKS = NODE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Subcategoryslink</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY__SUBCATEGORYSLINK = NODE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Category</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_FEATURE_COUNT = NODE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Category</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_OPERATION_COUNT = NODE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.EntityImpl <em>Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.EntityImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getEntity()
	 * @generated
	 */
	int ENTITY = 5;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__SCHEMA = ELEMENT__SCHEMA;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Subattributelinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__SUBATTRIBUTELINKS = ELEMENT__SUBATTRIBUTELINKS;

	/**
	 * The feature id for the '<em><b>Is Weak</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__IS_WEAK = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Subclassglinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__SUBCLASSGLINKS = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Superclassslinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__SUPERCLASSSLINKS = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Subcategoryglinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__SUBCATEGORYGLINKS = ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Supercategoryslinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__SUPERCATEGORYSLINKS = ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Directsubclasslinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__DIRECTSUBCLASSLINKS = ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Directsuperclasslinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__DIRECTSUPERCLASSLINKS = ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Relationshiplinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY__RELATIONSHIPLINKS = ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENTITY_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.RelationshipImpl <em>Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.RelationshipImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getRelationship()
	 * @generated
	 */
	int RELATIONSHIP = 6;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP__SCHEMA = ELEMENT__SCHEMA;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Subattributelinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP__SUBATTRIBUTELINKS = ELEMENT__SUBATTRIBUTELINKS;

	/**
	 * The feature id for the '<em><b>Is Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP__IS_IDENTIFIER = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Relationshiplinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP__RELATIONSHIPLINKS = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.AttributeImpl <em>Attribute</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.AttributeImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getAttribute()
	 * @generated
	 */
	int ATTRIBUTE = 7;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SCHEMA = ELEMENT__SCHEMA;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__NAME = ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Subattributelinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SUBATTRIBUTELINKS = ELEMENT__SUBATTRIBUTELINKS;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__TYPE = ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__DATA_TYPE = ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SIZE = ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Null</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__IS_NULL = ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Is Unique</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__IS_UNIQUE = ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Check</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__CHECK = ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__COMMENT = ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Cardinality</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__CARDINALITY = ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Sourcelink</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE__SOURCELINK = ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_FEATURE_COUNT = ELEMENT_FEATURE_COUNT + 9;

	/**
	 * The number of operations of the '<em>Attribute</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_OPERATION_COUNT = ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.LinkImpl <em>Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.LinkImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getLink()
	 * @generated
	 */
	int LINK = 8;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK__SCHEMA = 0;

	/**
	 * The number of structural features of the '<em>Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.GeneralizationLinkImpl <em>Generalization Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.GeneralizationLinkImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getGeneralizationLink()
	 * @generated
	 */
	int GENERALIZATION_LINK = 9;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_LINK__SCHEMA = LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_LINK__ROLE = LINK_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Generalization Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_LINK_FEATURE_COUNT = LINK_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Generalization Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_LINK_OPERATION_COUNT = LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.InheritanceGLImpl <em>Inheritance GL</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.InheritanceGLImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getInheritanceGL()
	 * @generated
	 */
	int INHERITANCE_GL = 10;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_GL__SCHEMA = GENERALIZATION_LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_GL__ROLE = GENERALIZATION_LINK__ROLE;

	/**
	 * The feature id for the '<em><b>Completeness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_GL__COMPLETENESS = GENERALIZATION_LINK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_GL__TARGET = GENERALIZATION_LINK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_GL__SOURCE = GENERALIZATION_LINK_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Inheritance GL</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_GL_FEATURE_COUNT = GENERALIZATION_LINK_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Inheritance GL</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_GL_OPERATION_COUNT = GENERALIZATION_LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.SpecializationLinkImpl <em>Specialization Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.SpecializationLinkImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getSpecializationLink()
	 * @generated
	 */
	int SPECIALIZATION_LINK = 11;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIALIZATION_LINK__SCHEMA = LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIALIZATION_LINK__ROLE = LINK_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Specialization Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIALIZATION_LINK_FEATURE_COUNT = LINK_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Specialization Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPECIALIZATION_LINK_OPERATION_COUNT = LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.InheritanceSLImpl <em>Inheritance SL</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.InheritanceSLImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getInheritanceSL()
	 * @generated
	 */
	int INHERITANCE_SL = 12;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_SL__SCHEMA = SPECIALIZATION_LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_SL__ROLE = SPECIALIZATION_LINK__ROLE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_SL__TARGET = SPECIALIZATION_LINK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_SL__SOURCE = SPECIALIZATION_LINK_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Inheritance SL</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_SL_FEATURE_COUNT = SPECIALIZATION_LINK_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Inheritance SL</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INHERITANCE_SL_OPERATION_COUNT = SPECIALIZATION_LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.CategoryGLImpl <em>Category GL</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.CategoryGLImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCategoryGL()
	 * @generated
	 */
	int CATEGORY_GL = 13;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_GL__SCHEMA = GENERALIZATION_LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_GL__ROLE = GENERALIZATION_LINK__ROLE;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_GL__TARGET = GENERALIZATION_LINK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_GL__SOURCE = GENERALIZATION_LINK_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Category GL</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_GL_FEATURE_COUNT = GENERALIZATION_LINK_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Category GL</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_GL_OPERATION_COUNT = GENERALIZATION_LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.CategorySLImpl <em>Category SL</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.CategorySLImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCategorySL()
	 * @generated
	 */
	int CATEGORY_SL = 14;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_SL__SCHEMA = SPECIALIZATION_LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_SL__ROLE = SPECIALIZATION_LINK__ROLE;

	/**
	 * The feature id for the '<em><b>Completeness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_SL__COMPLETENESS = SPECIALIZATION_LINK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_SL__TARGET = SPECIALIZATION_LINK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_SL__SOURCE = SPECIALIZATION_LINK_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Category SL</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_SL_FEATURE_COUNT = SPECIALIZATION_LINK_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Category SL</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_SL_OPERATION_COUNT = SPECIALIZATION_LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.DirectInheritanceLinkImpl <em>Direct Inheritance Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.DirectInheritanceLinkImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getDirectInheritanceLink()
	 * @generated
	 */
	int DIRECT_INHERITANCE_LINK = 15;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_INHERITANCE_LINK__SCHEMA = LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_INHERITANCE_LINK__ROLE = LINK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_INHERITANCE_LINK__SOURCE = LINK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_INHERITANCE_LINK__TARGET = LINK_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Direct Inheritance Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_INHERITANCE_LINK_FEATURE_COUNT = LINK_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Direct Inheritance Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_INHERITANCE_LINK_OPERATION_COUNT = LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.RelationshipLinkImpl <em>Relationship Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.RelationshipLinkImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getRelationshipLink()
	 * @generated
	 */
	int RELATIONSHIP_LINK = 16;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_LINK__SCHEMA = LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_LINK__ROLE = LINK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_LINK__IS_IDENTIFIER = LINK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_LINK__TARGET = LINK_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_LINK__SOURCE = LINK_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Notations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_LINK__NOTATIONS = LINK_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Relationship Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_LINK_FEATURE_COUNT = LINK_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Relationship Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATIONSHIP_LINK_OPERATION_COUNT = LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.NotationImpl <em>Notation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.NotationImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getNotation()
	 * @generated
	 */
	int NOTATION = 20;

	/**
	 * The feature id for the '<em><b>Relationshiplink</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION__RELATIONSHIPLINK = 0;

	/**
	 * The number of structural features of the '<em>Notation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Notation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.ChenLinkImpl <em>Chen Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.ChenLinkImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getChenLink()
	 * @generated
	 */
	int CHEN_LINK = 17;

	/**
	 * The feature id for the '<em><b>Relationshiplink</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHEN_LINK__RELATIONSHIPLINK = NOTATION__RELATIONSHIPLINK;

	/**
	 * The feature id for the '<em><b>Participation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHEN_LINK__PARTICIPATION = NOTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Cardinality</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHEN_LINK__CARDINALITY = NOTATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Chen Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHEN_LINK_FEATURE_COUNT = NOTATION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Chen Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CHEN_LINK_OPERATION_COUNT = NOTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.MinMaxLinkImpl <em>Min Max Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.MinMaxLinkImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getMinMaxLink()
	 * @generated
	 */
	int MIN_MAX_LINK = 18;

	/**
	 * The feature id for the '<em><b>Relationshiplink</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_MAX_LINK__RELATIONSHIPLINK = NOTATION__RELATIONSHIPLINK;

	/**
	 * The feature id for the '<em><b>Lower Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_MAX_LINK__LOWER_BOUND = NOTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Upper Bound</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_MAX_LINK__UPPER_BOUND = NOTATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Min Max Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_MAX_LINK_FEATURE_COUNT = NOTATION_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Min Max Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MIN_MAX_LINK_OPERATION_COUNT = NOTATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.impl.AttributeLinkImpl <em>Attribute Link</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.impl.AttributeLinkImpl
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getAttributeLink()
	 * @generated
	 */
	int ATTRIBUTE_LINK = 19;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_LINK__SCHEMA = LINK__SCHEMA;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_LINK__TARGET = LINK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_LINK__SOURCE = LINK_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Attribute Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_LINK_FEATURE_COUNT = LINK_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Attribute Link</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_LINK_OPERATION_COUNT = LINK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.DisjointnessType <em>Disjointness Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.DisjointnessType
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getDisjointnessType()
	 * @generated
	 */
	int DISJOINTNESS_TYPE = 21;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.CardinalityType <em>Cardinality Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.CardinalityType
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCardinalityType()
	 * @generated
	 */
	int CARDINALITY_TYPE = 22;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.AttributeType <em>Attribute Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.AttributeType
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getAttributeType()
	 * @generated
	 */
	int ATTRIBUTE_TYPE = 23;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.CompletenessType <em>Completeness Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.CompletenessType
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCompletenessType()
	 * @generated
	 */
	int COMPLETENESS_TYPE = 24;

	/**
	 * The meta object id for the '{@link entityrelationshipmetamodel.DataType <em>Data Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see entityrelationshipmetamodel.DataType
	 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getDataType()
	 * @generated
	 */
	int DATA_TYPE = 25;

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Schema <em>Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Schema</em>'.
	 * @see entityrelationshipmetamodel.Schema
	 * @generated
	 */
	EClass getSchema();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Schema#isIsChen <em>Is Chen</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Chen</em>'.
	 * @see entityrelationshipmetamodel.Schema#isIsChen()
	 * @see #getSchema()
	 * @generated
	 */
	EAttribute getSchema_IsChen();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Schema#isIsMinMax <em>Is Min Max</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Min Max</em>'.
	 * @see entityrelationshipmetamodel.Schema#isIsMinMax()
	 * @see #getSchema()
	 * @generated
	 */
	EAttribute getSchema_IsMinMax();

	/**
	 * Returns the meta object for the containment reference list '{@link entityrelationshipmetamodel.Schema#getNode_schema <em>Node schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Node schema</em>'.
	 * @see entityrelationshipmetamodel.Schema#getNode_schema()
	 * @see #getSchema()
	 * @generated
	 */
	EReference getSchema_Node_schema();

	/**
	 * Returns the meta object for the containment reference list '{@link entityrelationshipmetamodel.Schema#getLink_schema <em>Link schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Link schema</em>'.
	 * @see entityrelationshipmetamodel.Schema#getLink_schema()
	 * @see #getSchema()
	 * @generated
	 */
	EReference getSchema_Link_schema();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Node <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Node</em>'.
	 * @see entityrelationshipmetamodel.Node
	 * @generated
	 */
	EClass getNode();

	/**
	 * Returns the meta object for the container reference '{@link entityrelationshipmetamodel.Node#getSchema <em>Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Schema</em>'.
	 * @see entityrelationshipmetamodel.Node#getSchema()
	 * @see #getNode()
	 * @generated
	 */
	EReference getNode_Schema();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Element <em>Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Element</em>'.
	 * @see entityrelationshipmetamodel.Element
	 * @generated
	 */
	EClass getElement();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Element#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see entityrelationshipmetamodel.Element#getName()
	 * @see #getElement()
	 * @generated
	 */
	EAttribute getElement_Name();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Element#getSubattributelinks <em>Subattributelinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Subattributelinks</em>'.
	 * @see entityrelationshipmetamodel.Element#getSubattributelinks()
	 * @see #getElement()
	 * @generated
	 */
	EReference getElement_Subattributelinks();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Inheritance <em>Inheritance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Inheritance</em>'.
	 * @see entityrelationshipmetamodel.Inheritance
	 * @generated
	 */
	EClass getInheritance();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Inheritance#getDisjointness <em>Disjointness</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Disjointness</em>'.
	 * @see entityrelationshipmetamodel.Inheritance#getDisjointness()
	 * @see #getInheritance()
	 * @generated
	 */
	EAttribute getInheritance_Disjointness();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.Inheritance#getSuperclassglink <em>Superclassglink</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Superclassglink</em>'.
	 * @see entityrelationshipmetamodel.Inheritance#getSuperclassglink()
	 * @see #getInheritance()
	 * @generated
	 */
	EReference getInheritance_Superclassglink();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Inheritance#getSubclassslinks <em>Subclassslinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Subclassslinks</em>'.
	 * @see entityrelationshipmetamodel.Inheritance#getSubclassslinks()
	 * @see #getInheritance()
	 * @generated
	 */
	EReference getInheritance_Subclassslinks();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Category <em>Category</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Category</em>'.
	 * @see entityrelationshipmetamodel.Category
	 * @generated
	 */
	EClass getCategory();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Category#getSupercategoryglinks <em>Supercategoryglinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Supercategoryglinks</em>'.
	 * @see entityrelationshipmetamodel.Category#getSupercategoryglinks()
	 * @see #getCategory()
	 * @generated
	 */
	EReference getCategory_Supercategoryglinks();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.Category#getSubcategoryslink <em>Subcategoryslink</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Subcategoryslink</em>'.
	 * @see entityrelationshipmetamodel.Category#getSubcategoryslink()
	 * @see #getCategory()
	 * @generated
	 */
	EReference getCategory_Subcategoryslink();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Entity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Entity</em>'.
	 * @see entityrelationshipmetamodel.Entity
	 * @generated
	 */
	EClass getEntity();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Entity#isIsWeak <em>Is Weak</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Weak</em>'.
	 * @see entityrelationshipmetamodel.Entity#isIsWeak()
	 * @see #getEntity()
	 * @generated
	 */
	EAttribute getEntity_IsWeak();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Entity#getSubclassglinks <em>Subclassglinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Subclassglinks</em>'.
	 * @see entityrelationshipmetamodel.Entity#getSubclassglinks()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Subclassglinks();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Entity#getSuperclassslinks <em>Superclassslinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Superclassslinks</em>'.
	 * @see entityrelationshipmetamodel.Entity#getSuperclassslinks()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Superclassslinks();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Entity#getSubcategoryglinks <em>Subcategoryglinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Subcategoryglinks</em>'.
	 * @see entityrelationshipmetamodel.Entity#getSubcategoryglinks()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Subcategoryglinks();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Entity#getSupercategoryslinks <em>Supercategoryslinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Supercategoryslinks</em>'.
	 * @see entityrelationshipmetamodel.Entity#getSupercategoryslinks()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Supercategoryslinks();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Entity#getDirectsubclasslinks <em>Directsubclasslinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Directsubclasslinks</em>'.
	 * @see entityrelationshipmetamodel.Entity#getDirectsubclasslinks()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Directsubclasslinks();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Entity#getDirectsuperclasslinks <em>Directsuperclasslinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Directsuperclasslinks</em>'.
	 * @see entityrelationshipmetamodel.Entity#getDirectsuperclasslinks()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Directsuperclasslinks();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Entity#getRelationshiplinks <em>Relationshiplinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Relationshiplinks</em>'.
	 * @see entityrelationshipmetamodel.Entity#getRelationshiplinks()
	 * @see #getEntity()
	 * @generated
	 */
	EReference getEntity_Relationshiplinks();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Relationship <em>Relationship</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Relationship</em>'.
	 * @see entityrelationshipmetamodel.Relationship
	 * @generated
	 */
	EClass getRelationship();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Relationship#isIsIdentifier <em>Is Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Identifier</em>'.
	 * @see entityrelationshipmetamodel.Relationship#isIsIdentifier()
	 * @see #getRelationship()
	 * @generated
	 */
	EAttribute getRelationship_IsIdentifier();

	/**
	 * Returns the meta object for the reference list '{@link entityrelationshipmetamodel.Relationship#getRelationshiplinks <em>Relationshiplinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Relationshiplinks</em>'.
	 * @see entityrelationshipmetamodel.Relationship#getRelationshiplinks()
	 * @see #getRelationship()
	 * @generated
	 */
	EReference getRelationship_Relationshiplinks();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Attribute <em>Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute</em>'.
	 * @see entityrelationshipmetamodel.Attribute
	 * @generated
	 */
	EClass getAttribute();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Attribute#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see entityrelationshipmetamodel.Attribute#getType()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Type();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Attribute#getDataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Data Type</em>'.
	 * @see entityrelationshipmetamodel.Attribute#getDataType()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_DataType();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Attribute#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see entityrelationshipmetamodel.Attribute#getSize()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Size();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Attribute#isIsNull <em>Is Null</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Null</em>'.
	 * @see entityrelationshipmetamodel.Attribute#isIsNull()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_IsNull();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Attribute#isIsUnique <em>Is Unique</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Unique</em>'.
	 * @see entityrelationshipmetamodel.Attribute#isIsUnique()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_IsUnique();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Attribute#getCheck <em>Check</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Check</em>'.
	 * @see entityrelationshipmetamodel.Attribute#getCheck()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Check();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Attribute#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comment</em>'.
	 * @see entityrelationshipmetamodel.Attribute#getComment()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Comment();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.Attribute#getCardinality <em>Cardinality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cardinality</em>'.
	 * @see entityrelationshipmetamodel.Attribute#getCardinality()
	 * @see #getAttribute()
	 * @generated
	 */
	EAttribute getAttribute_Cardinality();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.Attribute#getSourcelink <em>Sourcelink</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Sourcelink</em>'.
	 * @see entityrelationshipmetamodel.Attribute#getSourcelink()
	 * @see #getAttribute()
	 * @generated
	 */
	EReference getAttribute_Sourcelink();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Link <em>Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Link</em>'.
	 * @see entityrelationshipmetamodel.Link
	 * @generated
	 */
	EClass getLink();

	/**
	 * Returns the meta object for the container reference '{@link entityrelationshipmetamodel.Link#getSchema <em>Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Schema</em>'.
	 * @see entityrelationshipmetamodel.Link#getSchema()
	 * @see #getLink()
	 * @generated
	 */
	EReference getLink_Schema();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.GeneralizationLink <em>Generalization Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generalization Link</em>'.
	 * @see entityrelationshipmetamodel.GeneralizationLink
	 * @generated
	 */
	EClass getGeneralizationLink();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.GeneralizationLink#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see entityrelationshipmetamodel.GeneralizationLink#getRole()
	 * @see #getGeneralizationLink()
	 * @generated
	 */
	EAttribute getGeneralizationLink_Role();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.InheritanceGL <em>Inheritance GL</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Inheritance GL</em>'.
	 * @see entityrelationshipmetamodel.InheritanceGL
	 * @generated
	 */
	EClass getInheritanceGL();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.InheritanceGL#getCompleteness <em>Completeness</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Completeness</em>'.
	 * @see entityrelationshipmetamodel.InheritanceGL#getCompleteness()
	 * @see #getInheritanceGL()
	 * @generated
	 */
	EAttribute getInheritanceGL_Completeness();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.InheritanceGL#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see entityrelationshipmetamodel.InheritanceGL#getTarget()
	 * @see #getInheritanceGL()
	 * @generated
	 */
	EReference getInheritanceGL_Target();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.InheritanceGL#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see entityrelationshipmetamodel.InheritanceGL#getSource()
	 * @see #getInheritanceGL()
	 * @generated
	 */
	EReference getInheritanceGL_Source();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.SpecializationLink <em>Specialization Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Specialization Link</em>'.
	 * @see entityrelationshipmetamodel.SpecializationLink
	 * @generated
	 */
	EClass getSpecializationLink();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.SpecializationLink#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see entityrelationshipmetamodel.SpecializationLink#getRole()
	 * @see #getSpecializationLink()
	 * @generated
	 */
	EAttribute getSpecializationLink_Role();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.InheritanceSL <em>Inheritance SL</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Inheritance SL</em>'.
	 * @see entityrelationshipmetamodel.InheritanceSL
	 * @generated
	 */
	EClass getInheritanceSL();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.InheritanceSL#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see entityrelationshipmetamodel.InheritanceSL#getTarget()
	 * @see #getInheritanceSL()
	 * @generated
	 */
	EReference getInheritanceSL_Target();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.InheritanceSL#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see entityrelationshipmetamodel.InheritanceSL#getSource()
	 * @see #getInheritanceSL()
	 * @generated
	 */
	EReference getInheritanceSL_Source();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.CategoryGL <em>Category GL</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Category GL</em>'.
	 * @see entityrelationshipmetamodel.CategoryGL
	 * @generated
	 */
	EClass getCategoryGL();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.CategoryGL#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see entityrelationshipmetamodel.CategoryGL#getTarget()
	 * @see #getCategoryGL()
	 * @generated
	 */
	EReference getCategoryGL_Target();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.CategoryGL#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see entityrelationshipmetamodel.CategoryGL#getSource()
	 * @see #getCategoryGL()
	 * @generated
	 */
	EReference getCategoryGL_Source();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.CategorySL <em>Category SL</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Category SL</em>'.
	 * @see entityrelationshipmetamodel.CategorySL
	 * @generated
	 */
	EClass getCategorySL();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.CategorySL#getCompleteness <em>Completeness</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Completeness</em>'.
	 * @see entityrelationshipmetamodel.CategorySL#getCompleteness()
	 * @see #getCategorySL()
	 * @generated
	 */
	EAttribute getCategorySL_Completeness();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.CategorySL#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see entityrelationshipmetamodel.CategorySL#getTarget()
	 * @see #getCategorySL()
	 * @generated
	 */
	EReference getCategorySL_Target();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.CategorySL#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see entityrelationshipmetamodel.CategorySL#getSource()
	 * @see #getCategorySL()
	 * @generated
	 */
	EReference getCategorySL_Source();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.DirectInheritanceLink <em>Direct Inheritance Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Direct Inheritance Link</em>'.
	 * @see entityrelationshipmetamodel.DirectInheritanceLink
	 * @generated
	 */
	EClass getDirectInheritanceLink();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.DirectInheritanceLink#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see entityrelationshipmetamodel.DirectInheritanceLink#getRole()
	 * @see #getDirectInheritanceLink()
	 * @generated
	 */
	EAttribute getDirectInheritanceLink_Role();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.DirectInheritanceLink#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see entityrelationshipmetamodel.DirectInheritanceLink#getSource()
	 * @see #getDirectInheritanceLink()
	 * @generated
	 */
	EReference getDirectInheritanceLink_Source();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.DirectInheritanceLink#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see entityrelationshipmetamodel.DirectInheritanceLink#getTarget()
	 * @see #getDirectInheritanceLink()
	 * @generated
	 */
	EReference getDirectInheritanceLink_Target();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.RelationshipLink <em>Relationship Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Relationship Link</em>'.
	 * @see entityrelationshipmetamodel.RelationshipLink
	 * @generated
	 */
	EClass getRelationshipLink();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.RelationshipLink#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see entityrelationshipmetamodel.RelationshipLink#getRole()
	 * @see #getRelationshipLink()
	 * @generated
	 */
	EAttribute getRelationshipLink_Role();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.RelationshipLink#isIsIdentifier <em>Is Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Identifier</em>'.
	 * @see entityrelationshipmetamodel.RelationshipLink#isIsIdentifier()
	 * @see #getRelationshipLink()
	 * @generated
	 */
	EAttribute getRelationshipLink_IsIdentifier();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.RelationshipLink#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see entityrelationshipmetamodel.RelationshipLink#getTarget()
	 * @see #getRelationshipLink()
	 * @generated
	 */
	EReference getRelationshipLink_Target();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.RelationshipLink#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see entityrelationshipmetamodel.RelationshipLink#getSource()
	 * @see #getRelationshipLink()
	 * @generated
	 */
	EReference getRelationshipLink_Source();

	/**
	 * Returns the meta object for the containment reference list '{@link entityrelationshipmetamodel.RelationshipLink#getNotations <em>Notations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Notations</em>'.
	 * @see entityrelationshipmetamodel.RelationshipLink#getNotations()
	 * @see #getRelationshipLink()
	 * @generated
	 */
	EReference getRelationshipLink_Notations();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.ChenLink <em>Chen Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Chen Link</em>'.
	 * @see entityrelationshipmetamodel.ChenLink
	 * @generated
	 */
	EClass getChenLink();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.ChenLink#getParticipation <em>Participation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Participation</em>'.
	 * @see entityrelationshipmetamodel.ChenLink#getParticipation()
	 * @see #getChenLink()
	 * @generated
	 */
	EAttribute getChenLink_Participation();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.ChenLink#getCardinality <em>Cardinality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cardinality</em>'.
	 * @see entityrelationshipmetamodel.ChenLink#getCardinality()
	 * @see #getChenLink()
	 * @generated
	 */
	EAttribute getChenLink_Cardinality();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.MinMaxLink <em>Min Max Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Min Max Link</em>'.
	 * @see entityrelationshipmetamodel.MinMaxLink
	 * @generated
	 */
	EClass getMinMaxLink();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.MinMaxLink#getLowerBound <em>Lower Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lower Bound</em>'.
	 * @see entityrelationshipmetamodel.MinMaxLink#getLowerBound()
	 * @see #getMinMaxLink()
	 * @generated
	 */
	EAttribute getMinMaxLink_LowerBound();

	/**
	 * Returns the meta object for the attribute '{@link entityrelationshipmetamodel.MinMaxLink#getUpperBound <em>Upper Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Upper Bound</em>'.
	 * @see entityrelationshipmetamodel.MinMaxLink#getUpperBound()
	 * @see #getMinMaxLink()
	 * @generated
	 */
	EAttribute getMinMaxLink_UpperBound();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.AttributeLink <em>Attribute Link</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attribute Link</em>'.
	 * @see entityrelationshipmetamodel.AttributeLink
	 * @generated
	 */
	EClass getAttributeLink();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.AttributeLink#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see entityrelationshipmetamodel.AttributeLink#getTarget()
	 * @see #getAttributeLink()
	 * @generated
	 */
	EReference getAttributeLink_Target();

	/**
	 * Returns the meta object for the reference '{@link entityrelationshipmetamodel.AttributeLink#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see entityrelationshipmetamodel.AttributeLink#getSource()
	 * @see #getAttributeLink()
	 * @generated
	 */
	EReference getAttributeLink_Source();

	/**
	 * Returns the meta object for class '{@link entityrelationshipmetamodel.Notation <em>Notation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notation</em>'.
	 * @see entityrelationshipmetamodel.Notation
	 * @generated
	 */
	EClass getNotation();

	/**
	 * Returns the meta object for the container reference '{@link entityrelationshipmetamodel.Notation#getRelationshiplink <em>Relationshiplink</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Relationshiplink</em>'.
	 * @see entityrelationshipmetamodel.Notation#getRelationshiplink()
	 * @see #getNotation()
	 * @generated
	 */
	EReference getNotation_Relationshiplink();

	/**
	 * Returns the meta object for enum '{@link entityrelationshipmetamodel.DisjointnessType <em>Disjointness Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Disjointness Type</em>'.
	 * @see entityrelationshipmetamodel.DisjointnessType
	 * @generated
	 */
	EEnum getDisjointnessType();

	/**
	 * Returns the meta object for enum '{@link entityrelationshipmetamodel.CardinalityType <em>Cardinality Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Cardinality Type</em>'.
	 * @see entityrelationshipmetamodel.CardinalityType
	 * @generated
	 */
	EEnum getCardinalityType();

	/**
	 * Returns the meta object for enum '{@link entityrelationshipmetamodel.AttributeType <em>Attribute Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Attribute Type</em>'.
	 * @see entityrelationshipmetamodel.AttributeType
	 * @generated
	 */
	EEnum getAttributeType();

	/**
	 * Returns the meta object for enum '{@link entityrelationshipmetamodel.CompletenessType <em>Completeness Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Completeness Type</em>'.
	 * @see entityrelationshipmetamodel.CompletenessType
	 * @generated
	 */
	EEnum getCompletenessType();

	/**
	 * Returns the meta object for enum '{@link entityrelationshipmetamodel.DataType <em>Data Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Data Type</em>'.
	 * @see entityrelationshipmetamodel.DataType
	 * @generated
	 */
	EEnum getDataType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	EntityrelationshipmetamodelFactory getEntityrelationshipmetamodelFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.SchemaImpl <em>Schema</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.SchemaImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getSchema()
		 * @generated
		 */
		EClass SCHEMA = eINSTANCE.getSchema();

		/**
		 * The meta object literal for the '<em><b>Is Chen</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEMA__IS_CHEN = eINSTANCE.getSchema_IsChen();

		/**
		 * The meta object literal for the '<em><b>Is Min Max</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCHEMA__IS_MIN_MAX = eINSTANCE.getSchema_IsMinMax();

		/**
		 * The meta object literal for the '<em><b>Node schema</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCHEMA__NODE_SCHEMA = eINSTANCE.getSchema_Node_schema();

		/**
		 * The meta object literal for the '<em><b>Link schema</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCHEMA__LINK_SCHEMA = eINSTANCE.getSchema_Link_schema();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.NodeImpl <em>Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.NodeImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getNode()
		 * @generated
		 */
		EClass NODE = eINSTANCE.getNode();

		/**
		 * The meta object literal for the '<em><b>Schema</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NODE__SCHEMA = eINSTANCE.getNode_Schema();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.ElementImpl <em>Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.ElementImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getElement()
		 * @generated
		 */
		EClass ELEMENT = eINSTANCE.getElement();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ELEMENT__NAME = eINSTANCE.getElement_Name();

		/**
		 * The meta object literal for the '<em><b>Subattributelinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ELEMENT__SUBATTRIBUTELINKS = eINSTANCE.getElement_Subattributelinks();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.InheritanceImpl <em>Inheritance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.InheritanceImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getInheritance()
		 * @generated
		 */
		EClass INHERITANCE = eINSTANCE.getInheritance();

		/**
		 * The meta object literal for the '<em><b>Disjointness</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INHERITANCE__DISJOINTNESS = eINSTANCE.getInheritance_Disjointness();

		/**
		 * The meta object literal for the '<em><b>Superclassglink</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INHERITANCE__SUPERCLASSGLINK = eINSTANCE.getInheritance_Superclassglink();

		/**
		 * The meta object literal for the '<em><b>Subclassslinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INHERITANCE__SUBCLASSSLINKS = eINSTANCE.getInheritance_Subclassslinks();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.CategoryImpl <em>Category</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.CategoryImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCategory()
		 * @generated
		 */
		EClass CATEGORY = eINSTANCE.getCategory();

		/**
		 * The meta object literal for the '<em><b>Supercategoryglinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CATEGORY__SUPERCATEGORYGLINKS = eINSTANCE.getCategory_Supercategoryglinks();

		/**
		 * The meta object literal for the '<em><b>Subcategoryslink</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CATEGORY__SUBCATEGORYSLINK = eINSTANCE.getCategory_Subcategoryslink();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.EntityImpl <em>Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.EntityImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getEntity()
		 * @generated
		 */
		EClass ENTITY = eINSTANCE.getEntity();

		/**
		 * The meta object literal for the '<em><b>Is Weak</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ENTITY__IS_WEAK = eINSTANCE.getEntity_IsWeak();

		/**
		 * The meta object literal for the '<em><b>Subclassglinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__SUBCLASSGLINKS = eINSTANCE.getEntity_Subclassglinks();

		/**
		 * The meta object literal for the '<em><b>Superclassslinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__SUPERCLASSSLINKS = eINSTANCE.getEntity_Superclassslinks();

		/**
		 * The meta object literal for the '<em><b>Subcategoryglinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__SUBCATEGORYGLINKS = eINSTANCE.getEntity_Subcategoryglinks();

		/**
		 * The meta object literal for the '<em><b>Supercategoryslinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__SUPERCATEGORYSLINKS = eINSTANCE.getEntity_Supercategoryslinks();

		/**
		 * The meta object literal for the '<em><b>Directsubclasslinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__DIRECTSUBCLASSLINKS = eINSTANCE.getEntity_Directsubclasslinks();

		/**
		 * The meta object literal for the '<em><b>Directsuperclasslinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__DIRECTSUPERCLASSLINKS = eINSTANCE.getEntity_Directsuperclasslinks();

		/**
		 * The meta object literal for the '<em><b>Relationshiplinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ENTITY__RELATIONSHIPLINKS = eINSTANCE.getEntity_Relationshiplinks();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.RelationshipImpl <em>Relationship</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.RelationshipImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getRelationship()
		 * @generated
		 */
		EClass RELATIONSHIP = eINSTANCE.getRelationship();

		/**
		 * The meta object literal for the '<em><b>Is Identifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RELATIONSHIP__IS_IDENTIFIER = eINSTANCE.getRelationship_IsIdentifier();

		/**
		 * The meta object literal for the '<em><b>Relationshiplinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RELATIONSHIP__RELATIONSHIPLINKS = eINSTANCE.getRelationship_Relationshiplinks();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.AttributeImpl <em>Attribute</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.AttributeImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getAttribute()
		 * @generated
		 */
		EClass ATTRIBUTE = eINSTANCE.getAttribute();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__TYPE = eINSTANCE.getAttribute_Type();

		/**
		 * The meta object literal for the '<em><b>Data Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__DATA_TYPE = eINSTANCE.getAttribute_DataType();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__SIZE = eINSTANCE.getAttribute_Size();

		/**
		 * The meta object literal for the '<em><b>Is Null</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__IS_NULL = eINSTANCE.getAttribute_IsNull();

		/**
		 * The meta object literal for the '<em><b>Is Unique</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__IS_UNIQUE = eINSTANCE.getAttribute_IsUnique();

		/**
		 * The meta object literal for the '<em><b>Check</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__CHECK = eINSTANCE.getAttribute_Check();

		/**
		 * The meta object literal for the '<em><b>Comment</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__COMMENT = eINSTANCE.getAttribute_Comment();

		/**
		 * The meta object literal for the '<em><b>Cardinality</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE__CARDINALITY = eINSTANCE.getAttribute_Cardinality();

		/**
		 * The meta object literal for the '<em><b>Sourcelink</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE__SOURCELINK = eINSTANCE.getAttribute_Sourcelink();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.LinkImpl <em>Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.LinkImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getLink()
		 * @generated
		 */
		EClass LINK = eINSTANCE.getLink();

		/**
		 * The meta object literal for the '<em><b>Schema</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LINK__SCHEMA = eINSTANCE.getLink_Schema();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.GeneralizationLinkImpl <em>Generalization Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.GeneralizationLinkImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getGeneralizationLink()
		 * @generated
		 */
		EClass GENERALIZATION_LINK = eINSTANCE.getGeneralizationLink();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GENERALIZATION_LINK__ROLE = eINSTANCE.getGeneralizationLink_Role();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.InheritanceGLImpl <em>Inheritance GL</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.InheritanceGLImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getInheritanceGL()
		 * @generated
		 */
		EClass INHERITANCE_GL = eINSTANCE.getInheritanceGL();

		/**
		 * The meta object literal for the '<em><b>Completeness</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INHERITANCE_GL__COMPLETENESS = eINSTANCE.getInheritanceGL_Completeness();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INHERITANCE_GL__TARGET = eINSTANCE.getInheritanceGL_Target();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INHERITANCE_GL__SOURCE = eINSTANCE.getInheritanceGL_Source();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.SpecializationLinkImpl <em>Specialization Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.SpecializationLinkImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getSpecializationLink()
		 * @generated
		 */
		EClass SPECIALIZATION_LINK = eINSTANCE.getSpecializationLink();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SPECIALIZATION_LINK__ROLE = eINSTANCE.getSpecializationLink_Role();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.InheritanceSLImpl <em>Inheritance SL</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.InheritanceSLImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getInheritanceSL()
		 * @generated
		 */
		EClass INHERITANCE_SL = eINSTANCE.getInheritanceSL();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INHERITANCE_SL__TARGET = eINSTANCE.getInheritanceSL_Target();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INHERITANCE_SL__SOURCE = eINSTANCE.getInheritanceSL_Source();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.CategoryGLImpl <em>Category GL</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.CategoryGLImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCategoryGL()
		 * @generated
		 */
		EClass CATEGORY_GL = eINSTANCE.getCategoryGL();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CATEGORY_GL__TARGET = eINSTANCE.getCategoryGL_Target();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CATEGORY_GL__SOURCE = eINSTANCE.getCategoryGL_Source();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.CategorySLImpl <em>Category SL</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.CategorySLImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCategorySL()
		 * @generated
		 */
		EClass CATEGORY_SL = eINSTANCE.getCategorySL();

		/**
		 * The meta object literal for the '<em><b>Completeness</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CATEGORY_SL__COMPLETENESS = eINSTANCE.getCategorySL_Completeness();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CATEGORY_SL__TARGET = eINSTANCE.getCategorySL_Target();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CATEGORY_SL__SOURCE = eINSTANCE.getCategorySL_Source();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.DirectInheritanceLinkImpl <em>Direct Inheritance Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.DirectInheritanceLinkImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getDirectInheritanceLink()
		 * @generated
		 */
		EClass DIRECT_INHERITANCE_LINK = eINSTANCE.getDirectInheritanceLink();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DIRECT_INHERITANCE_LINK__ROLE = eINSTANCE.getDirectInheritanceLink_Role();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DIRECT_INHERITANCE_LINK__SOURCE = eINSTANCE.getDirectInheritanceLink_Source();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DIRECT_INHERITANCE_LINK__TARGET = eINSTANCE.getDirectInheritanceLink_Target();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.RelationshipLinkImpl <em>Relationship Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.RelationshipLinkImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getRelationshipLink()
		 * @generated
		 */
		EClass RELATIONSHIP_LINK = eINSTANCE.getRelationshipLink();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RELATIONSHIP_LINK__ROLE = eINSTANCE.getRelationshipLink_Role();

		/**
		 * The meta object literal for the '<em><b>Is Identifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RELATIONSHIP_LINK__IS_IDENTIFIER = eINSTANCE.getRelationshipLink_IsIdentifier();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RELATIONSHIP_LINK__TARGET = eINSTANCE.getRelationshipLink_Target();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RELATIONSHIP_LINK__SOURCE = eINSTANCE.getRelationshipLink_Source();

		/**
		 * The meta object literal for the '<em><b>Notations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RELATIONSHIP_LINK__NOTATIONS = eINSTANCE.getRelationshipLink_Notations();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.ChenLinkImpl <em>Chen Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.ChenLinkImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getChenLink()
		 * @generated
		 */
		EClass CHEN_LINK = eINSTANCE.getChenLink();

		/**
		 * The meta object literal for the '<em><b>Participation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHEN_LINK__PARTICIPATION = eINSTANCE.getChenLink_Participation();

		/**
		 * The meta object literal for the '<em><b>Cardinality</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CHEN_LINK__CARDINALITY = eINSTANCE.getChenLink_Cardinality();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.MinMaxLinkImpl <em>Min Max Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.MinMaxLinkImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getMinMaxLink()
		 * @generated
		 */
		EClass MIN_MAX_LINK = eINSTANCE.getMinMaxLink();

		/**
		 * The meta object literal for the '<em><b>Lower Bound</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MIN_MAX_LINK__LOWER_BOUND = eINSTANCE.getMinMaxLink_LowerBound();

		/**
		 * The meta object literal for the '<em><b>Upper Bound</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MIN_MAX_LINK__UPPER_BOUND = eINSTANCE.getMinMaxLink_UpperBound();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.AttributeLinkImpl <em>Attribute Link</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.AttributeLinkImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getAttributeLink()
		 * @generated
		 */
		EClass ATTRIBUTE_LINK = eINSTANCE.getAttributeLink();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_LINK__TARGET = eINSTANCE.getAttributeLink_Target();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ATTRIBUTE_LINK__SOURCE = eINSTANCE.getAttributeLink_Source();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.impl.NotationImpl <em>Notation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.impl.NotationImpl
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getNotation()
		 * @generated
		 */
		EClass NOTATION = eINSTANCE.getNotation();

		/**
		 * The meta object literal for the '<em><b>Relationshiplink</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTATION__RELATIONSHIPLINK = eINSTANCE.getNotation_Relationshiplink();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.DisjointnessType <em>Disjointness Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.DisjointnessType
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getDisjointnessType()
		 * @generated
		 */
		EEnum DISJOINTNESS_TYPE = eINSTANCE.getDisjointnessType();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.CardinalityType <em>Cardinality Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.CardinalityType
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCardinalityType()
		 * @generated
		 */
		EEnum CARDINALITY_TYPE = eINSTANCE.getCardinalityType();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.AttributeType <em>Attribute Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.AttributeType
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getAttributeType()
		 * @generated
		 */
		EEnum ATTRIBUTE_TYPE = eINSTANCE.getAttributeType();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.CompletenessType <em>Completeness Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.CompletenessType
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getCompletenessType()
		 * @generated
		 */
		EEnum COMPLETENESS_TYPE = eINSTANCE.getCompletenessType();

		/**
		 * The meta object literal for the '{@link entityrelationshipmetamodel.DataType <em>Data Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see entityrelationshipmetamodel.DataType
		 * @see entityrelationshipmetamodel.impl.EntityrelationshipmetamodelPackageImpl#getDataType()
		 * @generated
		 */
		EEnum DATA_TYPE = eINSTANCE.getDataType();

	}

} //EntityrelationshipmetamodelPackage
